/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.dialogs.newjob;

import java.awt.CardLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.CardLayoutActionControl;
import oracle.dbtools.raptor.ui.controls.PropertyPanelActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobModel;
import oracle.dbtools.scheduler.panels.IdSqlComboBoxActionControl;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelModel;
import oracle.javatools.util.ArrayMap;

public class NewJobCreateActionDialogTab_Destination
extends ActionDialogTab
implements PropertyChangeListener {
    private String jobTypeChoice = NewJobPropertyPanelModel.JOB_TYPE_PLSQL_BLOCK;
    CardLayoutActionControl whereJobCtl = null;
    CardLayout _cardLayout;
    protected JPanel topCardPanel;
    private PropertyPanelActionControl topPanelCtl = null;
    private ActionControl nonExecutableCtl = null;
    private ActionControl executableCtl = null;
    private NewJobModel model;
    private String jobCredential = "";
    private String jobCredentialOwner = "";
    private String jobDestination = "";
    private String jobDestinationOwner = "";
    private String jobDestinationType = "";
    private String jobDestinationTypeChoice = NewJobPropertyPanelModel.JOB_WHERE_LOCAL;
    private String jobSource = null;
    private int jobNumberOfDestinations = 0;
    private String _currentSelector;

    public NewJobCreateActionDialogTab_Destination(String string, String string2, NewJobModel newJobModel) {
        super(string, string2);
        this.model = newJobModel;
        if (this.model != null && newJobModel.getOperation() != NewJobModel.Operation.CREATE_NEW) {
            this.jobCredential = (String)newJobModel.getPreviousJobData("oldCredentialName");
            this.jobDestination = (String)newJobModel.getPreviousJobData("oldDestinationName");
            this.jobCredentialOwner = (String)newJobModel.getPreviousJobData("oldCredentialOwner");
            if (this.jobCredentialOwner != null) {
                if (this.jobCredential != null) {
                    if (this.jobCredential.length() > 0 && this.jobCredentialOwner.length() > 0) {
                        this.jobCredential = this.jobCredentialOwner + "." + this.jobCredential;
                    }
                } else {
                    this.jobCredential = "";
                }
            } else if (this.jobCredential == null) {
                this.jobCredential = "";
            }
            this.jobDestinationOwner = (String)newJobModel.getPreviousJobData("oldDestinationOwner");
            if (this.jobDestinationOwner != null) {
                if (this.jobDestination != null) {
                    if (this.jobDestination.length() > 0 && this.jobDestinationOwner.length() > 0) {
                        this.jobDestination = this.jobDestinationOwner + "." + this.jobDestination;
                    }
                } else {
                    this.jobDestination = "";
                }
            } else if (this.jobDestination == null) {
                this.jobDestination = "";
            }
            this.jobDestinationType = newJobModel.getPreviousJobDestinationData("oldJobDestinationType");
            if (this.jobDestinationType != null) {
                if (this.jobDestinationType.equals("EXTERNAL") || this.jobDestinationType.equals("DATABASE")) {
                    this.jobDestinationTypeChoice = NewJobPropertyPanelModel.JOB_WHERE_REMOTE;
                } else if (this.jobDestinationType.equals("EXTERNAL_DEST") || this.jobDestinationType.equals("DB_DEST")) {
                    this.jobDestinationTypeChoice = NewJobPropertyPanelModel.JOB_WHERE_MULTIPLE;
                }
            }
            this.jobSource = (String)newJobModel.getPreviousJobData("oldSource");
            this.jobNumberOfDestinations = (Integer)newJobModel.getPreviousJobData("oldNumberOfDestination");
        }
    }

    public List<ActionControl> createControls(Connection connection) {
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        this.topPanelCtl = new PropertyPanelActionControl("WHERE_TOP_PANEL", null);
        this.nonExecutableCtl = this.createNonExecutableControl(connection);
        this.executableCtl = this.createExecutableControl(connection);
        ArrayList<ActionControl> arrayList2 = new ArrayList<ActionControl>();
        arrayList2.add(this.nonExecutableCtl);
        arrayList2.add(this.executableCtl);
        this.topPanelCtl.addChildControls(arrayList2);
        this.createUI();
        arrayList.add((ActionControl)this.topPanelCtl);
        return arrayList;
    }

    public void createUI() {
        this.topCardPanel = this.topPanelCtl.getUI();
        this.topCardPanel.removeAll();
        this._cardLayout = new CardLayout(0, 0);
        this.topCardPanel.setLayout(this._cardLayout);
        this.topCardPanel.add(this.nonExecutableCtl.getUI(), "NON_EXECUTABLE_CHOICE");
        this.topCardPanel.add(this.executableCtl.getUI(), "EXECUTABLE_CHOICE");
    }

    protected ActionControl createNonExecutableControl(Connection connection) {
        String string;
        final PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl("WHERE_LOCAL_PANEL", null);
        ArrayMap arrayMap = null;
        if (this.model.supportsExternalDBJobs()) {
            string = this.getQuery(connection, "jobCreateGetRemoteCredentials");
            IdSqlComboBoxActionControl idSqlComboBoxActionControl = new IdSqlComboBoxActionControl("JOB_WHERES_REMOTE_CRED", SchedulerArb.getString("JOB_CREATE_DESTINATION_ADD_REMOTE_CREDENTIAL"), connection, string, null, this.jobCredential, false, this.model.getDelayLoadingChoice());
            String string2 = this.getQuery(connection, "jobCreateGetRemoteDBDestinations");
            IdSqlComboBoxActionControl idSqlComboBoxActionControl2 = new IdSqlComboBoxActionControl("JOB_WHERES_REMOTE_DEST", SchedulerArb.getString("JOB_CREATE_DESTINATION_ADD_REMOTE_DESTINATION"), connection, string2, null, this.jobDestination, false, this.model.getDelayLoadingChoice());
            final PropertyPanelActionControl propertyPanelActionControl2 = new PropertyPanelActionControl("WHERE_REMOTE_PANEL", null);
            ArrayList<IdSqlComboBoxActionControl> arrayList = new ArrayList<IdSqlComboBoxActionControl>();
            arrayList.add(idSqlComboBoxActionControl);
            arrayList.add(idSqlComboBoxActionControl2);
            propertyPanelActionControl2.addChildControls(arrayList);
            String string3 = this.getQuery(connection, "jobCreateGetMultipleCredentials");
            IdSqlComboBoxActionControl idSqlComboBoxActionControl3 = new IdSqlComboBoxActionControl("JOB_WHERES_MULTIPLE_CRED", SchedulerArb.getString("JOB_CREATE_DESTINATION_ADD_MULTIPLE_CREDENTIAL"), connection, string3, null, this.jobCredential, false, this.model.getDelayLoadingChoice());
            String string4 = this.getQuery(connection, "jobCreateGetMultipleDBDestinations");
            IdSqlComboBoxActionControl idSqlComboBoxActionControl4 = new IdSqlComboBoxActionControl("JOB_WHERES_MULTIPLE_DEST", SchedulerArb.getString("JOB_CREATE_DESTINATION_ADD_MULTIPLE_DESTINATION"), connection, string4, null, this.jobDestination, false, this.model.getDelayLoadingChoice());
            final PropertyPanelActionControl propertyPanelActionControl3 = new PropertyPanelActionControl("WHERE_MULTIPLE_PANEL", null);
            ArrayList<IdSqlComboBoxActionControl> arrayList2 = new ArrayList<IdSqlComboBoxActionControl>();
            arrayList2.add(idSqlComboBoxActionControl3);
            arrayList2.add(idSqlComboBoxActionControl4);
            propertyPanelActionControl3.addChildControls(arrayList2);
            arrayMap = new ArrayMap<String, ActionControl>(){
                {
                    this.put(NewJobPropertyPanelModel.JOB_WHERE_LOCAL, propertyPanelActionControl);
                    this.put(NewJobPropertyPanelModel.JOB_WHERE_REMOTE, propertyPanelActionControl2);
                    this.put(NewJobPropertyPanelModel.JOB_WHERE_MULTIPLE, propertyPanelActionControl3);
                }
            };
        } else {
            arrayMap = new ArrayMap<String, ActionControl>(){
                {
                    this.put(NewJobPropertyPanelModel.JOB_WHERE_LOCAL, propertyPanelActionControl);
                }
            };
        }
        string = new CardLayoutActionControl("DESTINATION_NONEXEC_CARDPANEL_NAME", null, CardLayoutPanel.Type.PLAIN, (Map)arrayMap);
        ((CardLayoutActionControl)string).setSelected((Object)this.jobDestinationTypeChoice);
        return string;
    }

    protected ActionControl createExecutableControl(Connection connection) {
        String string;
        String string2 = this.getQuery(connection, "jobCreateGetLocalCredentials");
        IdSqlComboBoxActionControl idSqlComboBoxActionControl = new IdSqlComboBoxActionControl("JOB_WHERES_EXEC_LOCAL_CRED", SchedulerArb.getString("JOB_CREATE_DESTINATION_ADD_LOCAL_EXECUTABLE_CREDENTIAL"), connection, string2, null, this.jobCredential, false, this.model.getDelayLoadingChoice());
        final PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl();
        ArrayList<IdSqlComboBoxActionControl> arrayList = new ArrayList<IdSqlComboBoxActionControl>();
        arrayList.add(idSqlComboBoxActionControl);
        propertyPanelActionControl.addChildControls(arrayList);
        String string3 = this.getQuery(connection, "jobCreateGetRemoteExternalCredentials");
        IdSqlComboBoxActionControl idSqlComboBoxActionControl2 = new IdSqlComboBoxActionControl("JOB_WHERES_EXEC_REMOTE_CRED", SchedulerArb.getString("JOB_CREATE_DESTINATION_ADD_REMOTE_EXECUTABLE_CREDENTIAL"), connection, string3, null, this.jobCredential, false, this.model.getDelayLoadingChoice());
        String string4 = this.getQuery(connection, "jobCreateGetRemoteExternalDestinations");
        Object object = null;
        object = this.model.supportsExternalDBJobs() ? new IdSqlComboBoxActionControl("JOB_WHERES_EXEC_REMOTE_DEST", SchedulerArb.getString("JOB_CREATE_DESTINATION_ADD_REMOTE_EXECUTABLE_DESTINATION"), connection, string4, null, this.jobDestination, false, this.model.getDelayLoadingChoice()) : new TextBoxActionControl("JOB_WHERES_EXEC_REMOTE_DEST", SchedulerArb.getString("JOB_CREATE_DESTINATION_ADD_REMOTE_EXECUTABLE_DESTINATION"), this.jobDestination);
        final PropertyPanelActionControl propertyPanelActionControl2 = new PropertyPanelActionControl();
        ArrayList<IdSqlComboBoxActionControl> arrayList2 = new ArrayList<IdSqlComboBoxActionControl>();
        arrayList2.add(idSqlComboBoxActionControl2);
        arrayList2.add((IdSqlComboBoxActionControl)((Object)object));
        propertyPanelActionControl2.addChildControls(arrayList2);
        ArrayMap arrayMap = null;
        if (this.model.supportsExternalDBJobs()) {
            string = this.getQuery(connection, "jobCreateGetMultipleCredentials");
            IdSqlComboBoxActionControl idSqlComboBoxActionControl3 = new IdSqlComboBoxActionControl("JOB_WHERES_EXEC_MULTIPLE_CRED", SchedulerArb.getString("JOB_CREATE_DESTINATION_ADD_MULTIPLE_EXECUTABLE_CREDENTIAL"), connection, string, null, this.jobCredential, false, this.model.getDelayLoadingChoice());
            String string5 = this.getQuery(connection, "jobCreateGetMultipleExternalDestinations");
            IdSqlComboBoxActionControl idSqlComboBoxActionControl4 = new IdSqlComboBoxActionControl("JOB_WHERES_EXEC_MULTIPLE_DEST", SchedulerArb.getString("JOB_CREATE_DESTINATION_ADD_MULTIPLE_EXECUTABLE_DESTINATION"), connection, string5, null, this.jobDestination, false, this.model.getDelayLoadingChoice());
            final PropertyPanelActionControl propertyPanelActionControl3 = new PropertyPanelActionControl();
            ArrayList<IdSqlComboBoxActionControl> arrayList3 = new ArrayList<IdSqlComboBoxActionControl>();
            arrayList3.add(idSqlComboBoxActionControl3);
            arrayList3.add(idSqlComboBoxActionControl4);
            propertyPanelActionControl3.addChildControls(arrayList3);
            arrayMap = new ArrayMap<String, ActionControl>(){
                {
                    this.put(NewJobPropertyPanelModel.JOB_WHERE_LOCAL, propertyPanelActionControl);
                    this.put(NewJobPropertyPanelModel.JOB_WHERE_REMOTE, propertyPanelActionControl2);
                    this.put(NewJobPropertyPanelModel.JOB_WHERE_MULTIPLE, propertyPanelActionControl3);
                }
            };
        } else {
            arrayMap = new ArrayMap<String, ActionControl>(){
                {
                    this.put(NewJobPropertyPanelModel.JOB_WHERE_LOCAL, propertyPanelActionControl);
                    this.put(NewJobPropertyPanelModel.JOB_WHERE_REMOTE, propertyPanelActionControl2);
                }
            };
        }
        string = new CardLayoutActionControl("DESTINATION_EXEC_CARDPANEL_NAME", null, CardLayoutPanel.Type.PLAIN, (Map)arrayMap);
        ((CardLayoutActionControl)string).setSelected((Object)this.jobDestinationTypeChoice);
        return string;
    }

    private void show(String string) {
        this._cardLayout.show(this.topCardPanel, string);
        this.setCurrentSelector(string);
    }

    private void setCurrentSelector(String string) {
        this._currentSelector = string;
    }

    private String getCurrentSelectorKey() {
        return this._currentSelector;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.jobTypeChoice = ((ActionControl.Value)propertyChangeEvent.getNewValue()).get();
        if (this.jobTypeChoice.equals(NewJobPropertyPanelModel.JOB_TYPE_EXECUTABLE)) {
            this.show("EXECUTABLE_CHOICE");
        } else {
            this.show("NON_EXECUTABLE_CHOICE");
        }
    }

    public void initialize(Connection connection) {
        super.initialize(connection);
    }
}

