/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.oviewer.base.ViewerAddin;
import oracle.dbtools.raptor.report.addin.ReportAddin;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.dbtools.scheduler.editors.chain.ChainEditorAddin;
import oracle.dbtools.scheduler.editors.graphical.GraphicalEditorAddin;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineModel;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.GraphEngineXML;
import oracle.dbtools.scheduler.reportactions.SchedulerReportAction;
import oracle.ide.Addin;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.ViewId;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import org.w3c.dom.Document;

public class SchedulerAddin
implements Addin,
DockableFactory {
    private static Map<String, Document> editors = new HashMap<String, Document>();
    private static boolean editorsRegistered = false;
    private static GraphEngineXML geXMLProcessor = new GraphEngineXML();

    public void initialize() {
        this.initialiseMenus();
        this.initialiseEditors();
        this.initialiseReports();
    }

    private void initialiseReports() {
        ReportAddin.registerReportPackage((String)"oracle/dbtools/scheduler/reports");
        ResultSetTable.addGridContextMenu((GridContextMenuItem)SchedulerReportAction.getInstance());
    }

    private void initialiseMenus() {
        XMLBasedObjectAction.registerContextMenus((URL)this.getClass().getResource("schedulerMenu.xml"));
    }

    private void initialiseEditors() {
        try {
            ViewerAddin.registerPackage((String)"oracle.dbtools.scheduler.navigator.xml");
            ViewerAddin.registerPackage((String)"oracle.dbtools.scheduler.oviewer.xml");
            EditorManager editorManager = EditorManager.getEditorManager();
            editorManager.registerDynamic((EditorAddin)new GraphicalEditorAddin());
            editorManager.registerDynamic((EditorAddin)new ChainEditorAddin());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void registerGraphEditors() {
        if (!editorsRegistered) {
            editorsRegistered = true;
            try {
                URLFileSystemHelper uRLFileSystemHelper = URLFileSystem.findHelper((String)"ide.scheduler");
                if (uRLFileSystemHelper == null) {
                    uRLFileSystemHelper = URLFileSystem.findHelper((String)"ide.text");
                }
                URLFileSystem.registerHelper((String)"ide.scheduler", (URLFileSystemHelper)uRLFileSystemHelper);
                String string = "oracle.dbtools.scheduler.editors.graphical.xml";
                List list = FileUtils.getFilesInPackage((String)string, (String)".xml");
                for (URL uRL : list) {
                    try {
                        String string2 = geXMLProcessor.getModelName(uRL);
                        editors.put(string2, geXMLProcessor.getDocument());
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Dockable getDockable(ViewId viewId) {
        return null;
    }

    public void install() {
    }

    public static GraphEngineModel getGraphEngineModel(String string) {
        GraphEngineModel graphEngineModel;
        Document document = editors.get(string);
        try {
            graphEngineModel = geXMLProcessor.processDocument(document);
        }
        catch (Exception exception) {
            graphEngineModel = null;
        }
        return graphEngineModel;
    }

    static {
        SchedulerAddin.registerGraphEditors();
    }
}

