/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.TransferHandler;
import oracle.dbtools.spatial.mapviewer.CheckQueryListItem;
import oracle.dbtools.spatial.mapviewer.ReorderableJList;

class RJLDropHandler
extends TransferHandler {
    private final boolean DEBUG = false;
    ReorderableJList list;

    public RJLDropHandler(ReorderableJList reorderableJList) {
        this.list = reorderableJList;
    }

    public ReorderableJList getReorderableJList() {
        return this.list;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (!transferSupport.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return false;
        }
        JList.DropLocation dropLocation = (JList.DropLocation)transferSupport.getDropLocation();
        return dropLocation.getIndex() != -1;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        String string;
        if (!this.canImport(transferSupport)) {
            return false;
        }
        Transferable transferable = transferSupport.getTransferable();
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            return false;
        }
        int n = Integer.parseInt(string);
        JList.DropLocation dropLocation = (JList.DropLocation)transferSupport.getDropLocation();
        int n2 = dropLocation.getIndex();
        this.reorderList(n, n2, this.list);
        return true;
    }

    private void reorderList(int n, int n2, ReorderableJList reorderableJList) {
        try {
            CheckQueryListItem checkQueryListItem = (CheckQueryListItem)this.list.getModel().getElementAt(n);
            ((DefaultListModel)reorderableJList.getModel()).remove(n);
            int n3 = ((DefaultListModel)reorderableJList.getModel()).getSize();
            if (n2 == 0) {
                n2 = 1;
            }
            ((DefaultListModel)reorderableJList.getModel()).add(n2 - 1, checkQueryListItem);
            int n4 = ((DefaultListModel)reorderableJList.getModel()).getSize();
            for (int i = 0; i < n4; ++i) {
                CheckQueryListItem checkQueryListItem2 = (CheckQueryListItem)reorderableJList.getModel().getElementAt(i);
                if (checkQueryListItem2 == null) continue;
                checkQueryListItem2.setLayerNumber(i);
                this.getReorderableJList().persist(checkQueryListItem2.getQueryTitle());
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }
}

