/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.CheckTypes;
import oracle.jdbc.driver.OracleDriver;

public class OracleDatabaseConnector {
    private String m_hostname = null;
    private String m_sid = null;
    private String m_port = null;
    private String m_login = null;
    private String m_password = null;
    private static final boolean DEBUG = false;

    public void register(String string, String string2, String string3, String string4, String string5) throws Exception {
        if (!CheckTypes.isValidString(string)) {
            throw new Exception(SpatialArb.getString("SpatialError13505"));
        }
        this.m_hostname = string;
        if (!CheckTypes.isValidString(string2)) {
            throw new Exception(SpatialArb.getString("SpatialError13506"));
        }
        this.m_sid = string2;
        if (!CheckTypes.isValidString(string3)) {
            throw new Exception(SpatialArb.getString("SpatialError13507"));
        }
        this.m_port = string3;
        if (!CheckTypes.isValidString(string4)) {
            throw new Exception(SpatialArb.getString("SpatialError13508"));
        }
        this.m_login = string4;
        if (!CheckTypes.isValidString(string5)) {
            throw new Exception(SpatialArb.getString("SpatialError13509"));
        }
        this.m_password = string5;
    }

    public Connection connect() throws SQLException {
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection connection = DriverManager.getConnection("jdbc:oracle:thin:@" + this.m_hostname + ":" + this.m_port + ":" + this.m_sid, this.m_login, this.m_password);
        return connection;
    }

    public boolean testConnection() {
        try {
            OracleDatabaseConnector oracleDatabaseConnector = new OracleDatabaseConnector();
            oracleDatabaseConnector.register(this.m_hostname, this.m_sid, this.m_port, this.m_login, this.m_password);
            Connection connection = oracleDatabaseConnector.connect();
            return oracleDatabaseConnector.testConnection(connection);
        }
        catch (SQLException sQLException) {
            System.out.println("OracleDatabaseConnector.testConnection.Error Message: " + sQLException.getMessage());
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            return false;
        }
        catch (Exception exception) {
            System.out.println("OracleDatabaseConnector.testConnection.Error Message: " + exception.getMessage());
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return false;
        }
    }

    public boolean testConnection(Connection connection) {
        if (connection != null) {
            System.out.println("OracleDatabaseConnector.testConnection.Connection Passed");
            return true;
        }
        System.out.println("OracleDatabaseConnector.testConnection.Connection Failed");
        return false;
    }

    public static void main(String[] stringArray) {
        try {
            OracleDatabaseConnector oracleDatabaseConnector = new OracleDatabaseConnector();
            oracleDatabaseConnector.register("stadq38", "ora112", "1521", "self", "self");
            Connection connection = oracleDatabaseConnector.connect();
            oracleDatabaseConnector.testConnection(connection);
            oracleDatabaseConnector.register("stadq38", "ora112", "1521", "self", "self");
            Connection connection2 = oracleDatabaseConnector.connect();
            oracleDatabaseConnector.testConnection(connection2);
        }
        catch (SQLException sQLException) {
            System.out.println("OracleDatabaseConnector.main.Error Message: " + sQLException.getMessage());
        }
        catch (Exception exception) {
            System.out.println("OracleDatabaseConnector.main.Error Message: " + exception.getMessage());
        }
    }
}

