/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.AnnotatedGeometry;
import oracle.dbtools.spatial.mapviewer.CheckQueryListItem;
import oracle.dbtools.spatial.mapviewer.CheckQueryListItemComparator;
import oracle.dbtools.spatial.mapviewer.CheckQueryListRenderer;
import oracle.dbtools.spatial.mapviewer.DropTargetJPanel;
import oracle.dbtools.spatial.mapviewer.ImagePanel;
import oracle.dbtools.spatial.mapviewer.MapGeometry;
import oracle.dbtools.spatial.mapviewer.MapGeometryCache;
import oracle.dbtools.spatial.mapviewer.MapViewerGeometryResultSet;
import oracle.dbtools.spatial.mapviewer.MapViewerHistoryDB;
import oracle.dbtools.spatial.mapviewer.MapViewerHistoryItem;
import oracle.dbtools.spatial.mapviewer.MapViewerRenderer;
import oracle.dbtools.spatial.mapviewer.QueryButton;
import oracle.dbtools.spatial.mapviewer.QueryEditDialog3;
import oracle.dbtools.spatial.mapviewer.QueryListCache;
import oracle.dbtools.spatial.mapviewer.QueryListHandler;
import oracle.ide.Ide;
import oracle.ide.help.HelpInfo;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.spatial.geometry.JGeometry;

public class MapViewerPanel3
extends DropTargetJPanel {
    protected static final int STATE_DEFAULT = 0;
    protected static final int STATE_ZOOM_IN = 1;
    protected static final int STATE_ZOOM_OUT = 2;
    protected static final int STATE_ZOOM_FIT = 3;
    protected static final int STATE_ZOOM_MARQUEE = 4;
    protected static final int STATE_ZOOM_MARQUEE_DRAWIMAGE = 5;
    protected static final int ZOOM_IN = 50;
    protected static final int ZOOM_OUT = 50;
    private final boolean DEBUG = false;
    private int queryListIndex = 0;
    Container parentContentPane = null;
    String selectedQuery = "";
    QueryListCache queryCache = null;
    int currentImageWidth = 0;
    int currentImageHeight = 0;
    CheckQueryListItem[] qits;
    int currentLayerIndex = 0;
    MapViewerGeometryResultSet mvrs = null;
    DBConnectionComboBox dbSelector;
    MapViewerHistoryDB historyDB;
    String previousConnectionName = null;
    boolean isMarqueeZoomStateActive = false;
    int state = 0;
    private static MapViewerPanel3 mapViewerPanel3 = null;
    private Icon panIcon;
    private Icon zoomInIcon;
    private Icon zoomOutIcon;
    private Icon fitIcon;
    private Icon marqueeOverIcon;
    private Icon marqueeDownIcon;
    private Icon marqueeZoomIcon;
    private Icon newQueryIcon;
    private Icon editQueryIcon;
    private Icon removeQueryIcon;
    private Icon submitQueryIcon;
    private JButton FillButton;
    private JPanel MapQueryPanel;
    private JSplitPane MapQuerySplitPane;
    private JPanel QueryPanel;
    private JButton ZoomInButton;
    private JButton ZoomOutButton;
    private JButton newQueryButton;
    private QueryButton editQueryButton;
    private QueryListHandler jList1;
    private JScrollPane jScrollPane1;
    private JLabel queryLabel;
    private JButton removeQueryButton;
    private JButton submitButton;
    private JButton MarqueeZoomButton;
    private JPanel topMostPanel;
    private QueryEditDialog3 queryDialog;
    private JPanel MapPanel;
    private JToolBar MapToolBar;
    private JPanel QueryListPanel;
    private JToolBar QueryListToolBar;
    private JComboBox dataSourceComboBox;
    private JPanel dataSourcePanel;
    MapGeometry[] allGeoms = null;
    private static ImagePanel imagePanel = null;

    private MapViewerPanel3() {
        try {
            this.queryCache = QueryListCache.getInstance();
            this.initDBConnectionComboBox();
            this.initMapHistoryDB();
            this.initComponents();
            this.setState(0);
            imagePanel = ImagePanel.getInstance();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public static MapViewerPanel3 getInstance() {
        if (mapViewerPanel3 == null) {
            mapViewerPanel3 = new MapViewerPanel3();
        }
        return mapViewerPanel3;
    }

    public void setContentPane(Container container) {
        this.parentContentPane = container;
    }

    public Container getContentPane() {
        return this.parentContentPane;
    }

    private void initDBConnectionComboBox() {
        this.dbSelector = new DBConnectionComboBox(){

            public void addConnection(String string) {
                if (Connections.getInstance().isOracle(string)) {
                    super.addConnection(string);
                }
            }
        };
        this.dbSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapViewerPanel3.this.dataSourceComboBoxActionPerformed(actionEvent);
                MapViewerPanel3.this.topMostPanel.requestFocus();
            }
        });
    }

    private void initMapHistoryDB() {
        this.historyDB = MapViewerHistoryDB.getDatabase();
    }

    private boolean isMapHistoryDBReadOnly() {
        return MapViewerHistoryDB.getDatabase().isReadOnly();
    }

    private void loadIcons() {
        this.zoomInIcon = SpatialArb.getIcon("ZOOM_IN_BUTTON_ICON");
        this.zoomOutIcon = SpatialArb.getIcon("ZOOM_OUT_BUTTON_ICON");
        this.fitIcon = SpatialArb.getIcon("FIT_BUTTON_ICON");
        this.newQueryIcon = OracleIcons.getIcon((String)"add.png");
        this.editQueryIcon = OracleIcons.getIcon((String)"edit.png");
        this.removeQueryIcon = OracleIcons.getIcon((String)"delete.png");
        this.submitQueryIcon = OracleIcons.getIcon((String)"refresh.png");
        this.marqueeOverIcon = SpatialArb.getIcon("MARQUEE_ZOOM_BUTTON_OVER_ICON");
        this.marqueeDownIcon = SpatialArb.getIcon("MARQUEE_ZOOM_BUTTON_DOWN_ICON");
        this.marqueeZoomIcon = SpatialArb.getIcon("MARQUEE_ZOOM_BUTTON_ICON");
        this.panIcon = OracleIcons.getIcon((String)"pan.png");
    }

    private void setState(int n) {
        this.state = n;
        imagePanel.setState(this.state);
    }

    private int getState() {
        return this.state;
    }

    private void initComponents() {
        this.topMostPanel = new JPanel();
        this.MapQueryPanel = new JPanel();
        this.MapQuerySplitPane = new JSplitPane();
        this.MapPanel = new JPanel();
        this.MapToolBar = new JToolBar();
        this.ZoomInButton = new JButton();
        this.ZoomOutButton = new JButton();
        this.FillButton = new JButton();
        this.MarqueeZoomButton = new JButton();
        imagePanel = ImagePanel.getInstance();
        this.QueryListPanel = new JPanel();
        this.QueryPanel = new JPanel();
        this.queryLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new QueryListHandler(this);
        this.QueryListToolBar = new JToolBar();
        this.newQueryButton = new JButton();
        this.editQueryButton = new QueryButton();
        this.removeQueryButton = new JButton();
        this.submitButton = new JButton();
        this.dataSourcePanel = new JPanel();
        this.dataSourceComboBox = new JComboBox();
        this.loadIcons();
        this.MapQuerySplitPane.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.MapQuerySplitPane.setDividerLocation(700);
        this.MapQuerySplitPane.setDividerSize(10);
        this.MapQuerySplitPane.setLastDividerLocation(500);
        this.MapPanel.setLayout(new BorderLayout());
        this.MapToolBar.setBorder(BorderFactory.createLineBorder(new Color(150, 150, 150)));
        this.MapToolBar.setFloatable(false);
        this.MapToolBar.setBorderPainted(true);
        this.MapToolBar.setFocusable(false);
        this.MapToolBar.setOpaque(false);
        this.ZoomInButton.setIcon(this.zoomInIcon);
        this.ZoomInButton.setToolTipText(SpatialArb.getString("MapViewerPanelToolTipZoomIn"));
        this.ZoomInButton.setBorder(null);
        this.ZoomInButton.setFocusable(true);
        this.ZoomInButton.setHorizontalTextPosition(0);
        this.ZoomInButton.setVerticalTextPosition(3);
        this.ZoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapViewerPanel3.this.ZoomInButtonActionPerformed(actionEvent);
            }
        });
        this.ZoomInButton.setName("ZoomInButtonMainMapViewer");
        this.MapToolBar.add(this.ZoomInButton);
        this.ZoomOutButton.setIcon(this.zoomOutIcon);
        this.ZoomOutButton.setToolTipText(SpatialArb.getString("MapViewerPanelToolTipZoomOut"));
        this.ZoomOutButton.setBorder(null);
        this.ZoomOutButton.setFocusable(true);
        this.ZoomOutButton.setHorizontalTextPosition(0);
        this.ZoomOutButton.setVerticalTextPosition(3);
        this.ZoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapViewerPanel3.this.ZoomOutButtonActionPerformed(actionEvent);
            }
        });
        this.ZoomOutButton.setName("ZoomOutButtonMainMapViewer");
        this.MapToolBar.add(this.ZoomOutButton);
        this.FillButton.setIcon(this.fitIcon);
        this.FillButton.setToolTipText(SpatialArb.getString("MapViewerPanelToolTipFit"));
        this.FillButton.setBorder(null);
        this.FillButton.setFocusable(true);
        this.FillButton.setHorizontalTextPosition(0);
        this.FillButton.setVerticalTextPosition(3);
        this.FillButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapViewerPanel3.this.FillButtonActionPerformed(actionEvent);
            }
        });
        this.FillButton.setName("FitButtonMainMapViewer");
        this.MapToolBar.add(this.FillButton);
        this.MarqueeZoomButton.setIcon(this.marqueeZoomIcon);
        this.MarqueeZoomButton.setToolTipText(SpatialArb.getString("MapViewerPanelToolTipMarqueeZoom"));
        this.MarqueeZoomButton.setBorder(null);
        this.MarqueeZoomButton.setFocusable(true);
        this.MarqueeZoomButton.setHorizontalTextPosition(0);
        this.MarqueeZoomButton.setVerticalTextPosition(3);
        this.MarqueeZoomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapViewerPanel3.this.MarqueeZoomButtonActionPerformed(actionEvent);
            }
        });
        this.MarqueeZoomButton.setName("MarqueeButtonMainMapViewer");
        this.MapToolBar.add(this.MarqueeZoomButton);
        this.MapPanel.add((Component)this.MapToolBar, "North");
        imagePanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        imagePanel.setPreferredSize(new Dimension(100, 100));
        GroupLayout groupLayout = new GroupLayout(imagePanel);
        imagePanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 697, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 312, Short.MAX_VALUE));
        this.MapPanel.add((Component)imagePanel, "Center");
        this.MapQuerySplitPane.setLeftComponent(this.MapPanel);
        this.MapPanel.getAccessibleContext().setAccessibleParent(this.MapQuerySplitPane);
        this.QueryListPanel.setLayout(new BorderLayout());
        this.QueryListPanel.setFocusable(false);
        this.queryLabel.setText(SpatialArb.getString("MapViewerPanelQueryList"));
        this.jList1.setModel(new DefaultListModel(){
            CheckQueryListItem[] qits = new CheckQueryListItem[0];

            @Override
            public int getSize() {
                return this.qits.length;
            }

            @Override
            public Object getElementAt(int n) {
                return this.qits[n];
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MapViewerPanel3.this.queryListMouseControl(mouseEvent);
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JList jList = (JList)actionEvent.getSource();
                int n = jList.getModel().getSize();
                MapViewerPanel3.this.queryListIndex++;
                if (MapViewerPanel3.this.queryListIndex > n) {
                    MapViewerPanel3.this.queryListIndex = n;
                }
                MapViewerPanel3.this.queryListKeyControl(actionEvent, MapViewerPanel3.this.queryListIndex);
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(40, 0, false);
        this.jList1.registerKeyboardAction(actionListener, keyStroke, 0);
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapViewerPanel3.this.queryListIndex--;
                if (MapViewerPanel3.this.queryListIndex < 0) {
                    MapViewerPanel3.this.queryListIndex = 0;
                }
                MapViewerPanel3.this.queryListKeyControl(actionEvent, MapViewerPanel3.this.queryListIndex);
            }
        };
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(38, 0, false);
        this.jList1.registerKeyboardAction(actionListener2, keyStroke2, 0);
        this.jList1.setCellRenderer(new CheckQueryListRenderer(this));
        this.jList1.setSelectionMode(0);
        this.jList1.setFocusable(true);
        this.jScrollPane1.setViewportView(this.jList1);
        this.jScrollPane1.setFocusable(false);
        GroupLayout groupLayout2 = new GroupLayout(this.QueryPanel);
        this.QueryPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.queryLabel).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 349, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.queryLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 269, Short.MAX_VALUE).addContainerGap()));
        this.QueryListPanel.add((Component)this.QueryPanel, "Center");
        this.QueryListToolBar.setRollover(true);
        this.newQueryButton.setIcon(this.newQueryIcon);
        this.newQueryButton.setToolTipText(SpatialArb.getString("MapViewerPanelToolTipNewQuery"));
        this.newQueryButton.setBorder(null);
        this.newQueryButton.setFocusable(true);
        this.newQueryButton.setHorizontalTextPosition(0);
        this.newQueryButton.setVerticalTextPosition(3);
        this.newQueryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapViewerPanel3.this.newQueryButtonActionPerformed(actionEvent);
            }
        });
        this.newQueryButton.setName("NewQueryButtonMainMapViewer");
        if (this.isMapHistoryDBReadOnly()) {
            this.newQueryButton.setEnabled(false);
        } else {
            this.newQueryButton.setEnabled(true);
        }
        this.QueryListToolBar.add(this.newQueryButton);
        this.newQueryButton.getAccessibleContext().setAccessibleParent(this.MapToolBar);
        this.editQueryButton.setIcon(this.editQueryIcon);
        this.editQueryButton.setToolTipText(SpatialArb.getString("MapViewerPanelToolTipEditQuery"));
        this.editQueryButton.setBorder(null);
        this.editQueryButton.setFocusable(true);
        this.editQueryButton.setHorizontalTextPosition(0);
        this.editQueryButton.setVerticalTextPosition(3);
        this.editQueryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapViewerPanel3.this.editQueryButtonActionPerformed(actionEvent);
            }
        });
        this.editQueryButton.setName("EditQueryButtonMainMapViewer");
        if (this.isMapHistoryDBReadOnly()) {
            this.editQueryButton.setEnabled(false);
        } else {
            this.editQueryButton.setEnabled(true);
        }
        this.QueryListToolBar.add(this.editQueryButton);
        this.editQueryButton.getAccessibleContext().setAccessibleParent(this.MapToolBar);
        this.editQueryButton.setEnabled(false);
        this.removeQueryButton.setIcon(this.removeQueryIcon);
        this.removeQueryButton.setToolTipText(SpatialArb.getString("MapViewerPanelToolTipRemoveQuery"));
        this.removeQueryButton.setBorder(null);
        this.removeQueryButton.setFocusable(true);
        this.removeQueryButton.setHorizontalTextPosition(0);
        this.removeQueryButton.setVerticalTextPosition(3);
        this.removeQueryButton.setEnabled(false);
        this.removeQueryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapViewerPanel3.this.removeQueryButtonActionPerformed(actionEvent);
            }
        });
        this.removeQueryButton.setName("RemoveQueryButtonMainMapViewer");
        if (this.isMapHistoryDBReadOnly()) {
            this.removeQueryButton.setEnabled(false);
        } else {
            this.removeQueryButton.setEnabled(true);
        }
        this.QueryListToolBar.add(this.removeQueryButton);
        this.removeQueryButton.getAccessibleContext().setAccessibleParent(this.MapToolBar);
        this.submitButton.setIcon(this.submitQueryIcon);
        this.submitButton.setToolTipText(SpatialArb.getString("MapViewerPanelToolTipRefresh"));
        this.submitButton.setBorder(null);
        this.submitButton.setFocusable(true);
        this.submitButton.setHorizontalTextPosition(0);
        this.submitButton.setVerticalTextPosition(3);
        this.submitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MapViewerPanel3.this.submitButtonActionPerformed(actionEvent);
            }
        });
        this.submitButton.setName("RefreshQueryButtonMainMapViewer");
        this.QueryListToolBar.add(this.submitButton);
        this.submitButton.getAccessibleContext().setAccessibleParent(this.MapToolBar);
        GroupLayout groupLayout3 = new GroupLayout(this.dataSourcePanel);
        this.dataSourcePanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap(164, Short.MAX_VALUE).addComponent(this.dbSelector.getJComboBox(), -2, 82, -2).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dbSelector.getJComboBox(), -2, -1, -2));
        this.QueryListToolBar.add(this.dataSourcePanel);
        this.QueryListPanel.add((Component)this.QueryListToolBar, "North");
        this.MapQuerySplitPane.setRightComponent(this.QueryListPanel);
        GroupLayout groupLayout4 = new GroupLayout(this.MapQueryPanel);
        this.MapQueryPanel.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.MapQuerySplitPane, GroupLayout.Alignment.TRAILING, -1, 300, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.MapQuerySplitPane, -1, 100, Short.MAX_VALUE));
        GroupLayout groupLayout5 = new GroupLayout(this.topMostPanel);
        this.topMostPanel.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.MapQueryPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.MapQueryPanel, -1, -1, Short.MAX_VALUE));
        GroupLayout groupLayout6 = new GroupLayout(this);
        this.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.topMostPanel, -1, -1, Short.MAX_VALUE));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.topMostPanel, -1, -1, Short.MAX_VALUE));
    }

    private void newQueryButtonActionPerformed(ActionEvent actionEvent) {
        this.invokeNewQueryDialog();
    }

    private void invokeNewQueryDialog() {
        if (!this.ensureConnection()) {
            return;
        }
        this.queryDialog = new QueryEditDialog3((Frame)new JFrame(), true, this.jList1);
        this.queryDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
        this.queryDialog.setVisible(true);
        String string = this.queryDialog.getQueryTitle().trim();
        String string2 = this.queryDialog.getQueryText().trim();
        String string3 = this.queryDialog.getAnnotatedColumnName();
        Color color = this.queryDialog.getFillColor();
        Color color2 = this.queryDialog.getLineColor();
        if (string.length() > 0) {
            int n;
            DefaultListModel defaultListModel = new DefaultListModel();
            for (n = 0; n < this.jList1.getModel().getSize(); ++n) {
                defaultListModel.addElement(this.jList1.getModel().getElementAt(n));
            }
            n = this.jList1.getModel().getSize();
            defaultListModel.addElement(new CheckQueryListItem(string, string2, color2, color, string3, n));
            this.jList1.setModel(defaultListModel);
        }
        this.saveQueryTitleToSleepyCatDB(string);
    }

    @Override
    public void invokeNewQueryDialog(String string, String string2, boolean bl) {
        this.invokeNewQueryDialog(string, string2, bl, null);
    }

    public void invokeNewQueryDialog(String string, String string2, boolean bl, String string3) {
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Color color = null;
        Color color2 = null;
        String string7 = null;
        boolean bl2 = false;
        if (this.isMapHistoryDBReadOnly()) {
            return;
        }
        if (string3 != null && string3.length() > 0) {
            this.setUserPreferredConnection(string3);
        } else if (!this.ensureConnection()) {
            return;
        }
        if (bl) {
            this.queryDialog = new QueryEditDialog3(new JFrame(), true, string, string2, this.jList1);
            this.queryDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                }
            });
            this.queryDialog.setVisible(true);
            string4 = this.queryDialog.getQueryTitle();
            string5 = this.queryDialog.getQueryText();
            string6 = this.queryDialog.getQueryText();
            color = this.queryDialog.getFillColor();
            color2 = this.queryDialog.getLineColor();
            string7 = this.queryDialog.getAnnotatedColumnName();
        } else {
            string4 = string;
            string5 = string2;
            string6 = "";
            color = QueryEditDialog3.getDefaultFillColor();
            color2 = QueryEditDialog3.getDefaultLineColor();
            string7 = "";
            bl2 = true;
        }
        MapViewerGeometryResultSet mapViewerGeometryResultSet = MapViewerGeometryResultSet.getInstance();
        if (!mapViewerGeometryResultSet.isValidSpatialQuery(string5)) {
            return;
        }
        if (string4.length() > 0) {
            CheckQueryListItem checkQueryListItem;
            int n;
            DefaultListModel<CheckQueryListItem> defaultListModel = new DefaultListModel<CheckQueryListItem>();
            for (n = 0; n < this.jList1.getModel().getSize(); ++n) {
                checkQueryListItem = (CheckQueryListItem)this.jList1.getModel().getElementAt(n);
                checkQueryListItem.setSelected(false);
                defaultListModel.addElement(checkQueryListItem);
            }
            if (bl2) {
                for (n = 0; n < defaultListModel.getSize(); ++n) {
                    if (!((CheckQueryListItem)defaultListModel.getElementAt(n)).getQueryTitle().equals(string4)) continue;
                    string4 = this.getUniqueName(string);
                }
            } else {
                for (n = 0; n < defaultListModel.getSize(); ++n) {
                    if (!((CheckQueryListItem)defaultListModel.getElementAt(n)).getQueryTitle().equals(string4)) continue;
                    MessageDialog.critical((Component)Ide.getMainWindow(), (Object)SpatialArb.getString("SpatialError13515"), (String)SpatialArb.getString("MapViewerQueryTitleUniqnessError"), null);
                    return;
                }
            }
            n = this.jList1.getModel().getSize();
            checkQueryListItem = new CheckQueryListItem(string4, string5, color2, color, string7, n);
            checkQueryListItem.setSelected(true);
            defaultListModel.addElement(checkQueryListItem);
            CheckQueryListRenderer checkQueryListRenderer = (CheckQueryListRenderer)this.jList1.getCellRenderer();
            int n2 = this.jList1.getModel().getSize() - 1;
            checkQueryListRenderer.getListCellRendererComponent((JList)this.jList1, checkQueryListItem, n2, true, true);
            this.jList1.setModel(defaultListModel);
            this.enableEditButton(true);
            this.enableRemoveButton(true);
        }
        this.jList1.setSelectedIndex(this.jList1.getModel().getSize() - 1);
        this.saveQueryTitleToSleepyCatDB(string4);
        this.executeQueries();
    }

    private void editQueryButtonActionPerformed(ActionEvent actionEvent) {
        this.invokeEditQueryButtonDialog();
    }

    private void invokeEditQueryButtonDialog() {
        if (!this.ensureConnection()) {
            return;
        }
        this.queryDialog = new QueryEditDialog3((Frame)new JFrame(), true, this.jList1, true);
        this.queryDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
        int n = this.jList1.getSelectedIndex();
        if (n == -1) {
            return;
        }
        CheckQueryListItem checkQueryListItem = (CheckQueryListItem)this.jList1.getModel().getElementAt(n);
        String string = checkQueryListItem.toString();
        String string2 = checkQueryListItem.getQuery();
        String string3 = checkQueryListItem.getAnnotatedColumn();
        Color color = checkQueryListItem.getFillColor();
        Color color2 = checkQueryListItem.getLineColor();
        this.queryDialog.updateFields(string, string2, color2, color, string3);
        this.queryDialog.setVisible(true);
        String string4 = this.queryDialog.getQueryTitle();
        String string5 = this.queryDialog.getQueryText();
        Color color3 = this.queryDialog.getFillColor();
        Color color4 = this.queryDialog.getLineColor();
        String string6 = this.queryDialog.getAnnotatedColumnName();
        if (string4.length() > 0) {
            this.editQueryButton.setQueryText(string5);
            this.editQueryButton.setQueryTitle(string4);
            int n2 = this.jList1.getSelectedIndex();
            Vector<CheckQueryListItem> vector = new Vector<CheckQueryListItem>();
            for (int i = 0; i < this.jList1.getModel().getSize(); ++i) {
                vector.add((CheckQueryListItem)this.jList1.getModel().getElementAt(i));
            }
            if (n > -1) {
                vector.removeElementAt(n);
                CheckQueryListItem checkQueryListItem2 = (CheckQueryListItem)this.jList1.getModel().getElementAt(n);
                checkQueryListItem2.remove();
                CheckQueryListItem checkQueryListItem3 = new CheckQueryListItem(string4, string5, color4, color3, string6, n);
                checkQueryListItem3.setSelected(true);
                vector.insertElementAt(checkQueryListItem3, n);
            }
            DefaultListModel defaultListModel = new DefaultListModel();
            for (int i = 0; i < this.jList1.getModel().getSize(); ++i) {
                defaultListModel.addElement(vector.elementAt(i));
            }
            this.jList1.setModel(defaultListModel);
            if (!string.equals(string4)) {
                System.out.println("existingQueryTitle=" + string);
                this.removeQueryTitleFromSleepyCatDB(string);
            }
            this.removeQueryTitleFromSleepyCatDB(string4);
            this.saveQueryTitleToSleepyCatDB(string4);
        }
    }

    private void removeQueryButtonActionPerformed(ActionEvent actionEvent) {
        if (!this.ensureConnection()) {
            return;
        }
        this.removeQueryFromList();
    }

    private void removeQueryFromList() {
        CheckQueryListItem checkQueryListItem;
        int n;
        DefaultListModel<CheckQueryListItem> defaultListModel = new DefaultListModel<CheckQueryListItem>();
        for (n = 0; n < this.jList1.getModel().getSize(); ++n) {
            checkQueryListItem = (CheckQueryListItem)this.jList1.getModel().getElementAt(n);
            defaultListModel.addElement(checkQueryListItem);
        }
        n = this.jList1.getSelectedIndex();
        if (n <= -1) {
            return;
        }
        checkQueryListItem = (CheckQueryListItem)this.jList1.getModel().getElementAt(n);
        if (checkQueryListItem.isGrayedOut()) {
            return;
        }
        if (n > -1) {
            this.removeQueryTitleFromSleepyCatDB(checkQueryListItem.getQueryTitle());
            checkQueryListItem.remove();
        }
        if (n > -1) {
            defaultListModel.remove(n);
        }
        this.removeConnectionInstancesFromSleepyCatDB(this.getCurrentConnectionName());
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            CheckQueryListItem checkQueryListItem2 = (CheckQueryListItem)defaultListModel.getElementAt(i);
            checkQueryListItem2.setLayerNumber(i);
            String string = checkQueryListItem2.getQueryTitle();
            this.saveQueryTitleToSleepyCatDB(string);
        }
        this.jList1.setModel(defaultListModel);
        this.enableOrDisableEditAndDeleteButtonBasedOnListStatus();
    }

    private void cleanQueryLists() {
        DefaultListModel defaultListModel = (DefaultListModel)this.jList1.getModel();
        int n = defaultListModel.getSize();
        for (int i = 0; i < n; ++i) {
            CheckQueryListItem checkQueryListItem = (CheckQueryListItem)defaultListModel.get(i);
            if (checkQueryListItem == null) continue;
            checkQueryListItem.remove();
        }
        defaultListModel.clear();
        DefaultListModel defaultListModel2 = new DefaultListModel();
        this.jList1.setModel(defaultListModel2);
    }

    private void FillButtonActionPerformed(ActionEvent actionEvent) {
        this.isMarqueeZoomStateActive = false;
        this.MarqueeZoomButton.setIcon(this.marqueeZoomIcon);
        this.setState(3);
        this.refreshImage();
    }

    private void ZoomInButtonActionPerformed(ActionEvent actionEvent) {
        int n = 50;
        if (imagePanel != null) {
            this.currentImageWidth = imagePanel.getImageWidth();
            this.currentImageHeight = imagePanel.getImageHeight();
            imagePanel.removeImage();
        }
        this.isMarqueeZoomStateActive = false;
        this.MarqueeZoomButton.setIcon(this.marqueeZoomIcon);
        this.setState(1);
        if (this.allGeoms != null && this.allGeoms.length > 0) {
            this.drawImage(this.allGeoms, this.currentImageWidth + n, this.currentImageHeight + n);
        }
    }

    private void ZoomOutButtonActionPerformed(ActionEvent actionEvent) {
        int n = 50;
        if (imagePanel != null) {
            this.currentImageWidth = imagePanel.getImageWidth();
            this.currentImageHeight = imagePanel.getImageHeight();
            imagePanel.removeImage();
        }
        this.isMarqueeZoomStateActive = false;
        this.MarqueeZoomButton.setIcon(this.marqueeZoomIcon);
        this.setState(2);
        if (this.allGeoms != null && this.allGeoms.length > 0) {
            this.drawImage(this.allGeoms, this.currentImageWidth - n, this.currentImageHeight - n);
        }
    }

    private void submitButtonActionPerformed(ActionEvent actionEvent) {
        if (!this.ensureConnection()) {
            return;
        }
        this.executeQueries();
    }

    private void executeQueries() {
        if (imagePanel != null) {
            imagePanel.removeImage();
        } else {
            imagePanel = ImagePanel.getInstance();
        }
        this.setState(3);
        this.allGeoms = this.queryAllGeometries();
        if (this.allGeoms != null && this.allGeoms.length > 0) {
            Dimension dimension;
            this.currentImageWidth = imagePanel.getWidth();
            this.currentImageHeight = imagePanel.getHeight();
            if (this.currentImageWidth == 0 && this.currentImageHeight == 0 && (dimension = imagePanel.getPreferredSize()) != null) {
                this.currentImageWidth = dimension.width;
                this.currentImageHeight = dimension.height;
            }
            this.drawImage(this.allGeoms, this.currentImageWidth, this.currentImageHeight);
        }
    }

    private void MarqueeZoomButtonActionPerformed(ActionEvent actionEvent) {
        if (!this.isMarqueeZoomStateActive) {
            this.isMarqueeZoomStateActive = true;
            this.currentImageWidth = imagePanel.getImageWidth();
            this.currentImageHeight = imagePanel.getImageHeight();
            this.setState(4);
            if (this.allGeoms != null && this.allGeoms.length > 0) {
                this.drawImage(this.allGeoms, this.currentImageWidth, this.currentImageHeight);
            }
            this.isMarqueeZoomStateActive = false;
        } else {
            this.MarqueeZoomButton.setIcon(this.marqueeZoomIcon);
            this.isMarqueeZoomStateActive = false;
            this.setState(0);
        }
    }

    private void queryListMouseControl(MouseEvent mouseEvent) {
        JList jList = (JList)mouseEvent.getSource();
        int n = jList.getModel().getSize();
        if (n == 0) {
            return;
        }
        int n2 = jList.locationToIndex(mouseEvent.getPoint());
        if (n2 < 0) {
            return;
        }
        Rectangle rectangle = jList.getCellBounds(n2, n2);
        if (rectangle == null) {
            return;
        }
        if (!rectangle.contains(mouseEvent.getPoint())) {
            return;
        }
        CheckQueryListItem checkQueryListItem = (CheckQueryListItem)jList.getModel().getElementAt(n2);
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            jList.setSelectedIndex(n2);
            this.invokeEditQueryButtonDialog();
        } else {
            checkQueryListItem.setSelected(!checkQueryListItem.isSelected());
            jList.setSelectedIndex(n2);
            jList.repaint(jList.getCellBounds(n2, n2));
        }
        this.enableOrDisableEditAndDeleteButtonBasedOnListStatus();
    }

    private void queryListKeyControl(ActionEvent actionEvent, int n) {
        JList jList = (JList)actionEvent.getSource();
        this.queryListKeyControl(jList, n);
    }

    private void queryListKeyControl(JList jList, int n) {
        CheckQueryListItem checkQueryListItem;
        int n2 = jList.getModel().getSize();
        if (n2 == 0) {
            return;
        }
        if (n < 0) {
            return;
        }
        Rectangle rectangle = jList.getCellBounds(n, n);
        if (rectangle == null) {
            return;
        }
        checkQueryListItem.setSelected(!(checkQueryListItem = (CheckQueryListItem)jList.getModel().getElementAt(n)).isSelected());
        jList.setSelectedIndex(n);
        jList.repaint(jList.getCellBounds(n, n));
        this.enableOrDisableEditAndDeleteButtonBasedOnListStatus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean ensureConnection() {
        try {
            this.mvrs = MapViewerGeometryResultSet.getInstance();
            if (this.mvrs.getDatabaseConnection() == null) {
                String string = ConnectionSelectorUI.getConnection((String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_TITLE"), (String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_LABEL"), null, (boolean)true, (boolean)true);
                if (string == null) throw new Exception(SpatialArb.getString("SpatialError13500"));
                this.setUserPreferredConnection(string);
                return true;
            } else {
                if (!this.mvrs.getDatabaseConnection().isClosed()) return true;
                this.mvrs.setDatabaseConnection(null);
                this.drawEmptyImage();
                throw new Exception(SpatialArb.getString("SpatialError13517"));
            }
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)(Messages.getString((String)"ConnectionDialog.7") + exception.getMessage()), (String)"", null);
            return false;
        }
    }

    @Override
    public String getCurrentConnectionName() {
        if (this.dbSelector != null) {
            String string = this.dbSelector.getCurrentConnectionName();
            if (string == null) {
                return "";
            }
            return string;
        }
        return "";
    }

    public boolean setUserPreferredConnection(String string) {
        if (string != null) {
            try {
                Connection connection = Connections.getInstance().getConnection(string);
                this.dbSelector.addConnection(string);
                this.mvrs = MapViewerGeometryResultSet.getInstance();
                this.mvrs.setDatabaseConnection(connection);
                this.dbSelector.setCurrentConnection(string);
            }
            catch (DBException dBException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
                return false;
            }
        }
        return true;
    }

    private void dataSourceComboBoxActionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        String string = (String)jComboBox.getSelectedItem();
        Connections connections = Connections.getInstance();
        try {
            Connection connection = connections.getConnection(string);
            this.mvrs = MapViewerGeometryResultSet.getInstance();
            this.mvrs.setDatabaseConnection(connection);
            this.cleanQueryLists();
            this.drawEmptyImage();
            this.LoadEntireCacheFromSleepyCatDB(string);
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void saveQueryTitleToSleepyCatDB(String string) {
        if (!this.ensureConnection()) {
            return;
        }
        String string2 = this.getCurrentConnectionName();
        if (string2 == null || !string2.equals("")) {
            // empty if block
        }
        if (this.jList1 != null) {
            ListModel listModel = this.jList1.getModel();
            if (listModel.getSize() == 0) {
                return;
            }
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < listModel.getSize(); ++i) {
                MapViewerHistoryItem mapViewerHistoryItem = new MapViewerHistoryItem();
                CheckQueryListItem checkQueryListItem = (CheckQueryListItem)listModel.getElementAt(i);
                if (checkQueryListItem == null || !checkQueryListItem.getQueryTitle().equals(string)) continue;
                mapViewerHistoryItem.setTitle(checkQueryListItem.getQueryTitle());
                if (checkQueryListItem.getQuery() == null) {
                    mapViewerHistoryItem.setSql("");
                } else {
                    mapViewerHistoryItem.setSql(checkQueryListItem.getQuery());
                }
                mapViewerHistoryItem.setLineColor(checkQueryListItem.getLineColor().toString());
                mapViewerHistoryItem.setFillColor(checkQueryListItem.getFillColor().toString());
                mapViewerHistoryItem.setAnnotationColumn(checkQueryListItem.getAnnotatedColumn());
                mapViewerHistoryItem.setConn(string2);
                mapViewerHistoryItem.setLayerNumber(checkQueryListItem.getLayerNumber());
                this.historyDB.put(mapViewerHistoryItem);
            }
        }
    }

    public void saveEntireCacheToSleepyCatDB(String string, boolean bl) {
        if (this.jList1 != null) {
            ListModel listModel = this.jList1.getModel();
            if (listModel.getSize() == 0) {
                return;
            }
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < listModel.getSize(); ++i) {
                MapViewerHistoryItem mapViewerHistoryItem = new MapViewerHistoryItem();
                CheckQueryListItem checkQueryListItem = (CheckQueryListItem)listModel.getElementAt(i);
                if (checkQueryListItem == null) continue;
                mapViewerHistoryItem.setTitle(checkQueryListItem.getQueryTitle());
                if (checkQueryListItem.getQuery() == null) {
                    mapViewerHistoryItem.setSql("");
                } else {
                    mapViewerHistoryItem.setSql(checkQueryListItem.getQuery());
                }
                mapViewerHistoryItem.setLineColor(checkQueryListItem.getLineColor().toString());
                mapViewerHistoryItem.setFillColor(checkQueryListItem.getFillColor().toString());
                mapViewerHistoryItem.setAnnotationColumn(checkQueryListItem.getAnnotatedColumn());
                mapViewerHistoryItem.setConn(string);
                mapViewerHistoryItem.setLayerNumber(checkQueryListItem.getLayerNumber());
                this.historyDB.put(mapViewerHistoryItem);
                if (!bl) continue;
                checkQueryListItem.remove();
            }
        }
    }

    public void LoadEntireCacheFromSleepyCatDB(String string) {
        this.cleanQueryLists();
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        Vector<String> vector = new Vector<String>();
        MapViewerHistoryItem[] mapViewerHistoryItemArray = this.historyDB.getAllHistoryItems();
        Vector<CheckQueryListItem> vector2 = new Vector<CheckQueryListItem>(mapViewerHistoryItemArray.length);
        for (int i = 0; i < mapViewerHistoryItemArray.length; ++i) {
            String string2;
            MapViewerHistoryItem mapViewerHistoryItem = mapViewerHistoryItemArray[i];
            if (mapViewerHistoryItem == null || (string2 = mapViewerHistoryItem.getTitle()) == null || string2.length() <= 0) continue;
            String string3 = mapViewerHistoryItem.getSql();
            String string4 = mapViewerHistoryItem.getAnnotationColumn();
            String string5 = mapViewerHistoryItem.getLineColor();
            Color color = this.colorDecode(string5);
            String string6 = mapViewerHistoryItem.getFillColor();
            Color color2 = this.colorDecode(string6);
            String string7 = mapViewerHistoryItem.getConn();
            int n = mapViewerHistoryItem.getLayerNumber();
            if (!string.equalsIgnoreCase(string7) || vector.contains(string2)) continue;
            vector.add(string2);
            CheckQueryListItem checkQueryListItem = new CheckQueryListItem(string2, string3, color, color2, string4, n);
            vector2.add(checkQueryListItem);
        }
        Object[] objectArray = new CheckQueryListItem[vector2.size()];
        vector2.copyInto(objectArray);
        Arrays.sort(objectArray, new CheckQueryListItemComparator());
        for (int i = 0; i < objectArray.length; ++i) {
            defaultListModel.addElement(objectArray[i]);
        }
        this.jList1.setModel(defaultListModel);
    }

    public void removeQueryTitleFromSleepyCatDB(String string) {
        if (!this.ensureConnection()) {
            return;
        }
        String string2 = this.getCurrentConnectionName();
        if (string2 != null && !string2.equals("")) {
            this.historyDB.deleteByTitle(string, string2);
        }
    }

    private void removeConnectionInstancesFromSleepyCatDB(String string) {
        if (string != null && !string.equals("")) {
            this.historyDB.deleteByConnection(string);
        }
    }

    public void showSleepCatHistoryAndQueryCache(String string) {
        System.out.println("/////////////////////////////////////////////////////////////////////////////////");
        System.out.println("showSleepCatHistoryAndQueryCache: " + string + " =============================================================");
        System.out.println("- showSleepCatHistoryAndQueryCache - (show Query cache) ------------------ ");
        this.queryCache.showCache();
        System.out.println("- showSleepCatHistoryAndQueryCache - (end  Query cache) ------------------ ");
        System.out.println("                                  ************ ");
        System.out.println("- showSleepCatHistoryAndQueryCache - Begin SleepyCat history ==============");
        this.historyDB.showHistory();
        System.out.println("- showSleepCatHistoryAndQueryCache - End SleepyCat history ================");
        System.out.println("showSleepCatHistoryAndQueryCache: " + string + " =============================================================");
        System.out.println("//////////////////////////////////////////////////////////////////////////////////");
    }

    public void refreshImage() {
        if (imagePanel != null) {
            imagePanel.removeImage();
            int n = imagePanel.getWidth();
            int n2 = imagePanel.getHeight();
            if (this.allGeoms != null && this.allGeoms.length > 0) {
                this.drawImage(this.allGeoms, n, n2);
            }
        }
    }

    public MapGeometry[] queryAllGeometries() {
        Object object;
        int n = this.jList1.getModel().getSize();
        MapViewerGeometryResultSet mapViewerGeometryResultSet = MapViewerGeometryResultSet.getInstance();
        Vector<MapGeometry> vector = new Vector<MapGeometry>();
        for (int i = 0; i < n; ++i) {
            object = (CheckQueryListItem)this.jList1.getModel().getElementAt(i);
            boolean bl = ((CheckQueryListItem)object).isSelected();
            if (!bl) continue;
            this.selectedQuery = ((CheckQueryListItem)object).getQuery();
            Color color = ((CheckQueryListItem)object).getLineColor();
            Color color2 = ((CheckQueryListItem)object).getFillColor();
            String string = ((CheckQueryListItem)object).getAnnotatedColumn();
            int n2 = ((CheckQueryListItem)object).getLayerNumber();
            if (!mapViewerGeometryResultSet.isValidSpatialQuery(this.selectedQuery)) {
                this.selectedQuery = null;
            }
            if (this.selectedQuery == null || this.selectedQuery.length() <= 0) continue;
            try {
                mapViewerGeometryResultSet.setQuery(this.selectedQuery);
                AnnotatedGeometry[] annotatedGeometryArray = mapViewerGeometryResultSet.getGeometryObjects();
                if (annotatedGeometryArray == null) continue;
                MapGeometry mapGeometry = new MapGeometry(this.selectedQuery, color, color2, annotatedGeometryArray, string, n2);
                vector.add(mapGeometry);
                continue;
            }
            catch (SQLException sQLException) {
                vector = null;
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)sQLException.getMessage(), (String)"", null);
                continue;
            }
            catch (Exception exception) {
                vector = null;
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)"", null);
            }
        }
        if (vector == null || vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new MapGeometry[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        object = MapGeometryCache.getInstance();
        ((MapGeometryCache)object).setMapCache((MapGeometry[])objectArray);
        return objectArray;
    }

    public void drawImage(MapGeometry[] mapGeometryArray, int n, int n2) {
        try {
            Image image = new MapViewerRenderer().getImage2(mapGeometryArray, n, n2);
            if (image == null) {
                return;
            }
            imagePanel = ImagePanel.getInstance();
            imagePanel.setImage(image);
            this.currentImageWidth = image.getWidth(null);
            this.currentImageHeight = image.getHeight(null);
            image.flush();
            image = null;
            System.gc();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            MessageDialog.critical((Component)this, (Object)(SpatialArb.getString("MapViewerWarning") + exception.getMessage()), (String)"", null);
        }
    }

    public void drawImage(MapGeometry[] mapGeometryArray) {
        this.drawImage(mapGeometryArray, this.currentImageWidth, this.currentImageHeight);
    }

    public void highLightExternalGeometryInMap(JGeometry jGeometry) {
        MapGeometry[] mapGeometryArray = this.queryAllGeometries();
        if (mapGeometryArray == null || mapGeometryArray.length == 0) {
            return;
        }
        MapGeometry mapGeometry = new MapGeometry(null, Color.red, Color.black, new AnnotatedGeometry[]{new AnnotatedGeometry(jGeometry)});
        boolean bl = mapGeometry.contains(mapGeometryArray);
        if (bl) {
            this.drawEmptyImage();
            this.drawHighLightedImage(mapGeometryArray, mapGeometry);
        }
    }

    public void drawHighLightedImage(MapGeometry[] mapGeometryArray, MapGeometry mapGeometry) {
        int n = 3;
        try {
            imagePanel = ImagePanel.getInstance();
            MapViewerRenderer mapViewerRenderer = new MapViewerRenderer();
            Image image = mapViewerRenderer.getHighLightedImage(mapGeometryArray, mapGeometry, imagePanel.getWidth() * n, imagePanel.getHeight() * n);
            if (image == null) {
                return;
            }
            Point point = mapViewerRenderer.getHiLiteCoordinates();
            imagePanel.setImage(image, point, true);
            this.currentImageWidth = image.getWidth(null);
            this.currentImageHeight = image.getHeight(null);
            image.flush();
            image = null;
            System.gc();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void drawEmptyImage() {
        imagePanel = ImagePanel.getInstance();
        imagePanel.removeImage();
    }

    private Color colorDecode(String string) {
        string = string.startsWith("javax.swing.plaf.ColorUIResource") ? string.replace("javax.swing.plaf.ColorUIResource[", "") : string.replace("java.awt.Color[", "");
        string = string.replace("]", "");
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = Integer.parseInt(stringTokenizer.nextToken().trim().replace("r=", ""));
        int n2 = Integer.parseInt(stringTokenizer.nextToken().trim().replace("g=", ""));
        int n3 = Integer.parseInt(stringTokenizer.nextToken().trim().replace("b=", ""));
        return new Color(n, n2, n3);
    }

    public static void cleanStaticReferences() {
        imagePanel = null;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_mapview_html");
    }

    protected void resetMarqueeButton() {
        this.MarqueeZoomButton.setIcon(this.marqueeZoomIcon);
    }

    private String getUniqueName(String string) {
        int n = 0;
        String string2 = string;
        while (this.queryCache.containsKey(string2)) {
            string2 = string + "_" + n++;
        }
        return string2;
    }

    public void enableRemoveButton(boolean bl) {
        this.removeQueryButton.setEnabled(bl);
    }

    public void enableEditButton(boolean bl) {
        this.editQueryButton.setEnabled(bl);
    }

    private void enableOrDisableEditAndDeleteButtonBasedOnListStatus() {
        if (this.isMapHistoryDBReadOnly()) {
            this.enableEditButton(false);
            this.enableRemoveButton(false);
            return;
        }
        boolean bl = false;
        for (int i = 0; i < this.jList1.getModel().getSize(); ++i) {
            boolean bl2 = ((CheckQueryListItem)this.jList1.getModel().getElementAt(i)).isSelected();
            if (!bl2) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.enableEditButton(true);
            this.enableRemoveButton(true);
        } else {
            this.enableEditButton(false);
            this.enableRemoveButton(false);
        }
    }

    private void newQueryKeyHandler(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 40: {
                System.out.println("newQueryKeyHandler.key down");
                break;
            }
            case 38: {
                System.out.println("newQueryKeyHandler.key up");
            }
        }
    }
}

