/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer;

import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.AnnotatedGeometry;
import oracle.dbtools.spatial.mapviewer.GeometryContext;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.DATE;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;

public class MapViewerGeometryResultSet {
    private AnnotatedGeometry[] geoms = null;
    private Connection conn = null;
    private String query = null;
    private GeometryContext[] foundAttrs = null;
    private static MapViewerGeometryResultSet mvgrs = null;
    private boolean DEBUG = false;

    private MapViewerGeometryResultSet() {
    }

    public static MapViewerGeometryResultSet getInstance() {
        if (mvgrs == null) {
            mvgrs = new MapViewerGeometryResultSet();
        }
        return mvgrs;
    }

    public void checkDatabaseConnection() {
        try {
            if (this.conn == null) {
                throw new Exception("Failed to connect a spatial database. Choose a valid spatial database.");
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            String string = "";
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)(Messages.getString((String)"ConnectionDialog.7") + exception.getMessage()), (String)"", null);
        }
    }

    public void setDatabaseConnection(Connection connection) {
        this.conn = connection;
    }

    public Connection getDatabaseConnection() {
        return this.conn;
    }

    public void setQuery(String string) {
        try {
            if (string != null) {
                if ((string = string.trim()).length() <= 0) {
                    throw new Exception(SpatialArb.getString("SpatialError13501"));
                }
            } else {
                throw new Exception(SpatialArb.getString("SpatialError13502"));
            }
            this.query = string;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    public String getQuery(String string) {
        return this.query;
    }

    public int getNumberGeometryObjects() {
        return this.geoms.length;
    }

    public AnnotatedGeometry[] getGeometryObjects() throws Exception, SQLException {
        if (this.DEBUG) {
            System.out.println("MapViewerGeomtryResultSet.getGeometryObjects: Enter.");
        }
        this.assertQuery();
        Vector<AnnotatedGeometry> vector = new Vector<AnnotatedGeometry>();
        this.checkDatabaseConnection();
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery(this.query);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int n2 = 0;
        while (resultSet.next()) {
            JGeometry jGeometry = null;
            Vector<String> vector2 = new Vector<String>();
            if (this.DEBUG) {
                System.out.println("MapViewerGeomtryResultSet.row #:" + n2++);
            }
            for (int i = 1; i <= n; ++i) {
                Object object;
                Object[] objectArray = resultSetMetaData.getColumnName(i);
                Object object2 = resultSet.getObject(i);
                if (object2 instanceof STRUCT) {
                    object = (STRUCT)object2;
                    jGeometry = JGeometry.load((STRUCT)object);
                    continue;
                }
                if (object2 instanceof String) {
                    vector2.add((String)objectArray + "=" + object2.toString());
                    continue;
                }
                if (object2 instanceof Integer) {
                    object = ((Integer)object2).toString();
                    vector2.add((String)objectArray + "=" + (String)object);
                    continue;
                }
                if (object2 instanceof NUMBER) {
                    object = ((NUMBER)object2).stringValue();
                    vector2.add((String)objectArray + "=" + (String)object);
                    continue;
                }
                if (object2 instanceof BigDecimal) {
                    object = ((BigDecimal)object2).toPlainString();
                    vector2.add((String)objectArray + "=" + (String)object);
                    continue;
                }
                if (object2 instanceof Double) {
                    object = ((Double)object2).toString();
                    vector2.add((String)objectArray + "=" + (String)object);
                    continue;
                }
                if (object2 instanceof Float) {
                    object = ((Float)object2).toString();
                    vector2.add((String)objectArray + "=" + (String)object);
                    continue;
                }
                if (!(object2 instanceof DATE)) continue;
                object = ((DATE)object2).stringValue();
                vector2.add((String)objectArray + "=" + (String)object);
            }
            Object[] objectArray = new String[vector2.size()];
            vector2.copyInto(objectArray);
            if (jGeometry != null) {
                if (this.DEBUG) {
                    for (Object object : objectArray) {
                        System.out.println("MapViewerGeomtryResultSet.getGeometryObjects: annotationText =" + (String)object);
                    }
                }
                vector.add(new AnnotatedGeometry(jGeometry, (String[])objectArray));
            }
            jGeometry = null;
            vector2 = null;
            objectArray = null;
        }
        resultSet.close();
        statement.close();
        if (vector == null || vector.size() == 0) {
            return null;
        }
        this.geoms = new AnnotatedGeometry[vector.size()];
        vector.copyInto(this.geoms);
        vector = null;
        if (this.DEBUG) {
            System.out.println("MapViewerGeomtryResultSet.getGeometryObjects: Exit.");
        }
        return this.geoms;
    }

    public GeometryContext[] getGeometryContextObjects(JGeometry jGeometry) throws Exception, SQLException {
        Object object;
        int n;
        Object object2;
        int n2 = -1;
        this.assertQuery();
        Vector<Object[]> vector = new Vector<Object[]>();
        this.checkDatabaseConnection();
        try {
            Statement statement = this.conn.createStatement();
            object2 = statement.executeQuery(this.query);
            ResultSetMetaData resultSetMetaData = object2.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            n = 1;
            while (object2.next()) {
                object = new Vector();
                for (int i = 1; i <= n3; ++i) {
                    Object object3;
                    Object object4;
                    String string = resultSetMetaData.getColumnName(i);
                    String string2 = resultSetMetaData.getColumnTypeName(i);
                    Object object5 = object2.getObject(i);
                    if (object5 instanceof STRUCT) {
                        object4 = (STRUCT)object5;
                        object3 = JGeometry.load((STRUCT)object4);
                        GeometryContext geometryContext = new GeometryContext(string, this.getUniqueGeomId((JGeometry)object3));
                        geometryContext.setShowAllowed(false);
                        ((Vector)object).add(geometryContext);
                        continue;
                    }
                    if (object5 instanceof Integer) {
                        object4 = DataTypesUtil.stringValue((Object)object5, (Connection)this.conn);
                        object3 = new GeometryContext(string, (String)object4);
                        ((Vector)object).add(object3);
                        continue;
                    }
                    if (object5 instanceof NUMBER) {
                        object4 = DataTypesUtil.stringValue((Object)object5, (Connection)this.conn);
                        object3 = new GeometryContext(string, (String)object4);
                        ((Vector)object).add(object3);
                        continue;
                    }
                    if (object5 instanceof BigDecimal) {
                        object4 = DataTypesUtil.stringValue((Object)object5, (Connection)this.conn);
                        object3 = new GeometryContext(string, (String)object4);
                        ((Vector)object).add(object3);
                        continue;
                    }
                    if (object5 instanceof Double) {
                        object4 = DataTypesUtil.stringValue((Object)object5, (Connection)this.conn);
                        object3 = new GeometryContext(string, (String)object4);
                        ((Vector)object).add(object3);
                        continue;
                    }
                    if (object5 instanceof Float) {
                        object4 = DataTypesUtil.stringValue((Object)object5, (Connection)this.conn);
                        object3 = new GeometryContext(string, (String)object4);
                        ((Vector)object).add(object3);
                        continue;
                    }
                    if (object5 instanceof DATE) {
                        object4 = DataTypesUtil.stringValue((Object)object5, (Connection)this.conn);
                        object3 = new GeometryContext(string, (String)object4);
                        ((Vector)object).add(object3);
                        continue;
                    }
                    if (!(object5 instanceof String)) continue;
                    object4 = new GeometryContext(string, DataTypesUtil.stringValue((Object)object5, (Connection)this.conn));
                    ((Vector)object).add(object4);
                }
                Object[] objectArray = new GeometryContext[((Vector)object).size()];
                ((Vector)object).copyInto(objectArray);
                vector.add(objectArray);
                object = null;
            }
            object2.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, sQLException.getStackTrace()[0].toString(), sQLException);
            ExceptionHandler.handleException((Throwable)sQLException);
        }
        if (jGeometry == null) {
            return null;
        }
        boolean bl = false;
        object2 = this.getUniqueGeomId(jGeometry);
        for (int i = 0; i < vector.size(); ++i) {
            GeometryContext[] geometryContextArray = (GeometryContext[])vector.get(i);
            for (n = 0; n < geometryContextArray.length; ++n) {
                object = geometryContextArray[n].getValue();
                if (((String)object).equalsIgnoreCase((String)object2)) {
                    n2 = i;
                    this.foundAttrs = (GeometryContext[])vector.get(i);
                    bl = true;
                }
                if (bl) break;
            }
            if (bl) break;
        }
        vector = null;
        System.gc();
        return this.foundAttrs;
    }

    private void assertQuery() throws Exception {
        try {
            if (this.query == null) {
                throw new Exception(SpatialArb.getString("SpatialError13501"));
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            ExceptionHandler.handleException((Throwable)exception);
        }
        try {
            if (this.query.trim().length() == 0) {
                throw new Exception(SpatialArb.getString("SpatialError13502"));
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    public String getUniqueGeomId(JGeometry jGeometry) {
        double[] dArray = jGeometry.getMBR();
        int n = jGeometry.getNumPoints();
        return new Double(dArray[0] + dArray[1] + dArray[2] + dArray[3] + (double)n).toString();
    }

    public boolean compareMBRs(JGeometry jGeometry, JGeometry jGeometry2) {
        double[] dArray;
        double[] dArray2 = jGeometry.getMBR();
        return dArray2[0] == (dArray = jGeometry2.getMBR())[0] && dArray2[1] == dArray[1] && dArray2[3] == dArray[3] && dArray2[2] == dArray[2];
    }

    public boolean shallowGeometryCompare(JGeometry jGeometry, JGeometry jGeometry2) {
        boolean bl = this.compareMBRs(jGeometry, jGeometry2);
        boolean bl2 = this.compareNumberOfPoints(jGeometry, jGeometry2);
        return bl && bl2;
    }

    public boolean compareNumberOfPoints(JGeometry jGeometry, JGeometry jGeometry2) {
        int n;
        int n2 = jGeometry.getNumPoints();
        return n2 == (n = jGeometry2.getNumPoints());
    }

    protected boolean isValidSpatialQuery(String string) {
        try {
            this.checkDatabaseConnection();
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            int n2 = 0;
            for (int i = 1; i <= n; ++i) {
                int n3 = resultSetMetaData.getColumnType(i);
                if (n3 != 2002) continue;
                ++n2;
            }
            resultSet.close();
            statement.close();
            return n2 != 0;
        }
        catch (SQLException sQLException) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String[] getColumnNames(String string) {
        try {
            this.checkDatabaseConnection();
            Statement statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            boolean bl = false;
            Vector<String> vector = new Vector<String>();
            vector.add("");
            for (int i = 1; i <= n; ++i) {
                int n2 = resultSetMetaData.getColumnType(i);
                String string2 = resultSetMetaData.getColumnName(i);
                if (n2 == 2002) continue;
                vector.add(string2);
            }
            resultSet.close();
            statement.close();
            if (vector.size() == 0) {
                return null;
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (SQLException sQLException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Connection getConnection() {
        return this.conn;
    }
}

