/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer;

import java.awt.Color;
import oracle.dbtools.spatial.mapviewer.QueryListCache;
import oracle.dbtools.spatial.mapviewer.QueryObject;

public class CheckQueryListItem {
    private String queryLabel;
    private String queryText;
    private Color lineColor;
    private Color fillColor;
    private String annotatedColumn;
    private boolean isSelected = false;
    private boolean isGrayedOut = false;
    QueryListCache queryCache = null;
    private int layerNumber = -1;

    public CheckQueryListItem(String string) {
        this.queryLabel = string;
        this.queryCache = QueryListCache.getInstance();
        this.queryCache.addQuery(this.queryLabel, "");
    }

    public CheckQueryListItem(String string, String string2) {
        this.queryLabel = string;
        this.queryText = string2;
        this.queryCache = QueryListCache.getInstance();
        this.queryCache.addQuery(this.queryLabel, this.queryText);
    }

    public CheckQueryListItem(String string, String string2, Color color, Color color2) {
        this.queryLabel = string;
        this.queryText = string2;
        this.fillColor = color2;
        this.lineColor = color;
        this.queryCache = QueryListCache.getInstance();
        this.queryCache.addQuery(string, string2, color, color2);
    }

    public CheckQueryListItem(String string, String string2, Color color, Color color2, String string3) {
        this.queryLabel = string;
        this.queryText = string2;
        this.fillColor = color2;
        this.lineColor = color;
        this.annotatedColumn = string3;
        this.queryCache = QueryListCache.getInstance();
        this.queryCache.addQuery(string, string2, color, color2, string3);
    }

    public CheckQueryListItem(String string, String string2, Color color, Color color2, String string3, int n) {
        this.queryLabel = string;
        this.queryText = string2;
        this.fillColor = color2;
        this.lineColor = color;
        this.annotatedColumn = string3;
        this.layerNumber = n;
        this.queryCache = QueryListCache.getInstance();
        this.queryCache.addQuery(string, string2, color, color2, string3, n);
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
    }

    public boolean isGrayedOut() {
        return this.isGrayedOut;
    }

    public void setGrayedOut(boolean bl) {
        this.isGrayedOut = bl;
    }

    public void setAnnotatedColumn(String string) {
        this.annotatedColumn = string;
    }

    public String getAnnotatedColumn() {
        return this.annotatedColumn;
    }

    public String toString() {
        return this.queryLabel;
    }

    public String toDetailedString() {
        return "Query=" + this.queryLabel + "/layerId=" + this.getLayerNumber();
    }

    public String getQueryTitle() {
        return this.queryLabel;
    }

    public void remove() {
        this.queryCache.removeQuery(this.queryLabel);
    }

    public String getQuery() {
        if (this.queryCache.getQuery(this.queryLabel) != null) {
            return this.queryCache.getQuery(this.queryLabel).getQueryText();
        }
        return "";
    }

    public QueryObject getQueryObject() {
        return this.queryCache.getQuery(this.queryLabel);
    }

    public Color getLineColor() {
        return this.queryCache.getQuery(this.queryLabel).getLineColor();
    }

    public Color getFillColor() {
        return this.queryCache.getQuery(this.queryLabel).getFillColor();
    }

    public int getLayerNumber() {
        return this.queryCache.getQuery(this.queryLabel).getLayerNumber();
    }

    public void setLayerNumber(int n) {
        this.queryCache.getQuery(this.queryLabel).setLayerNumber(n);
    }
}

