/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.dialogs.validate.model;

import java.util.Vector;
import javax.swing.DefaultListModel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.spatial.dialogs.validate.model.ProcessSQL;

public class ValidateGeometryModel {
    private String tableName;
    private String tolerance;
    private Object[] selectedIdCols = null;
    private Vector spatialcols = null;
    private DBObject dbObject;
    private ProcessSQL processSql = null;
    private String spatialcol = null;
    private boolean isColumnSelected;
    private DefaultListModel idColNames = new DefaultListModel();
    private boolean dimValidation;

    public ValidateGeometryModel() {
        this.processSql = new ProcessSQL();
    }

    public void setDimValidation(boolean bl) {
        this.dimValidation = bl;
    }

    public boolean getDimValidation() {
        return this.dimValidation;
    }

    public void setDBObject(DBObject dBObject) {
        this.dbObject = dBObject;
    }

    public void setIsColumnSelected(boolean bl) {
        this.isColumnSelected = bl;
    }

    public boolean getIsColumnSelected() {
        return this.isColumnSelected;
    }

    public void setCurrrentColumn(String string) {
        this.spatialcol = string;
    }

    public DefaultListModel getIdColsListModel() {
        return this.idColNames;
    }

    public String getCurrentColumn() {
        return this.spatialcol;
    }

    public boolean isSingleColumnSpatial() {
        for (int i = 0; i < this.getSpatialColumnSize(); ++i) {
            String string = this.getCurrentColumn();
            if (!this.getSpatialColumn(i).equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean toleranceOK() {
        return this.processSql.isTolerance_OK(this.dbObject, this.spatialcol);
    }

    public void setInitialModelData() {
        this.spatialcols = null;
        this.idColNames.clear();
        this.setTableName(this.dbObject.getObjectName());
        Vector vector = this.processSql.getSpatialColumns(this.dbObject);
        this.setSpatialColumns(vector);
        Vector vector2 = this.processSql.getNonSpatialColumns(this.dbObject);
        this.setIdColumns(vector2);
        if (!this.isColumnSelected) {
            this.spatialcol = this.getFirstColumn();
        }
        this.setTolerance("0.0005");
    }

    public String getValidationSql() {
        return this.processSql.getValidationSql(this.dimValidation, this.dbObject, this.spatialcol, this.selectedIdCols, this.tolerance);
    }

    public String getConnection() {
        return this.processSql.getConnection(this.dbObject);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getIdColumn(int n) {
        if (this.idColNames.size() > n) {
            return (String)this.idColNames.elementAt(n);
        }
        return null;
    }

    public int getIdColumnSize() {
        return this.idColNames.getSize();
    }

    public void setIdColumns(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.idColNames.addElement(vector.elementAt(i));
        }
    }

    public void setSelectedIdColumns(Object[] objectArray) {
        this.selectedIdCols = objectArray;
    }

    public Object[] getSelectedIdColumns() {
        return this.selectedIdCols;
    }

    public String getTolerance() {
        return this.tolerance.toString();
    }

    public void setTolerance(String string) {
        this.tolerance = string == null ? "" : string;
    }

    public String getFirstColumn() {
        return this.getSpatialColumn(0);
    }

    public Vector getSpatialColumns() {
        return this.spatialcols;
    }

    public String getSpatialColumn(int n) {
        if (this.spatialcols.size() > n) {
            return (String)this.spatialcols.elementAt(n);
        }
        return null;
    }

    public int getSpatialColumnSize() {
        return this.spatialcols.size();
    }

    public void setSpatialColumns(Vector vector) {
        this.spatialcols = vector;
    }
}

