/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.dialogs.validate.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.spatial.SpatialUtils;

public class ProcessSQL {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getSpatialColumns(DBObject dBObject) {
        Vector<String> vector = new Vector<String>();
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = dBObject.getConnection();
        String string = dBObject.getObjectName();
        String string2 = dBObject.getSchemaName();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(false);
                String string3 = SpatialUtils.getQuery("spatialcols", connection);
                hashMap.put("OWNER_NAME", string2);
                hashMap.put("TABLE_NAME", string);
                resultSetWrapper = dBUtil.executeOracleQuery(string3, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string4 = resultSet.getString("COLUMN_NAME");
                        vector.add(string4);
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTolerance_OK(DBObject dBObject, String string) {
        block9: {
            ResultSetWrapper resultSetWrapper = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Connection connection = dBObject.getConnection();
            String string2 = dBObject.getObjectName();
            String string3 = dBObject.getSchemaName();
            if (Connections.getInstance().lock(connection)) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(false);
                    String string4 = SpatialUtils.getQuery("spatialmetadatatolerance", connection);
                    hashMap.put("OWNER_NAME", string3);
                    hashMap.put("TABLE_NAME", string2);
                    hashMap.put("COLUMN_NAME", string);
                    resultSetWrapper = dBUtil.executeOracleQuery(string4, hashMap);
                    if (resultSetWrapper == null) break block9;
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        Double d = resultSet.getDouble("SDO_TOLERANCE");
                        if (!(d <= 0.0)) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
                finally {
                    if (resultSetWrapper != null) {
                        resultSetWrapper.close();
                    }
                    Connections.getInstance().unlock(connection);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getNonSpatialColumns(DBObject dBObject) {
        Vector<String> vector = new Vector<String>();
        ResultSetWrapper resultSetWrapper = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = dBObject.getConnection();
        String string = dBObject.getObjectName();
        String string2 = dBObject.getSchemaName();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(false);
                String string3 = SpatialUtils.getQuery("nonspatialcols", connection);
                hashMap.put("OWNER_NAME", string2);
                hashMap.put("TABLE_NAME", string);
                resultSetWrapper = dBUtil.executeOracleQuery(string3, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string4 = resultSet.getString("COLUMN_NAME");
                        vector.add(string4);
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return vector;
    }

    public String getValidationSql(boolean bl, DBObject dBObject, String string, Object[] objectArray, String string2) {
        Connection connection = dBObject.getConnection();
        String string3 = dBObject.getObjectName();
        String string4 = dBObject.getSchemaName();
        String string5 = "";
        for (int i = 0; i < objectArray.length; ++i) {
            string5 = string5 + (String)objectArray[i] + ",";
        }
        String string6 = bl ? SpatialUtils.getQuery("validatecolumnwithdim", connection) : SpatialUtils.getQuery("validatecolumn", connection);
        string6 = SpatialUtils.replaceAll(string6, "<IDCOLS>", string5);
        string6 = SpatialUtils.replaceAll(string6, "<GEOMCOL>", string);
        string6 = SpatialUtils.replaceAll(string6, "<TOLERANCE>", string2);
        string6 = SpatialUtils.replaceAll(string6, "<OWNERNAME>", string4);
        string6 = SpatialUtils.replaceAll(string6, "<TABLENAME>", string3);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            dBUtil.execute(string6);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string6;
    }

    public String getConnection(DBObject dBObject) {
        Connection connection = dBObject.getConnection();
        return Connections.getInstance().getConnectionName(connection);
    }
}

