/*
 * Decompiled with CFR 0.152.
 */
package ice.util.swing.jdk14;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollBar;

public class SwingMouseWheelListener
implements MouseWheelListener {
    private JScrollBar vbar;
    private JScrollBar hbar;

    private void $init$() {
        this.vbar = null;
        this.hbar = null;
    }

    public SwingMouseWheelListener(JScrollBar vbar, JScrollBar hbar) {
        this.$init$();
        this.vbar = vbar;
        this.hbar = hbar;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getScrollAmount() != 0) {
            int direction = 0;
            JScrollBar toScroll = this.vbar;
            if (!(this.vbar != null && this.vbar.isVisible() || (toScroll = this.hbar) != null && toScroll.isVisible())) {
                return;
            }
            int n = direction = e.getWheelRotation() < 0 ? -1 : 1;
            if (e.getScrollType() == 0) {
                SwingMouseWheelListener.scrollByUnits(toScroll, direction, e.getScrollAmount());
            } else if (e.getScrollType() == 1) {
                SwingMouseWheelListener.scrollByBlock(toScroll, direction);
            }
        }
    }

    static void scrollByBlock(JScrollBar scrollbar, int direction) {
        int oldValue = scrollbar.getValue();
        int blockIncrement = scrollbar.getBlockIncrement(direction);
        int delta = blockIncrement * (direction > 0 ? 1 : -1);
        scrollbar.setValue(oldValue + delta);
    }

    static void scrollByUnits(JScrollBar scrollbar, int direction, int units) {
        int delta = units;
        delta = direction > 0 ? (delta *= scrollbar.getUnitIncrement(direction)) : (delta *= -scrollbar.getUnitIncrement(direction));
        int oldValue = scrollbar.getValue();
        int newValue = oldValue + delta;
        if (delta > 0 && newValue < oldValue) {
            newValue = scrollbar.getMaximum();
        } else if (delta < 0 && newValue > oldValue) {
            newValue = scrollbar.getMinimum();
        }
        scrollbar.setValue(newValue);
    }
}

