/*
 * Decompiled with CFR 0.152.
 */
package ice.util.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class URLEncoder {
    private static final int CASE_DIFF = 32;
    private static final BitSet dontNeedEncoding = new BitSet(128);

    static {
        int i = 97;
        while (i <= 122) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            dontNeedEncoding.set(i);
            ++i;
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }

    private URLEncoder() {
    }

    public static String encode(String target, String encoding) {
        if (encoding != null) {
            try {
                String string = URLEncoder.doEncode(target, encoding);
                return string;
            }
            catch (UnsupportedEncodingException exception) {
                String string = java.net.URLEncoder.encode(target);
                return string;
            }
        }
        return java.net.URLEncoder.encode(target);
    }

    private static String doEncode(String s, String encoding) throws UnsupportedEncodingException {
        boolean _needToChange = false;
        boolean _wroteUnencodedChar = false;
        int _maxBytesPerChar = 10;
        int _length = s.length();
        StringBuffer _stringBuffer = new StringBuffer(_length);
        ByteArrayOutputStream _byteArrayOutputStream = new ByteArrayOutputStream(_maxBytesPerChar);
        OutputStreamWriter _outputStreamWriter = new OutputStreamWriter((OutputStream)_byteArrayOutputStream, encoding);
        int i = 0;
        while (i < _length) {
            block11: {
                int _char = s.charAt(i);
                if (dontNeedEncoding.get(_char)) {
                    if (_char == 32) {
                        _char = 43;
                        _needToChange = true;
                    }
                    _stringBuffer.append((char)_char);
                    _wroteUnencodedChar = true;
                } else {
                    try {
                        char _nextChar;
                        if (_wroteUnencodedChar) {
                            _outputStreamWriter = new OutputStreamWriter((OutputStream)_byteArrayOutputStream, encoding);
                            _wroteUnencodedChar = false;
                        }
                        _outputStreamWriter.write(_char);
                        if (_char >= 55296 && _char <= 56319 && i + 1 < _length && (_nextChar = s.charAt(i + 1)) >= '\udc00' && _nextChar <= '\udfff') {
                            _outputStreamWriter.write(_nextChar);
                            ++i;
                        }
                        _outputStreamWriter.flush();
                    }
                    catch (IOException exception) {
                        _byteArrayOutputStream.reset();
                        break block11;
                    }
                    byte[] _bytes = _byteArrayOutputStream.toByteArray();
                    int j = 0;
                    while (j < _bytes.length) {
                        _stringBuffer.append('%');
                        char _character = Character.forDigit(_bytes[j] >> 4 & 0xF, 16);
                        if (Character.isLetter(_character)) {
                            _character = (char)(_character - 32);
                        }
                        _stringBuffer.append(_character);
                        _character = Character.forDigit(_bytes[j] & 0xF, 16);
                        if (Character.isLetter(_character)) {
                            _character = (char)(_character - 32);
                        }
                        _stringBuffer.append(_character);
                        ++j;
                    }
                    _byteArrayOutputStream.reset();
                    _needToChange = true;
                }
            }
            ++i;
        }
        return _needToChange ? _stringBuffer.toString() : s;
    }
}

