/*
 * Decompiled with CFR 0.152.
 */
package ice.util.io;

import ice.util.io.LazyCachedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MarkerInputStream
extends InputStream {
    private static final int INVALID = Integer.MIN_VALUE;
    private static final int UNLIMITED = Integer.MAX_VALUE;
    private boolean closed;
    private LazyCachedInputStream lazyCachedInputStream;
    private int mark;
    private int position;
    private int readLimit;

    private void $init$() {
        this.mark = Integer.MIN_VALUE;
        this.position = -1;
        this.readLimit = -1;
    }

    public MarkerInputStream(LazyCachedInputStream lazyCachedInputStream) {
        this.$init$();
        this.lazyCachedInputStream = lazyCachedInputStream;
    }

    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        return this.lazyCachedInputStream.available() - (this.position + 1);
    }

    private void checkReadLimit() {
        if (this.mark != Integer.MIN_VALUE && this.readLimit != Integer.MAX_VALUE && this.position - this.mark > this.readLimit) {
            this.mark = Integer.MIN_VALUE;
            this.readLimit = -1;
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.lazyCachedInputStream = null;
            this.position = -1;
            this.closed = true;
        }
    }

    public void mark() {
        this.mark(Integer.MAX_VALUE);
    }

    public void mark(int readLimit) {
        this.mark = this.position;
        this.readLimit = readLimit >= 0 ? readLimit : 0;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("read error: stream is closed");
        }
        int _byte = this.lazyCachedInputStream.read(this.position + 1);
        if (_byte != -1) {
            ++this.position;
        }
        this.checkReadLimit();
        return _byte;
    }

    public int read(byte[] bytes) throws IOException {
        if (this.closed) {
            throw new IOException("read error: stream is closed");
        }
        int _bytesRead = this.lazyCachedInputStream.read(this.position + 1, bytes, 0, bytes.length);
        if (_bytesRead != -1) {
            this.position += _bytesRead;
        }
        this.checkReadLimit();
        return _bytesRead;
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (this.closed) {
            throw new IOException("read error: stream is closed");
        }
        int _bytesRead = this.lazyCachedInputStream.read(this.position + 1, bytes, offset, length);
        if (_bytesRead != -1) {
            this.position += _bytesRead;
        }
        this.checkReadLimit();
        return _bytesRead;
    }

    public void reset() throws IOException {
        if (this.mark == Integer.MIN_VALUE) {
            throw new IOException("mark has not been set or read limit was exceeded");
        }
        this.position = this.mark;
    }
}

