/*
 * Decompiled with CFR 0.152.
 */
package ice.util.image;

import ice.util.image.IceImageObserver;
import ice.util.image.ImageFactory;
import ice.util.image.ImageProxy;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.Vector;

class ImageObserverProxy
implements ImageObserver {
    ImageProxy theImage;
    Vector theListeners;
    boolean disposed;

    private void $init$() {
        this.theImage = null;
        this.theListeners = new Vector(2);
        this.disposed = false;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if (this.disposed) {
            return false;
        }
        if (this.theListeners.size() > 0 && this.theImage != null) {
            int i = 0;
            while (i < this.theListeners.size()) {
                boolean b = ((IceImageObserver)this.theListeners.elementAt(i)).imageUpdate(this.theImage, infoflags, x, y, width, height);
                if (!b) {
                    this.theListeners.removeElementAt(i);
                    if (i != this.theListeners.size() - 1) {
                        --i;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public ImageObserverProxy(IceImageObserver iio, ImageProxy ip) {
        this.$init$();
        if (!this.theListeners.contains(iio)) {
            this.theListeners.addElement(iio);
        }
        this.theImage = ip;
    }

    void registerListener(IceImageObserver iio) {
        if (!this.theListeners.contains(iio) && iio != null) {
            this.theListeners.addElement(iio);
        }
    }

    void dispose() {
        this.disposed = true;
        this.theListeners.removeAllElements();
        ImageFactory.removeObserver(this.theImage);
    }
}

