/*
 * Decompiled with CFR 0.152.
 */
package ice.util.encoding;

import ice.debug.Debug;
import ice.util.Defs;
import ice.util.alg.HashArray;
import ice.util.encoding.ReaderLatin1;
import ice.util.encoding.ReaderUTF8;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.text.BreakIterator;
import java.util.Locale;

public class CharIO {
    public static final int DEFAULT_DECODING_BUFFER_SIZE = 4096;
    public static final String ENC_UTF8 = "UTF8";
    public static final String ENC_ISO8859_1 = "ISO8859_1";
    private static final char[] UNICODE_RANGES = new char[]{'\u0350', '\u03ff', '\u0400', '\u051f', '\u0520', '\u057f', '\u0580', '\u05ff', '\u0600', '\u06ff', '\u0980', '\u09ff', '\u0e00', '\u0e7f', '\u0e80', '\u0eff', '\u0f00', '\u0fff', '\u1000', '\u108f', '\u1090', '\u10ff', '\u1780', '\u17ff', '\u1800', '\u187f', '\u2e00', '\u9fff', '\uff00', '\uffff'};
    private static final String[] ISO639Langs = new String[]{"el", "ru", "hy", "iw", "ar", "bn", "th", "lo", "bo", "my", "ka", "km", "mn", "zh", "zh"};
    private static final String defaultEncoding = CharIO.buildDefaultEncoding();
    private static final Object initLock = new Object();
    private static HashArray otherEncodingAliases;
    private static HashArray encodingToLanguageMap;
    public static final int CHARSET_DEFAULT = 0;
    public static final int CHARSET_WINDOWS_1255 = 1;
    public static final int CHARSET_VISUAL = 2;
    public static final int CHARSET_ISO8859_8 = 3;

    private static String buildDefaultEncoding() {
        ByteArrayInputStream tmp = new ByteArrayInputStream(Defs.EMPTY_BYTE_ARRAY);
        String enc = new InputStreamReader(tmp).getEncoding();
        enc = CharIO.resolveEncodingAliases(enc, true);
        return enc;
    }

    public static String getDefaultEncoding() {
        return defaultEncoding;
    }

    private static String resolveEncodingAliases(String name, boolean checkOnlyHardcoded) {
        String test = null;
        String id = ENC_ISO8859_1;
        int length = name.length();
        switch (length) {
            case 4: {
                test = ENC_UTF8;
                id = ENC_UTF8;
                break;
            }
            case 5: {
                char c = name.charAt(0);
                if (c == 'A' || c == 'a') {
                    test = "ASCII";
                    break;
                }
                if (c != 'U' && c != 'u') break;
                test = "UTF_8";
                id = ENC_UTF8;
                break;
            }
            case 6: {
                char c = name.charAt(0);
                if (c == '8') {
                    test = "8859_1";
                    break;
                }
                if (c != 'L' && c != 'l') break;
                test = "LATIN1";
                break;
            }
            case 7: {
                char c = name.charAt(0);
                if (c == 'L' || c == 'l') {
                    test = "LATIN_1";
                    break;
                }
                if (c != 'U' && c != 'u') break;
                test = "UNICODE";
                id = ENC_UTF8;
                break;
            }
            case 8: {
                test = "US_ASCII";
                break;
            }
            case 9: {
                test = ENC_ISO8859_1;
                break;
            }
            case 10: {
                test = "ISO_8859_1";
                break;
            }
        }
        if (test != null && CharIO.compareEncodings(name, test, length)) {
            return id;
        }
        if (!checkOnlyHardcoded) {
            if (length == defaultEncoding.length() && CharIO.compareEncodings(name, defaultEncoding, length)) {
                return defaultEncoding;
            }
            String normalized = CharIO.normalizeEncodingAlias(name);
            String converted = (String)CharIO.getOtherAliases().get(normalized);
            if (converted != null) {
                return converted;
            }
        }
        return name;
    }

    private static void fillOtherAliases(HashArray map) {
        map.put("X-SJIS", (Object)"SJIS");
        map.put("SHIFT-JIS", (Object)"SJIS");
        map.put("SHIFT_JIS", (Object)"SJIS");
        map.put("ISO-2022-JP", (Object)"ISO2022JP");
        map.put("VISUAL", (Object)"ISO8859_8");
        map.put("ISO-8859-8 VISUAL", (Object)"ISO8859_8");
        map.put("MACINTOSH", (Object)"MacRoman");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashArray getOtherAliases() {
        HashArray map = otherEncodingAliases;
        if (map == null) {
            Object object = initLock;
            synchronized (object) {
                map = otherEncodingAliases;
                if (map == null) {
                    map = new HashArray(initLock);
                    CharIO.fillOtherAliases(map);
                    otherEncodingAliases = map;
                }
            }
        }
        return map;
    }

    public static void addEncodingAlias(String alias, String encoding) {
        CharIO.getOtherAliases().put(CharIO.normalizeEncodingAlias(alias), (Object)encoding);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean compareEncodings(String str1, String str2, int length) {
        if (str1 != str2) ** GOTO lbl16
        return true;
lbl-1000:
        // 1 sources

        {
            if ((c1 = str1.charAt(--length)) == 45) {
                c1 = 95;
            } else if (97 <= c1 && c1 <= 122) {
                c1 += -32;
            }
            c2 = str2.charAt(length);
            if (c2 == 45) {
                c2 = 95;
            } else if (97 <= c2 && c2 <= 122) {
                c2 += -32;
            }
            if (c1 == c2) continue;
            return false;
lbl16:
            // 2 sources

            ** while (length != 0)
        }
lbl17:
        // 1 sources

        return true;
    }

    private static String normalizeEncodingAlias(String s) {
        return s.toUpperCase();
    }

    public static Reader createInputStreamReader(InputStream in, String enc) {
        return CharIO.createInputStreamReader(in, enc, false);
    }

    public static Reader createInputStreamReader(InputStream in, String encArg, boolean deafultIfBadEncoding) {
        String enc = encArg == null ? defaultEncoding : CharIO.resolveEncodingAliases(encArg, false);
        Reader result = CharIO.createBaseReader(in, enc);
        if (result == null) {
            block9: {
                try {
                    InputStreamReader r = new InputStreamReader(in, enc);
                    enc = r.getEncoding();
                    result = r;
                }
                catch (UnsupportedEncodingException ex) {
                    if (Debug.ex) {
                        Debug.ex(ex);
                    }
                }
                catch (RuntimeException ex) {
                    if (!Debug.ex) break block9;
                    Debug.ex(ex);
                }
            }
            if (result == null) {
                if (!deafultIfBadEncoding) {
                    result = null;
                } else {
                    enc = defaultEncoding;
                    result = CharIO.createBaseReader(in, defaultEncoding);
                }
            }
        }
        if (Debug.trace && result != null) {
            Debug.trace("Given encoding=(" + encArg + ") Java name=(" + enc + ")");
        }
        return result;
    }

    private static Reader createBaseReader(InputStream in, String enc) {
        Reader result;
        if (enc == ENC_UTF8) {
            ReaderUTF8 r = new ReaderUTF8(in, 4096);
            r.setThrowOnBadUTF8(false);
            result = r;
        } else if (enc == ENC_ISO8859_1) {
            ReaderLatin1 r = new ReaderLatin1(in, 4096);
            r.setWin1252Mode();
            result = r;
        } else {
            result = enc == defaultEncoding ? new InputStreamReader(in) : null;
        }
        return result;
    }

    public static Reader createURLReader(URLConnection conn) throws IOException {
        String enc = conn.getContentEncoding();
        InputStream is = conn.getInputStream();
        if (is != null) {
            return CharIO.createInputStreamReader(is, enc, true);
        }
        if (Debug.trace) {
            Debug.trace("ALERT: " + conn.getClass().getName() + ".getInputStream() returns null for " + conn.getURL() + ". Check it is OK.");
        }
        throw new EOFException();
    }

    public static BreakIterator getBreakIterator(Locale l) {
        String lang = l.getLanguage();
        if (lang.equals("zh") || lang.equals("iw") || lang.equals("ko") || lang.equals("ja") || lang.equals("th") || lang.equals("tr") || lang.equals("el") || lang.equals("ru") || lang.equals("hy") || lang.equals("iw") || lang.equals("ar") || lang.equals("bn") || lang.equals("th") || lang.equals("lo") || lang.equals("bo") || lang.equals("my") || lang.equals("ka") || lang.equals("km") || lang.equals("mn")) {
            return BreakIterator.getWordInstance(l);
        }
        return null;
    }

    private static void fillEncodingToLanguageMap(HashArray map) {
        map.put("Big5", (Object)"zh");
        map.put("EUC_CN", (Object)"zh");
        map.put("EUC_TW", (Object)"zh");
        map.put("GBK", (Object)"zh");
        map.put("ISO2022CN", (Object)"zh");
        map.put("ISO2022CN_CNS", (Object)"zh");
        map.put("ISO2022CN_GB", (Object)"zh");
        map.put("EUC_CN", (Object)"zh");
        map.put("ISO8859_8", (Object)"iw");
        map.put("Cp1255", (Object)"iw");
        map.put("EUC_KR", (Object)"ko");
        map.put("Johab", (Object)"ko");
        map.put("ISO2022KR", (Object)"ko");
        map.put("EUC_JP", (Object)"ja");
        map.put("ISO2022JP", (Object)"ja");
        map.put("JISAutoDetect", (Object)"ja");
        map.put("SJIS", (Object)"ja");
        map.put("TIS620", (Object)"th");
        map.put("Cp857", (Object)"tr");
        map.put("Cp1254", (Object)"tr");
        map.put("ISO8859_9", (Object)"tr");
        map.put("MacTurkish", (Object)"tr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashArray encodingToLanguageMap() {
        HashArray map = encodingToLanguageMap;
        if (map == null) {
            Object object = initLock;
            synchronized (object) {
                map = encodingToLanguageMap;
                if (map == null) {
                    map = new HashArray(initLock);
                    CharIO.fillEncodingToLanguageMap(map);
                    encodingToLanguageMap = map;
                }
            }
        }
        return map;
    }

    public static String getEncodingLanguage(String encoding) {
        String result = null;
        if ((encoding = CharIO.resolveEncodingAliases(encoding, false)) != ENC_ISO8859_1 && encoding != ENC_UTF8) {
            result = (String)CharIO.encodingToLanguageMap().get(encoding);
        }
        return result;
    }

    public static Locale getEncodingLocale(String encoding) {
        String language = CharIO.getEncodingLanguage(encoding);
        return language != null ? new Locale(language, "", "") : null;
    }

    public static Locale getLocaleFromTextSample(char[] text) {
        String language = "en";
        char maxChar = '\u0000';
        int idx = 0;
        while (idx < text.length) {
            if (text[idx] > maxChar) {
                maxChar = text[idx];
            }
            ++idx;
        }
        if (maxChar >= UNICODE_RANGES[0]) {
            int idx2 = 0;
            while (idx2 < ISO639Langs.length) {
                if (maxChar >= UNICODE_RANGES[idx2 * 2] && maxChar <= UNICODE_RANGES[idx2 * 2 + 1]) {
                    language = ISO639Langs[idx2];
                    break;
                }
                ++idx2;
            }
        }
        return new Locale(language, "");
    }

    public static int getCharsetId(String encoding) {
        int charsetId = 0;
        if (encoding.equalsIgnoreCase("windows-1255")) {
            charsetId = 1;
        } else if (encoding.equalsIgnoreCase("visual")) {
            charsetId = 2;
        } else if (encoding.equalsIgnoreCase("iso-8859-8") || encoding.equalsIgnoreCase("ISO8859_8")) {
            charsetId = 3;
        }
        return charsetId;
    }

    public static String utf8ToStr(byte[] array, int offset, int length) throws IOException {
        char[] buffer = new char[length];
        int end = offset + length;
        int i = 0;
        boolean ok = true;
        while (offset != end) {
            int c;
            if ((c = array[offset++]) < 0) {
                int minumum_value;
                int utf8_tail;
                if ((0xC0 & c) != 192) {
                    ok = false;
                    break;
                }
                if ((0x20 & c) == 0) {
                    utf8_tail = 1;
                    c &= 0x1F;
                    minumum_value = 128;
                } else if ((0x10 & c) == 0) {
                    utf8_tail = 2;
                    c &= 0xF;
                    minumum_value = 2048;
                } else if ((8 & c) == 0) {
                    utf8_tail = 3;
                    c &= 7;
                    minumum_value = 65536;
                } else if ((4 & c) == 0) {
                    utf8_tail = 4;
                    c &= 3;
                    minumum_value = 0x200000;
                } else if ((2 & c) == 0) {
                    utf8_tail = 5;
                    c &= 1;
                    minumum_value = 0x4000000;
                } else {
                    ok = false;
                    break;
                }
                if (offset + utf8_tail > end) {
                    ok = false;
                    break;
                }
                do {
                    byte b;
                    if (((b = array[offset++]) & 0xC0) != 128) {
                        ok = false;
                        break;
                    }
                    c = c << 6 | 0x3F & b;
                } while (--utf8_tail != 0);
                if (c < minumum_value) {
                    ok = false;
                    break;
                }
                if (c > 65535) {
                    ok = false;
                    break;
                }
            }
            buffer[i++] = (char)c;
        }
        if (!ok) {
            throw new IOException("Bad UTF-8 bytes");
        }
        return new String(buffer, 0, i);
    }

    public static byte[] strToUTF8(String str) {
        int L = str.length();
        char[] ch = new char[L];
        str.getChars(0, L, ch, 0);
        int bytesCount = L;
        int i = 0;
        while (i != L) {
            char c = ch[i];
            if ((c & 0xFFFFFF80) != 0) {
                ++bytesCount;
                if ((c & 0xFFFFF800) != 0) {
                    ++bytesCount;
                }
            }
            ++i;
        }
        byte[] buffer = new byte[bytesCount];
        int offset = 0;
        int i2 = 0;
        while (i2 != L) {
            int c = ch[i2];
            if ((c & 0xFFFFFF80) != 0) {
                if ((c & 0xFFFFF800) == 0) {
                    buffer[offset++] = (byte)(0xC0 | c >>> 6);
                } else {
                    buffer[offset++] = (byte)(0xE0 | c >>> 12);
                    buffer[offset++] = (byte)(0x80 | c >>> 6 & 0x3F);
                }
                c = 0x80 | c & 0x3F;
            }
            buffer[offset++] = (byte)c;
            ++i2;
        }
        if (offset != bytesCount) {
            Debug.bug();
        }
        return buffer;
    }

    public static int mapWin1252_128_159_toUnicode(int c) {
        String s = "\u20ac\u0081\u201a\u0192\u201e\u2026\u2020\u2021\u02c6\u2030\u0160\u2039\u0152\u008d\u017d\u008f\u0090\u2018\u2019\u201c\u201d\u2022\u2013\u2014\u02dc\u2122\u0161\u203a\u0153\u009d\u017e\u0178";
        return s.charAt(c - 128);
    }
}

