/*
 * Decompiled with CFR 0.152.
 */
package ice.util.alg;

import ice.debug.Debug;
import ice.util.alg.Bidi;

class Bidi_WINDOWS_1255
extends Bidi {
    private static final int LET = 0;
    private static final int NUM = 1;
    private static final int HEB = 2;
    private static final int SEP = 3;
    private static final int MIR = 4;
    private static final int NOR = 5;
    private static final int WSP = 6;
    private static final int NEQ = 7;
    private static final int NSP = 8;
    private static final int TURN = 0;
    private static final int LEAVE = 1;
    private static final int STATE_HEBREW = 0;
    private static final int STATE_ENGLISH = 1;
    private static final byte[] charMap = new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 3, 5, 7, 7, 7, 5, 5, 4, 4, 5, 5, 3, 5, 3, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 4, 5, 4, 3, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 5, 4, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 5, 4, 5, 5};
    private static final char lastChar = '~';
    private int[] types;
    private int pos;

    protected Bidi_WINDOWS_1255(int id, char[] buf, int pos1, int pos2) {
        super(id, buf, pos1, pos2);
    }

    protected void reset() {
        this.types = null;
        this.pos = 0;
    }

    private static boolean isHebrew(char c) {
        return c > '~';
    }

    private int findFirstEnglishIndex(int start, boolean forward) {
        if (start == this.startPos || start == this.endPos - 1) {
            return -1;
        }
        int inc = forward ? 1 : -1;
        int i = start + inc;
        while (true) {
            if (i == this.startPos || i == this.endPos - 1) break;
            char c = this.buf[i];
            switch (charMap[c]) {
                case 0: 
                case 1: 
                case 7: {
                    return i;
                }
            }
            i += inc;
        }
        i = -1;
        return i;
    }

    private void changeBackwardsToHebrew(int i, int j) {
        int index = this.findFirstEnglishIndex(i, false);
        if (Debug.trace && index < 0) {
            Debug.trace("!!!! ERROR");
        }
        int k = ++index - this.startPos;
        while (k <= j) {
            this.types[k] = 0;
            ++k;
        }
    }

    private void getTypes() {
        int sz = this.endPos - this.startPos;
        this.types = new int[sz];
        int i = 0;
        while (i < sz) {
            this.types[i] = 0;
            ++i;
        }
        boolean state = false;
        int lastCharType = 2;
        int nextCharType = 2;
        int i2 = this.startPos;
        while (i2 < this.endPos) {
            int type;
            block15: {
                int j;
                char c;
                block14: {
                    char cn;
                    c = this.buf[i2];
                    j = i2 - this.startPos;
                    type = 2;
                    nextCharType = i2 + 1 < this.endPos ? (Bidi_WINDOWS_1255.isHebrew(cn = this.buf[i2 + 1]) ? 2 : charMap[cn]) : 2;
                    if (!Bidi_WINDOWS_1255.isHebrew(c)) break block14;
                    if (!state) break block15;
                    this.changeBackwardsToHebrew(i2, j);
                    state = false;
                    break block15;
                }
                type = charMap[c];
                switch (type) {
                    case 0: {
                        if (!state) {
                            state = true;
                        }
                        this.types[j] = 1;
                        break;
                    }
                    case 7: {
                        if (state) {
                            if (lastCharType != 0 && lastCharType != 1 && nextCharType != 0 && nextCharType != 1) {
                                this.changeBackwardsToHebrew(i2, j);
                                state = false;
                                break;
                            }
                            this.types[j] = 1;
                            break;
                        }
                        if (lastCharType == 1) {
                            this.types[j] = 1;
                            break;
                        }
                        this.types[j] = 0;
                        break;
                    }
                    case 1: {
                        this.types[j] = 1;
                        break;
                    }
                    case 6: {
                        if (state) {
                            this.types[j] = 1;
                        }
                        if (state) break;
                        this.types[j] = 0;
                        break;
                    }
                    default: {
                        if (state || lastCharType == 1 && nextCharType == 1) {
                            this.types[j] = 1;
                            break;
                        }
                        if (state) break;
                        this.types[j] = 0;
                        break;
                    }
                }
            }
            lastCharType = type;
            ++i2;
        }
    }

    protected StringBuffer getStringBuffer() {
        StringBuffer sbuf = new StringBuffer();
        if (this.endPos == this.startPos) {
            return sbuf;
        }
        this.pos = this.endPos - 1;
        while (this.buf[this.pos] == ' ') {
            if (this.pos == this.startPos) {
                return sbuf;
            }
            --this.pos;
        }
        this.endPos = this.pos + 1;
        this.getTypes();
        while (this.pos >= this.startPos) {
            char c = this.buf[this.pos];
            int j = this.pos - this.startPos;
            int type = this.types[j];
            if (type == 1) {
                int mark = j;
                int k = mark - 1;
                while (k >= 0 && this.types[k] == 1) {
                    --k;
                }
                int m = ++k;
                while (m <= mark) {
                    char cc = this.buf[m + this.startPos];
                    sbuf.append(this.mirror(cc));
                    ++m;
                }
                if (k == 0) break;
                this.pos = k + this.startPos - 1;
                continue;
            }
            sbuf.append(this.mirror(c));
            --this.pos;
        }
        return sbuf;
    }
}

