/*
 * Decompiled with CFR 0.152.
 */
package ice.storm.print;

import ice.storm.print.AbstractPageDecoration;
import ice.storm.print.StormPageFormat;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class StringPageDecoration
extends AbstractPageDecoration {
    private String text;

    public StringPageDecoration(String name, String text, int verticalAlignment, int horizontalAlignment) {
        super(name, verticalAlignment, horizontalAlignment);
        this.verticalAlignment = verticalAlignment;
        this.horizontalAlignment = horizontalAlignment;
        this.text = text;
    }

    public void paint(Graphics g, int currentPageIndex, int pageCount, StormPageFormat pageFormat) {
        if (this.text == null) {
            return;
        }
        g.setFont(pageFormat.getHeaderFooterFont());
        FontMetrics fontMetrics = g.getFontMetrics();
        int fontWidth = 0;
        g.setColor(Color.black);
        fontWidth = fontMetrics.stringWidth(this.text);
        int x = 0;
        int y = 0;
        int buffer = 25;
        y = this.verticalAlignment == AbstractPageDecoration.TOP ? (int)pageFormat.getMargin(1) - fontMetrics.getMaxDescent() : (int)pageFormat.getImageableHeight() + (int)pageFormat.getMargin(3) + fontMetrics.getMaxAscent();
        x = this.horizontalAlignment == AbstractPageDecoration.LEFT ? buffer : (this.horizontalAlignment == AbstractPageDecoration.CENTER ? (int)(pageFormat.getPageWidth() - (double)fontWidth) / 2 : (int)pageFormat.getPageWidth() - fontWidth - buffer);
        g.drawString(this.text, x, y);
    }
}

