/*
 * Decompiled with CFR 0.152.
 */
package ice.scripters;

import ice.scripters.MimeTypeObj;
import ice.storm.DynEnv;
import ice.storm.DynamicList;
import ice.storm.PilotInfo;
import ice.util.Defs;

final class PluginObj
extends DynamicList {
    PilotInfo pilotInfo;
    MimeTypeObj[] types;
    private static final int Field_description = 1;
    private static final int Field_filename = 2;
    private static final int Field_name = 3;

    PluginObj(PilotInfo pilotInfo) {
        this.pilotInfo = pilotInfo;
        String[] names = pilotInfo.getSupportedContentTypes();
        int N = names.length;
        MimeTypeObj[] types = new MimeTypeObj[N];
        int count = 0;
        int i = 0;
        while (i != N) {
            String name = names[i];
            if (name.indexOf(42) < 0) {
                MimeTypeObj type = new MimeTypeObj(name, this);
                types[count++] = type;
            }
            ++i;
        }
        if (count != N) {
            MimeTypeObj[] tmp = new MimeTypeObj[count];
            System.arraycopy(types, 0, tmp, 0, count);
            types = tmp;
        }
        this.types = types;
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = PluginObj.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = PluginObj.toDynamicId(name);
        if (id < 0) {
            return 1;
        }
        if (id > 0) {
            return 1;
        }
        return super.setDynamicValue(name, value, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return this.pilotInfo.getDescription();
            }
            case 2: {
                return this.pilotInfo.getClassName();
            }
            case 3: {
                return this.pilotInfo.getName();
            }
        }
        return null;
    }

    public String script_toString(DynEnv env) {
        return "[Object Plugin]";
    }

    protected int getLength() {
        return this.types.length;
    }

    protected Object script_item(int index, DynEnv env) {
        if (0 > index || index >= this.types.length) {
            return Defs.NOT_FOUND;
        }
        return this.types[index];
    }

    protected Object script_namedItem(String name, DynEnv env) {
        return Defs.NOT_FOUND;
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String X = null;
        int s_length = s.length();
        if (s_length == 4) {
            X = "name";
            id = 3;
        } else if (s_length == 8) {
            X = "filename";
            id = 2;
        } else if (s_length == 11) {
            X = "description";
            id = 1;
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

