/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.debug.Debug;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.ThePilot;
import ice.ri.swing.SwingWorker;
import ice.storm.Pilot;
import ice.storm.Viewport;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;

public class SaveAs
extends SwingWorker {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int PAGE_BUFFER_SIZE = 10240;
    private static final int URL = 1;
    private static final int PATH = 2;
    private Viewport mainViewport;
    private Viewport currentViewport;
    private Vector viewports;
    private String baseDirectory;
    private String pageFileName;
    private String resourceDir;
    private Hashtable images;
    private boolean resDirExist;
    private int nameCounter;
    private StringBuffer pageBuffer;
    private boolean cancelled;
    private boolean error;
    private ActionListener actionListener;
    private String actionCommand;

    private void $init$() {
        this.nameCounter = 0;
        this.cancelled = false;
        this.error = false;
    }

    public SaveAs(Viewport main_viewport) {
        this(main_viewport, System.getProperty("user.home"), "UpToDate.html");
    }

    public SaveAs(Viewport main_viewport, String base_directory, String filename) {
        this.$init$();
        this.currentViewport = this.mainViewport = main_viewport;
        this.baseDirectory = base_directory;
        this.pageFileName = filename;
        this.resDirExist = false;
    }

    public void setFile(File file) {
        this.pageFileName = file.getName();
        this.baseDirectory = file.getParent() + File.separator;
        this.resourceDir = this.makeupResourceDirName(this.pageFileName);
    }

    public void setFilename(String filename) {
        this.pageFileName = filename;
        this.resourceDir = this.makeupResourceDirName(this.pageFileName);
    }

    public void setBaseDirectory(String base_directory) {
        this.baseDirectory = base_directory;
    }

    public void setActionListener(ActionListener listener) {
        this.actionListener = listener;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public void setActionCommand(String action_command) {
        this.actionCommand = action_command;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        SaveAs saveAs = this;
        synchronized (saveAs) {
            this.cancelled = true;
        }
        if (this.actionListener != null) {
            ActionEvent event = new ActionEvent(this, 1001, this.actionCommand);
            this.actionListener.actionPerformed(event);
        }
    }

    public void worker_finished() {
        this.stop();
    }

    public Object worker_construct() {
        this.resourceDir = this.makeupResourceDirName(this.pageFileName);
        this.detectAndCreateBaseDir();
        this.viewports = new Vector(4, 1);
        this.mainViewport.getViewAndAllChildren(this.viewports);
        int viewportsCount = this.viewports.size();
        int i = 0;
        while (i < viewportsCount && !this.cancelled) {
            this.currentViewport = (Viewport)this.viewports.elementAt(i);
            Pilot p = this.currentViewport.getPilot();
            if (p instanceof ThePilot) {
                ThePilot pp = (ThePilot)p;
                DElement e = (DElement)pp.getDDocument().getFirstChild();
                this.pageBuffer = new StringBuffer(10240);
                this.save_r(e);
                this.savePageFile(this.pageBuffer.toString());
            }
            ++i;
        }
        if (this.images != null) {
            this.images.clear();
        }
        this.viewports.removeAllElements();
        return new Boolean(this.error ^ true);
    }

    private String makeupResourceDirName(String main_page_filename) {
        if (main_page_filename == null) {
            return "_files";
        }
        int idx = main_page_filename.lastIndexOf(46);
        String dirName = null;
        dirName = idx <= 0 ? main_page_filename + "_files" : main_page_filename.substring(0, idx) + "_files";
        return dirName;
    }

    private void detectAndCreateBaseDir() {
        File f = new File(this.baseDirectory + this.resourceDir);
        if (f.exists()) {
            if (f.isDirectory()) {
                this.resDirExist = true;
            }
        } else {
            this.resDirExist = f.mkdir();
        }
    }

    private void save_r(DElement e) {
        String nodeName = e.getNodeName();
        boolean needEndTag = this.needEndTag(e);
        this.writeBeginTageToPageBuffer(nodeName);
        int nodeNameID = e.getNameId();
        NamedNodeMap map = e.getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            DAttr a = (DAttr)map.item(i);
            String attrName = a.getName();
            if (attrName.equalsIgnoreCase("src")) {
                String urlString = e.getOwnerDDocument().resolveUrl(a.getValue());
                switch (nodeNameID) {
                    case 33: {
                        String pageFilename = this.getPageFilename(urlString);
                        if (pageFilename != null) {
                            this.writeAttributeToPageBuffer(attrName, this.rewrite(1, pageFilename));
                            break;
                        }
                        this.writeAttributeToPageBuffer(attrName, urlString);
                        break;
                    }
                    case 46: {
                        String imagefilename = this.saveImage(urlString);
                        this.writeAttributeToPageBuffer(attrName, this.rewrite(1, imagefilename));
                        break;
                    }
                    case 70: {
                        String scriptFilename = this.saveResourceFile(urlString);
                        this.writeAttributeToPageBuffer(attrName, this.rewrite(1, scriptFilename));
                        break;
                    }
                    case 47: {
                        String value = e.getAttribute(111);
                        if (value != null && value.equalsIgnoreCase("image")) {
                            String imagebuttonfilename = this.saveImage(urlString);
                            this.writeAttributeToPageBuffer(attrName, this.rewrite(1, imagebuttonfilename));
                            break;
                        }
                    }
                    default: {
                        this.writeAttributeToPageBuffer(attrName, urlString);
                        break;
                    }
                }
            } else if (attrName.equalsIgnoreCase("href")) {
                String urlString = e.getOwnerDDocument().resolveUrl(a.getValue());
                if (nodeNameID == 54) {
                    String value = e.getAttribute(111);
                    if (value != null && value.equalsIgnoreCase("text/css")) {
                        String cssFilename = this.saveResourceFile(urlString);
                        this.writeAttributeToPageBuffer(attrName, this.rewrite(1, cssFilename));
                    }
                } else {
                    String pageFilename = this.getPageFilename(urlString);
                    if (pageFilename != null) {
                        String attrValue = a.getValue();
                        if (attrValue != null && attrValue.length() > 0) {
                            if (attrValue.charAt(0) == '#') {
                                this.writeAttributeToPageBuffer(attrName, attrValue);
                            } else {
                                this.writeAttributeToPageBuffer(attrName, this.rewrite(1, pageFilename));
                            }
                        }
                    } else {
                        this.writeAttributeToPageBuffer(attrName, urlString);
                    }
                }
            } else {
                this.writeAttributeToPageBuffer(attrName, a.getValue());
            }
            ++i;
        }
        this.writeEndTageToPageBuffer(null);
        DNode n = (DNode)e.getFirstChild();
        while (n != null && !this.cancelled) {
            if (n instanceof DElement) {
                this.save_r((DElement)n);
            } else if (n instanceof DTextNode) {
                String text = this.isVisible(e) ? this.recoverEntityChar(n.toString()) : n.toString();
                this.writeTextToPageBuffer(text);
            }
            n = (DNode)n.getNextSibling();
        }
        if (needEndTag) {
            this.writeEndTageToPageBuffer(nodeName);
        }
    }

    private String rewrite(int type, String filename) {
        String str = null;
        if (filename.length() == 0) {
            return this.pageFileName;
        }
        str = this.resDirExist ? (type == 1 ? (this.currentViewport == this.mainViewport ? this.resourceDir + "/" + filename : filename) : this.resourceDir + File.separator + filename) : filename;
        return str;
    }

    private String saveImage(String sourceURLString) {
        String fname = null;
        URL sourceURL = null;
        if (this.images != null && this.images.containsKey(sourceURLString)) {
            return (String)this.images.get(sourceURLString);
        }
        try {
            sourceURL = new URL(sourceURLString);
            fname = this.getResourceFilename(sourceURL);
            this.streamCopy(sourceURL, this.baseDirectory + this.rewrite(2, fname));
            if (this.images == null) {
                this.images = new Hashtable();
            }
            this.images.put(sourceURLString, fname);
        }
        catch (MalformedURLException excp) {
            this.error = true;
            Debug.ex(excp);
            if (Debug.trace) {
                Debug.trace("Malformed URL: " + sourceURLString);
            }
        }
        catch (IOException excp) {
            this.error = true;
            Debug.ex(excp);
        }
        return fname;
    }

    private String saveResourceFile(String sourceURLString) {
        String fname = null;
        URL sourceURL = null;
        try {
            sourceURL = new URL(sourceURLString);
            fname = this.getResourceFilename(sourceURL);
            this.streamCopy(sourceURL, this.baseDirectory + this.rewrite(2, fname));
        }
        catch (MalformedURLException excp) {
            this.error = true;
            Debug.ex(excp);
            if (Debug.trace) {
                Debug.trace("Malformed URL: " + sourceURLString);
            }
        }
        catch (IOException excp) {
            this.error = true;
            Debug.ex(excp);
        }
        return fname;
    }

    private void savePageFile(String pageContent) {
        String fname = null;
        FileWriter pageOut = null;
        fname = this.currentViewport == this.mainViewport ? this.baseDirectory + this.pageFileName : this.baseDirectory + this.rewrite(2, this.currentViewport.getId() + ".html");
        try {
            try {
                pageOut = new FileWriter(fname);
                pageOut.write(pageContent);
                pageOut.flush();
            }
            catch (IOException e) {
                this.error = true;
                Debug.ex(e);
                if (Debug.trace) {
                    Debug.trace("Write html page to " + fname + " failed");
                }
            }
        }
        finally {
            if (pageOut != null) {
                try {
                    pageOut.close();
                }
                catch (IOException e) {
                    this.error = true;
                    Debug.ex(e);
                }
            }
        }
    }

    private void streamCopy(URL sourceUrl, String destFilename) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                in = sourceUrl.openStream();
                out = new FileOutputStream(destFilename);
                byte[] buffer = new byte[512];
                int length = buffer.length;
                while ((length = in.read(buffer, 0, buffer.length)) != -1) {
                    out.write(buffer, 0, length);
                }
                out.flush();
            }
            catch (IOException e) {
                this.error = true;
                Debug.ex(e);
                if (Debug.trace) {
                    Debug.trace("Copy " + sourceUrl + " to " + destFilename + " failed");
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private String getPageFilename(String url) {
        Viewport vport = null;
        int idx = url.lastIndexOf(35);
        String baseURL = null;
        String fragment = null;
        if (idx > 0) {
            baseURL = url.substring(0, idx);
            fragment = idx < url.length() ? url.substring(idx) : null;
        } else {
            baseURL = url;
        }
        int viewportsCount = this.viewports.size();
        int v = 0;
        while (v < viewportsCount) {
            Viewport vp = (Viewport)this.viewports.elementAt(v);
            String docurl = vp.getBaseUrl();
            int lidx = docurl.lastIndexOf(35);
            if (lidx >= 0) {
                docurl = docurl.substring(0, lidx);
            }
            if (docurl.equals(baseURL)) {
                vport = vp;
                break;
            }
            ++v;
        }
        String name = null;
        if (vport != null) {
            name = vport == this.mainViewport ? "" : (fragment != null ? vport.getId() + ".html" + fragment : vport.getId() + ".html");
        }
        return name;
    }

    private String getResourceFilename(URL u) {
        String name;
        int idx = u.getFile().lastIndexOf(46);
        if (idx != -1) {
            name = u.getFile().substring(idx);
            name = String.valueOf(this.nameCounter) + name;
        } else {
            name = String.valueOf(this.nameCounter);
        }
        ++this.nameCounter;
        return name;
    }

    public String getDefaultFilename() {
        Pilot p = this.mainViewport.getPilot();
        StringBuffer title = new StringBuffer();
        if (p instanceof ThePilot) {
            ThePilot pp = (ThePilot)p;
            String str = pp.getDDocument().getTitle();
            if (str == null) {
                title.append("UpToDatePage");
            } else {
                title.append(str.trim());
            }
            int len = title.length();
            int i = 0;
            while (i < len) {
                char c = title.charAt(i);
                if (!(c == '.' || c > '/' && c < ':' || c > '@' && c < '[' || c == '_' || c > '`' && c < '{')) {
                    title.setCharAt(i, '_');
                }
                ++i;
            }
            boolean needExtension = true;
            if (len > 5 && title.charAt(len - 5) == '.') {
                if (title.charAt(len - 4) == 'h' && title.charAt(len - 3) == 't' && title.charAt(len - 2) == 'm' && title.charAt(len - 1) == 'l') {
                    needExtension = false;
                }
            } else if (len > 4 && title.charAt(len - 4) == '.' && title.charAt(len - 3) == 'h' && title.charAt(len - 2) == 't' && title.charAt(len - 1) == 'm') {
                needExtension = false;
            }
            if (needExtension) {
                title.append(".html");
            }
        } else {
            title.append("not_html_pilot");
            Debug.trace("Only HTML4 page can be saved");
        }
        return title.toString();
    }

    private String recoverEntityChar(String str) {
        StringBuffer sBuffer = new StringBuffer(str.length());
        int len = str.length();
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            if (c == '\u00a0') {
                sBuffer.append("&nbsp;");
            } else if (c == '\"') {
                sBuffer.append("&quot;");
            } else if (c == '&') {
                sBuffer.append("&amp;");
            } else if (c == '<') {
                sBuffer.append("&lt;");
            } else if (c == '>') {
                sBuffer.append("&gt;");
            } else {
                int ci = 0xFFFF & c;
                if (ci < 160) {
                    sBuffer.append(c);
                } else {
                    sBuffer.append("&#");
                    sBuffer.append(new Integer(ci).toString());
                    sBuffer.append(';');
                }
            }
            ++i;
        }
        return sBuffer.toString();
    }

    private boolean needEndTag(DNode dNode) {
        int id = dNode.getNameId();
        boolean needEndingTag = true;
        switch (id) {
            case 6: 
            case 8: 
            case 9: 
            case 14: 
            case 42: 
            case 46: 
            case 47: 
            case 49: 
            case 54: 
            case 57: 
            case 60: {
                needEndingTag = false;
                break;
            }
        }
        return needEndingTag;
    }

    private boolean isVisible(DNode dNode) {
        int id = dNode.getNameId();
        boolean isVisible = true;
        switch (id) {
            case 70: 
            case 76: 
            case 86: {
                isVisible = false;
                break;
            }
        }
        return isVisible;
    }

    private void writeAttributeToPageBuffer(String attribute_name, String attribute_value) {
        this.pageBuffer.append(' ');
        this.pageBuffer.append(attribute_name);
        this.pageBuffer.append("=\"");
        this.pageBuffer.append(attribute_value);
        this.pageBuffer.append("\"");
    }

    private void writeBeginTageToPageBuffer(String node_name) {
        if (this.pageBuffer.length() > 0) {
            this.pageBuffer.append(LINE_SEPARATOR);
        }
        this.pageBuffer.append('<');
        this.pageBuffer.append(node_name);
    }

    private void writeEndTageToPageBuffer(String node_name) {
        if (node_name != null) {
            this.pageBuffer.append("</");
            this.pageBuffer.append(node_name);
        }
        this.pageBuffer.append('>');
    }

    private void writeTextToPageBuffer(String text) {
        this.pageBuffer.append(text);
    }
}

