/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.debug.Debug;
import ice.ri.swing.BrowserWindow;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class DragEventListener
implements DropTargetListener {
    private final BrowserWindow targetWindow;

    public DragEventListener(BrowserWindow target) {
        this.targetWindow = target;
    }

    public void drop(DropTargetDropEvent event) {
        block12: {
            try {
                if (!this.isDropAcceptable(event)) {
                    event.rejectDrop();
                    return;
                }
                event.acceptDrop(1);
                Transferable transferable = event.getTransferable();
                DataFlavor[] flavors = transferable.getTransferDataFlavors();
                boolean isFirst = true;
                int i = 0;
                while (i < flavors.length) {
                    String lc;
                    String urlStr;
                    DataFlavor dataFlavor = flavors[i];
                    if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
                        List fileList = (List)transferable.getTransferData(dataFlavor);
                        for (File file : fileList) {
                            String filePath = file.getAbsolutePath();
                            if (filePath == null) continue;
                            filePath = "file:///" + filePath;
                            if (isFirst) {
                                this.targetWindow.gotoLocation(filePath);
                                isFirst = false;
                                continue;
                            }
                            this.targetWindow.gotoLocation(filePath, String.valueOf(filePath.hashCode()), null);
                        }
                    } else if (dataFlavor.equals(DataFlavor.stringFlavor) && (urlStr = (String)transferable.getTransferData(dataFlavor)) != null && ((lc = (urlStr = urlStr.trim()).toLowerCase()).startsWith("http:") || lc.startsWith("https:") || lc.startsWith("file:"))) {
                        int endChar = urlStr.indexOf(10);
                        if (endChar > 0) {
                            urlStr = urlStr.substring(0, endChar);
                        }
                        this.targetWindow.gotoLocation(urlStr);
                    }
                    ++i;
                }
                event.dropComplete(true);
            }
            catch (IOException ioe) {
                if (Debug.ex) {
                    Debug.ex(ioe);
                }
            }
            catch (UnsupportedFlavorException ufe) {
                if (!Debug.ex) break block12;
                Debug.ex(ufe);
            }
        }
    }

    public void dragEnter(DropTargetDragEvent event) {
        if (!this.isDragAcceptable(event)) {
            event.rejectDrag();
            return;
        }
    }

    public void dropActionChanged(DropTargetDragEvent event) {
        if (!this.isDragAcceptable(event)) {
            event.rejectDrag();
            return;
        }
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
    }

    private boolean isDropAcceptable(DropTargetDropEvent event) {
        return (event.getDropAction() & 3) != 0;
    }

    private boolean isDragAcceptable(DropTargetDragEvent event) {
        return (event.getDropAction() & 3) != 0;
    }
}

