/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.ri.swing.Bookmark;
import ice.ri.swing.BrowserWindow;
import ice.ri.swing.MinimumFileFilter;
import ice.ri.swing.Net;
import ice.ri.swing.ProgressBarWindow;
import ice.ri.swing.PropertiesManager;
import ice.ri.swing.Resources;
import ice.ri.swing.SaveAs;
import ice.ri.swing.SaveAsDialog;
import ice.ri.swing.SetFileFilter;
import ice.ri.swing.StatusBar;
import ice.ri.swing.WindowManager;
import ice.util.Defs;
import ice.util.Emulation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Dialogs
implements ActionListener,
ItemListener,
ListSelectionListener {
    WindowManager windowManager;
    PropertiesManager properties;
    Resources res;
    private BrowserWindow about_parent;
    private JDialog about_dialog;
    private JButton about_ok;
    private JButton about_goBrowser;
    private JDialog auth_dialog;
    private JButton auth_ok;
    private JButton auth_cancel;
    private JTextField auth_domainName_field;
    private JTextField auth_userName_field;
    private JTextField auth_workstationName_field;
    private JPasswordField auth_password_field;
    private JLabel auth_destination;
    private String auth_domainName;
    private String auth_userName;
    private String auth_workstationName;
    private String auth_password;
    private BrowserWindow bookmark_window;
    private JDialog bookmark_dialog;
    private JButton bookmark_ok;
    private JButton bookmark_cancel;
    private JButton bookmark_makeNew;
    private JButton bookmark_add;
    private JButton bookmark_remove;
    private JButton bookmark_change;
    private JButton bookmark_up;
    private JButton bookmark_down;
    private JList bookmark_list;
    private DefaultListModel bookmark_model;
    private JTextField bookmark_title;
    private JTextField bookmark_location;
    private JDialog cache_dialog;
    private JButton cache_ok;
    private JButton cache_cancel;
    private JButton cache_memory_clear;
    private JButton cache_file_clear;
    private JCheckBox cache_memory_enableBox;
    private JCheckBox cache_file_enableBox;
    private JTextField cache_memory_valueField;
    private JTextField cache_file_valueField;
    private JDialog alert_dialog;
    private JButton alert_ok;
    private JDialog confirmation_dialog;
    private JButton confirmation_yes;
    private JButton confirmation_no;
    private boolean confirmation_result;
    private JDialog cookies_dialog;
    private JButton cookies_ok;
    private JButton cookies_cancel;
    private JRadioButton cookies_enable;
    private JRadioButton cookies_disable;
    private JDialog emulationDialog;
    private JButton emulationOkButton;
    private JButton emulationCancelButton;
    private JComboBox emulationComboBox;
    private final String[] emulationNames;
    private final String[] emulationValues;
    private BrowserWindow encoding_window;
    private JDialog encoding_dialog;
    private JButton encoding_ok;
    private JButton encoding_cancel;
    private JTextField encoding_valueField;
    private BrowserWindow fonts_window;
    private Font fonts_initialProp;
    private Font fonts_initialFixed;
    private Font fonts_currentProp;
    private Font fonts_currentFixed;
    private JDialog fonts_dialog;
    private JButton fonts_apply;
    private JButton fonts_ok;
    private JButton fonts_cancel;
    private JComboBox fonts_fontProp;
    private JTextField fonts_sizeProp;
    private JComboBox fonts_fontFixed;
    private JTextField fonts_sizeFixed;
    private String[] fonts_names;
    private int lookfeel_initial;
    private int lookfeel_current;
    private JDialog lookfeel_dialog;
    private JButton lookfeel_apply;
    private JButton lookfeel_ok;
    private JButton lookfeel_cancel;
    private JList lookfeel_list;
    private UIManager.LookAndFeelInfo[] lookfeel_looks;
    private BrowserWindow openURL_window;
    private JDialog openURL_dialog;
    private JButton openURL_ok;
    private JButton openURL_cancel;
    private JTextField openURL_valueField;
    private JFileChooser openFile_dialog;
    private JFileChooser save_file_dialog;
    private String save_directory;

    Dialogs(WindowManager windowManager) {
        this.$init$();
        this.windowManager = windowManager;
        this.properties = windowManager.getProperties();
        this.res = windowManager.getProperties().res;
    }

    private void showDialog(BrowserWindow window, JDialog dlg) {
        if (!dlg.isVisible()) {
            dlg.setLocationRelativeTo(window);
            dlg.setVisible(true);
        }
    }

    private void hideDialog(JDialog dlg) {
        dlg.setVisible(false);
    }

    JDialog createModalDialog() {
        JDialog dlg = new JDialog((Frame)this.res.getBaseFrame(), true);
        dlg.setResizable(true);
        return dlg;
    }

    JDialog createModalDialog(String titleRes) {
        JDialog dlg = this.createModalDialog();
        dlg.setTitle(this.res.str(titleRes));
        return dlg;
    }

    private void gotoURLIfGood(BrowserWindow window, String location) {
        URL url = Net.checkURL(location, this.res);
        if (url != null) {
            window.gotoLocation(location.toString());
        }
    }

    void updateUI() {
        if (this.about_dialog != null) {
            SwingUtilities.updateComponentTreeUI(this.about_dialog);
        }
        if (this.auth_dialog != null) {
            SwingUtilities.updateComponentTreeUI(this.auth_dialog);
        }
        if (this.cache_dialog != null) {
            SwingUtilities.updateComponentTreeUI(this.cache_dialog);
        }
        if (this.bookmark_dialog != null) {
            SwingUtilities.updateComponentTreeUI(this.bookmark_dialog);
        }
        if (this.cookies_dialog != null) {
            SwingUtilities.updateComponentTreeUI(this.cookies_dialog);
        }
        if (this.emulationDialog != null) {
            SwingUtilities.updateComponentTreeUI(this.emulationDialog);
        }
        if (this.encoding_dialog != null) {
            SwingUtilities.updateComponentTreeUI(this.encoding_dialog);
        }
        if (this.fonts_dialog != null) {
            SwingUtilities.updateComponentTreeUI(this.fonts_dialog);
        }
        if (this.lookfeel_dialog != null) {
            SwingUtilities.updateComponentTreeUI(this.lookfeel_dialog);
        }
        if (this.openURL_dialog != null) {
            SwingUtilities.updateComponentTreeUI(this.openURL_dialog);
        }
        if (this.openFile_dialog != null) {
            SwingUtilities.updateComponentTreeUI(this.openFile_dialog);
        }
        if (this.save_file_dialog != null) {
            SwingUtilities.updateComponentTreeUI(this.save_file_dialog);
        }
    }

    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        boolean caught = false;
        if (!caught) {
            caught = this.about_actionPerformed(source, ev);
        }
        if (!caught) {
            caught = this.auth_actionPerformed(source, ev);
        }
        if (!caught) {
            caught = this.bookmark_actionPerformed(source, ev);
        }
        if (!caught) {
            caught = this.cache_actionPerformed(source, ev);
        }
        if (!caught) {
            caught = this.cookies_actionPerformed(source, ev);
        }
        if (!caught) {
            caught = this.alert_actionPerformed(source, ev);
        }
        if (!caught) {
            caught = this.confirmation_actionPerformed(source, ev);
        }
        if (!caught) {
            caught = this.encoding_actionPerformed(source, ev);
        }
        if (!caught) {
            caught = this.fonts_actionPerformed(source, ev);
        }
        if (!caught) {
            caught = this.lookfeel_actionPerformed(source, ev);
        }
        if (!caught) {
            caught = this.emulation_actionPerformed(source, ev);
        }
    }

    public void itemStateChanged(ItemEvent ev) {
        Object source = ev.getSource();
        boolean caught = false;
        if (!caught) {
            caught = this.cookies_itemStateChanged(source, ev);
        }
        if (!caught) {
            caught = this.cache_itemStateChanged(source, ev);
        }
    }

    public void valueChanged(ListSelectionEvent ev) {
        Object source = ev.getSource();
        boolean caught = false;
        if (!caught) {
            caught = this.bookmark_valueChanged(source, ev);
        }
    }

    public void showAbout(BrowserWindow window) {
        if (this.about_dialog == null) {
            this.about_createNew();
        }
        this.about_valueToUI(window);
        this.showDialog(window, this.about_dialog);
    }

    private void about_hide() {
        this.about_parent = null;
        this.hideDialog(this.about_dialog);
    }

    private void about_valueToUI(BrowserWindow window) {
        this.about_parent = window;
    }

    private void about_createNew() {
        int c1;
        JDialog dlg = this.about_dialog = this.createModalDialog("aboutdialog.title");
        Resources r = this.res;
        String text = r.str("aboutdialog.text", this.properties.versionName);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new GridLayout(0, 1));
        CompoundBorder groupBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 25, 5, 25));
        infoPanel.setBorder(groupBorder);
        int c2 = 0;
        while ((c1 = text.indexOf(10, c2)) > -1) {
            infoPanel.add(new JLabel(text.substring(c2, c1)));
            c2 = c1 + 1;
        }
        infoPanel.add(new JLabel(text.substring(c2, text.length())));
        JPanel browserPanel = new JPanel();
        this.about_goBrowser = new JButton(r.str("aboutdialog.product"));
        this.about_goBrowser.addActionListener(this);
        this.about_goBrowser.setAlignmentY(0.5f);
        browserPanel.setLayout(new BoxLayout(browserPanel, 0));
        browserPanel.add(this.about_goBrowser);
        browserPanel.add(new JLabel("  "));
        browserPanel.add(new JLabel(r.str("aboutdialog.company")));
        JPanel buttonPanel = new JPanel();
        this.about_ok = new JButton(this.res.strButtonOk());
        this.about_ok.addActionListener(this);
        buttonPanel.add(this.about_ok);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(infoPanel);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        Container root = dlg.getContentPane();
        root.setLayout(new BorderLayout());
        root.add((Component)mainPanel, "Center");
        root.add((Component)buttonPanel, "South");
        dlg.pack();
        dlg.setLocationRelativeTo(this.res.getBaseFrame());
    }

    private boolean about_actionPerformed(Object source, ActionEvent ev) {
        boolean caught = true;
        if (source == this.about_ok) {
            this.about_hide();
        } else if (source == this.about_goBrowser) {
            if (this.about_parent != null) {
                this.gotoURLIfGood(this.about_parent, this.res.str("aboutdialog.product.url"));
            }
        } else {
            caught = false;
        }
        return caught;
    }

    public String[] showAuthentification(String type, String realm, URL url) {
        this.auth_createNew(type);
        this.auth_valueToUI(realm, url);
        this.showDialog(null, this.auth_dialog);
        String[] result = this.auth_userName == null || this.auth_password == null ? null : new String[]{this.auth_domainName, this.auth_userName, this.auth_workstationName, this.auth_password};
        return result;
    }

    private void auth_hide() {
        this.hideDialog(this.auth_dialog);
    }

    private void auth_valueToUI(String realm, URL url) {
        this.auth_userName = null;
        this.auth_userName_field.setText("");
        this.auth_password = null;
        this.auth_password_field.setText("");
        this.auth_destination.setText(this.res.str("authdialog.destination", realm, url.getProtocol() + "://" + url.getHost()));
        if (this.auth_domainName_field != null) {
            this.auth_domainName = null;
            this.auth_domainName_field.setText("");
        }
        if (this.auth_workstationName_field != null) {
            this.auth_workstationName = null;
            this.auth_workstationName_field.setText("");
        }
        if (this.auth_domainName_field != null) {
            this.auth_domainName_field.requestFocus();
        } else {
            this.auth_userName_field.requestFocus();
        }
    }

    private boolean auth_UIToValue() {
        this.auth_userName = this.auth_userName_field.getText();
        this.auth_password = new String(this.auth_password_field.getPassword());
        this.auth_userName_field.setText("");
        this.auth_password_field.setText("");
        if (this.auth_domainName_field != null) {
            this.auth_domainName = this.auth_domainName_field.getText();
            this.auth_domainName_field.setText("");
        }
        if (this.auth_workstationName_field != null) {
            this.auth_workstationName = this.auth_workstationName_field.getText();
            this.auth_workstationName_field.setText("");
        }
        return true;
    }

    private void auth_createNew(String type) {
        this.auth_dialog = this.createModalDialog("authdialog.title");
        this.auth_dialog.getContentPane().setLayout(new BoxLayout(this.auth_dialog.getContentPane(), 1));
        JPanel descriptionPanel = new JPanel(new FlowLayout(0));
        this.auth_destination = new JLabel("", 0);
        descriptionPanel.add(this.auth_destination);
        this.auth_dialog.getContentPane().add(descriptionPanel);
        JPanel credentialsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(5, 5, 5, 5);
        int gridy = 0;
        if (type.equals("NTLM")) {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = gridy;
            gridBagConstraints.insets = insets;
            gridBagConstraints.weightx = 0.0;
            credentialsPanel.add((Component)new JLabel(this.res.str("authdialog.domainname"), 2), gridBagConstraints);
            this.auth_domainName_field = new JTextField(20);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = gridy++;
            gridBagConstraints.insets = insets;
            gridBagConstraints.weightx = 1.0;
            credentialsPanel.add((Component)this.auth_domainName_field, gridBagConstraints);
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 0.0;
        credentialsPanel.add((Component)new JLabel(this.res.str("authdialog.username"), 2), gridBagConstraints);
        this.auth_userName_field = new JTextField(20);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        credentialsPanel.add((Component)this.auth_userName_field, gridBagConstraints);
        if (type.equals("NTLM")) {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = gridy;
            gridBagConstraints.insets = insets;
            gridBagConstraints.weightx = 0.0;
            credentialsPanel.add((Component)new JLabel(this.res.str("authdialog.workstationname"), 2), gridBagConstraints);
            this.auth_workstationName_field = new JTextField(20);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = gridy++;
            gridBagConstraints.insets = insets;
            gridBagConstraints.weightx = 1.0;
            credentialsPanel.add((Component)this.auth_workstationName_field, gridBagConstraints);
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 0.0;
        credentialsPanel.add((Component)new JLabel(this.res.str("authdialog.password"), 2), gridBagConstraints);
        this.auth_password_field = new JPasswordField(20);
        this.auth_password_field.setEchoChar('*');
        this.auth_password_field.addActionListener(this);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        credentialsPanel.add((Component)this.auth_password_field, gridBagConstraints);
        this.auth_dialog.getContentPane().add(credentialsPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.auth_ok = new JButton(this.res.strButtonOk());
        this.auth_ok.addActionListener(this);
        buttonPanel.add(this.auth_ok);
        this.auth_cancel = new JButton(this.res.strButtonCancel());
        this.auth_cancel.addActionListener(this);
        buttonPanel.add(this.auth_cancel);
        this.auth_dialog.getContentPane().add(buttonPanel);
        this.auth_dialog.getRootPane().setDefaultButton(this.auth_ok);
        this.auth_dialog.pack();
        if (type.equals("NTLM")) {
            this.auth_dialog.setSize(500, 221);
        } else {
            this.auth_dialog.setSize(500, 159);
        }
    }

    private boolean auth_actionPerformed(Object source, ActionEvent ev) {
        boolean caught = true;
        if (source == this.auth_ok || source == this.auth_password_field) {
            if (this.auth_UIToValue()) {
                this.auth_hide();
            }
        } else if (source == this.auth_cancel) {
            this.auth_hide();
        } else {
            caught = false;
        }
        return caught;
    }

    public void showBookmarkManager(BrowserWindow window) {
        if (this.bookmark_dialog == null) {
            this.bookmark_createNew();
        }
        this.bookmark_valueToUI(window);
        this.showDialog(window, this.bookmark_dialog);
    }

    private void bookmark_hide() {
        this.bookmark_window = null;
        this.hideDialog(this.bookmark_dialog);
    }

    private void bookmark_valueToUI(BrowserWindow window) {
        this.bookmark_window = window;
        Vector source = this.properties.bookmarks();
        this.bookmark_model.removeAllElements();
        int size = source.size();
        this.bookmark_model.ensureCapacity(size);
        int i = 0;
        while (i != size) {
            this.bookmark_model.addElement(source.elementAt(i));
            ++i;
        }
        if (size > 0) {
            this.bookmark_list.setSelectedIndex(0);
        }
    }

    private boolean bookmark_UIToValue() {
        Vector bookmarks = this.properties.bookmarks();
        bookmarks.removeAllElements();
        int i = 0;
        while (i < this.bookmark_model.size()) {
            bookmarks.addElement(this.bookmark_model.elementAt(i));
            ++i;
        }
        this.windowManager.resetBookmarks();
        this.properties.saveBookmarks();
        return true;
    }

    private URL bookmark_extractURL(String errText) {
        String location = this.bookmark_location.getText();
        URL u = Net.checkURL(location, this.res);
        if (u == null) {
            this.res.displayError(errText, location);
            this.bookmark_location.requestFocus();
        }
        return u;
    }

    private void bookmark_updateEnable() {
        int selected = this.bookmark_list.getSelectedIndex();
        int size = this.bookmark_model.getSize();
        if (0 <= selected && selected < size) {
            Bookmark b = (Bookmark)this.bookmark_model.getElementAt(selected);
            this.bookmark_title.setText(b.title);
            this.bookmark_location.setText(b.url);
            this.bookmark_remove.setEnabled(true);
            this.bookmark_change.setEnabled(true);
            this.bookmark_up.setEnabled(selected > 0);
            this.bookmark_down.setEnabled(selected <= size - 2);
        } else {
            this.bookmark_remove.setEnabled(false);
            this.bookmark_change.setEnabled(false);
            this.bookmark_up.setEnabled(false);
            this.bookmark_down.setEnabled(false);
        }
    }

    private void bookmark_createNew() {
        JDialog dlg = this.bookmark_dialog = this.createModalDialog("bookmarkdialog.title");
        JPanel bookmarkPanel = new JPanel();
        JPanel titlePanel = new JPanel();
        JLabel titleLabel = new JLabel(this.res.str("bookmarkdialog.bookmarktitle"));
        JTextField txt = this.bookmark_title = new JTextField();
        txt.setAlignmentY(0.5f);
        txt.setMaximumSize(new Dimension(txt.getMaximumSize().width, txt.getPreferredSize().height));
        txt.setMinimumSize(new Dimension(txt.getPreferredSize().width, txt.getMinimumSize().height));
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        titlePanel.setBorder(new EmptyBorder(0, 5, 0, 5));
        titlePanel.add(titleLabel);
        titlePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        titlePanel.add(this.bookmark_title);
        JPanel locationPanel = new JPanel();
        JLabel locationLabel = new JLabel(this.res.str("bookmarkdialog.bookmarklocation"));
        txt = this.bookmark_location = new JTextField();
        txt.setAlignmentY(0.5f);
        txt.setMaximumSize(new Dimension(txt.getMaximumSize().width, txt.getPreferredSize().height));
        txt.setMinimumSize(new Dimension(txt.getPreferredSize().width, txt.getMinimumSize().height));
        locationPanel.setLayout(new BoxLayout(locationPanel, 0));
        locationPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
        locationPanel.add(locationLabel);
        locationPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        locationPanel.add(this.bookmark_location);
        this.bookmark_model = new DefaultListModel();
        this.bookmark_list = new JList(this.bookmark_model);
        JScrollPane scrollList = new JScrollPane(this.bookmark_list);
        bookmarkPanel.setLayout(new BoxLayout(bookmarkPanel, 1));
        bookmarkPanel.setBorder(new EmptyBorder(5, 0, 5, 0));
        bookmarkPanel.add(titlePanel);
        bookmarkPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        bookmarkPanel.add(locationPanel);
        bookmarkPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        bookmarkPanel.add(scrollList);
        JPanel actionPanel = new JPanel();
        this.bookmark_makeNew = new JButton(this.res.str("bookmarkdialog.new"));
        this.bookmark_add = new JButton(this.res.str("bookmarkdialog.add"));
        this.bookmark_remove = new JButton(this.res.str("bookmarkdialog.remove"));
        this.bookmark_change = new JButton(this.res.str("bookmarkdialog.change"));
        this.bookmark_up = new JButton(this.res.str("bookmarkdialog.up"));
        this.bookmark_down = new JButton(this.res.str("bookmarkdialog.down"));
        actionPanel.setLayout(new GridLayout(0, 1, 5, 5));
        actionPanel.add(this.bookmark_makeNew);
        actionPanel.add(this.bookmark_add);
        actionPanel.add(this.bookmark_remove);
        actionPanel.add(this.bookmark_change);
        actionPanel.add(this.bookmark_up);
        actionPanel.add(this.bookmark_down);
        JPanel mainPanel = new JPanel();
        CompoundBorder groupBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));
        mainPanel.setBorder(groupBorder);
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        mainPanel.add((Component)bookmarkPanel, "Center");
        mainPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        mainPanel.add((Component)actionPanel, "East");
        JPanel buttonPanel = new JPanel();
        this.bookmark_ok = new JButton(this.res.strButtonOk());
        this.bookmark_cancel = new JButton(this.res.strButtonCancel());
        buttonPanel.add(this.bookmark_ok);
        buttonPanel.add(this.bookmark_cancel);
        Container root = dlg.getContentPane();
        root.setLayout(new BorderLayout());
        root.add((Component)mainPanel, "Center");
        root.add((Component)buttonPanel, "South");
        this.bookmark_list.addListSelectionListener(this);
        this.bookmark_makeNew.addActionListener(this);
        this.bookmark_add.addActionListener(this);
        this.bookmark_remove.addActionListener(this);
        this.bookmark_change.addActionListener(this);
        this.bookmark_up.addActionListener(this);
        this.bookmark_down.addActionListener(this);
        this.bookmark_ok.addActionListener(this);
        this.bookmark_cancel.addActionListener(this);
        dlg.setSize(500, 300);
    }

    private boolean bookmark_actionPerformed(Object source, ActionEvent ev) {
        boolean caught = true;
        if (source == this.bookmark_cancel) {
            this.bookmark_hide();
        } else if (source == this.bookmark_ok) {
            if (this.bookmark_UIToValue()) {
                this.bookmark_hide();
            }
        } else if (source == this.bookmark_makeNew) {
            this.bookmark_list.setSelectedIndices(new int[0]);
            this.bookmark_title.setText("");
            this.bookmark_location.setText("http://");
            this.bookmark_title.requestFocus();
        } else if (source == this.bookmark_add) {
            URL u = this.bookmark_extractURL("bookmarkdialog.add.malformed");
            if (u != null) {
                Bookmark b = new Bookmark(this.bookmark_title.getText(), u);
                int currentSelected = this.bookmark_list.getSelectedIndex();
                if (currentSelected > -1) {
                    this.bookmark_model.insertElementAt(b, currentSelected + 1);
                } else {
                    this.bookmark_model.addElement(b);
                }
                this.bookmark_updateEnable();
            }
        } else if (source == this.bookmark_change) {
            int selected;
            URL u = this.bookmark_extractURL("bookmarkdialog.change.malformed");
            if (u != null && (selected = this.bookmark_list.getSelectedIndex()) >= 0) {
                Bookmark b = new Bookmark(this.bookmark_title.getText(), u);
                this.bookmark_model.setElementAt(b, selected);
                this.bookmark_updateEnable();
                this.bookmark_updateEnable();
            }
        } else if (source == this.bookmark_remove) {
            int selected = this.bookmark_list.getSelectedIndex();
            if (selected >= 0) {
                this.bookmark_model.removeElementAt(selected);
                if (this.bookmark_model.size() > selected) {
                    this.bookmark_list.setSelectedIndex(selected);
                } else {
                    this.bookmark_list.setSelectedIndex(selected - 1);
                }
                this.bookmark_updateEnable();
            }
        } else if (source == this.bookmark_up) {
            int selected = this.bookmark_list.getSelectedIndex();
            if (selected > 0) {
                Object b = this.bookmark_model.getElementAt(selected);
                Object bPrev = this.bookmark_model.getElementAt(selected - 1);
                this.bookmark_model.setElementAt(bPrev, selected);
                this.bookmark_model.setElementAt(b, selected - 1);
                this.bookmark_list.setSelectedIndex(selected - 1);
                this.bookmark_updateEnable();
            }
        } else if (source == this.bookmark_down) {
            int selected = this.bookmark_list.getSelectedIndex();
            if (0 <= selected && selected <= this.bookmark_model.size() - 2) {
                Object b = this.bookmark_model.getElementAt(selected);
                Object bNext = this.bookmark_model.getElementAt(selected + 1);
                this.bookmark_model.setElementAt(bNext, selected);
                this.bookmark_model.setElementAt(b, selected + 1);
                this.bookmark_list.setSelectedIndex(selected + 1);
                this.bookmark_updateEnable();
            }
        } else {
            caught = false;
        }
        return caught;
    }

    private boolean bookmark_valueChanged(Object source, ListSelectionEvent ev) {
        boolean caught = true;
        if (source == this.bookmark_list) {
            this.bookmark_updateEnable();
        } else {
            caught = false;
        }
        return caught;
    }

    public void showCache(BrowserWindow window) {
        if (this.cache_dialog == null) {
            this.cache_createNew();
        }
        this.cache_valueToUI();
        this.showDialog(window, this.cache_dialog);
    }

    private void cache_hide() {
        this.hideDialog(this.cache_dialog);
    }

    private void cache_valueToUI() {
        long memoryCacheSizeKB = this.properties.getMemoryCacheSize() / 1024L;
        if (memoryCacheSizeKB > 0L) {
            this.cache_memory_enableBox.setSelected(true);
            this.cache_memory_valueField.setText(Long.toString(memoryCacheSizeKB));
            this.cache_memory_valueField.setEnabled(true);
        } else {
            this.cache_memory_enableBox.setSelected(false);
            this.cache_memory_valueField.setText("0");
            this.cache_memory_valueField.setEnabled(false);
        }
        long fileCacheSizeKB = this.properties.getFileCacheSize() / 1024L;
        if (fileCacheSizeKB > 0L) {
            this.cache_file_enableBox.setSelected(true);
            this.cache_file_valueField.setText(Long.toString(fileCacheSizeKB));
            this.cache_file_valueField.setEnabled(true);
        } else {
            this.cache_file_enableBox.setSelected(false);
            this.cache_file_valueField.setText("0");
            this.cache_file_valueField.setEnabled(false);
        }
    }

    private boolean cache_UIToValue() {
        long fileCacheSize;
        long memoryCacheSize;
        String valueStr_memoryCache = this.cache_memory_valueField.getText();
        String valueStr_fileCache = this.cache_file_valueField.getText();
        try {
            memoryCacheSize = Long.parseLong(valueStr_memoryCache) * 1024L;
        }
        catch (NumberFormatException ex) {
            this.res.displayError("cachedialog.invalidnumber", valueStr_memoryCache);
            boolean bl = false;
            return bl;
        }
        try {
            fileCacheSize = Long.parseLong(valueStr_fileCache) * 1024L;
        }
        catch (NumberFormatException ex) {
            this.res.displayError("cachedialog.invalidnumber", valueStr_fileCache);
            boolean bl = false;
            return bl;
        }
        this.properties.setMemoryCacheSize(memoryCacheSize);
        this.properties.setFileCacheSize(fileCacheSize);
        return true;
    }

    private void cache_createNew() {
        JDialog dlg = this.cache_dialog = this.createModalDialog("cachedialog.title");
        String sizeLabelString = this.res.str("cachedialog.cache");
        String unitLabelString = this.res.str("cachedialog.kb");
        String clearBtnString = this.res.str("cachedialog.clear");
        String enableString = this.res.str("cachedialog.enable");
        JPanel cachePanel = new JPanel(new BorderLayout());
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Border etchedBorder = BorderFactory.createEtchedBorder();
        Border leftEmptyBorder = BorderFactory.createEmptyBorder(0, 5, 0, 0);
        Border rightEmptyBorder = BorderFactory.createEmptyBorder(0, 0, 0, 5);
        JPanel memoryPanel = new JPanel(new BorderLayout());
        memoryPanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, this.res.str("cachedialog.memory.title")));
        JPanel cacheSizePanel = new JPanel(new BorderLayout());
        cacheSizePanel.setBorder(emptyBorder);
        this.cache_memory_enableBox = new JCheckBox(enableString);
        this.cache_memory_enableBox.addItemListener(this);
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
        this.cache_memory_valueField = new JTextField(10);
        this.cache_memory_valueField.setHorizontalAlignment(4);
        JLabel sizeLabel = new JLabel(sizeLabelString);
        sizeLabel.setBorder(rightEmptyBorder);
        panel1.add((Component)sizeLabel, "West");
        panel1.add((Component)this.cache_memory_valueField, "Center");
        JLabel unitLabel = new JLabel(unitLabelString);
        unitLabel.setBorder(leftEmptyBorder);
        panel1.add((Component)unitLabel, "East");
        cacheSizePanel.add((Component)this.cache_memory_enableBox, "West");
        cacheSizePanel.add((Component)panel1, "Center");
        memoryPanel.add((Component)cacheSizePanel, "North");
        JPanel clearBtnPanel = new JPanel(new FlowLayout(1));
        clearBtnPanel.setBorder(emptyBorder);
        this.cache_memory_clear = new JButton(clearBtnString);
        this.cache_memory_clear.addActionListener(this);
        clearBtnPanel.add(this.cache_memory_clear);
        memoryPanel.add((Component)clearBtnPanel, "Center");
        cachePanel.add((Component)memoryPanel, "North");
        JPanel fileCachePanel = new JPanel(new BorderLayout());
        fileCachePanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, this.res.str("cachedialog.file.title")));
        cacheSizePanel = new JPanel(new BorderLayout());
        cacheSizePanel.setBorder(emptyBorder);
        this.cache_file_enableBox = new JCheckBox(enableString);
        this.cache_file_enableBox.addItemListener(this);
        panel1 = new JPanel(new BorderLayout());
        panel1.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
        this.cache_file_valueField = new JTextField(10);
        this.cache_file_valueField.setHorizontalAlignment(4);
        sizeLabel = new JLabel(sizeLabelString);
        sizeLabel.setBorder(rightEmptyBorder);
        panel1.add((Component)sizeLabel, "West");
        panel1.add((Component)this.cache_file_valueField, "Center");
        unitLabel = new JLabel(unitLabelString);
        unitLabel.setBorder(leftEmptyBorder);
        panel1.add((Component)unitLabel, "East");
        cacheSizePanel.add((Component)this.cache_file_enableBox, "West");
        cacheSizePanel.add((Component)panel1, "Center");
        fileCachePanel.add((Component)cacheSizePanel, "North");
        clearBtnPanel = new JPanel(new FlowLayout(1));
        clearBtnPanel.setBorder(emptyBorder);
        this.cache_file_clear = new JButton(clearBtnString);
        this.cache_file_clear.addActionListener(this);
        clearBtnPanel.add(this.cache_file_clear);
        fileCachePanel.add((Component)clearBtnPanel, "Center");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)fileCachePanel, "North");
        cachePanel.add((Component)panel2, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.cache_ok = new JButton(this.res.strButtonOk());
        buttonPanel.add(this.cache_ok);
        this.cache_ok.addActionListener(this);
        this.cache_cancel = new JButton(this.res.strButtonCancel());
        buttonPanel.add(this.cache_cancel);
        this.cache_cancel.addActionListener(this);
        Container root = dlg.getContentPane();
        root.setLayout(new BorderLayout());
        root.add((Component)cachePanel, "Center");
        root.add((Component)buttonPanel, "South");
        dlg.pack();
    }

    private boolean cache_actionPerformed(Object source, ActionEvent ev) {
        boolean caught = true;
        if (source == this.cache_memory_clear) {
            this.properties.clearMemoryCache();
        } else if (source == this.cache_file_clear) {
            this.properties.clearFileCache();
        } else if (source == this.cache_ok) {
            if (this.cache_UIToValue()) {
                this.cache_hide();
            }
        } else if (source == this.cache_cancel) {
            this.cache_hide();
        } else {
            caught = false;
        }
        return caught;
    }

    private boolean cache_itemStateChanged(Object source, ItemEvent e) {
        boolean caught = true;
        int state = e.getStateChange();
        if (source == this.cache_memory_enableBox) {
            if (state == 1) {
                this.cache_memory_valueField.setText(Long.toString(1024L));
                this.cache_memory_valueField.setEnabled(true);
            } else if (state == 2) {
                this.cache_memory_valueField.setText("0");
                this.cache_memory_valueField.setEnabled(false);
            }
        } else if (source == this.cache_file_enableBox) {
            if (state == 1) {
                this.cache_file_valueField.setText(Long.toString(5120L));
                this.cache_file_valueField.setEnabled(true);
            } else if (state == 2) {
                this.cache_file_valueField.setText("0");
                this.cache_file_valueField.setEnabled(false);
            }
        } else {
            caught = false;
        }
        return caught;
    }

    public void showAlert(BrowserWindow window, String message, String description) {
        this.alert_createNew(message, description);
        this.showDialog(window, this.alert_dialog);
    }

    private void alert_createNew(String message, String description) {
        this.alert_dialog = this.createModalDialog("alertdialog.title");
        this.alert_dialog.getContentPane().setLayout(new BorderLayout());
        JLabel _messageLabel = new JLabel(this.res.str(message), 0);
        Font _font = _messageLabel.getFont();
        _messageLabel.setFont(new Font(_font.getName(), 1, _font.getSize()));
        this.alert_dialog.getContentPane().add((Component)_messageLabel, "North");
        this.alert_dialog.getContentPane().add((Component)new JLabel(this.res.str(description), 2), "Center");
        JPanel _buttonPanel = new JPanel(new FlowLayout());
        this.alert_ok = new JButton(this.res.strButtonOk());
        this.alert_ok.addActionListener(this);
        _buttonPanel.add(this.alert_ok);
        this.alert_dialog.getContentPane().add((Component)_buttonPanel, "South");
        this.alert_dialog.pack();
    }

    private boolean alert_actionPerformed(Object source, ActionEvent event) {
        if (source == this.alert_ok) {
            this.alert_hide();
            return true;
        }
        return false;
    }

    private void alert_hide() {
        this.hideDialog(this.alert_dialog);
    }

    public boolean showConfirmation(BrowserWindow window, String title, String question) {
        this.confirmation_createNew(title, question);
        this.showDialog(window, this.confirmation_dialog);
        return this.confirmation_result;
    }

    private boolean confirmation_actionPerformed(Object source, ActionEvent event) {
        if (source == this.confirmation_yes) {
            this.confirmation_result = true;
            this.confirmation_hide();
            return true;
        }
        if (source == this.confirmation_no) {
            this.confirmation_result = false;
            this.confirmation_hide();
            return true;
        }
        return false;
    }

    private void confirmation_createNew(String title, String question) {
        this.confirmation_dialog = this.createModalDialog(title);
        this.confirmation_dialog.getContentPane().setLayout(new BorderLayout());
        this.confirmation_dialog.getContentPane().add((Component)new JLabel(this.res.str(question)), "Center");
        JPanel _buttonPanel = new JPanel(new FlowLayout());
        this.confirmation_yes = new JButton(this.res.str("confirmationdialog.yes"));
        this.confirmation_yes.addActionListener(this);
        _buttonPanel.add(this.confirmation_yes);
        this.confirmation_no = new JButton(this.res.str("confirmationdialog.no"));
        this.confirmation_no.addActionListener(this);
        _buttonPanel.add(this.confirmation_no);
        this.confirmation_dialog.getContentPane().add((Component)_buttonPanel, "South");
        this.confirmation_dialog.pack();
    }

    private void confirmation_hide() {
        this.hideDialog(this.confirmation_dialog);
    }

    public void showCookies(BrowserWindow window) {
        if (this.cookies_dialog == null) {
            this.cookies_createNew();
        }
        this.cookies_valueToUI();
        this.showDialog(window, this.cookies_dialog);
    }

    private void cookies_hide() {
        this.hideDialog(this.cookies_dialog);
    }

    private void cookies_valueToUI() {
        if (this.properties.getBoolean("document.cookies.enable")) {
            this.cookies_enable.setSelected(true);
        } else {
            this.cookies_disable.setSelected(true);
        }
    }

    private boolean cookies_UIToValue() {
        boolean value = this.cookies_enable.isSelected();
        this.properties.setBoolean("document.cookies.enable", value);
        return true;
    }

    private void cookies_createNew() {
        JDialog dlg = this.cookies_dialog = this.createModalDialog("cookiesdialog.title");
        JPanel choicePanel = new JPanel();
        this.cookies_enable = new JRadioButton(this.res.str("cookiesdialog.enable"));
        this.cookies_disable = new JRadioButton(this.res.str("cookiesdialog.disable"));
        this.cookies_enable.addItemListener(this);
        this.cookies_disable.addItemListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.cookies_enable);
        group.add(this.cookies_disable);
        CompoundBorder groupBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 25, 5, 25));
        choicePanel.setBorder(groupBorder);
        choicePanel.setLayout(new GridLayout(0, 1));
        choicePanel.add(this.cookies_enable);
        choicePanel.add(this.cookies_disable);
        JPanel buttonPanel = new JPanel();
        this.cookies_ok = new JButton(this.res.strButtonOk());
        this.cookies_cancel = new JButton(this.res.strButtonCancel());
        this.cookies_ok.addActionListener(this);
        this.cookies_cancel.addActionListener(this);
        buttonPanel.add(this.cookies_ok);
        buttonPanel.add(this.cookies_cancel);
        Container root = dlg.getContentPane();
        root.setLayout(new BorderLayout());
        root.add((Component)choicePanel, "Center");
        root.add((Component)buttonPanel, "South");
        dlg.pack();
    }

    private boolean cookies_actionPerformed(Object source, ActionEvent ev) {
        boolean caught = true;
        if (source == this.cookies_ok) {
            if (this.cookies_UIToValue()) {
                this.cookies_hide();
            }
        } else if (source == this.cookies_cancel) {
            this.cookies_hide();
        } else {
            caught = false;
        }
        return caught;
    }

    private boolean cookies_itemStateChanged(Object source, ItemEvent e) {
        boolean caught = true;
        if (source != this.cookies_enable && source != this.cookies_disable) {
            caught = false;
        }
        return caught;
    }

    private void $init$() {
        this.emulationNames = new String[]{"Internet Explorer v6.0", "Internet Explorer v7.0", "Mozilla Firefox 2.0", "Netscape Navigator v4.x", "Netscape Navigator v6.x +", "None (ICEbrowser native mode)"};
        this.emulationValues = new String[]{"ie6", "ie7", "ff2", "ns", "ns6", "none"};
    }

    public void showEmulation(BrowserWindow window) {
        if (this.emulationDialog == null) {
            this.emulation_createNew();
        }
        this.emulation_valueToUI();
        this.showDialog(window, this.emulationDialog);
    }

    private void emulation_hide() {
        this.hideDialog(this.emulationDialog);
    }

    private void emulation_valueToUI() {
        String mode = Emulation.getEmulationMode();
        if (mode.equalsIgnoreCase(this.emulationValues[0])) {
            this.emulationComboBox.setSelectedIndex(0);
        } else if (mode.equalsIgnoreCase(this.emulationValues[1])) {
            this.emulationComboBox.setSelectedIndex(1);
        } else if (mode.equalsIgnoreCase(this.emulationValues[2])) {
            this.emulationComboBox.setSelectedIndex(2);
        } else if (mode.equalsIgnoreCase(this.emulationValues[3])) {
            this.emulationComboBox.setSelectedIndex(3);
        }
    }

    private boolean emulation_UIToValue() {
        this.properties.set("application.emulation", this.emulationValues[this.emulationComboBox.getSelectedIndex()]);
        Defs.setSystemProperty("ice.browser.emulation", this.emulationValues[this.emulationComboBox.getSelectedIndex()]);
        return true;
    }

    private void emulation_createNew() {
        JDialog dlg = this.emulationDialog = new JDialog(this.res.getBaseFrame(), "Emulation Settings", true);
        this.emulationComboBox = new JComboBox<String>(this.emulationNames);
        this.emulationComboBox.addActionListener(this);
        JLabel emulationLabel = new JLabel("Emulation Modes: ");
        JPanel choicePanel = new JPanel();
        CompoundBorder groupBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 25, 5, 25));
        choicePanel.setBorder(groupBorder);
        choicePanel.setLayout(new BorderLayout());
        choicePanel.add((Component)emulationLabel, "West");
        choicePanel.add((Component)this.emulationComboBox, "Center");
        JPanel buttonPanel = new JPanel();
        this.emulationOkButton = new JButton(this.res.strButtonOk());
        this.emulationCancelButton = new JButton(this.res.strButtonCancel());
        this.emulationOkButton.addActionListener(this);
        this.emulationCancelButton.addActionListener(this);
        buttonPanel.add(this.emulationOkButton);
        buttonPanel.add(this.emulationCancelButton);
        Container root = dlg.getContentPane();
        root.setLayout(new BorderLayout());
        root.add((Component)choicePanel, "Center");
        root.add((Component)buttonPanel, "South");
        dlg.pack();
        this.emulationDialog.setResizable(false);
    }

    private boolean emulation_actionPerformed(Object source, ActionEvent ev) {
        boolean caught = true;
        if (source == this.emulationOkButton) {
            if (this.emulation_UIToValue()) {
                this.emulation_hide();
            }
        } else if (source == this.emulationCancelButton) {
            this.emulation_hide();
        } else {
            caught = false;
        }
        return caught;
    }

    public void showEncoding(BrowserWindow window) {
        if (this.encoding_dialog == null) {
            this.encoding_createNew();
        }
        this.encoding_valueToUI(window);
        this.showDialog(window, this.encoding_dialog);
    }

    private void encoding_hide() {
        this.encoding_window = null;
        this.hideDialog(this.encoding_dialog);
    }

    private void encoding_valueToUI(BrowserWindow window) {
        this.encoding_window = window;
        this.encoding_valueField.setText(window.getEncoding());
        this.encoding_valueField.requestFocus();
    }

    private boolean encoding_UIToValue() {
        String encoding = this.encoding_valueField.getText();
        try {
            "test".getBytes(encoding);
        }
        catch (UnsupportedEncodingException ex) {
            this.res.displayError("encodingdialog.invalidencoding", encoding);
            this.encoding_valueField.requestFocus();
            boolean bl = false;
            return bl;
        }
        if (this.encoding_window != null) {
            this.encoding_window.setEncoding(encoding);
        }
        this.properties.set("document.encoding", encoding);
        return true;
    }

    private void encoding_createNew() {
        JDialog dlg = this.encoding_dialog = this.createModalDialog("encodingdialog.title");
        JPanel mainPanel = new JPanel();
        JLabel labelEncoding = new JLabel(this.res.str("encodingdialog.encoding"));
        labelEncoding.setAlignmentY(0.5f);
        JTextField txt = this.encoding_valueField = new JTextField(" ", 10);
        txt.setHorizontalAlignment(4);
        txt.setAlignmentY(0.5f);
        txt.addActionListener(this);
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        AbstractBorder groupBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 25, 5, 25));
        mainPanel.setBorder(groupBorder);
        mainPanel.add(labelEncoding);
        mainPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        mainPanel.add(txt);
        JPanel buttonPanel = new JPanel();
        groupBorder = new EmptyBorder(5, 35, 5, 35);
        buttonPanel.setBorder(groupBorder);
        this.encoding_ok = new JButton(this.res.strButtonOk());
        this.encoding_cancel = new JButton(this.res.strButtonCancel());
        this.encoding_ok.addActionListener(this);
        this.encoding_cancel.addActionListener(this);
        buttonPanel.add(this.encoding_ok);
        buttonPanel.add(this.encoding_cancel);
        Container root = dlg.getContentPane();
        root.setLayout(new BorderLayout());
        root.add((Component)mainPanel, "Center");
        root.add((Component)buttonPanel, "South");
        dlg.pack();
    }

    private boolean encoding_actionPerformed(Object source, ActionEvent ev) {
        boolean caught = true;
        if (source == this.encoding_ok || source == this.encoding_valueField) {
            if (this.encoding_UIToValue()) {
                this.encoding_hide();
            }
        } else if (source == this.encoding_cancel) {
            this.encoding_hide();
        } else {
            caught = false;
        }
        return caught;
    }

    public void showFonts(BrowserWindow window) {
        if (this.fonts_dialog == null) {
            this.fonts_createNew();
        }
        this.fonts_valueToUI();
        this.showDialog(window, this.fonts_dialog);
    }

    private void fonts_hide() {
        this.fonts_window = null;
        this.fonts_initialProp = null;
        this.fonts_initialFixed = null;
        this.fonts_currentProp = null;
        this.fonts_currentFixed = null;
        this.hideDialog(this.fonts_dialog);
    }

    private void fonts_valueToUI() {
        this.fonts_currentProp = this.fonts_initialProp = this.properties.getFont("document.proportionalfont");
        this.fonts_currentFixed = this.fonts_initialFixed = this.properties.getFont("document.fixedfont");
        String theFontName = this.fonts_initialProp.getFamily();
        int i = 0;
        while (i < this.fonts_names.length) {
            if (this.fonts_names[i].equals(theFontName)) {
                this.fonts_fontProp.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        this.fonts_sizeProp.setText("" + this.fonts_initialProp.getSize());
        theFontName = this.fonts_initialFixed.getFamily();
        int i2 = 0;
        while (i2 < this.fonts_names.length) {
            if (this.fonts_names[i2].equals(theFontName)) {
                this.fonts_fontFixed.setSelectedIndex(i2);
                break;
            }
            ++i2;
        }
        this.fonts_sizeFixed.setText("" + this.fonts_initialFixed.getSize());
    }

    private boolean fonts_UIToValue() {
        Font fProp = this.fonts_extractFont(this.fonts_fontProp, this.fonts_sizeProp);
        Font fFixed = this.fonts_extractFont(this.fonts_fontFixed, this.fonts_sizeFixed);
        if (fProp == null || fFixed == null) {
            return false;
        }
        this.fonts_apply(fProp, fFixed);
        return true;
    }

    private void fonts_apply(Font fProp, Font fFixed) {
        boolean changed = false;
        if (!fProp.equals(this.fonts_currentProp)) {
            changed = true;
            this.properties.setFont("document.proportionalfont", fProp);
            this.fonts_currentProp = fProp;
        }
        if (!fFixed.equals(this.fonts_initialFixed)) {
            changed = true;
            this.properties.setFont("document.fixedfont", fFixed);
            this.fonts_currentFixed = fFixed;
        }
        if (changed) {
            this.windowManager.updateUserFonts();
        }
    }

    private Font fonts_extractFont(JComboBox familyField, JTextField sizeFiled) {
        try {
            int size = Integer.parseInt(sizeFiled.getText());
            if (1 <= size) {
                String family = this.fonts_names[familyField.getSelectedIndex()];
                Font font = new Font(family, 0, size);
                return font;
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        sizeFiled.requestFocus();
        return null;
    }

    private void fonts_createNew() {
        JDialog dlg = this.fonts_dialog = this.createModalDialog("fontdialog.title");
        JPanel proportionalPanel = new JPanel();
        JLabel labelProp = new JLabel(this.res.str("fontdialog.proportional"));
        labelProp.setAlignmentY(0.5f);
        this.fonts_names = dlg.getToolkit().getFontList();
        this.fonts_fontProp = new JComboBox<String>(this.fonts_names);
        JLabel labelSize = new JLabel(this.res.str("fontdialog.size"));
        labelSize.setAlignmentY(0.5f);
        JTextField txt = this.fonts_sizeProp = new JTextField("9999");
        txt.setHorizontalAlignment(4);
        txt.setAlignmentY(0.5f);
        txt.setMaximumSize(new Dimension(txt.getMaximumSize().width, txt.getPreferredSize().height));
        txt.setMinimumSize(new Dimension(txt.getPreferredSize().width, txt.getMinimumSize().height));
        proportionalPanel.setLayout(new BoxLayout(proportionalPanel, 0));
        proportionalPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
        proportionalPanel.add(labelProp);
        proportionalPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        proportionalPanel.add(this.fonts_fontProp);
        proportionalPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        proportionalPanel.add(labelSize);
        proportionalPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        proportionalPanel.add(txt);
        JPanel fixedPanel = new JPanel();
        JLabel labelFixed = new JLabel(this.res.str("fontdialog.fixed"));
        labelFixed.setAlignmentY(0.5f);
        labelSize = new JLabel(this.res.str("fontdialog.size"));
        this.fonts_fontFixed = new JComboBox<String>(this.fonts_names);
        txt = this.fonts_sizeFixed = new JTextField("9999");
        txt.setHorizontalAlignment(4);
        txt.setAlignmentY(0.5f);
        txt.setMaximumSize(new Dimension(txt.getMaximumSize().width, txt.getPreferredSize().height));
        txt.setMinimumSize(new Dimension(txt.getPreferredSize().width, txt.getMinimumSize().height));
        fixedPanel.setLayout(new BoxLayout(fixedPanel, 0));
        fixedPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
        fixedPanel.add(labelFixed);
        fixedPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        fixedPanel.add(this.fonts_fontFixed);
        fixedPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        fixedPanel.add(labelSize);
        fixedPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        fixedPanel.add(txt);
        JPanel mainPanel = new JPanel();
        CompoundBorder groupBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 25, 5, 25));
        mainPanel.setBorder(groupBorder);
        mainPanel.setLayout(new GridLayout(0, 1));
        mainPanel.add(proportionalPanel);
        mainPanel.add(fixedPanel);
        JPanel buttonPanel = new JPanel();
        this.fonts_apply = new JButton(this.res.strButtonApply());
        this.fonts_ok = new JButton(this.res.strButtonOk());
        this.fonts_cancel = new JButton(this.res.strButtonCancel());
        this.fonts_apply.addActionListener(this);
        this.fonts_ok.addActionListener(this);
        this.fonts_cancel.addActionListener(this);
        buttonPanel.add(this.fonts_apply);
        buttonPanel.add(this.fonts_ok);
        buttonPanel.add(this.fonts_cancel);
        Container root = dlg.getContentPane();
        root.setLayout(new BorderLayout());
        root.add((Component)mainPanel, "Center");
        root.add((Component)buttonPanel, "South");
        dlg.pack();
        this.fonts_sizeProp.setText("");
        this.fonts_sizeFixed.setText("");
    }

    private boolean fonts_actionPerformed(Object source, ActionEvent ev) {
        boolean caught = true;
        if (source == this.fonts_apply) {
            this.fonts_UIToValue();
        } else if (source == this.fonts_ok) {
            if (this.fonts_UIToValue()) {
                this.fonts_hide();
            }
        } else if (source == this.fonts_cancel) {
            this.fonts_apply(this.fonts_initialProp, this.fonts_initialFixed);
            this.fonts_hide();
        } else {
            caught = false;
        }
        return caught;
    }

    public void showLookAndFeel(BrowserWindow window) {
        if (this.lookfeel_dialog == null) {
            this.lookfeel_createNew();
            if (this.lookfeel_dialog == null) {
                return;
            }
        }
        this.lookfeel_valueToUI();
        this.showDialog(window, this.lookfeel_dialog);
    }

    private void lookfeel_hide() {
        this.lookfeel_initial = 0;
        this.lookfeel_current = 0;
        this.hideDialog(this.lookfeel_dialog);
    }

    private void lookfeel_valueToUI() {
        this.lookfeel_current = this.lookfeel_initial = this.lookfeel_getCurrent();
        this.lookfeel_setupListSelection();
    }

    private int lookfeel_getCurrent() {
        LookAndFeel lf = UIManager.getLookAndFeel();
        String className = lf != null ? lf.getClass().getName() : UIManager.getCrossPlatformLookAndFeelClassName();
        int i = this.lookfeel_looks.length;
        while (i-- != 0) {
            if (!this.lookfeel_looks[i].getClassName().equals(className)) continue;
            return i;
        }
        return 0;
    }

    private void lookfeel_setupListSelection() {
        String[] userNames = new String[this.lookfeel_looks.length];
        int i = this.lookfeel_looks.length;
        while (i-- != 0) {
            userNames[i] = this.lookfeel_looks[i].getName();
        }
        this.lookfeel_list.setListData(userNames);
        this.lookfeel_list.setSelectedIndex(this.lookfeel_current);
    }

    private boolean lookfeel_UIToValue() {
        int selected = this.lookfeel_list.getSelectedIndex();
        if (0 <= selected && selected < this.lookfeel_looks.length) {
            return this.lookfeel_apply(selected);
        }
        return false;
    }

    private boolean lookfeel_apply(int lfIndex) {
        if (lfIndex == this.lookfeel_current) {
            return true;
        }
        String className = this.lookfeel_looks[lfIndex].getClassName();
        String userName = this.lookfeel_looks[lfIndex].getName();
        try {
            UIManager.setLookAndFeel(className);
        }
        catch (Exception exc) {
            int N = this.lookfeel_looks.length;
            UIManager.LookAndFeelInfo[] tmp = new UIManager.LookAndFeelInfo[N - 1];
            System.arraycopy(this.lookfeel_looks, 0, tmp, 0, lfIndex);
            System.arraycopy(this.lookfeel_looks, lfIndex + 1, tmp, lfIndex, N - 1 - lfIndex);
            this.lookfeel_looks = tmp;
            if (this.lookfeel_current >= lfIndex) {
                --this.lookfeel_current;
            }
            if (this.lookfeel_initial >= lfIndex) {
                --this.lookfeel_initial;
            }
            this.lookfeel_setupListSelection();
            this.res.displayError("lookandfeeldialog.unsupported_error", userName);
            boolean bl = false;
            return bl;
        }
        this.windowManager.updateUI();
        this.properties.set("application.lookandfeel", userName);
        this.lookfeel_current = lfIndex;
        return true;
    }

    private void lookfeel_createNew() {
        this.lookfeel_initial = 0;
        this.lookfeel_current = 0;
        this.lookfeel_looks = UIManager.getInstalledLookAndFeels();
        if (this.lookfeel_looks == null || this.lookfeel_looks.length == 0) {
            return;
        }
        JDialog dlg = this.lookfeel_dialog = this.createModalDialog("lookandfeeldialog.title");
        JPanel choicePanel = new JPanel();
        this.lookfeel_list = new JList();
        this.lookfeel_setupListSelection();
        JScrollPane scrollList = new JScrollPane(this.lookfeel_list);
        choicePanel.setLayout(new BorderLayout());
        choicePanel.add((Component)scrollList, "Center");
        JPanel buttonPanel = new JPanel();
        this.lookfeel_apply = new JButton(this.res.strButtonApply());
        this.lookfeel_apply.addActionListener(this);
        this.lookfeel_ok = new JButton(this.res.strButtonOk());
        this.lookfeel_ok.addActionListener(this);
        this.lookfeel_cancel = new JButton(this.res.strButtonCancel());
        this.lookfeel_cancel.addActionListener(this);
        buttonPanel.add(this.lookfeel_apply);
        buttonPanel.add(this.lookfeel_ok);
        buttonPanel.add(this.lookfeel_cancel);
        Container root = dlg.getContentPane();
        root.setLayout(new BoxLayout(root, 1));
        root.add(Box.createVerticalStrut(6));
        root.add(choicePanel);
        root.add(Box.createVerticalStrut(6));
        root.add(new JSeparator());
        root.add(Box.createVerticalStrut(6));
        root.add(buttonPanel);
        root.add(Box.createVerticalStrut(6));
        dlg.pack();
    }

    private boolean lookfeel_actionPerformed(Object source, ActionEvent ev) {
        boolean caught = true;
        if (source == this.lookfeel_apply) {
            this.lookfeel_UIToValue();
        } else if (source == this.lookfeel_ok) {
            if (this.lookfeel_UIToValue()) {
                this.lookfeel_hide();
            }
        } else if (source == this.lookfeel_cancel) {
            this.lookfeel_apply(this.lookfeel_initial);
            this.lookfeel_hide();
        } else {
            caught = false;
        }
        return caught;
    }

    public void showOpenFile(BrowserWindow window) {
        File chosenFile;
        if (this.openFile_dialog == null) {
            this.openFile_createNew();
        }
        this.openFile_valueToUI();
        int answer = this.openFile_dialog.showDialog(window, null);
        if (answer == 0 && (chosenFile = this.openFile_dialog.getSelectedFile()) != null && chosenFile.exists()) {
            window.gotoLocation(Net.fileToUrlString(chosenFile));
        }
    }

    private void openFile_valueToUI() {
        this.openFile_dialog.rescanCurrentDirectory();
    }

    private void openFile_createNew() {
        JFileChooser dlg = this.openFile_dialog = new JFileChooser();
        dlg.setDialogType(0);
        dlg.setFileSelectionMode(0);
        dlg.setDialogTitle(this.res.str("openfiledialog.title"));
        String[] htmlTypes = new String[]{".HTM", ".HTML"};
        dlg.addChoosableFileFilter(new SetFileFilter("HTML", this.res, htmlTypes));
        dlg.addChoosableFileFilter(new MinimumFileFilter("Text", this.res, ".TXT"));
        String[] imageTypes = new String[]{".GIF", ".JPG", ".JPEG", ".PNG"};
        dlg.addChoosableFileFilter(new SetFileFilter("Image", this.res, imageTypes));
        dlg.addChoosableFileFilter(new MinimumFileFilter("PDF", this.res, ".PDF"));
        dlg.addChoosableFileFilter(new MinimumFileFilter("XML", this.res, ".XML"));
        dlg.setAcceptAllFileFilterUsed(true);
        dlg.setCurrentDirectory(this.properties.userHome);
    }

    private void save_createNew() {
        JFileChooser dlg = this.save_file_dialog = new JFileChooser();
        dlg.setFileSelectionMode(0);
        dlg.setDialogType(1);
        dlg.setCurrentDirectory(this.properties.userHome);
        this.save_directory = this.properties.userHome.getAbsolutePath();
        dlg.setDialogTitle(this.res.str("savefiledialog.title"));
    }

    public void showSaveURL(BrowserWindow window, String str) {
        StatusBar sb;
        URL u = Net.checkURL(str, this.res);
        if (u != null && this.showSaveURL(window, u) && (sb = window.statusBar) != null) {
            sb.setStatusText(this.res.str("status.saved"));
        }
    }

    private boolean showSaveURL(BrowserWindow window, URL location) {
        if (this.save_file_dialog == null) {
            this.save_createNew();
        }
        this.saveURL_valueToUI(location);
        File toSave = null;
        int value = this.save_file_dialog.showDialog(window, null);
        if (value == 0 && (toSave = this.save_file_dialog.getSelectedFile()) != null) {
            boolean saveIt;
            this.save_directory = toSave.getParent();
            if (toSave.exists() && !(saveIt = this.res.displayYesOrNo("save.exists", toSave.getAbsolutePath()))) {
                toSave = null;
            }
        }
        if (toSave != null) {
            new ProgressBarWindow(this.windowManager, location, toSave);
        }
        return toSave != null;
    }

    private void saveURL_valueToUI(URL location) {
        JFileChooser dlg = this.save_file_dialog;
        dlg.resetChoosableFileFilters();
        String extension = Net.getExtension(location);
        if (extension != null && !extension.equals("")) {
            MinimumFileFilter ff = new MinimumFileFilter(extension.toUpperCase(), this.res, extension);
            dlg.addChoosableFileFilter(ff);
            dlg.setFileFilter(ff);
        }
        dlg.setSelectedFile(new File(Net.getFile(location)));
    }

    public void showSaveAs(BrowserWindow window) {
        if (this.save_file_dialog == null) {
            this.save_createNew();
        }
        SaveAs saveAs = new SaveAs(window.mainview);
        File defaultFile = new File(this.save_directory + File.separator + saveAs.getDefaultFilename());
        this.saveAs_valueToUI(defaultFile);
        File toSave = null;
        int value = this.save_file_dialog.showSaveDialog(window);
        if (value == 0 && (toSave = this.save_file_dialog.getSelectedFile()) != null) {
            boolean saveIt;
            this.save_directory = toSave.getParent();
            if (toSave.exists() && !(saveIt = this.res.displayYesOrNo("save.exists", this.save_directory))) {
                toSave = null;
            }
        }
        if (toSave != null) {
            saveAs.setFile(toSave);
            SaveAsDialog saveAsDialog = new SaveAsDialog(window, saveAs, this.res);
            saveAs.setActionListener(saveAsDialog);
            saveAs.worker_start();
            saveAsDialog.show();
        }
        if (toSave != null) {
            boolean saveStatus = (Boolean)saveAs.get();
            StatusBar sb = window.statusBar;
            if (sb != null && saveStatus) {
                sb.setStatusText(this.res.str("status.saved"));
            }
        }
    }

    private void saveAs_valueToUI(File default_file) {
        JFileChooser dlg = this.save_file_dialog;
        dlg.resetChoosableFileFilters();
        MinimumFileFilter ff = new MinimumFileFilter("HTML", this.res, ".HTML");
        dlg.addChoosableFileFilter(ff);
        dlg.setFileFilter(ff);
        dlg.setSelectedFile(default_file);
    }
}

