/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.dialog.swing;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class DecimalJTextField
extends JTextField {
    public DecimalJTextField(double value, int maxLength, int columns) {
        super(columns);
        this.setInputVerifier(new 1(this, maxLength));
        this.addKeyListener(new 2());
        this.setText(value + "");
    }

    public double getValue() {
        return Double.parseDouble(this.getText());
    }

    public void setValue(double value) {
        this.setText(value + "");
    }

    final class 1
    extends InputVerifier {
        private final /* synthetic */ int v$maxLength;
        final /* synthetic */ DecimalJTextField this$0;

        public boolean verify(JComponent comp) {
            boolean returnValue = true;
            JTextField textField = (JTextField)comp;
            String content = textField.getText();
            if (content.length() != 0 && textField.getText().length() < this.v$maxLength) {
                try {
                    Double.parseDouble(textField.getText());
                }
                catch (NumberFormatException e) {
                    returnValue = false;
                }
            } else if (textField.getText().length() > 0) {
                textField.setText(textField.getText().substring(0, this.v$maxLength));
            } else {
                textField.setText("0");
            }
            return returnValue;
        }

        public boolean shouldYieldFocus(JComponent input) {
            boolean valid = super.shouldYieldFocus(input);
            if (!valid) {
                this.this$0.getToolkit().beep();
            }
            return valid;
        }

        public 1(DecimalJTextField decimalJTextField, int n) {
            this.v$maxLength = n;
            this.this$0 = decimalJTextField;
        }
    }

    final class 2
    extends KeyAdapter {
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            if (!Character.isDigit(c) && c != '\b' && c != '\u007f' && c != '.') {
                DecimalJTextField.this.getToolkit().beep();
                e.consume();
            }
        }
    }
}

