/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.dialog.swing;

import ice.ri.common.dialog.SettingsDialogInterface;
import ice.ri.common.dialog.SettingsDialogPanelGroup;
import ice.ri.common.dialog.swing.AbstractJSettingsDialogPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public abstract class AbstractJSettingsDialog
extends JDialog
implements SettingsDialogInterface,
ActionListener {
    public static final int OK_CANCEL_APPLY = 1;
    public static final int OK_CANCEL = 2;
    private static ResourceBundle messages = null;
    protected Vector panelGroups;
    protected Vector panels;
    private boolean hasChanged;
    protected int displayType;
    protected JButton okButton;
    protected JButton applyButton;
    protected JButton cancelButton;

    private void $init$() {
        this.displayType = 1;
    }

    public AbstractJSettingsDialog(JFrame parent, String title, int width, int height) {
        super(parent, title, true);
        this.$init$();
        this.setBounds(parent.getX() + (parent.getWidth() - width) / 2, parent.getY() + (parent.getHeight() - height) / 2, width, height);
        messages = parent != null ? ResourceBundle.getBundle("ice.ri.common.dialog.resources.MessageBundleDialog", parent.getLocale()) : ResourceBundle.getBundle("ice.ri.common.dialog.resources.MessageBundleDialog");
        this.setupGUI();
    }

    public AbstractJSettingsDialog(JDialog parent, String title, int width, int height) {
        super(parent, title, true);
        this.$init$();
        this.setBounds(parent.getX() + (parent.getWidth() - width) / 2, parent.getY() + (parent.getHeight() - height) / 2, width, height);
        this.setupGUI();
    }

    private void setupGUI() {
        this.panelGroups = new Vector();
        this.panels = new Vector();
        this.hasChanged = false;
        this.okButton = new JButton(messages.getString("dialog.ok"));
        this.okButton.addActionListener(this);
        this.okButton.setMnemonic('O');
        this.applyButton = new JButton(messages.getString("dialog.apply"));
        this.applyButton.setMnemonic('A');
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
        this.cancelButton = new JButton(messages.getString("dialog.cancel"));
        this.cancelButton.setMnemonic('C');
        this.cancelButton.addActionListener(this);
    }

    public void showDialog() {
        this.setGui();
        this.setVisible(true);
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.setGui();
        }
        super.setVisible(isVisible);
    }

    public void setButtonDisplay(int displayType) {
        this.displayType = displayType == 2 ? 2 : 1;
    }

    public int getButtonDisplay() {
        return this.displayType;
    }

    public abstract void setGui();

    public void setHasChanged(boolean value) {
        this.hasChanged = value;
        this.applyButton.setEnabled(value);
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void add(SettingsDialogPanelGroup group) {
        this.panelGroups.add(group);
    }

    public void add(AbstractJSettingsDialogPanel panel) {
        this.panels.add(panel);
    }

    public boolean save() {
        boolean isChanges = true;
        Enumeration panel = this.panels.elements();
        while (panel.hasMoreElements()) {
            AbstractJSettingsDialogPanel tmp = (AbstractJSettingsDialogPanel)panel.nextElement();
            if (!tmp.hasChanged()) continue;
            tmp.save();
        }
        Enumeration groups = this.panelGroups.elements();
        while (groups.hasMoreElements()) {
            SettingsDialogPanelGroup tmp = (SettingsDialogPanelGroup)groups.nextElement();
            Vector groupPanels = tmp.getPanels();
            Enumeration panels = groupPanels.elements();
            while (panels.hasMoreElements()) {
                AbstractJSettingsDialogPanel tmp2 = (AbstractJSettingsDialogPanel)panels.nextElement();
                if (!tmp2.hasChanged()) continue;
                tmp2.save();
            }
        }
        return isChanges;
    }

    public boolean cancel() {
        boolean isChanges = true;
        Enumeration panel = this.panels.elements();
        while (panel.hasMoreElements()) {
            AbstractJSettingsDialogPanel tmp = (AbstractJSettingsDialogPanel)panel.nextElement();
            if (!this.hasChanged) continue;
            tmp.cancel();
        }
        Enumeration groups = this.panelGroups.elements();
        while (groups.hasMoreElements()) {
            SettingsDialogPanelGroup tmp = (SettingsDialogPanelGroup)groups.nextElement();
            Vector groupPanels = tmp.getPanels();
            Enumeration panels = groupPanels.elements();
            while (panels.hasMoreElements()) {
                AbstractJSettingsDialogPanel tmp2 = (AbstractJSettingsDialogPanel)panels.nextElement();
                if (!this.hasChanged) continue;
                tmp2.cancel();
            }
        }
        return isChanges;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.okButton)) {
            if (this.hasChanged) {
                this.save();
            }
            this.setVisible(false);
            this.dispose();
        }
        if (source.equals(this.applyButton) && this.hasChanged) {
            this.save();
            this.applyButton.setEnabled(false);
        }
        if (source.equals(this.cancelButton)) {
            if (this.hasChanged) {
                this.cancel();
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    protected JRootPane createRootPane() {
        1 actionListener = new 1();
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractJSettingsDialog.this.setVisible(false);
            AbstractJSettingsDialog.this.dispose();
        }
    }
}

