/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.svg.batik;

import ice.debug.Debug;
import ice.storm.ContentLoader;
import ice.storm.Pilot;
import java.awt.Component;
import java.awt.Cursor;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;

public class ThePilot
extends Pilot {
    private static final Cursor WAIT_CURSOR = new Cursor(3);
    private static final Cursor NORMAL_CURSOR = new Cursor(0);
    protected JSVGCanvas svgCanvas;
    protected String currLocation;

    static {
        ThePilot.testForBatik();
    }

    private static final void testForBatik() throws RuntimeException {
        String className = "org.apache.batik.swing.JSVGCanvas";
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            String msg = "Required class '" + className + "' not found. Required Batik SVG library jars may not be on the classpath - SVG Pilot disabled.";
            Debug.trace(msg);
            throw new RuntimeException(msg);
        }
    }

    public void init(String toolkitName) {
        super.init(toolkitName);
        this.svgCanvas = new JSVGCanvas();
        this.svgCanvas.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)new 1());
        this.svgCanvas.addGVTTreeRendererListener((GVTTreeRendererListener)new 2());
    }

    public Component createComponent() {
        return this.svgCanvas;
    }

    public void clear(String contentType) {
    }

    public void parse(ContentLoader cl) throws IOException {
        try {
            this.firePropertyChange("location", null, cl.getLocation());
            this.firePropertyChange("title", null, "Displaying " + cl.getLocation());
            this.currLocation = cl.getURL().toString();
            this.svgCanvas.setURI(this.currLocation);
        }
        catch (Exception ex) {
            String errMsg = "Batik SVG Pilot: Failed to load " + cl.getLocation();
            this.firePropertyChange("contentLoading", errMsg, "error");
            if (Debug.ex) {
                Debug.ex(ex);
            }
            throw new IOException(errMsg);
        }
    }

    public void dispose() {
        this.svgCanvas = null;
        super.dispose();
    }

    private void setCursor(Cursor theCursor) {
        Cursor cursor = theCursor;
        if (SwingUtilities.isEventDispatchThread()) {
            this.svgCanvas.setCursor(cursor);
        } else {
            3 doWorkRunnable = new 3(this, cursor);
            SwingUtilities.invokeLater(doWorkRunnable);
        }
    }

    static Cursor ra$NORMAL_CURSOR() {
        return NORMAL_CURSOR;
    }

    static void mav$setCursor(ThePilot thePilot, Cursor cursor) {
        thePilot.setCursor(cursor);
    }

    static Cursor ra$WAIT_CURSOR() {
        return WAIT_CURSOR;
    }

    final class 1
    extends SVGDocumentLoaderAdapter {
        public void documentLoadingStarted(SVGDocumentLoaderEvent event) {
            ThePilot.this.firePropertyChange("statusLine", null, "Opening diagram " + ThePilot.this.currLocation + "...");
            ThePilot.mav$setCursor(ThePilot.this, ThePilot.ra$WAIT_CURSOR());
        }

        public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
            ThePilot.this.firePropertyChange("contentLoading", null, "end");
            String title = e.getSVGDocument().getTitle();
            if (title != null && !title.equals("")) {
                ThePilot.this.firePropertyChange("title", null, e.getSVGDocument().getTitle());
            }
        }

        public void documentLoadingCancelled(SVGDocumentLoaderEvent event) {
            ThePilot.mav$setCursor(ThePilot.this, ThePilot.ra$NORMAL_CURSOR());
        }

        public void documentLoadingFailed(SVGDocumentLoaderEvent e) {
            ThePilot.mav$setCursor(ThePilot.this, ThePilot.ra$NORMAL_CURSOR());
            String errMsg = "Batik SVG Pilot failed to load " + ThePilot.this.currLocation;
            ThePilot.this.firePropertyChange("contentLoading", errMsg, "error");
        }
    }

    final class 2
    extends GVTTreeRendererAdapter {
        public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
            ThePilot.mav$setCursor(ThePilot.this, ThePilot.ra$WAIT_CURSOR());
            ThePilot.this.firePropertyChange("statusLine", null, "Rendering...");
        }

        public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
            ThePilot.mav$setCursor(ThePilot.this, ThePilot.ra$NORMAL_CURSOR());
            ThePilot.this.firePropertyChange("statusLine", null, "Done");
        }

        public void gvtRenderingCancelled(GVTTreeRendererEvent event) {
            ThePilot.mav$setCursor(ThePilot.this, ThePilot.ra$NORMAL_CURSOR());
            ThePilot.this.firePropertyChange("statusLine", null, "Cancelled");
        }

        public void gvtRenderingFailed(GVTTreeRendererEvent event) {
            ThePilot.mav$setCursor(ThePilot.this, ThePilot.ra$NORMAL_CURSOR());
            ThePilot.this.firePropertyChange("statusLine", null, "Error");
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ Cursor v$cursor;
        final /* synthetic */ ThePilot this$0;

        public void run() {
            this.this$0.svgCanvas.setCursor(this.v$cursor);
        }

        public 3(ThePilot thePilot, Cursor cursor) {
            this.v$cursor = cursor;
            this.this$0 = thePilot;
        }
    }
}

