/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.image;

import ice.debug.Debug;
import ice.pilots.image.ThePilot;
import ice.storm.print.AbstractStormPrinter;
import ice.storm.print.PageDecoration;
import ice.storm.print.StormPageFormat;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.util.Vector;

class ThePrinter
extends AbstractStormPrinter {
    private Vector pageLayoutCache;
    private ImageComponent imageComponent;

    private void $init$() {
        this.pageLayoutCache = new Vector();
    }

    ThePrinter(ThePilot pilot) {
        this.$init$();
        this.pageFormat = new StormPageFormat();
        this.imageComponent = new ImageComponent(pilot.getImage());
        this.getPageCount();
    }

    public void printPage(Graphics g, int pageIndex) {
        if (pageIndex < 0) {
            pageIndex = 0;
        } else if (pageIndex > this.numberOfPages - 1) {
            pageIndex = this.numberOfPages - 1;
        }
        Point[] tempPage = (Point[])this.pageLayoutCache.elementAt(pageIndex);
        Graphics gg = g.create((int)this.pageFormat.getMargin(2), (int)this.pageFormat.getMargin(1), (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
        gg.setClip(0, 0, (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
        MediaTracker tracker = new MediaTracker(this.imageComponent);
        tracker.addImage(this.imageComponent.getScaledImage(), 1);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException e) {
            Debug.p(" " + e);
        }
        if (!tracker.isErrorAny()) {
            gg.drawImage(this.imageComponent.getScaledImage(), -tempPage[0].x, -tempPage[0].y, this.imageComponent);
        } else {
            Debug.trace("Loading Image error");
        }
        this.imageComponent.paint(gg);
        gg.dispose();
        Graphics gd = g.create(0, 0, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
        gd.translate(0, 0);
        gd.setClip(0, 0, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
        Vector pageDecorations = this.pageFormat.getDecoration();
        int i = pageDecorations.size() - 1;
        while (i >= 0) {
            PageDecoration tmp = (PageDecoration)pageDecorations.elementAt(i);
            tmp.paint(gd, pageIndex, this.numberOfPages, this.pageFormat);
            --i;
        }
        gd.dispose();
    }

    /*
     * Unable to fully structure code
     */
    public int getPageCount() {
        block4: {
            if (this.pageFormat == null) {
                throw new NullPointerException();
            }
            if (!this.pageFormat.hasImageableAreaChanged()) break block4;
            if (this.pageFormat.isScaleToFitEnabled()) {
                scale = 1.0 / (double)this.imageComponent.getWidth() * this.pageFormat.getImageableWidth();
                this.pageFormat.setScale(scale);
            }
            ImageComponent.mav$scaleImage(this.imageComponent, this.pageFormat.getScale());
            this.pageLayoutCache = new Vector<E>();
            this.currentPageIndex = 0;
            totalImageableWidth = 0;
            totalImageableHeight = 0;
            previousPage = new Point[]{new Point(0, 0), new Point(0, (int)this.pageFormat.getImageableHeight())};
            ** GOTO lbl25
            {
                totalImageableWidth = (int)((double)totalImageableWidth + this.pageFormat.getImageableWidth());
                tmpPage = new Point[]{new Point(previousPage[0].x, previousPage[0].y), new Point(totalImageableWidth, previousPage[0].y), new Point(previousPage[1].x, previousPage[1].y), new Point(totalImageableWidth, previousPage[0].y)};
                this.pageLayoutCache.addElement(tmpPage);
                previousPage[0] = new Point(tmpPage[1].x, tmpPage[1].y);
                previousPage[1] = new Point(tmpPage[3].x, tmpPage[3].y);
                do {
                    if (totalImageableWidth < this.imageComponent.getScaledWidth()) continue block0;
                    totalImageableWidth = 0;
                    totalImageableHeight = (int)((double)totalImageableHeight + this.pageFormat.getImageableHeight());
                    previousPage[0] = new Point(0, totalImageableHeight);
                    previousPage[1] = new Point(0, totalImageableHeight + (int)this.pageFormat.getImageableHeight());
lbl25:
                    // 2 sources

                } while (totalImageableHeight < this.imageComponent.getScaledHeight());
            }
            this.currentPageIndex = -1;
            this.pageFormat.setImageableAreaChangedFlag(false);
            this.numberOfPages = this.pageLayoutCache.size();
        }
        return this.numberOfPages;
    }

    public void print(Graphics g) {
        g.drawImage(this.imageComponent.getScaledImage(), 0, 0, null, null);
    }

    public Dimension getDimension() {
        return new Dimension(this.imageComponent.getScaledWidth(), this.imageComponent.getScaledHeight());
    }

    public void setZoom(int zoom) {
        double pageFormatZoom = (double)Math.abs(zoom) / 256.0;
        this.pageFormat.setScale(pageFormatZoom);
        this.getPageCount();
    }

    public int getZoom() {
        if (this.pageFormat.isScaleToFitEnabled()) {
            double scale = 1.0 / (double)this.imageComponent.getWidth() * this.pageFormat.getImageableWidth();
            this.pageFormat.setScale(scale);
        }
        return (int)Math.round(this.pageFormat.getScale() * 256.0);
    }

    public void dispose() {
    }

    class ImageComponent
    extends Component {
        private Image image;
        private Image scaledImage;
        private int scaledWidth;
        private int scaledHeight;

        ImageComponent(Image image) {
            this.image = image;
            this.scaledImage = image.getScaledInstance(-1, -1, 8);
            this.scaledWidth = image.getWidth(this);
            this.scaledHeight = image.getHeight(this);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        }

        public Image getScaledImage() {
            return this.scaledImage;
        }

        public Image getImage() {
            return this.image;
        }

        public int getScaledWidth() {
            return this.scaledWidth;
        }

        public int getWidth() {
            return this.image.getWidth(this);
        }

        public int getHeight() {
            return this.image.getHeight(this);
        }

        public int getScaledHeight() {
            return this.scaledHeight;
        }

        private void scaleImage(double zoom) {
            this.scaledWidth = (int)((double)this.image.getWidth(this) * zoom);
            this.scaledHeight = (int)((double)this.image.getHeight(this) * zoom);
            this.scaledImage = this.image.getScaledInstance(this.scaledWidth, this.scaledHeight, 4);
        }

        static void mav$scaleImage(ImageComponent imageComponent, double d) {
            imageComponent.scaleImage(d);
        }
    }
}

