/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing.dnd.jdk14;

import ice.pilots.html4.swing.dnd.StringTransferable;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class TextComponentTransferHandler
extends TransferHandler {
    private static boolean doInstall = true;
    private DataFlavor[] acceptableFlavors;

    private void $init$() {
        this.acceptableFlavors = new DataFlavor[]{DataFlavor.plainTextFlavor, DataFlavor.stringFlavor};
    }

    public TextComponentTransferHandler() {
        super("text");
        this.$init$();
    }

    public static void installCustomHandler(JTextComponent jfield) {
        if (doInstall) {
            try {
                jfield.setDragEnabled(true);
                jfield.setTransferHandler(new TextComponentTransferHandler());
            }
            catch (Exception e) {
                doInstall = false;
            }
        }
    }

    public Transferable createTransferable(JComponent j) {
        String s = null;
        if (j instanceof JTextComponent) {
            JTextComponent jf = (JTextComponent)j;
            s = jf.getSelectedText();
        }
        if (s != null) {
            return new StringTransferable(s);
        }
        return null;
    }

    public boolean importData(JComponent jfield, Transferable t) {
        JTextComponent jtext = null;
        if (!(jfield instanceof JTextComponent)) {
            return false;
        }
        jtext = (JTextComponent)jfield;
        DataFlavor[] flavors = this.acceptableFlavors;
        DataFlavor chosenFlavor = null;
        int i = 0;
        while (i < flavors.length) {
            if (t.isDataFlavorSupported(flavors[i])) {
                chosenFlavor = flavors[i];
                break;
            }
            ++i;
        }
        if (chosenFlavor == null) {
            return false;
        }
        try {
            jtext.replaceSelection((String)t.getTransferData(DataFlavor.stringFlavor));
        }
        catch (UnsupportedFlavorException e) {
            UIManager.getLookAndFeel().provideErrorFeedback(jtext);
        }
        catch (IOException e) {
            UIManager.getLookAndFeel().provideErrorFeedback(jtext);
        }
        return true;
    }

    public void exportToClipboard(JComponent comp, Clipboard clipboard, int action) {
        int p1;
        JTextComponent text;
        int p0;
        if (comp instanceof JTextComponent && (p0 = (text = (JTextComponent)comp).getSelectionStart()) != (p1 = text.getSelectionEnd())) {
            try {
                Document doc = text.getDocument();
                String srcData = doc.getText(p0, p1 - p0);
                StringSelection contents = new StringSelection(srcData);
                clipboard.setContents(contents, null);
                if (action == 2) {
                    doc.remove(p0, p1 - p0);
                }
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
        }
    }

    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        return true;
    }
}

