/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DTextAreaElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import ice.pilots.html4.swing.MyTextArea;
import ice.util.JavaVersion;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

class FormTextArea
extends JScrollPane
implements ObjectPainter,
DocumentListener,
CaretListener,
Movable {
    private DocView docView;
    private DTextAreaElement text;
    private ObjectBox box;
    private JTextArea textArea;

    FormTextArea(DocView docView, DElement e) {
        this.docView = docView;
        this.text = (DTextAreaElement)e;
        int rows = e.getAttributeAsInt("rows");
        int cols = e.getAttributeAsInt("cols");
        if (rows < 0) {
            rows = 3;
        }
        if (cols < 0) {
            cols = 20;
        }
        this.textArea = new MyTextArea(rows, cols, docView, this.text);
        this.setViewportView(this.textArea);
        this.checkAttributes(this.text);
        this.textArea.getDocument().addDocumentListener(this);
        this.textArea.addCaretListener(this);
        this.textArea.setCaretPosition(0);
        if (JavaVersion.isV14orGreater()) {
            try {
                Class<?> c = Class.forName("ice.pilots.html4.swing.dnd.jdk14.TextComponentTransferHandler");
                Method m = c.getMethod("installCustomHandler", JTextComponent.class);
                if (m != null) {
                    m.invoke(c, this.textArea);
                }
            }
            catch (Throwable thr) {
                // empty catch block
            }
        }
        this.doLayout();
        this.validateTree();
    }

    public void paintComponent(Graphics g) {
        if (this.isShowing()) {
            super.paintComponent(g);
        } else {
            Dimension size = this.getSize();
            try {
                g.setColor(this.getForeground());
                g.translate(1, 1);
                g.drawRect(0, 0, size.width - 2, size.height - 2);
                String textAreaText = this.text.getValue();
                if (textAreaText != null) {
                    int baseline;
                    int currentY = 0;
                    FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                    currentY = baseline = fontMetrics.getMaxAscent();
                    Dimension d = this.getSize();
                    Vector lines = this.breakIntoLines(textAreaText, d.width, fontMetrics);
                    Enumeration elements = lines.elements();
                    while (elements.hasMoreElements() && currentY <= d.height) {
                        g.drawString((String)elements.nextElement(), 0, currentY);
                        currentY += fontMetrics.getHeight();
                    }
                    fontMetrics = null;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            g.setClip(0, 0, size.width - 3, size.height - 3);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Vector breakIntoLines(String s, int width, FontMetrics fm) {
        block11: {
            text = s;
            fromIndex = 0;
            pos = 0;
            lines = new Vector<String>();
            break block11;
            while (++fromIndex < text.length()) lbl-1000:
            // 2 sources

            {
                ** while (fromIndex >= text.length() || text.charAt((int)fromIndex) != ' ')
lbl8:
                // 1 sources

            }
lbl9:
            // 2 sources

            if (width < fm.charWidth(s.charAt(fromIndex))) {
                st = new StringTokenizer(s, "\n ");
                while (st.hasMoreElements()) {
                    lines.addElement(st.nextToken());
                }
                return lines;
            }
            pos = fromIndex;
            bestpos = -1;
            largestString = null;
            while (pos >= fromIndex) {
                bHardNewline = false;
                newlinePos = text.indexOf(10, pos);
                spacePos = text.indexOf(32, pos);
                if (newlinePos != -1 && (spacePos == -1 || spacePos != -1 && newlinePos < spacePos)) {
                    pos = newlinePos;
                    bHardNewline = true;
                } else {
                    pos = spacePos;
                    bHardNewline = false;
                }
                s = pos == -1 ? text.substring(fromIndex) : text.substring(fromIndex, pos);
                if (fm.stringWidth(s) >= width) break;
                largestString = s;
                bestpos = pos;
                if (bHardNewline) {
                    ++bestpos;
                }
                if (pos == -1 || bHardNewline) break;
                ++pos;
            }
            if (largestString == null) {
                totalWidth = 0;
                oneCharWidth = 0;
                pos = fromIndex;
                while (pos < text.length()) {
                    oneCharWidth = fm.charWidth(text.charAt(pos));
                    if (totalWidth + oneCharWidth >= width) break;
                    totalWidth += oneCharWidth;
                    ++pos;
                }
                lines.addElement(text.substring(fromIndex, pos));
                fromIndex = pos;
            } else {
                lines.addElement(largestString);
                fromIndex = bestpos;
            }
        }
        if (fromIndex != -1) ** GOTO lbl-1000
        return lines;
    }

    private void checkAttributes(DTextAreaElement element) {
        this.updateFont();
        this.textArea.setEditable(this.text.getReadOnly() ^ true);
        this.textArea.setEnabled(this.text.getDisabled() ^ true);
        String s = this.text.getValue();
        if (s != null && !s.equals(this.textArea.getText())) {
            this.textArea.setText(s);
            this.textArea.setCaretPosition(s.length());
        }
        if (this.box != null) {
            int rows = element.getAttributeAsInt("rows");
            int cols = element.getAttributeAsInt("cols");
            if (rows < 0) {
                rows = 3;
            }
            if (cols < 0) {
                cols = 20;
            }
            if (cols != this.textArea.getColumns() || rows != this.textArea.getRows()) {
                this.textArea.setColumns(cols);
                this.textArea.setRows(rows);
                this.box.invalidate();
                this.box.reqReflow();
            }
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.text.setValue(this.textArea.getText());
    }

    public void removeUpdate(DocumentEvent e) {
        this.text.setValue(this.textArea.getText());
    }

    public void changedUpdate(DocumentEvent e) {
        this.text.setValue(this.textArea.getText());
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
        this.checkAttributes((DTextAreaElement)elem);
    }

    public void caretUpdate(CaretEvent e) {
        int selMark;
        int caret = e.getDot();
        if (caret != (selMark = e.getMark())) {
            int end;
            int start;
            if (caret < selMark) {
                start = caret;
                end = selMark;
            } else {
                end = caret;
                start = selMark;
            }
            this.text.dispatchSelection(start, end);
        }
    }

    public void setFont(Font f) {
        super.setFont(f);
        if (this.textArea != null) {
            this.textArea.setFont(f);
        }
    }

    void updateFont() {
        CSSAttribs css;
        Font f;
        if (this.textArea == null) {
            return;
        }
        if (this.box != null && !(f = (css = this.box.getCSSAttribs()).getTestedFont(this.text.getValue())).equals(this.getFont())) {
            this.setFont(f);
        }
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.textArea != null) {
            this.textArea.setBackground(c);
        }
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        if (this.textArea != null) {
            this.textArea.setForeground(c);
        }
    }

    public void dispose() {
        Container c = this.getParent();
        if (c != null) {
            c.remove(this);
        }
    }

    public void setBox(ObjectBox box) {
        this.box = box;
        this.docView.checkAwtTree(box, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int w, int h) {
        this.setSize(w, h);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void draw(Graphics g) {
    }

    public void syncDom(int x, int y, boolean visible) {
        this.setLocation(x, y);
        this.setVisible(visible);
    }

    public void setBorderVisible(boolean aDrawBorder) {
    }

    public void setFontHints(CSSAttribs css) {
        this.updateFont();
    }

    public int getClientHeight() {
        JScrollBar hbar = this.horizontalScrollBar;
        int hbarWidth = hbar != null ? hbar.getHeight() : 0;
        return this.getHeight() - hbarWidth;
    }

    public int getClientWidth() {
        JScrollBar vbar = this.verticalScrollBar;
        int vbarWidth = vbar != null ? vbar.getWidth() : 0;
        return this.getWidth() - vbarWidth;
    }
}

