/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.debug.Debug;
import ice.pilots.html4.swing.LaFConfig;
import ice.util.Defs;
import ice.util.JavaVersion;
import ice.util.alg.HashArray;
import java.awt.Color;
import java.awt.Graphics;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.UIManager;

public class FocusIndicator {
    private static String jvmMajMinVersion;
    private static String jvmMajMinSubVersion;

    static {
        int[] version = JavaVersion.getVMVersion().getParts();
        StringBuffer versStr = new StringBuffer();
        versStr.append(version[0]);
        versStr.append('.');
        versStr.append(version[1]);
        jvmMajMinVersion = versStr.toString();
        versStr.append('.');
        versStr.append(version[2]);
        jvmMajMinSubVersion = versStr.toString();
    }

    static LaFConfig findLaFConfig(HashArray configs, LaFConfig defaultConfig) {
        LaFConfig config;
        String key;
        Object cf;
        String lafClass = UIManager.getLookAndFeel().getClass().getName();
        if ((jvmMajMinSubVersion.equals("1.4.2") || JavaVersion.isV15orGreater()) && lafClass.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel") && Defs.sysProperty("swing.noxp") != null) {
            lafClass = "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel";
        }
        if ((cf = configs.get(key = jvmMajMinSubVersion + lafClass)) != null) {
            config = (LaFConfig)cf;
        } else {
            key = jvmMajMinVersion + lafClass;
            cf = configs.get(key);
            if (cf != null) {
                config = (LaFConfig)cf;
            } else {
                config = defaultConfig;
                if (Debug.trace) {
                    String errMsg = "LaFConfig not found for jvmVersion: '" + jvmMajMinVersion + "', classname: '" + lafClass + "'.\nUsing DEFAULT LaFConfig.";
                    Debug.trace(errMsg);
                }
            }
        }
        if (Debug.all) {
            Debug.trace("Found LaFConfig for specified jvmVersion: '" + jvmMajMinVersion + "' and lafClassName: '" + lafClass + "': \n" + config);
        }
        return config;
    }

    static HashArray parseCustomConfigs(int type, String args) {
        HashArray retConfigs;
        block6: {
            if (args == null) {
                return new HashArray(0);
            }
            StringTokenizer st = new StringTokenizer(args, ",");
            retConfigs = new HashArray(4);
            try {
                while (true) {
                    LaFConfig customConfig;
                    String argStr;
                    String version = argStr = st.nextToken();
                    String laf = argStr = st.nextToken();
                    argStr = st.nextToken();
                    if (argStr.equalsIgnoreCase("NONE")) {
                        customConfig = new LaFConfig(type, version, laf, false);
                        retConfigs.put(customConfig.getKey(), (Object)customConfig);
                        if (!Debug.all) continue;
                        String msg = "Custom focusIndicatorConfig created from system property:\n" + customConfig.toString();
                        Debug.trace(msg);
                        continue;
                    }
                    int x = Integer.parseInt(argStr);
                    argStr = st.nextToken();
                    int y = Integer.parseInt(argStr);
                    argStr = st.nextToken();
                    int w = Integer.parseInt(argStr);
                    argStr = st.nextToken();
                    int h = Integer.parseInt(argStr);
                    customConfig = new LaFConfig(type, version, laf, x, y, w, h);
                    retConfigs.put(customConfig.getKey(), (Object)customConfig);
                    if (!Debug.all) continue;
                    String msg = "Custom focusIndicatorConfig created from system property:\n" + customConfig.toString();
                    Debug.trace(msg);
                }
            }
            catch (NoSuchElementException e) {
            }
            catch (NumberFormatException e) {
                if (!Debug.trace) break block6;
                String typeName = LaFConfig.getTypeAsString(type);
                String errMsg = "Incorrect format error while parsing '..." + typeName + "' system property." + "\nExpected format is: \n" + "'jvmVersion(String),lookAndFeelClassname(String),enabled(String='none')" + " OR xOffset(int),yOffset(int),widthOffest(int),heightOffset(int), etc.'" + "\nParsing of '...'" + typeName + "' aborted.";
                Debug.trace(errMsg);
            }
        }
        return retConfigs;
    }

    static void drawFocusRect(Graphics g, int x, int y, int width, int height) {
        Color origColor = g.getColor();
        g.setColor(Color.black);
        g.setXORMode(Color.white);
        int xInc = x + 1;
        while (xInc < width - 1) {
            g.drawLine(xInc, y, xInc, y);
            xInc += 2;
        }
        int xInc2 = x + 1;
        while (xInc2 < width - 1) {
            g.drawLine(xInc2, height - 1, xInc2, height - 1);
            xInc2 += 2;
        }
        int yInc = y + 1;
        while (yInc < height - 1) {
            g.drawLine(x, yInc, x, yInc);
            yInc += 2;
        }
        int yInc2 = y + 1;
        while (yInc2 < height - 1) {
            g.drawLine(width - 1, yInc2, width - 1, yInc2);
            yInc2 += 2;
        }
        g.setPaintMode();
        g.setColor(origColor);
    }
}

