/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.debug.Debug;
import ice.pilots.html4.ComponentFactory;
import ice.pilots.html4.Html4DocumentAccess;
import ice.pilots.html4.ICEDragClient;
import ice.pilots.html4.ICEDropClient;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ScreenReaderStatusComponent;
import ice.pilots.html4.ScrollPositionChangeCallback;
import ice.pilots.html4.ThePilot;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import ice.util.Defs;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

class DocPanel
extends JPanel
implements ICEDragClient {
    DocView docView;
    private int sx;
    private int sy;
    int nsx;
    int nsy;
    private int selectButton;
    private int scrollButton;
    private int scrollMouseX;
    private int scrollMouseY;
    private int selectMouseX;
    private int selectMouseY;
    private int vScrollDistance;
    private int hScrollDistance;
    private int scrollTimeout;
    private long scrollTimestamp;
    private int lastDraggedY;
    private boolean mouseGestureListeningEnabled;
    private ICEDropClient dropClient;
    private boolean preserveSelectedText;

    private void $init$() {
        this.sx = 0;
        this.sy = 0;
        this.nsx = 0;
        this.nsy = 0;
        this.selectButton = 0;
        this.scrollButton = 1;
        this.scrollMouseX = -1;
        this.scrollMouseY = -1;
        this.selectMouseX = -1;
        this.selectMouseY = -1;
        this.scrollTimeout = 30;
    }

    DocPanel(DocView docView) {
        this.$init$();
        this.docView = docView;
        this.enableEvents(60);
        this.setLayout(null);
        this.vScrollDistance = Defs.sysPropertyInt("ice.pilots.html4.vScrollDistance", 0);
        this.hScrollDistance = Defs.sysPropertyInt("ice.pilots.html4.hScrollDistance", 0);
        this.scrollTimeout = Defs.sysPropertyInt("ice.pilots.html4.scrollTimeout", this.scrollTimeout);
        String value = Defs.sysProperty("ice.pilots.html4.selectButton");
        if (!docView.enableTextSelection) {
            value = "none";
        }
        this.selectButton = ComponentFactory.parseButton(value, this.selectButton);
        value = Defs.sysProperty("ice.pilots.html4.scrollButton");
        this.scrollButton = ComponentFactory.parseButton(value, this.scrollButton);
        boolean def = Defs.booleanProperty("ice.pilots.html4.enableTextSelection", true);
        if (def) {
            this.loadDragAgentReflexively();
        }
    }

    public boolean isGestureListeningEnabled() {
        return this.mouseGestureListeningEnabled;
    }

    public String getDragPayload() {
        return this.docView.getDragPayload();
    }

    void setDropClient(ICEDropClient client) {
        if (this.dropClient == null) {
            this.dropClient = client;
            this.loadDropAgentReflexively();
        }
    }

    private void loadDragAgentReflexively() {
        Class<?> dragAgent = null;
        try {
            dragAgent = Class.forName("ice.pilots.html4.swing.dnd.DragSourceAgent");
            Class[] consArgs = new Class[]{ICEDragClient.class, Component.class};
            Constructor<?> constructor = dragAgent.getConstructor(consArgs);
            Object[] args = new Object[]{this, this};
            constructor.newInstance(args);
        }
        catch (ClassNotFoundException cnf) {
            Debug.trace("DnD Class not found: " + cnf);
        }
        catch (NoSuchMethodException nsme) {
            Debug.trace("DnD Constructor not found: " + nsme);
        }
        catch (InstantiationException ie) {
            Debug.trace("DnD instantiation exception: " + ie);
        }
        catch (IllegalAccessException ia) {
            Debug.trace("DnD IllegalAccessException: " + ia);
        }
        catch (InvocationTargetException ite) {
            Debug.trace("DnD InvocationTargetException: " + ite);
        }
        catch (Error err) {
            // empty catch block
        }
    }

    private void loadDropAgentReflexively() {
        Class<?> dropAgent = null;
        try {
            dropAgent = Class.forName("ice.pilots.html4.swing.dnd.DropTargetAgent");
            Class[] consArgs = new Class[]{ICEDropClient.class, Component.class};
            Constructor<?> constructor = dropAgent.getConstructor(consArgs);
            Object[] args = new Object[]{this.dropClient, this};
            constructor.newInstance(args);
        }
        catch (ClassNotFoundException cnf) {
            Debug.trace("DnD Class not found: " + cnf);
        }
        catch (NoSuchMethodException nsme) {
            Debug.trace("DnD Constructor not found: " + nsme);
        }
        catch (InstantiationException ie) {
            Debug.trace("DnD instantiation exception: " + ie);
        }
        catch (IllegalAccessException ia) {
            Debug.trace("DnD IllegalAccessException: " + ia);
        }
        catch (InvocationTargetException ite) {
            Debug.trace("DnD InvocationTargetException: " + ite);
        }
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isManagingFocus() {
        return true;
    }

    void scrollLightweightChildren() {
        int count = this.getComponentCount();
        try {
            int i = 0;
            while (i < count) {
                Component component = this.getComponent(i);
                if (component != null && component instanceof JComponent) {
                    if (component instanceof Movable) {
                        Movable m = (Movable)((Object)component);
                        ObjectBox box = m.getBox();
                        if (box != null) {
                            Point p = new Point(0, 0);
                            box.findAbsolutePosition(p);
                            m.syncDom(p.x - this.sx, p.y - this.sy, box.checkIfVisible());
                        }
                    } else if (!component.isVisible()) {
                        component.setVisible(true);
                    }
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            return;
        }
    }

    public void doLayout() {
        Dimension sz = this.getSize();
        int width = sz.width <= 0 ? DocView.headlessLayoutWidth : sz.width;
        int height = sz.height <= 0 ? DocView.headlessLayoutHeight : sz.height;
        this.doLayout(width, height);
    }

    public void doLayout(int width, int height) {
        if (this.docView.isPilotDisposed()) {
            return;
        }
        this.docView.docLayout(width, height);
        JScrollBar vbar = this.docView.vbar;
        JScrollBar hbar = this.docView.hbar;
        if (vbar != null && this.isVisible()) {
            int y = vbar.getValue();
            int newHeight = height;
            int maxy = this.docView.getDocHeight();
            if (newHeight > maxy) {
                newHeight = maxy;
            }
            if (y + newHeight > maxy) {
                this.nsy = y = maxy - newHeight;
            }
            vbar.setValues(y, newHeight, 0, maxy);
            vbar.setBlockIncrement(newHeight);
            vbar.setUnitIncrement(20);
            int x = hbar.getValue();
            int maxx = this.docView.getDocWidth();
            int newWidth = width;
            if (newWidth > maxx) {
                newWidth = maxx;
            }
            if (x + newWidth > maxx) {
                this.nsx = x = maxx - newWidth;
            }
            this.setScrollPosition(this.nsx, this.nsy);
            hbar.setValues(x, newWidth, 0, maxx);
            hbar.setBlockIncrement(newWidth);
            hbar.setUnitIncrement(20);
            boolean scrollbarVisibilityChange = false;
            if (maxy <= newHeight) {
                if (vbar.isVisible() && this.docView.validateTreeNesting <= 1) {
                    vbar.setVisible(false);
                    scrollbarVisibilityChange = true;
                }
            } else if (!vbar.isVisible()) {
                vbar.setVisible(true);
                scrollbarVisibilityChange = true;
            }
            if (maxx <= newWidth) {
                if (hbar.isVisible() && this.docView.validateTreeNesting <= 1) {
                    hbar.setVisible(false);
                    scrollbarVisibilityChange = true;
                }
            } else if (!hbar.isVisible()) {
                hbar.setVisible(true);
                scrollbarVisibilityChange = true;
            }
            if (scrollbarVisibilityChange) {
                this.docView._panePanel.validateTree();
                return;
            }
        }
        if (this.docView.pendingScrollUpdate) {
            if (vbar != null) {
                vbar.setValue(0);
            }
            if (hbar != null) {
                hbar.setValue(0);
            }
            this.docView.pendingScrollUpdate = false;
        }
        this.docView.docPostLayout();
        this.scrollLightweightChildren();
    }

    void setScrollPosition(int x, int y) {
        if (this.sx != x || this.sy != y) {
            int oldX = this.sx;
            int oldY = this.sy;
            this.sx = x;
            this.sy = y;
            ScrollPositionChangeCallback callback = this.docView.getScrollPositionChangeCallback();
            if (callback != null) {
                callback.setScrollPositionChanged(x, oldX, y, oldY);
            }
        }
    }

    int getScrollX() {
        return this.sx;
    }

    int getScrollY() {
        return this.sy;
    }

    void scroll(int x, int y) {
        if (!this.docView.canScroll(x, y)) {
            return;
        }
        this.nsx = x;
        this.nsy = y;
        this.setScrollPosition(this.nsx, this.nsy);
        this.docView.docScrollChanged(x, y);
        this.scrollLightweightChildren();
        this.repaint();
    }

    public AccessibleContext getAccessibleContext() {
        if (!DocView.isAccessible) {
            return null;
        }
        if (this.accessibleContext == null) {
            try {
                if (DocView.accessibility.equalsIgnoreCase("java")) {
                    Class<?> clazz = Class.forName("ice.pilots.html4.swing.AccessibleHypertextPanel");
                    Constructor<?> constructor = clazz.getConstructor(DocView.class, AccessibleContext.class, ScreenReaderStatusComponent.class);
                    this.accessibleContext = (AccessibleContext)constructor.newInstance(this.docView, super.getAccessibleContext(), this.initializeStatusPanel());
                }
                if (DocView.accessibility.equalsIgnoreCase("jaws")) {
                    Class<?> clazz = Class.forName("ice.pilots.html4.AccessibleHyperPanel");
                    Constructor<?> constructor = clazz.getConstructor(ThePilot.class, AccessibleContext.class, ScreenReaderStatusComponent.class);
                    this.accessibleContext = (AccessibleContext)constructor.newInstance(this.docView.getPilot(), super.getAccessibleContext(), this.initializeStatusPanel());
                }
            }
            catch (Exception e) {
                Debug.trace("Missing accessibility library.");
                Debug.ex(e);
            }
        }
        if (Debug.trace) {
            Debug.trace("AccessibleContext <" + DocView.accessibility + " > created for " + this);
        }
        return this.accessibleContext;
    }

    private ScreenReaderStatusComponent initializeStatusPanel() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> clazz = Class.forName("ice.pilots.html4.swing.SwingScreenReaderStatusPanel");
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        Component statusPanel = (Component)constructor.newInstance(new Object[0]);
        this.docView._panePanel.add(statusPanel, "North");
        statusPanel.setVisible(false);
        return (ScreenReaderStatusComponent)((Object)statusPanel);
    }

    public void paintComponent(Graphics g) {
        if (this.docView.isPilotDisposed()) {
            return;
        }
        long tt = System.currentTimeMillis();
        Rectangle r = g.getClipBounds();
        if (r == null) {
            g.setClip(0, 0, this.getSize().width, this.getSize().height);
            r = g.getClipBounds();
        }
        this.paintInto(g, r);
        this.scrollLightweightChildren();
        tt = System.currentTimeMillis() - tt;
    }

    private void paintInto(Graphics g, Rectangle r) {
        g.setColor(Color.white);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.translate(-this.sx, -this.sy);
        g.setClip(r.x + this.sx, r.y + this.sy, r.width, r.height);
        this.docView.docPaint(g);
        g.translate(this.sx, this.sy);
        this.docView.docPaintFixed(g);
    }

    private void mouseDragged(MouseEvent e) {
        this.preserveSelectedText = true;
        if (this.mouseGestureListeningEnabled) {
            return;
        }
        this.lastDraggedY = e.getY();
        if (this.isButtonDown(this.scrollButton, e)) {
            if (this.scrollMouseX >= 0) {
                int dx = this.scrollMouseX - e.getX();
                int dy = this.scrollMouseY - e.getY();
                if (Math.abs(dx) > Math.abs(dy)) {
                    dy = 0;
                } else {
                    dx = 0;
                }
                this.docView.setScrollPosition(this.sx + dx, this.sy + dy);
            }
            this.scrollMouseX = e.getX();
            this.scrollMouseY = e.getY();
        } else if (this.isButtonDown(this.selectButton, e) && this.selectMouseX >= 0) {
            int scrollUpDown = 0;
            int scrollLeftRight = 0;
            Dimension d = this.getSize();
            int itemp = e.getY();
            if (itemp > d.height) {
                scrollUpDown = this.vScrollDistance > 0 ? this.vScrollDistance : itemp - d.height;
            } else if (itemp < 0) {
                scrollUpDown = this.vScrollDistance > 0 ? -this.vScrollDistance : itemp;
            }
            itemp = e.getX();
            if (itemp > d.width) {
                scrollLeftRight = this.hScrollDistance > 0 ? this.hScrollDistance : itemp - d.width;
            } else if (itemp < 0) {
                scrollLeftRight = this.hScrollDistance > 0 ? -this.hScrollDistance : itemp;
            }
            this.scrollAndSelect(scrollUpDown, scrollLeftRight, e.getX(), e.getY());
        }
    }

    private void scrollAndSelect(int scrollUpDown, int scrollLeftRight, int ex, int ey) {
        if (scrollUpDown != 0 || scrollLeftRight != 0) {
            long tmp = System.currentTimeMillis();
            if (tmp - this.scrollTimestamp > (long)this.scrollTimeout) {
                if (this.docView.vbar == null || this.docView.hbar == null) {
                    return;
                }
                int max = this.docView.vbar.getMaximum();
                int vis = this.docView.vbar.getVisibleAmount();
                int val = this.docView.vbar.getValue();
                if (scrollUpDown > 0 && val + vis == max) {
                    return;
                }
                if (scrollUpDown < 0 && val == 0) {
                    return;
                }
                if (scrollLeftRight > 0 && this.docView.hbar.getValue() + this.docView.hbar.getVisibleAmount() == this.docView.hbar.getMaximum()) {
                    return;
                }
                if (scrollLeftRight < 0 && this.docView.hbar.getValue() == 0) {
                    return;
                }
                this.docView.setScrollPosition(this.sx + scrollLeftRight, this.sy + scrollUpDown);
                this.scrollTimestamp = tmp;
                this.selectMouseY -= scrollUpDown;
                this.selectMouseX -= scrollLeftRight;
            }
            DelayedScroll t = new DelayedScroll(this, ex, ey, scrollUpDown, scrollLeftRight);
            this.docView.getPilot().getStorm().runOnEventThreadLater(t, this.scrollTimeout + 10);
        }
        this.docView.docSetSelection(this.selectMouseX, this.selectMouseY, ex + scrollLeftRight, ey + scrollUpDown);
    }

    private void performDelayedScroll(DelayedScroll ds) {
        if (this.selectMouseX != -1 && DelayedScroll.ra$selY(ds) == this.lastDraggedY) {
            this.scrollAndSelect(DelayedScroll.ra$scrollUpDown(ds), DelayedScroll.ra$scrollLeftRight(ds), DelayedScroll.ra$selX(ds), DelayedScroll.ra$selY(ds));
        }
    }

    private void mousePressed(MouseEvent e) {
        this.requestFocus();
        this.preserveSelectedText = false;
        if (this.isButtonDown(this.selectButton, e) && !e.isPopupTrigger()) {
            this.mouseGestureListeningEnabled = this.docView.isGestureListeningEnabled(e.getX(), e.getY());
            if (!this.mouseGestureListeningEnabled) {
                this.docView.docClearSelection();
                this.docView.docMarkDocument(e.getX(), e.getY());
                this.mouseGestureListeningEnabled = false;
                this.preserveSelectedText = true;
            }
            this.selectMouseX = e.getX();
            this.selectMouseY = e.getY();
        }
    }

    private void mouseReleased(MouseEvent e) {
        this.scrollMouseX = -1;
        this.selectMouseX = -1;
        this.docView.postSelectedToClipboard();
        if (this.isButtonDown(this.selectButton, e) && !this.preserveSelectedText) {
            this.docView.docClearSelection();
        }
    }

    private void mouseExited(MouseEvent e) {
        this.scrollMouseX = -1;
    }

    private void mouseClicked(MouseEvent event) {
        if (this.isButtonDown(this.selectButton, event)) {
            int clickCount = event.getClickCount();
            int mouseX = event.getX();
            int mouseY = event.getY();
            Html4DocumentAccess access = new Html4DocumentAccess(this.docView.getPilot());
            switch (clickCount) {
                case 4: {
                    access.setSelection(0, mouseX, mouseY);
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    access.setSelection(2, mouseX, mouseY);
                    break;
                }
            }
        }
    }

    private boolean isButtonDown(int whichButton, InputEvent e) {
        if (whichButton < 0) {
            return false;
        }
        int m = e.getModifiers();
        if (whichButton == 0 && (m == 0 || (m & 0x10) != 0)) {
            return true;
        }
        return whichButton == 1 && (m & 4) != 0;
    }

    protected void processEvent(AWTEvent e) {
        if (this.docView.onComponentEvent(this, e)) {
            super.processEvent(e);
            switch (e.getID()) {
                case 506: {
                    this.mouseDragged((MouseEvent)e);
                    break;
                }
                case 501: {
                    this.mousePressed((MouseEvent)e);
                    break;
                }
                case 502: {
                    this.mouseReleased((MouseEvent)e);
                    break;
                }
                case 505: {
                    this.mouseExited((MouseEvent)e);
                    break;
                }
                case 500: {
                    this.mouseClicked((MouseEvent)e);
                    break;
                }
            }
        }
    }

    static void mav$performDelayedScroll(DocPanel docPanel, DelayedScroll delayedScroll) {
        docPanel.performDelayedScroll(delayedScroll);
    }

    private static class DelayedScroll
    implements Runnable {
        private final DocPanel owner;
        private final int selY;
        private final int selX;
        private final int scrollUpDown;
        private final int scrollLeftRight;

        DelayedScroll(DocPanel owner, int selX, int selY, int scrollUpDown, int scrollLeftRight) {
            this.owner = owner;
            this.selY = selY;
            this.selX = selX;
            this.scrollUpDown = scrollUpDown;
            this.scrollLeftRight = scrollLeftRight;
        }

        public void run() {
            DocPanel.mav$performDelayedScroll(this.owner, this);
        }

        static int ra$selY(DelayedScroll delayedScroll) {
            return delayedScroll.selY;
        }

        static int ra$scrollUpDown(DelayedScroll delayedScroll) {
            return delayedScroll.scrollUpDown;
        }

        static int ra$scrollLeftRight(DelayedScroll delayedScroll) {
            return delayedScroll.scrollLeftRight;
        }

        static int ra$selX(DelayedScroll delayedScroll) {
            return delayedScroll.selX;
        }
    }
}

