/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.DOptionElement;
import ice.pilots.html4.DSelectElement;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

class ChoiceModel
extends DefaultComboBoxModel
implements ComboBoxModel,
ActionListener,
FocusListener {
    DSelectElement sel;
    boolean ignoreItemChange;
    private boolean outOfSync;
    private Object tempSelection;

    private void $init$() {
        this.ignoreItemChange = true;
        this.outOfSync = false;
        this.tempSelection = null;
    }

    ChoiceModel(DSelectElement sel) {
        this.$init$();
        this.sel = sel;
        int index = 0;
        while (index < sel.getLength()) {
            this.addElement(sel.getDOption(index).getTextOrEmptyString());
            ++index;
        }
    }

    public Object getSelectedItem() {
        if (this.outOfSync) {
            return this.tempSelection;
        }
        DOptionElement selectedOption = this.sel.getSelectedDOption();
        if (selectedOption != null) {
            return selectedOption.getTextOrEmptyString();
        }
        return null;
    }

    public void setSelectedItem(Object selectedItem) {
        if (selectedItem == null || this.ignoreItemChange) {
            return;
        }
        super.setSelectedItem(selectedItem);
        this.outOfSync = true;
        this.tempSelection = selectedItem;
    }

    public Object getElementAt(int index) {
        String optionText = null;
        DOptionElement opt = this.sel.getDOption(index);
        if (opt != null) {
            optionText = opt.getTextOrEmptyString();
        }
        return optionText;
    }

    void sync() {
        this.ignoreItemChange = true;
        if (this.outOfSync) {
            if (this.tempSelection != null) {
                String s = this.tempSelection.toString();
                DOptionElement opt = this.sel.firstDOption();
                int i = 0;
                while (opt != null) {
                    if (s.equals(opt.getTextOrEmptyString())) {
                        this.sel.setSelectedIndexByUser(i);
                        break;
                    }
                    opt = this.sel.nextDOption(opt);
                    ++i;
                }
            }
            this.outOfSync = false;
        }
        this.ignoreItemChange = false;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getModifiers() != 0) {
            this.sync();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.sync();
    }
}

