/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.pilots.html4.Html4DocumentAccess;
import ice.pilots.html4.swing.AccessibleLink;
import ice.pilots.html4.swing.DocView;
import java.util.Vector;

class AccessibleLinkIndex {
    private Vector links;
    private Html4DocumentAccess docAccess;

    public AccessibleLinkIndex(Html4DocumentAccess docAccess) {
        this.docAccess = docAccess;
        this.links = new Vector();
    }

    public void processDoc(DDocument ddoc) {
        this.processNodes(ddoc.getRootDNode());
    }

    private void processNodes(DNode currentNode) {
        if (currentNode == null) {
            return;
        }
        this.processNode(currentNode);
        DNode iter = (DNode)currentNode.getFirstChild();
        while (iter != null) {
            this.processNodes(iter);
            iter = (DNode)iter.getNextSibling();
        }
    }

    private void processNode(DNode node) {
        if (!(node instanceof DAnchorElement)) {
            return;
        }
        this.links.addElement(node);
    }

    public int getLinkCount() {
        return this.links.size();
    }

    public AccessibleLink getLink(int linkIndex, DocView docView) {
        if (linkIndex < 0 || linkIndex > this.links.size()) {
            return null;
        }
        DAnchorElement anchor = (DAnchorElement)this.links.get(linkIndex);
        AccessibleLink link = new AccessibleLink(anchor, docView, this.docAccess);
        return link;
    }

    public int getIndexFromNode(DAnchorElement anchorNode) {
        return this.links.indexOf(anchorNode);
    }
}

