/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DTextNode;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;

public class TransformXml {
    public static String toHtml(DDocument doc) {
        StringBuffer htmlStr = new StringBuffer();
        htmlStr.append("<html>");
        htmlStr.append("<head>");
        htmlStr.append("<style>");
        htmlStr.append("body {font-family: Arial; font-size: 11pt;}");
        htmlStr.append("div {margin-left: 1ex;}");
        htmlStr.append("div.deepest {margin-left: 3ex;}");
        htmlStr.append(".lt, .gt, .quote {color: blue;}");
        htmlStr.append(".node_name, .attr_name {color: brown;}");
        htmlStr.append(".node_text, .attr_value {font-weight: bold;}");
        htmlStr.append("a:link {text-decoration: none}");
        htmlStr.append("a:visited {text-decoration: none}");
        htmlStr.append("a:active {text-decoration: none}");
        htmlStr.append("</style>");
        htmlStr.append("<script language=\"JavaScript\">");
        htmlStr.append("function toggleDisplay(idNum)");
        htmlStr.append("{");
        htmlStr.append("var divStyle = document.getElementById(\"div\" + idNum).style;");
        htmlStr.append("divStyle.display = divStyle.display == \"none\" ? \"block\" : \"none\";");
        htmlStr.append("var lnkTextNode = document.getElementById(\"lnk\" + idNum).firstChild;");
        htmlStr.append("lnkTextNode.nodeValue = lnkTextNode.nodeValue == \"-\" ? \"+\" : \"-\";");
        htmlStr.append("}");
        htmlStr.append("</script>");
        htmlStr.append("</head>");
        htmlStr.append("<body>");
        TransformXml.toHtml((DElement)doc.getFirstChild(), 1, htmlStr, 1);
        htmlStr.append("</body>");
        htmlStr.append("</html>");
        return htmlStr.toString();
    }

    private static void toHtml(DElement e, int tab, StringBuffer htmlStr, int divCount) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < tab) {
            buf.append(" ");
            ++i;
        }
        String temp = buf.toString();
        String nodeName = e.getNodeName();
        String attr = "";
        NamedNodeMap map = e.getAttributes();
        int i2 = 0;
        while (i2 < map.getLength()) {
            Attr a = (Attr)map.item(i2);
            attr = attr + " <span class=\"attr_name\">" + a.getName() + "</span>" + "<span class=\"quote\">" + "=\"" + "</span>" + "<span class=\"attr_value\">" + a.getValue() + "</span>" + "<span class=\"quote\">" + "\"" + "</span>";
            ++i2;
        }
        DNode n = (DNode)e.getFirstChild();
        boolean hasChildElements = false;
        while (n != null) {
            if (n instanceof DElement) {
                hasChildElements = true;
                break;
            }
            n = (DNode)n.getNextSibling();
        }
        if (hasChildElements) {
            String idNum = tab + "." + divCount;
            htmlStr.append(temp + "<div><a id=\"lnk" + idNum + "\" href=\"javascript:toggleDisplay('" + idNum + "')\" style=\"font-family: monospace;\"" + ">-</a> <span class=\"lt\">&lt;</span>" + "<span class=\"node_name\">" + nodeName + "</span>" + attr + "<span class=\"gt\">&gt;</span>" + "<div id=\"div" + idNum + "\">");
        } else {
            htmlStr.append(temp + "<div class=\"deepest\"><span class=\"lt\">&lt;</span>" + "<span class=\"node_name\">" + nodeName + "</span>" + attr + "<span class=\"gt\">&gt;</span>");
        }
        n = (DNode)e.getFirstChild();
        int nodeCount = 0;
        while (n != null) {
            if (n instanceof DElement) {
                TransformXml.toHtml((DElement)n, tab + 1, htmlStr, ++nodeCount);
            } else if (n instanceof DTextNode && n.getNodeValue().trim().length() != 0) {
                if (hasChildElements) {
                    htmlStr.append("<div class=\"deepest\">");
                }
                htmlStr.append("<span class=\"node_text\">" + n + "</span>");
                if (hasChildElements) {
                    htmlStr.append("</div>");
                }
            }
            n = (DNode)n.getNextSibling();
        }
        if (hasChildElements) {
            htmlStr.append("<div>");
            htmlStr.append(temp + "<span class=\"lt\">&lt;/</span>" + "<span class=\"node_name\">" + nodeName + "</span>" + "<span class=\"gt\">&gt;</span>");
            htmlStr.append("</div></div></div>");
        } else {
            htmlStr.append("<span class=\"lt\">&lt;/</span><span class=\"node_name\">" + nodeName + "</span>" + "<span class=\"gt\">&gt;</span>");
            htmlStr.append("</div>");
        }
    }
}

