/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.dom.css.CSSStyleDeclarationImpl;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DAreaElement;
import ice.pilots.html4.DCSSRule;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DocPaneXml;
import ice.pilots.html4.FocusManager;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ParameterConstants;
import ice.pilots.html4.PositionedBox;
import ice.pilots.html4.ScrollBox;
import ice.pilots.html4.ThePilot;
import ice.storm.DocPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.views.DocumentView;

public class TheView
implements ViewCSS,
ParameterConstants {
    private DDocument doc;
    CSSLayout cssLayout;
    private final Vector clickTargets;

    TheView(DDocument doc, CSSLayout cssLayout) {
        this.$init$();
        this.doc = doc;
        this.cssLayout = cssLayout;
    }

    public void reqReflow() {
        this.cssLayout.refresh();
    }

    public DocumentView getDocument() {
        return this.doc;
    }

    public DocPane getDocPane() {
        return this.cssLayout.docPane;
    }

    public FocusManager getFocusManager() {
        return this.cssLayout.getFocusManager();
    }

    public int getWidth() {
        return this.cssLayout.getWidth();
    }

    public int getHeight() {
        return this.cssLayout.getHeight();
    }

    public CSSStyleDeclaration getComputedStyle(Element elt, String pseudoElt) {
        if (elt == null) {
            throw new IllegalArgumentException("Computed Style element argument cannot be null");
        }
        CSSStyleDeclarationImpl returnVal = new CSSStyleDeclarationImpl(this.doc.getDom(), new DCSSRule(1, null, null), null);
        if ("left".equalsIgnoreCase(pseudoElt)) {
            this.getPropertyLeft(returnVal, (DNode)((Object)elt));
        } else if ("top".equalsIgnoreCase(pseudoElt)) {
            this.getPropertyTop(returnVal, (DNode)((Object)elt));
        } else if ("width".equalsIgnoreCase(pseudoElt)) {
            this.getPropertyWidth(returnVal, (DNode)((Object)elt));
        } else if ("height".equalsIgnoreCase(pseudoElt)) {
            this.getPropertyHeight(returnVal, (DNode)((Object)elt));
        } else if ("background-color".equalsIgnoreCase(pseudoElt)) {
            this.getPropertyBackgroundColor(returnVal, (DNode)((Object)elt));
        } else if ("".equalsIgnoreCase(pseudoElt)) {
            this.getPropertyLeft(returnVal, (DNode)((Object)elt));
            this.getPropertyTop(returnVal, (DNode)((Object)elt));
            this.getPropertyWidth(returnVal, (DNode)((Object)elt));
            this.getPropertyHeight(returnVal, (DNode)((Object)elt));
            this.getPropertyBackgroundColor(returnVal, (DNode)((Object)elt));
        }
        return returnVal;
    }

    public void setZoom(int z) {
        this.cssLayout.setLayoutZoom(z);
    }

    public int getZoom() {
        return this.cssLayout.getLayoutZoom();
    }

    int getViewWidth() {
        return this.getDocPane().getPaneWidth();
    }

    int getViewHeight() {
        return this.getDocPane().getPaneHeight();
    }

    public void findBoundingBox(DNode e, Rectangle r) {
        if (e.getNameId() == 6) {
            ((DAreaElement)e).findBoundingBox(r);
            return;
        }
        CSSBox b = this.cssLayout.findCSSBox(e);
        if (b != null) {
            b.findBoundingBox(r);
        }
    }

    public ObjectPainter getNodePainter(DNode node) {
        ObjectBox obox;
        CSSBox b = this.cssLayout.findCSSBox(node);
        if (b != null && (obox = this.cssLayout.getWrappedObjectBoxOrNull(b)) != null) {
            return obox.getObjectPainter();
        }
        return null;
    }

    public static Object getToolkitComponent(DNode node) {
        ObjectPainter painter;
        ThePilot pilot = node.doc.getPilot();
        if (pilot != null && (painter = pilot.getView().getNodePainter(node)) instanceof Component) {
            return painter;
        }
        return null;
    }

    public ObjectPainter getNodeScroller(DNode node) {
        CSSBox b = this.cssLayout.findCSSBox(node);
        while (b != null) {
            if (b instanceof ScrollBox) {
                ScrollBox sbox = (ScrollBox)b;
                ObjectBox sobox = sbox.getObjectBox();
                return sobox.getObjectPainter();
            }
            b = b.parentBox;
        }
        return null;
    }

    public ScrollBox getScroller(DNode node) {
        CSSBox b = this.cssLayout.findCSSBox(node);
        if (b instanceof ScrollBox) {
            return (ScrollBox)b;
        }
        return null;
    }

    DElement getOffsetParent(DNode n) {
        CSSBox b = this.cssLayout.findCSSBox(n);
        if (b != null) {
            b = b.parentBox;
            while (b != null) {
                DElement e = b.element;
                if (e == null) break;
                if (e != (DElement)n) {
                    if (b instanceof PositionedBox || e.tagId == 13) {
                        return e;
                    }
                    if (e.tagId == 79 || e.tagId == 81) {
                        return e;
                    }
                }
                b = b.parentBox;
            }
        }
        return null;
    }

    int getOffsetLeft(DNode n) {
        return this.getOffsetLeftOrTop(n, true);
    }

    int getOffsetTop(DNode n) {
        return this.getOffsetLeftOrTop(n, false);
    }

    private int getOffsetLeftOrTop(DNode n, boolean left) {
        int offset = 0;
        Rectangle r = new Rectangle();
        this.findBoundingBox2(n, r);
        offset = left ? r.x : r.y;
        DElement op = this.getOffsetParent(n);
        if (op != null && op.tagId != 13) {
            this.findBoundingBox2(op, r);
            offset = left ? (offset -= r.x) : (offset -= r.y);
        }
        return offset;
    }

    void findBoundingBox2(DNode e, Rectangle r) {
        if (e.getNameId() == 6) {
            ((DAreaElement)e).findBoundingBox(r);
            return;
        }
        CSSBox b = this.cssLayout.findCSSBox(e);
        if (b != null) {
            b.findBoundingBox(r);
        } else {
            DocPaneXml pane;
            if (this.doc.pilot.getStorm().isEventThread() && (pane = this.cssLayout.docPane) != null) {
                int width = pane.getPaneWidth();
                int height = pane.getPaneHeight();
                if (width > 0 && height > 0) {
                    this.cssLayout.layout(width, height);
                    b = this.cssLayout.findCSSBox(e);
                    if (b != null) {
                        b.findBoundingBox(r);
                        return;
                    }
                }
            }
            if (e.tagId == 13) {
                r.width = this.getViewWidth();
                r.height = this.getViewHeight();
            } else {
                r.width = 108;
                r.height = 24;
            }
        }
    }

    void updateFrameList() {
        DocPaneXml pane;
        if (this.doc.pilot.getStorm().isEventThread() && !this.cssLayout.isLayoutValid() && (pane = this.cssLayout.docPane) != null) {
            int width = pane.getPaneWidth();
            int height = pane.getPaneHeight();
            if (width > 0 && height > 0) {
                this.cssLayout.layout(width, height);
            }
        }
    }

    public void findPosition(DNode e, Point p) {
        CSSBox b = this.cssLayout.findCSSBox(e);
        if (b != null) {
            b.findAbsolutePosition(p);
        }
    }

    void processFocusCall(DElement e) {
        FocusManager fm;
        if (e.isFocusable() && (fm = this.getFocusManager()) != null) {
            fm.setFocusedBox(e);
        }
    }

    void processBlurCall(DNode node) {
        FocusManager fm = this.getFocusManager();
        if (fm != null) {
            fm.setFocusedBox(null);
        }
    }

    void processSelectCall(DNode node) {
        this.cssLayout.docPane.onNodeSelectCall(node);
    }

    private void $init$() {
        this.clickTargets = new Vector(5);
    }

    void processClickCall(DNode node) {
        DOMEvent de = this.doc.createDOMEvent(1, node);
        if (!this.doc.pilot.getStorm().isEventThread()) {
            this.doc.processEventLater(de, 0L);
        } else if (!this.clickTargets.contains(node)) {
            this.clickTargets.addElement(node);
            try {
                this.doc.processEvent(de);
            }
            finally {
                this.clickTargets.removeElementAt(this.clickTargets.size() - 1);
            }
        }
    }

    private void getPropertyLeft(CSSStyleDeclaration value, DNode node) {
        int iValue = this.getOffsetLeft(node);
        value.setProperty("left", Integer.toString(iValue), "normal");
    }

    private void getPropertyTop(CSSStyleDeclaration value, DNode node) {
        int iValue = this.getOffsetTop(node);
        value.setProperty("top", Integer.toString(iValue), "normal");
    }

    private void getPropertyWidth(CSSStyleDeclaration value, DNode node) {
        Rectangle r = new Rectangle();
        this.findBoundingBox(node, r);
        value.setProperty("width", Integer.toString(r.width), "normal");
    }

    private void getPropertyHeight(CSSStyleDeclaration value, DNode node) {
        Rectangle r = new Rectangle();
        this.findBoundingBox(node, r);
        value.setProperty("height", Integer.toString(r.height), "normal");
    }

    private void getPropertyBackgroundColor(CSSStyleDeclaration value, DNode node) {
        Color c;
        CSSBox b = this.cssLayout.findCSSBox(node);
        if (b != null && (c = b.css.background_color) != null) {
            value.setProperty("background-color", "0x" + Integer.toHexString(c.getRGB()), "normal");
        }
    }
}

