/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.BlockBox;
import ice.pilots.html4.BoxList;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSRect;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.FloatBox;
import ice.pilots.html4.FloatManager;
import ice.pilots.html4.FloatPainter;
import ice.pilots.html4.InlineBox;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

class PositionedBox
extends BlockBox {
    Vector children;
    BoxList list;
    boolean dummy;
    private CSSBox firstBlock;
    CSSBox previousSibling;
    private FloatPainter floatPainter;

    private void $init$() {
        this.children = new Vector();
        this.dummy = false;
        this.floatPainter = new FloatPainter();
    }

    PositionedBox(DElement element, CSSAttribs css, CSSLayout cssLayout, byte dynamic, CSSBox b) {
        super(element, css, cssLayout, dynamic);
        this.$init$();
        if (css.margin_left != -123456) {
            if (css.margin_left != 0) {
                css.left = css.left == -123456 ? css.margin_left : (css.left += css.margin_left);
                css.margin_left = -123456;
            }
        } else if (css.margin_right != -123456 && css.margin_right != 0) {
            css.right = css.right == -123456 ? css.margin_right : (css.right += css.margin_right);
            css.margin_right = -123456;
        }
        if (css.margin_top != -123456) {
            if (css.margin_top != 0) {
                css.top = css.top == -123456 ? css.margin_top : (css.top += css.margin_top);
                css.margin_top = -123456;
            }
        } else if (css.margin_bottom != -123456 && css.margin_bottom != 0) {
            css.bottom = css.bottom == -123456 ? css.margin_bottom : (css.bottom += css.margin_bottom);
            css.margin_bottom = -123456;
        }
        this.floatPainter = new FloatPainter();
        this.previousSibling = b;
    }

    PositionedBox(CSSBox b, BoxList bl) {
        super(null, null, null, (byte)0);
        this.$init$();
        this.dummy = true;
        if (b != null) {
            CSSAttribs ca = b.css;
            this.css = new CSSAttribs(b.cssLayout.sdata, null);
            this.css.position = ca.position;
            this.css.left = ca.left;
            if (ca.margin_left != -123456) {
                this.css.left += ca.margin_left;
            }
            this.css.top = ca.top;
            this.css.right = ca.right;
            if (ca.margin_right != -123456) {
                this.css.right += ca.margin_right;
            }
            this.css.bottom = ca.bottom;
            this.css.display = ca.display;
            this.css.width = ca.width;
            this.css.percentage_flag = ca.percentage_flag;
            this.css.z_index = ca.z_index;
        }
        this.firstBlock = b;
        this.list = bl;
    }

    void propagateVisibility(short b, boolean self) {
        if (this.firstBlock != null) {
            this.firstBlock.propagateVisibility(b, self);
        } else {
            super.propagateVisibility(b, self);
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                CSSBox bb = (CSSBox)e.nextElement();
                bb.propagateVisibility(b, true);
            }
        }
    }

    void changeTopAndLeft(int dx, int dy) {
        this.oy += dy;
        this.ox += dx;
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            CSSBox b = (CSSBox)e.nextElement();
            if (b instanceof PositionedBox) {
                ((PositionedBox)b).changeTopAndLeft(dx, dy);
                continue;
            }
            b.oy += dy;
            b.ox += dx;
        }
    }

    void setParentBox(CSSBox pb) {
        super.setParentBox(pb);
        if (this.parentBox.getType() == 0 && this.css.position == 126) {
            InlineBox ib = (InlineBox)this.parentBox;
            this.parentBox = ib.inline2Block();
        }
    }

    boolean substitute(CSSBox old, CSSBox b) {
        if (this.firstBlock == old) {
            this.firstBlock = b;
            return true;
        }
        int i = 0;
        while (i < this.children.size()) {
            PositionedBox rb = (PositionedBox)this.children.elementAt(i);
            if (rb == old) {
                ((PositionedBox)b).list = this.list;
                this.children.setElementAt(b, i);
                return true;
            }
            if (rb.substitute(old, b)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void clear() {
        this.firstBlock = null;
        int i = 0;
        while (i < this.children.size()) {
            PositionedBox rb = (PositionedBox)this.children.elementAt(i);
            rb.clear();
            ++i;
        }
        this.children.removeAllElements();
    }

    private CSSBox do_getBoxAt(int x, int y, Point rv, CSSBox b) {
        int bx = b.ox;
        int by = b.oy;
        int bw = b.width;
        int bh = b.height;
        if (b.getType() == 0) {
            InlineBox ib = (InlineBox)b;
            Rectangle rr = new Rectangle();
            ib.findBoundingBox(rr);
            bx = rr.x;
            by = rr.y;
            bw = rr.width;
            bh = rr.height;
        }
        CSSBox result = null;
        CSSRect clip = b.css.clip;
        if (clip != null) {
            if (x >= bx + clip.left && y >= by + clip.top && x < bx + clip.right && y < by + clip.bottom) {
                result = b.getBoxAt(x - bx, y - by, rv);
            }
        } else if (x >= bx && y >= by && x < bx + bw && y < by + bh) {
            result = b.getBoxAt(x - bx, y - by, rv);
        }
        return result;
    }

    CSSBox _getBoxAt(int x, int y, Point rv) {
        CSSBox result = null;
        CSSBox b = this.firstBlock;
        if (b == null) {
            int i = this.children.size() - 1;
            while (i >= 0 && result == null) {
                PositionedBox rb = (PositionedBox)this.children.elementAt(i);
                result = rb._getBoxAt(x, y, rv);
                --i;
            }
        }
        if (!this.dummy) {
            b = this;
        }
        if (result == null && b != null && this._isVisible(b) && !this.isClippedByParents(x, y, b)) {
            result = this.do_getBoxAt(x, y, rv, b);
        }
        return result;
    }

    private void do_paint(Graphics g, CSSBox b) {
        if (!this.checkIfVisible()) {
            return;
        }
        if (b != null && this._isVisible(b) && b.getType() != 0) {
            Graphics gg = g.create();
            PositionedBox.applyClippingFromParents(gg, b);
            gg.clipRect(b.ox, b.oy, b.width, b.height);
            b.cssLayout.outlinePainter.drawBox(gg, b, b.ox, b.oy);
            gg.dispose();
        }
    }

    void _paint(Graphics g) {
        if (this.firstBlock != null) {
            this.do_paint(g, this.firstBlock);
            return;
        }
        int index = 0;
        int sz = this.children.size();
        while (index < sz) {
            PositionedBox rb = (PositionedBox)this.children.elementAt(index);
            if (rb.css.z_index >= 0) break;
            rb._paint(g);
            ++index;
        }
        if (!this.dummy) {
            this.do_paint(g, this);
        }
        while (index < sz) {
            PositionedBox rb = (PositionedBox)this.children.elementAt(index);
            rb._paint(g);
            ++index;
        }
    }

    private boolean _isVisible(CSSBox b) {
        while (b != null) {
            if (b.css.position != 124 && (b.css.misc & 1) == 0) {
                return false;
            }
            b = b.getParentBox();
        }
        return true;
    }

    private static void applyClippingFromParents(Graphics g, CSSBox b) {
        b = b.getParentBox();
        while (b != null) {
            CSSRect clip;
            if (b.css.position != 124 && (clip = b.css.clip) != null) {
                g.clipRect(b.ox + clip.left, b.oy + clip.top, clip.right - clip.left, clip.bottom - clip.top);
            }
            b = b.getParentBox();
        }
    }

    private boolean isClippedByParents(int x, int y, CSSBox b) {
        b = b.getParentBox();
        while (b != null) {
            CSSRect clip;
            if (b.css.position != 124 && (clip = b.css.clip) != null && (x < b.ox + clip.left || y < b.oy + clip.top || x >= b.ox + clip.right || y >= b.oy + clip.bottom)) {
                return true;
            }
            b = b.getParentBox();
        }
        return false;
    }

    void layout(CSSBox b) {
        if (b == null) {
            return;
        }
        if (!this.dummy || this.firstBlock != null) {
            if (this.css.position == 125) {
                this.layoutRelativeBox();
            } else if (this.css.position == 126) {
                this.layoutAbsoluteBox(b.width, b.height);
            }
        }
        if (this.firstBlock == null) {
            int i = 0;
            while (i < this.children.size()) {
                PositionedBox rb = (PositionedBox)this.children.elementAt(i);
                rb.layout(b);
                ++i;
            }
        }
    }

    CSSBox findCSSBox(DNode n) {
        if (this.firstBlock != null) {
            if (this.firstBlock.getDomNode() == n) {
                return this.firstBlock;
            }
            return null;
        }
        if (this.getDomNode() == n) {
            return this;
        }
        int i = 0;
        while (i < this.children.size()) {
            PositionedBox rb = (PositionedBox)this.children.elementAt(i);
            CSSBox b = rb.findCSSBox(n);
            if (b != null) {
                return b;
            }
            ++i;
        }
        return null;
    }

    PositionedBox findBox(CSSBox b) {
        if (this.firstBlock != null) {
            return null;
        }
        if (b == this) {
            return this;
        }
        PositionedBox rtrn = null;
        int i = 0;
        while (i < this.children.size()) {
            PositionedBox rb = (PositionedBox)this.children.elementAt(i);
            rtrn = rb.findBox(b);
            if (rtrn != null) break;
            ++i;
        }
        return rtrn;
    }

    void add(CSSBox b, CSSBox pb) {
        PositionedBox actualBox = null;
        if (!(b instanceof PositionedBox)) {
            actualBox = new PositionedBox(b, this.list);
        } else {
            actualBox = (PositionedBox)b;
            actualBox.list = this.list;
        }
        actualBox.setParentBox(pb);
        int i = 0;
        while (i < this.children.size()) {
            PositionedBox rb = (PositionedBox)this.children.elementAt(i);
            if (b.css.z_index < rb.css.z_index) {
                this.children.insertElementAt(actualBox, i);
                return;
            }
            ++i;
        }
        this.children.addElement(actualBox);
    }

    private void layoutRelativeBox() {
        CSSBox b = this.firstBlock != null ? this.firstBlock : this;
        int x = 0;
        int y = 0;
        if (b.css.left != -123456) {
            x = b.css.left;
        }
        if (b.css.right != -123456 && Math.abs(b.css.right) > Math.abs(x)) {
            x = -b.css.right;
        }
        if (b.css.top != -123456) {
            y = b.css.top;
        }
        if (b.css.bottom != -123456 && Math.abs(b.css.bottom) > Math.abs(y)) {
            y = -b.css.bottom;
        }
        if (b.getType() == 0) {
            InlineBox ib = (InlineBox)b;
            ib.relX = x;
            ib.relY = y;
        } else {
            Point p = new Point();
            p.x = b.ox;
            p.y = b.oy;
            if (b.parentBox != null) {
                b.parentBox.findAbsolutePosition(p);
            }
            b.ox = p.x + x;
            b.oy = p.y + y;
            if (b.parentBox == null || b.parentBox.minWidth == b.parentBox.maxWidth) {
                // empty if block
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void layoutAbsoluteBox(int totalWidth, int totalHeight) {
        block27: {
            b = this.firstBlock != null ? this.firstBlock : this;
            bbox = new Rectangle();
            containingBox = b.parentBox;
            if (containingBox != null) ** GOTO lbl9
            containingBox = this.parentBox;
            break block27;
            while (containingBox.css.position == 124 && containingBox.parentBox != null) {
                containingBox = containingBox.parentBox;
lbl9:
                // 2 sources

                if (containingBox != null) continue;
            }
        }
        containingBox.findBoundingBox(bbox);
        addX = 0;
        addY = 0;
        if (b instanceof PositionedBox) {
            pb = b;
            ps = pb.previousSibling;
            if (ps != null) {
                rec = new Rectangle();
                if (ps.getType() == 2) {
                    ps = ((FloatBox)ps).getBlock();
                }
                ps.findBoundingBox(rec);
                addY = rec.y - bbox.y + rec.height;
            }
        }
        left = 0;
        if (b.css.left != -123456) {
            left = PositionedBox.getValueOrPercentage(b.css.percentage_flag, 16, b.css.left, containingBox.width);
        }
        right = 0;
        if (b.css.right != -123456) {
            right = PositionedBox.getValueOrPercentage(b.css.percentage_flag, 131072, b.css.right, containingBox.width);
        }
        top = 0;
        if (b.css.top != -123456) {
            top = PositionedBox.getValueOrPercentage(b.css.percentage_flag, 524288, b.css.top, containingBox.width);
        }
        bottom = 0;
        if (b.css.bottom != -123456) {
            bottom = PositionedBox.getValueOrPercentage(b.css.percentage_flag, 4, b.css.bottom, containingBox.width);
        }
        width = 0;
        if (b.css.width != -123456) {
            width = PositionedBox.getValueOrPercentage(b.css.percentage_flag, 0x100000, b.css.width, containingBox.width);
        }
        height = 0;
        if (b.css.height != -123456) {
            height = PositionedBox.getValueOrPercentage(b.css.percentage_flag, 8, b.css.height, containingBox.width);
        }
        b.calcMinMaxWidths();
        widthOverhead = 0;
        heightOverhead = 0;
        if (this.css.width == -123456) {
            widthOverhead = left + right;
        }
        if (this.css.height == -123456) {
            heightOverhead = top + bottom;
        }
        if (b instanceof PositionedBox) {
            layoutWidth = containingBox.width;
            layoutHeight = containingBox.height;
            if (layoutWidth == 0 || layoutHeight == 0) {
                layoutWidth = totalWidth;
                layoutHeight = totalHeight;
            }
            layoutWidth -= widthOverhead;
            layoutHeight -= heightOverhead;
            if (b.css.width == -123456) {
                if (layoutWidth > b.maxWidth) {
                    layoutWidth = b.maxWidth;
                }
                if (layoutWidth < b.minWidth) {
                    layoutWidth = b.minWidth;
                }
            }
            ((PositionedBox)b).layout(layoutWidth, layoutHeight);
        } else {
            m = new FloatManager(0, width);
            b.layout(width, height, m);
            b.height += m.skipTill(width);
        }
        b.ox = containingBox.ox + addX;
        if (this.css.left != -123456) {
            b.ox += left;
        } else if (this.css.right != -123456) {
            b.ox += containingBox.width - right - (b.width + b.css.padding_right + b.css.border_right_width);
        }
        b.oy = containingBox.oy;
        b.oy = this.css.top != -123456 ? (b.oy += top) : (this.css.bottom != -123456 ? (b.oy += containingBox.height - bottom - b.height) : (b.oy += addY));
        if (height >= 0) {
            if (b.height > height) {
                if (top == -123456) {
                    b.oy -= b.height - height;
                }
            } else {
                b.height = height;
            }
        }
        if (b.ox + b.width > this.list.maxWidth) {
            this.list.maxWidth = b.ox + b.width;
        }
        if (b.oy + b.height > this.list.maxHeight) {
            this.list.maxHeight = b.oy + b.height;
        }
    }

    void dispose() {
        super.dispose();
        this.firstBlock = null;
        int i = 0;
        while (i < this.children.size()) {
            PositionedBox rb = (PositionedBox)this.children.elementAt(i);
            rb.dispose();
            ++i;
        }
        this.children.removeAllElements();
    }

    CSSBox getBoxAt(int ex, int ey, Point rv) {
        CSSBox b = this.floatPainter.getBoxAt(ex, ey, rv);
        if (b == null) {
            b = super.getBoxAt(ex, ey, rv);
        }
        return b;
    }

    void layout(int parentContentWidth, int parentContentHeight) {
        this.floatPainter.clear();
        FloatManager m = new FloatManager(0, parentContentWidth);
        super.layout(parentContentWidth, parentContentHeight, m);
        this.height += m.skipTill(parentContentWidth);
        CSSBox b = m.getFirstFloater();
        if (b != null) {
            this.floatPainter.add(b);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.floatPainter.paintNegativeZ_Indices(g);
        this.floatPainter.paintPositiveZ_Indices(g);
    }
}

