/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.dombase.LexBase;
import ice.pilots.html4.LexCallback;
import ice.pilots.html4.ProgressDetail;
import ice.util.encoding.CharIO;
import ice.util.io.LazyCachedInputStream;
import ice.util.io.MarkerInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

final class Lex2
extends LexBase {
    private String requestedEncoding;
    String curEncoding;
    private boolean lockedEncoding;
    private static int PRESCAN_BUFFER = 2048;
    private static final int CHAR_BUFFER_SIZE = 4096;
    private MarkerInputStream markerStream;
    private LazyCachedInputStream cachedStream;
    private final ProgressDetail progDet;

    private void $init$() {
        this.lockedEncoding = false;
        this.progDet = new ProgressDetail();
    }

    static {
        try {
            String encodingScanSize = System.getProperty("ice.browser.encodingScanSize");
            PRESCAN_BUFFER = Integer.parseInt(encodingScanSize);
        }
        catch (Throwable t) {
            PRESCAN_BUFFER = 2048;
        }
    }

    Lex2(LexCallback callback) {
        super(callback);
        this.$init$();
        this.char_buf = new char[4096];
    }

    void appendGeneratedContent(StringBuffer sb) {
        int n = sb.length();
        if (n != 0) {
            this.makeRoomForGeneratedContent(n);
            sb.getChars(0, n, this.char_buf, this.bufEnd);
            this.bufEnd += n;
        }
    }

    public void appendGeneratedContent(String s) {
        int n = s.length();
        if (n != 0) {
            this.makeRoomForGeneratedContent(n);
            s.getChars(0, n, this.char_buf, this.bufEnd);
            this.bufEnd += n;
        }
    }

    private void makeRoomForGeneratedContent(int spaceSize) {
        int new_end = this.bufEnd + spaceSize;
        int capacity = this.char_buf.length;
        if (new_end > capacity) {
            int length = this.bufEnd - this.mark;
            int new_length = length + spaceSize;
            if (new_length <= capacity) {
                System.arraycopy(this.char_buf, this.mark, this.char_buf, 0, length);
            } else {
                if (new_length > (capacity *= 2)) {
                    capacity = new_length;
                }
                char[] tmp = new char[capacity];
                System.arraycopy(this.char_buf, this.mark, tmp, 0, length);
                this.char_buf = tmp;
            }
            this.mark = 0;
            this.bufEnd = length;
        }
    }

    private void cleanUp() throws IOException {
        if (this.markerStream != null) {
            this.markerStream = null;
        }
        if (this.cachedStream != null) {
            this.cachedStream = null;
        }
    }

    public void close() throws IOException {
        this.cleanUp();
        super.close();
    }

    public int available() throws IOException {
        return this.markerStream.available();
    }

    public int read() throws IOException {
        return this.markerStream.read();
    }

    public int read(byte[] bytes) throws IOException {
        return this.markerStream.read(bytes);
    }

    public int read(byte[] array, int offset, int length) throws IOException {
        return this.markerStream.read(array, offset, length);
    }

    public long skip(long skipAmount) throws IOException {
        return this.markerStream.skip(skipAmount);
    }

    void setInputStream(InputStream in, String enc) {
        this.sourceInputStream = in;
        if (in instanceof MarkerInputStream) {
            this.markerStream = (MarkerInputStream)in;
        } else {
            this.cachedStream = new LazyCachedInputStream(in, PRESCAN_BUFFER);
            this.markerStream = new MarkerInputStream(this.cachedStream);
        }
        this.markerStream.mark();
        if (enc == null) {
            enc = CharIO.getDefaultEncoding();
        }
        this.changeEncoding(enc);
    }

    String getEncoding() {
        return this.curEncoding;
    }

    boolean applyEncodingChange(String newEncoding) {
        boolean result = false;
        if (!this.lockedEncoding && !newEncoding.equals(this.curEncoding) && this.sourceInputStream != null) {
            this.requestedEncoding = newEncoding;
            result = true;
        }
        return result;
    }

    void setLockedEncoding(boolean lockedEncoding) {
        this.lockedEncoding = lockedEncoding;
    }

    private void doEncodingChange(String newEncoding) {
        if (this.sourceInputStream != null) {
            block3: {
                this.changeEncoding(newEncoding);
                try {
                    this.markerStream.reset();
                }
                catch (IOException e) {
                    if (!Debug.ex) break block3;
                    Debug.ex(e);
                }
            }
            this.mark = 0;
            this.bufEnd = 0;
            this.lexerState = 0;
            this.done = false;
            this.inputReadProgress = 0;
            this.lineNumber = 0;
        }
    }

    private void changeEncoding(String enc) {
        Reader converter = CharIO.createInputStreamReader(this, enc = Lex2.cleanEncoding(enc));
        if (converter == null) {
            enc = "ISO8859_1";
            converter = CharIO.createInputStreamReader(this, enc);
        }
        if (converter instanceof InputStreamReader) {
            enc = ((InputStreamReader)converter).getEncoding();
        }
        this.curEncoding = enc;
        this.setReader(converter);
    }

    private static String cleanEncoding(String enc) {
        if (enc != null) {
            int len = enc.length();
            if (len == 0) {
                enc = null;
            } else {
                char c_0 = enc.charAt(0);
                char c_last = enc.charAt(len - 1);
                if (c_0 == '\"' || c_0 == '\'' || c_last == '\"' || c_last == '\'') {
                    int begin = c_0 == '\"' || c_0 == '\'' ? 1 : 0;
                    int end = c_last == '\"' || c_last == '\'' ? len - 1 : len;
                    enc = begin >= end ? null : enc.substring(begin, end);
                }
            }
        }
        return enc;
    }

    protected void restoreBuffer(char[] saved_buf, int saved_mark, int saved_bufEnd) {
        super.restoreBuffer(saved_buf, saved_mark, saved_bufEnd);
        if (this.lexerNestingLevel == 1 && this.requestedEncoding != null) {
            this.doEncodingChange(this.requestedEncoding);
            this.requestedEncoding = null;
        }
    }

    protected void readAtLeast(int minSize) throws IOException {
        int savedInputReadProgress = this.inputReadProgress;
        super.readAtLeast(minSize);
        this.progDet.length = this.inputReadProgress - savedInputReadProgress;
        this.progDet.startpos = this.bufEnd - this.progDet.length;
        this.progDet.buf = this.char_buf;
        this.progDet.enc = this.curEncoding;
        ((LexCallback)this.callback).progress(this.inputReadProgress, this.progDet);
    }
}

