/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.FramesDivider;
import ice.pilots.html4.FramesetInfo;
import ice.pilots.html4.ThePilot;
import ice.storm.Viewport;
import java.util.Vector;

class FramesetData {
    private ThePilot pilot;
    protected final Vector allFramesetInfos;
    FramesetInfo frameset;
    FramesetInfo curFrameset;

    private void $init$() {
        this.allFramesetInfos = new Vector();
        this.frameset = null;
        this.curFrameset = null;
    }

    FramesetData(ThePilot pilot) {
        this.$init$();
        this.pilot = pilot;
    }

    void dispose() {
        FramesetInfo fi = this.frameset;
        if (fi != null) {
            this.frameset = null;
            fi.dispose();
        }
    }

    void sendFramesetOnload() {
        DDocument doc = this.pilot.getDDocument();
        if (doc == null) {
            return;
        }
        int i = 0;
        int N = this.allFramesetInfos.size();
        while (i != N) {
            FramesetInfo fi = (FramesetInfo)this.allFramesetInfos.elementAt(i);
            doc.processEvent(13, fi.framesetElem);
            ++i;
        }
    }

    void layout(int x, int y, int w, int h) {
        if (this.frameset != null) {
            this.frameset.layout(x, y, w, h);
        }
    }

    void beginFrameset(DElement framesetElem, int[] colValues, int[] colTypes, int[] rowValues, int[] rowTypes, FramesDivider framesDivider, String parentViewportName) {
        int orientation = rowValues.length > 1 ? 1 : 2;
        FramesetInfo fi = new FramesetInfo(framesetElem, colValues, colTypes, rowValues, rowTypes, orientation);
        fi.setParentViewportName(parentViewportName);
        this.allFramesetInfos.addElement(fi);
        if (this.frameset == null) {
            this.curFrameset = this.frameset = fi;
        } else if (this.curFrameset.canAddChild()) {
            framesDivider.setFramesetInfo(this.curFrameset);
            this.curFrameset.addChild(fi, framesDivider);
            this.curFrameset = fi;
        }
    }

    void updateFramesetInfo(DElement framesetElem, int[] colValues, int[] colTypes, int[] rowValues, int[] rowTypes) {
        if (this.allFramesetInfos != null) {
            int i = 0;
            int N = this.allFramesetInfos.size();
            while (i != N) {
                FramesetInfo fi = (FramesetInfo)this.allFramesetInfos.elementAt(i);
                if (fi.framesetElem == framesetElem) {
                    fi.upDateSizes(colValues, colTypes, rowValues, rowTypes);
                }
                ++i;
            }
        }
    }

    void endFrameset() {
        if (this.curFrameset != null) {
            this.curFrameset = this.curFrameset.getParent();
        }
    }

    boolean addFramesetChild(Viewport v, FramesDivider f) {
        FramesetInfo fi = this.curFrameset;
        if (fi == null) {
            return false;
        }
        if (fi.canAddChild()) {
            fi.addChild(v, f);
            f.setFramesetInfo(fi);
            return true;
        }
        return false;
    }
}

