/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.FontProvider;
import ice.pilots.html4.JavaFontProvider;
import ice.util.Defs;
import ice.util.alg.CharKit;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class FontCache {
    private static String defaultFontFamily = "Serif";
    private static int baseFontSize = 9;
    private static final int defaultFontStyle = 0;
    static int minFontSize = 4;
    private Font fallbackFont;
    private float DPI;
    private static final int MAX_ISO8859_1_CHAR = 255;
    private boolean messageShown;
    private int fontCreations;
    private int cacheFetches;
    private int localCacheResets;
    private final int[] fontMuls;
    private Hashtable fontMetricsCache;
    private int LOCAL_FONT_CACHE_SIZE;
    private Font[] localCache;
    private boolean traceFonts;
    private FontProvider[] fontProviders;
    private static Graphics _printGraphics;

    private void $init$() {
        this.DPI = 120.0f;
        this.fontMuls = new int[]{256, 307, 369, 442, 531, 637, 764, 850};
        this.fontMetricsCache = new Hashtable();
        this.LOCAL_FONT_CACHE_SIZE = 5;
        this.localCache = new Font[this.LOCAL_FONT_CACHE_SIZE];
        this.traceFonts = Debug.trace && Defs.sysPropertyBoolean("ice.pilots.html4.traceFonts");
    }

    public FontCache() {
        this.$init$();
        this.init();
    }

    private void traceFonts(String[] families) {
        int N = families.length;
        StringBuffer sb = new StringBuffer();
        sb.append("Known families: " + N);
        int i = 0;
        while (i != N) {
            sb.append("\n\t");
            sb.append(families[i]);
            ++i;
        }
        if (Debug.trace) {
            Debug.trace(sb.toString());
        }
    }

    private void traceFontMetrics(FontMetrics fm) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n\tfont: ");
        sb.append(fm.getFont().toString());
        sb.append("\n\tascent: ");
        sb.append(fm.getAscent());
        sb.append(", descent: ");
        sb.append(fm.getDescent());
        sb.append(", height: ");
        sb.append(fm.getHeight());
        sb.append(", max-ascent: ");
        sb.append(fm.getMaxAscent());
        sb.append(", max-descent: ");
        sb.append(fm.getMaxDescent());
        sb.append("\n\tmax-advance: ");
        sb.append(fm.getMaxAdvance());
        sb.append(", test-width: ");
        sb.append(fm.stringWidth("Hello, world!"));
        if (Debug.trace) {
            Debug.trace(sb.toString());
        }
    }

    void init() {
        FontProvider prov;
        try {
            int t = Toolkit.getDefaultToolkit().getScreenResolution();
            this.DPI = t;
        }
        catch (Exception ex) {
            this.DPI = 120.0f;
        }
        String temp = Defs.sysProperty("ice.pilots.html4.addonFontProviders", "JavaVM");
        boolean javaAdded = false;
        Vector<JavaFontProvider> providers = new Vector<JavaFontProvider>();
        if (temp != null) {
            StringTokenizer st = new StringTokenizer(temp, ",");
            while (st.hasMoreTokens()) {
                temp = st.nextToken();
                if ("JavaVM".equalsIgnoreCase(temp)) {
                    prov = new JavaFontProvider();
                    providers.addElement((JavaFontProvider)prov);
                    javaAdded = true;
                    continue;
                }
                try {
                    prov = (FontProvider)Class.forName(temp).newInstance();
                    if (Debug.trace) {
                        Debug.trace("FontProvider instance loaded: " + temp);
                    }
                    providers.addElement((JavaFontProvider)prov);
                }
                catch (Exception e) {
                    if (!Debug.trace) continue;
                    Debug.trace("Exception loading FontProvider: " + temp + ", ex: " + e);
                }
            }
        }
        if (!javaAdded) {
            prov = new JavaFontProvider();
            providers.addElement((JavaFontProvider)prov);
        }
        this.fontProviders = new FontProvider[providers.size()];
        int idx = 0;
        while (idx < this.fontProviders.length) {
            this.fontProviders[idx] = (FontProvider)providers.elementAt(idx);
            ++idx;
        }
    }

    public Font getTestedFont(char[] text, int start, int limit, CSSAttribs css) {
        Font f = null;
        FontMetrics fm = null;
        if (css != null && this.canDisplay(f = (fm = this.getFontMetrics(css.font_family, css.font_style, css.font_size)).getFont(), text, start, limit)) {
            return f;
        }
        int fdx = 0;
        while (fdx < this.localCache.length) {
            f = this.localCache[fdx];
            if (f != null && this.canDisplay(f, text, start, limit)) {
                css.font_family = f.getFamily();
                f = this.getFontMetrics(css.font_family, css.font_style, css.font_size).getFont();
                return f;
            }
            ++fdx;
        }
        int idx = 0;
        while (idx < this.fontProviders.length) {
            String[] families = this.fontProviders[idx].getFontFamilies();
            int i = 0;
            while (i < families.length) {
                f = this.fontProviders[idx].getFont(families[i], css.font_style, css.font_size);
                if (f != null && this.canDisplay(f, text, start, limit)) {
                    fm = this.fontProviders[idx].getFontMetrics(f);
                    this.addToFontMetricsCache(families[i], css.font_style, css.font_size, fm);
                    this.addToLocalFamilyCache(f);
                    css.font_family = families[i];
                    return f;
                }
                ++i;
            }
            ++idx;
        }
        if (this.fallbackFont == null) {
            f = this.loadFailureFont(css.font_family, css.font_size, css.font_style);
        } else {
            f = this.fallbackFont;
            css.font_family = defaultFontFamily;
        }
        if (Debug.trace) {
            // empty if block
        }
        return f;
    }

    public Font getTestedFont(String text, CSSAttribs css) {
        Font f = null;
        FontMetrics fm = this.getFontMetrics(css.font_family, css.font_style, css.font_size);
        f = fm.getFont();
        if (this.canDisplay(f, text)) {
            return f;
        }
        int fdx = 0;
        while (fdx < this.localCache.length) {
            f = this.localCache[fdx];
            if (f != null && this.canDisplay(f, text)) {
                css.font_family = this.getSupportedFontFamily(f.getFamily());
                f = this.getFontMetrics(css.font_family, css.font_style, css.font_size).getFont();
                return f;
            }
            ++fdx;
        }
        int idx = 0;
        while (idx < this.fontProviders.length) {
            String[] families = this.fontProviders[idx].getFontFamilies();
            int i = 0;
            while (i < families.length) {
                f = this.fontProviders[idx].getFont(families[i], css.font_style, css.font_size);
                if (f != null && this.canDisplay(f, text)) {
                    fm = this.fontProviders[idx].getFontMetrics(f);
                    this.addToFontMetricsCache(families[i], css.font_style, css.font_size, fm);
                    this.addToLocalFamilyCache(f);
                    css.font_family = families[i];
                    return f;
                }
                ++i;
            }
            ++idx;
        }
        if (this.fallbackFont == null) {
            f = this.loadFailureFont(css.font_family, css.font_size, css.font_style);
        } else {
            f = this.fallbackFont;
            css.font_family = defaultFontFamily;
        }
        if (Debug.trace) {
            // empty if block
        }
        return f;
    }

    private Font loadFailureFont(String family, int size, int style) {
        Font returnVal = null;
        int idx = 0;
        while (idx < this.fontProviders.length) {
            returnVal = this.fontProviders[idx].getFont(family, style, size);
            if (returnVal != null) {
                return returnVal;
            }
            ++idx;
        }
        Debug.trace("No FontProvider able to load the fallback font family: " + family);
        return null;
    }

    private boolean canDisplay(Font f, char[] text, int start, int length) {
        try {
            Class<?> c = f.getClass();
            Class[] classArray = new Class[]{text.getClass(), Integer.TYPE, Integer.TYPE};
            Method m = c.getMethod("canDisplayUpTo", classArray);
            Object[] objArray = new Object[]{text, new Integer(start), new Integer(length)};
            Object res = m.invoke((Object)f, objArray);
            int i = (Integer)res;
            if (i == -1) {
                boolean bl = true;
                return bl;
            }
            if (i == length - start) {
                boolean bl = true;
                return bl;
            }
            int idx = i;
            while (idx < length) {
                if (text[idx] > '\u00ff') {
                    boolean bl = false;
                    return bl;
                }
                ++idx;
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            if (Debug.trace && !this.messageShown) {
                Debug.p("canDisplay Exception in char[] Introspection test, One warning only, continuing... ");
                this.messageShown = true;
            }
            boolean bl = true;
            return bl;
        }
    }

    private boolean canDisplay(Font f, String text) {
        try {
            Class<?> c = f.getClass();
            Class[] classArray = new Class[]{text.getClass()};
            Method m = c.getMethod("canDisplayUpTo", classArray);
            Object[] objArray = new Object[]{text};
            Object res = m.invoke((Object)f, objArray);
            int i = (Integer)res;
            if (i == -1) {
                boolean bl = true;
                return bl;
            }
            if (i == text.length()) {
                boolean bl = true;
                return bl;
            }
            int idx = i;
            while (idx < text.length()) {
                char chr = text.charAt(idx);
                if (chr > '\u00ff') {
                    boolean bl = false;
                    return bl;
                }
                ++idx;
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            if (Debug.trace && !this.messageShown) {
                Debug.p("canDisplay Exception in String introspection test, One warning only, continuing...  ");
                this.messageShown = true;
            }
            boolean bl = true;
            return bl;
        }
    }

    private void addToLocalFamilyCache(Font f) {
        String fam = f.getFamily();
        int idx = 0;
        while (idx < this.localCache.length) {
            if (this.localCache[idx] != null) {
                if (fam.equals(this.localCache[idx].getFamily())) {
                    return;
                }
            } else {
                this.localCache[idx] = f;
                return;
            }
            ++idx;
        }
        ++this.localCacheResets;
        this.localCache = new Font[this.LOCAL_FONT_CACHE_SIZE];
        this.localCache[0] = f;
    }

    float getScreenResolution() {
        return this.DPI;
    }

    public String getDefaultFontFamily() {
        return defaultFontFamily;
    }

    String getSupportedFontFamily(String listOfNames) {
        if (listOfNames.equals("")) {
            return defaultFontFamily;
        }
        StringTokenizer st = new StringTokenizer(listOfNames, ",");
        while (st.hasMoreTokens()) {
            String fontFamily = st.nextToken().trim();
            if (fontFamily.startsWith("\"") || fontFamily.startsWith("'")) {
                fontFamily = fontFamily.substring(1, fontFamily.length());
            }
            if (fontFamily.endsWith("\"") || fontFamily.endsWith("'")) {
                fontFamily = fontFamily.substring(0, fontFamily.length() - 1);
            }
            if (!this.fontFamilySupported(fontFamily = fontFamily.trim())) continue;
            return fontFamily;
        }
        return defaultFontFamily;
    }

    private boolean fontFamilySupported(String fname) {
        int idx = 0;
        while (idx < this.fontProviders.length) {
            if (this.fontProviders[idx].isFamilySupported(fname)) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public static void setPrintGraphics(Graphics g) {
        _printGraphics = g;
    }

    FontMetrics getFontMetrics(String fontFamily, int fontStyle, int fontSize) {
        Font printerFont;
        FontMetrics printerMetrics;
        FontMetrics fm = null;
        if (_printGraphics != null && (printerMetrics = _printGraphics.getFontMetrics(printerFont = this.loadNewFont(fontFamily, fontStyle, fontSize, false))) != null) {
            return printerMetrics;
        }
        String key = this.getKey(fontFamily, fontStyle, fontSize);
        fm = (FontMetrics)this.fontMetricsCache.get(key);
        if (fm == null) {
            ++this.cacheFetches;
            this.loadNewFont(fontFamily, fontStyle, fontSize, true);
            fm = (FontMetrics)this.fontMetricsCache.get(key);
            ++this.fontCreations;
        } else {
            ++this.cacheFetches;
        }
        return fm;
    }

    private Font loadNewFont(String fontFamily, int fontStyle, int fontSize, boolean addFontMetrics) {
        Font f = null;
        FontMetrics fm = null;
        int idx = 0;
        while (idx < this.fontProviders.length) {
            if (this.fontProviders[idx].isFamilySupported(fontFamily) && (f = this.fontProviders[idx].getFont(fontFamily, fontStyle, fontSize)) != null) {
                if (addFontMetrics) {
                    fm = this.fontProviders[idx].getFontMetrics(f);
                    if (this.traceFonts) {
                        this.traceFontMetrics(fm);
                    }
                    this.addToFontMetricsCache(fontFamily, fontStyle, fontSize, fm);
                }
                return f;
            }
            ++idx;
        }
        return this.fallbackFont;
    }

    private void addToFontMetricsCache(String fontFamily, int fontStyle, int fontSize, FontMetrics fontMetrics) {
        String key = this.getKey(fontFamily, fontStyle, fontSize);
        this.fontMetricsCache.put(key, fontMetrics);
    }

    public void clear() {
        this.fontMetricsCache.clear();
    }

    void setBaseFontFamily(String fontFamily) {
        defaultFontFamily = new String(fontFamily);
        this.loadDefault();
    }

    void setBaseFontSize(int t) {
        baseFontSize = t;
        this.loadDefault();
    }

    void setMinFontSize(int t) {
        minFontSize = t;
        this.loadDefault();
    }

    private void loadDefault() {
        this.fallbackFont = new Font(defaultFontFamily, 0, baseFontSize);
    }

    int getFontSizeAbs(int fontLevel, int zoom) {
        if (fontLevel < 0) {
            fontLevel = 0;
        } else if (fontLevel > 7) {
            fontLevel = 7;
        }
        fontLevel = baseFontSize * this.fontMuls[fontLevel] >> 8;
        if (zoom != 256 && (fontLevel = fontLevel * zoom >> 8) < minFontSize) {
            fontLevel = minFontSize;
        }
        return fontLevel;
    }

    int getFontSizeRel(int fontLevel, int prevSize) {
        if (fontLevel == 0) {
            return prevSize;
        }
        if (fontLevel < 0) {
            while (fontLevel < 0) {
                prevSize = prevSize * 256 / 307;
                ++fontLevel;
            }
        } else if (fontLevel > 0) {
            while (fontLevel > 0) {
                prevSize = prevSize * 307 >> 8;
                --fontLevel;
            }
        }
        if (prevSize < minFontSize) {
            prevSize = minFontSize;
        }
        return prevSize;
    }

    private String getKey(String fontFamily, int fontStyle, int fontSize) {
        StringBuffer sb = new StringBuffer(CharKit.toLowerCase(fontFamily)).append("_").append(fontStyle).append("_").append(fontSize);
        return sb.toString();
    }
}

