/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DAreaElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DHrefElement;
import ice.pilots.html4.DImageElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.DefaultEventHandler;
import ice.pilots.html4.DirectionFocusManager;
import ice.pilots.html4.DocPaneXml;
import ice.pilots.html4.FocusExitHandler;
import ice.pilots.html4.FocusManager;
import ice.pilots.html4.ScrollHandler;
import ice.pilots.html4.SmoothScrollHandler;
import ice.pilots.html4.ThePilot;
import ice.storm.DocPane;
import ice.util.Defs;
import ice.util.JavaVersion;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.lang.reflect.Method;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

class DefaultActionHandler
implements DefaultEventHandler {
    static final int KEY_TAB = 9;
    static final int KEY_SHIFTTAB = 411;
    static final int KEY_HELP = 112;
    static final int KEY_ACTION = 32;
    static final int KEY_SUBMIT = 10;
    static final int KEY_SUBMIT2 = 13;
    static final int KEY_UP = 38;
    static final int KEY_DOWN = 40;
    static final int KEY_LEFT = 37;
    static final int KEY_RIGHT = 39;
    static final int KEY_PGDOWN = 34;
    static final int KEY_PGUP = 33;
    static final int KEY_END = 35;
    static final int KEY_HOME = 36;
    static final int ZOOM_FACTOR = 16;
    ThePilot pilot;
    FocusManager focusManager;
    FocusExitHandler focusExitHandler;
    ScrollHandler scrollHandler;
    private static boolean applicationClipboardPresent;
    private DNode lastNode;
    private boolean shouldScrollOnly;
    private boolean shouldFocusOnly;
    private long previousTabAction;
    public static final String ACCESSIBILTIY_NONE = "none";
    public static final String ACCESSIBILTIY_JAVA = "java";
    public static final String ACCESSIBILTIY_JAWS = "jaws";
    static String accessibility;
    static boolean isAccessible;

    private void $init$() {
        this.focusExitHandler = null;
        this.shouldScrollOnly = false;
        this.shouldFocusOnly = false;
        this.previousTabAction = -1;
    }

    static {
        Toolkit t = Toolkit.getDefaultToolkit();
        Class<Toolkit> toolkitClass = Toolkit.class;
        Object[] mArgs = new Class[]{};
        try {
            Method clipMethod = toolkitClass.getMethod("getSystemSelection", (Class<?>[])mArgs);
            Clipboard clippy = (Clipboard)clipMethod.invoke((Object)t, mArgs);
            if (clippy != null) {
                applicationClipboardPresent = true;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        accessibility = ACCESSIBILTIY_NONE;
        isAccessible = false;
        accessibility = Defs.sysProperty("ice.pilots.html4.swing.accessible", ACCESSIBILTIY_JAWS);
        if (accessibility.equalsIgnoreCase(ACCESSIBILTIY_JAVA) || accessibility.equalsIgnoreCase(ACCESSIBILTIY_JAWS)) {
            isAccessible = true;
        }
    }

    DefaultActionHandler(ThePilot pilot) {
        this.$init$();
        this.pilot = pilot;
        CSSLayout cssLayout = pilot.getCSSLayout();
        String focusMode = Defs.sysProperty("ice.browser.directionFocus");
        this.focusManager = focusMode != null && focusMode.equalsIgnoreCase("true") ? new DirectionFocusManager(pilot.getDDocument(), cssLayout, pilot) : new FocusManager(pilot.getDDocument(), cssLayout, pilot);
        cssLayout.setFocusManager(this.focusManager);
        String scrollMode = Defs.sysProperty("ice.browser.scroll");
        this.scrollHandler = scrollMode != null && scrollMode.equalsIgnoreCase("smooth") ? new SmoothScrollHandler(pilot) : new ScrollHandler(pilot);
    }

    private void copySelectedToClipboard() {
        String str = this.pilot.getSelectedText();
        if (str != null && str.length() > 0) {
            Clipboard cl = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection sel = new StringSelection(str);
            cl.setContents(sel, sel);
        }
    }

    protected boolean isTabKey(long key) {
        return key == (long)9;
    }

    protected boolean isActionKey(long key) {
        return key == (long)32;
    }

    protected boolean isFormSubmitKey(long key) {
        return key == (long)10 || key == (long)13;
    }

    protected boolean isDirectionKey(long key) {
        return key == (long)38 || key == (long)40 || key == (long)37 || key == (long)39;
    }

    protected boolean isZoomKey(long key) {
        return key == (long)48 || key == (long)96 || key == (long)107 || key == (long)61 || key == (long)109 || key == (long)45;
    }

    protected boolean scrollOnly() {
        return this.shouldScrollOnly;
    }

    protected boolean focusOnly() {
        return this.shouldFocusOnly;
    }

    private void changeZoom(int factor) {
        CSSLayout cssLayout = this.pilot.getCSSLayout();
        cssLayout.setLayoutZoom(cssLayout.getLayoutZoom() + factor);
    }

    private void resetZoom() {
        this.pilot.getCSSLayout().setLayoutZoom(256);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleEvent(Event domEvent) {
        DOMEvent de = (DOMEvent)domEvent;
        if (de.isDefaultDone()) {
            return;
        }
        EventListener eventAction = de.getAction();
        if (eventAction != null) {
            eventAction.handleEvent(de);
            if (de.isDefaultDone()) {
                return;
            }
        }
        if (de instanceof DOMUIEvent) {
            this.shouldScrollOnly = ((DOMUIEvent)de).isShortcutKey();
        }
        DNode target = de.target;
        switch (de.typeId) {
            case 5: {
                this.updateCursor(target);
            }
            case 1: 
            case 6: 
            case 7: {
                DOMUIEvent deu = (DOMUIEvent)de;
                if (deu.isPopupTrigger) {
                    DDocument doc = this.pilot.getDDocument();
                    DOMUIEvent popup = (DOMUIEvent)doc.createDOMEvent(24);
                    popup.copyUIDataFrom(de);
                    de.stopPropagation();
                    de.preventDefault();
                    target.dispatchEvent(popup);
                    return;
                }
                while (true) {
                    if (target == null) {
                        return;
                    }
                    int tag = target.tagId;
                    if (tag == 1 || tag == 6) {
                        this.handleDefaultActionOnLinks(deu, (DElement)target);
                        return;
                    }
                    if (!(deu.isMousePressPopupTrigger || deu.typeId != 1 || tag != 15 && tag != 47)) {
                        target.dispatchEvent(deu);
                        return;
                    }
                    target = DDocument.getEventChainParent(target, de);
                }
            }
            case 3: {
                DInputElement dei;
                String type;
                DNode tmp = target;
                while (tmp != null) {
                    if (tmp.getNameId() == 15) {
                        target = tmp;
                        break;
                    }
                    tmp = (DNode)tmp.getParentNode();
                }
                tmp = target;
                while (!(tmp == null || tmp instanceof DElement && ((DElement)tmp).isFocusable())) {
                    tmp = DDocument.getEventChainParent(tmp, de);
                }
                this.focusManager.setFocusedBox(tmp);
                DOMUIEvent deu = (DOMUIEvent)de;
                if (target != null && deu.isPopupTrigger) {
                    DDocument doc = this.pilot.getDDocument();
                    DOMUIEvent popup = (DOMUIEvent)doc.createDOMEvent(24);
                    popup.copyUIDataFrom(de);
                    de.stopPropagation();
                    de.preventDefault();
                    target.dispatchEvent(popup);
                }
                if (target == null) return;
                boolean isDeselectionTarget = false;
                if (target.getNameId() == 82) {
                    isDeselectionTarget = true;
                } else if (target.getNameId() == 47 && ((type = (dei = (DInputElement)target).getType()).equals("text") || type.equals("password"))) {
                    isDeselectionTarget = true;
                }
                if (!isDeselectionTarget) return;
                if (applicationClipboardPresent) return;
                this.pilot.getCSSLayout().clearSelection();
                return;
            }
            case 4: {
                DNode relatedNode;
                DNode body;
                DOMUIEvent deu = (DOMUIEvent)de;
                if (!deu.isPopupTrigger) {
                    if (deu.isMousePressPopupTrigger) {
                        return;
                    }
                    if (deu.getMouseButtons() == 4) {
                        return;
                    }
                }
                if ((body = this.convertTargetToBody(target, relatedNode = (DNode)deu.getRelatedNode())) != null) {
                    target = relatedNode = body;
                }
                DNode tmp = target;
                while (tmp != null) {
                    if (tmp.getNameId() == 15) {
                        relatedNode = target = tmp;
                        break;
                    }
                    tmp = (DNode)tmp.getParentNode();
                }
                if (relatedNode != target) return;
                int clickId = 1;
                int clickCounter = deu.getDetail();
                if ((clickCounter & 1) == 0) {
                    clickId = 2;
                }
                DDocument doc = this.pilot.getDDocument();
                DOMUIEvent click = (DOMUIEvent)doc.createDOMEvent(clickId);
                click.copyUIDataFrom(de);
                target.dispatchEvent(click);
                return;
            }
            case 9: {
                this.onKeyDown((DOMUIEvent)de);
                return;
            }
            case 10: {
                this.onKeyUp((DOMUIEvent)de);
                return;
            }
            case 8: {
                this.onKeyPress((DOMUIEvent)de);
                return;
            }
            case 21: {
                this.onFocus((DOMUIEvent)de);
                return;
            }
            case 22: {
                this.onBlur((DOMUIEvent)de);
                return;
            }
        }
    }

    private DNode convertTargetToBody(DNode target, DNode relatedNode) {
        if (relatedNode != null && relatedNode.getNameId() == 43) {
            DNode child = relatedNode.first;
            while (child != null) {
                if (child.getNameId() == 13) {
                    return child;
                }
                child = child.next;
            }
        }
        return null;
    }

    private void updateCursor(DNode node) {
        DAreaElement area;
        if (this.lastNode == node) {
            return;
        }
        DocPane pane = this.pilot.getDocPane();
        if (pane == null) {
            return;
        }
        this.lastNode = node;
        CSSLayout layout = this.pilot.getCSSLayout();
        CSSBox cssBox = layout.findCSSBox(node);
        if (cssBox != null && cssBox.css.cursor > -1) {
            return;
        }
        if (node instanceof DTextNode) {
            while (node != null && !(node instanceof DDocument)) {
                DHrefElement hrefNode;
                if ((node = node.getParentDNode()) instanceof DHrefElement && (hrefNode = (DHrefElement)node).getAttribute(46) != null) {
                    pane.setCursor(12);
                    return;
                }
                if (!(node instanceof DInputElement)) continue;
                DInputElement inputElement = (DInputElement)node;
                if (inputElement.getType().equals("button")) {
                    pane.setCursor(0);
                }
                return;
            }
            if (((DocPaneXml)pane).enableTextSelection) {
                pane.setCursor(2);
            }
            return;
        }
        if (node != null && node instanceof DAreaElement && (area = (DAreaElement)node).getHref() != null) {
            pane.setCursor(12);
            return;
        }
        pane.setCursor(0);
    }

    private DNode getButtonBox(DNode n) {
        while (n != null && n.getNameId() != 13) {
            if (n.getNameId() == 15) {
                return n;
            }
            n = (DNode)n.getParentNode();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onKeyDown(DOMUIEvent de) {
        if (de.isDefaultCancelled()) {
            return;
        }
        long chr = de.getKeyCode();
        if (this.isTabKey(chr) && !de.getCtrlKey()) {
            DInputElement focusElement;
            String type;
            if (this.previousTabAction == chr + (long)(de.getShiftKey() ? 1 : 0) && this.focusManager.getFocusedElement() == null) {
                this.previousTabAction = -1;
                if (!JavaVersion.isV14orGreater()) return;
                if (de.getShiftKey()) {
                    this.focusManager.previousExternalFocus();
                    return;
                } else {
                    this.focusManager.nextExternalFocus();
                }
                return;
            }
            this.previousTabAction = chr + (long)(de.getShiftKey() ? 1 : 0);
            int itmp = de.getShiftKey() ? this.focusManager.previousFocus() : this.focusManager.nextFocus();
            if (itmp != -1) {
                this.pilot.getCSSLayout().clearSelection();
            }
            boolean handled = false;
            if (this.focusExitHandler != null && itmp == -1) {
                handled = de.getShiftKey() ? this.focusExitHandler.focusExit(411) : this.focusExitHandler.focusExit(9);
            }
            if (handled) {
                this.focusManager.setFocusedBox(null);
                de.preventDefault();
            } else {
                this.focusManager.setFocusedBox(itmp);
                de.preventDefault();
            }
            DNode focusNode = this.focusManager.getFocusedElement();
            if (focusNode == null || !(focusNode instanceof DInputElement) || !(type = (focusElement = (DInputElement)focusNode).getType()).equals("text")) return;
            focusElement.select();
            return;
        }
        if (this.isActionKey(chr)) {
            String tt;
            DNode dnode = this.focusManager.getFocusedElement();
            if (dnode == null) {
                this.scrollHandler.scrollRequest(34);
                return;
            }
            int tmp = dnode.getNameId();
            if (tmp == 1) {
                this.scrollHandler.scrollRequest(34);
                return;
            }
            if (tmp == 71) {
                return;
            }
            if (tmp == 82) {
                return;
            }
            if (tmp == 47 && ((tt = ((DInputElement)dnode).getType()) == null || tt.equalsIgnoreCase("text") || tt.equalsIgnoreCase("password"))) {
                return;
            }
            this.doAction(dnode);
            de.preventDefault();
        }
        if (this.isDirectionKey(chr) && !de.getShiftKey()) {
            if (de.getAltKey() || !this.doDirectionKey((int)chr)) return;
            de.preventDefault();
            return;
        }
        if (this.isZoomKey(chr)) {
            if (Defs.booleanProperty("ice.pilots.html4.disableZoomKeys", false)) return;
            switch ((int)chr) {
                case 48: 
                case 96: {
                    if (!de.isShortcutKey()) return;
                    this.resetZoom();
                    de.preventDefault();
                    return;
                }
                case 107: {
                    if (!de.isShortcutKey() || de.getCtrlKey()) return;
                    this.changeZoom(16);
                    de.preventDefault();
                    return;
                }
                case 61: {
                    if (!de.isShortcutKey()) return;
                    this.changeZoom(16);
                    de.preventDefault();
                    return;
                }
                case 109: {
                    if (!de.isShortcutKey() || de.getCtrlKey()) return;
                    this.changeZoom(-16);
                    de.preventDefault();
                    return;
                }
                case 45: {
                    if (!de.isShortcutKey()) return;
                    this.changeZoom(-16);
                    de.preventDefault();
                    return;
                }
            }
            return;
        }
        if (de.getObjectPainter() != null) {
            return;
        }
        if (!this.scrollAction((int)chr)) {
            switch ((int)chr) {
                case 67: 
                case 88: 
                case 155: {
                    if (!de.isShortcutKey()) return;
                    this.copySelectedToClipboard();
                    de.preventDefault();
                    return;
                }
                case 65: {
                    if (!((DocPaneXml)this.pilot.getDocPane()).enableTextSelection || !de.isShortcutKey()) return;
                    this.pilot.getCSSLayout().selectAll();
                    de.preventDefault();
                    return;
                }
                case 39: {
                    if (!((DocPaneXml)this.pilot.getDocPane()).enableTextSelection) return;
                    if (de.getCtrlKey() && de.getShiftKey()) {
                        this.pilot.getCSSLayout().selectWordRight();
                        this.pilot.getCSSLayout().postSelectedToClipboard();
                        de.preventDefault();
                        return;
                    }
                    if (!de.getShiftKey()) return;
                    this.pilot.getCSSLayout().selectCharRight();
                    this.pilot.getCSSLayout().postSelectedToClipboard();
                    de.preventDefault();
                    return;
                }
                case 37: {
                    if (!((DocPaneXml)this.pilot.getDocPane()).enableTextSelection) return;
                    if (de.getCtrlKey() && de.getShiftKey()) {
                        this.pilot.getCSSLayout().selectWordLeft();
                        this.pilot.getCSSLayout().postSelectedToClipboard();
                        de.preventDefault();
                        return;
                    }
                    if (!de.getShiftKey()) return;
                    this.pilot.getCSSLayout().selectCharLeft();
                    this.pilot.getCSSLayout().postSelectedToClipboard();
                    de.preventDefault();
                    return;
                }
                case 38: {
                    if (((DocPaneXml)this.pilot.getDocPane()).enableTextSelection) {
                        if (!de.getShiftKey()) return;
                        this.pilot.getCSSLayout().selectSentenceLeft();
                        this.pilot.getCSSLayout().postSelectedToClipboard();
                        de.preventDefault();
                        return;
                    }
                }
                case 40: {
                    if (!((DocPaneXml)this.pilot.getDocPane()).enableTextSelection || !de.getShiftKey()) return;
                    this.pilot.getCSSLayout().selectSentenceRight();
                    this.pilot.getCSSLayout().postSelectedToClipboard();
                    de.preventDefault();
                }
                default: {
                    return;
                }
            }
        } else {
            de.preventDefault();
        }
    }

    protected boolean doDirectionKey(int dir) {
        if (isAccessible) {
            return false;
        }
        if (!this.scrollOnly() && this.focusManager.localDFM(dir)) {
            return true;
        }
        if (!this.focusOnly() && this.scrollHandler.scrollRequest(dir)) {
            return true;
        }
        if (this.focusExitHandler != null) {
            boolean retval = this.focusExitHandler.focusExit(dir);
            if (retval) {
                this.focusManager.setFocusedBox(null);
            }
            return retval;
        }
        return !this.scrollOnly() && this.focusManager.globalDFM(dir);
    }

    private void processFormSubmitKey(DOMUIEvent de) {
        DNode dnode = this.focusManager.getFocusedElement();
        if (dnode == null) {
            return;
        }
        if (dnode instanceof DInputElement) {
            DInputElement in = (DInputElement)dnode;
            String tt = in.getType();
            if (tt.equalsIgnoreCase("text") || tt.equalsIgnoreCase("password")) {
                DFormElement form = in.getDForm();
                if (form != null && form.submitUsingSubmitkey()) {
                    de.preventDefault();
                }
            } else if (tt.equalsIgnoreCase("button") || tt.equalsIgnoreCase("submit") || tt.equalsIgnoreCase("image") || tt.equalsIgnoreCase("reset")) {
                this.doAction(dnode);
                de.preventDefault();
            }
        } else if (dnode instanceof DHrefElement) {
            this.doAction(dnode);
            de.preventDefault();
        }
    }

    private void onKeyPress(DOMUIEvent de) {
        if (de.isDefaultCancelled()) {
            return;
        }
        long chr = de.getKeyCode();
        if (JavaVersion.isV12orGreater() && this.isFormSubmitKey(chr)) {
            this.processFormSubmitKey(de);
            return;
        }
        if (de.getAltKey()) {
            chr = de.getCharCode();
            if (!de.getShiftKey() && chr >= (long)65 && chr <= (long)93) {
                chr -= (long)32;
            }
            if (this.focusManager.processAccessKey(chr)) {
                de.preventDefault();
            }
        }
    }

    private void onKeyUp(DOMUIEvent de) {
        if (de.isDefaultCancelled()) {
            return;
        }
        long chr = de.getKeyCode();
        if (!JavaVersion.isV12orGreater() && this.isFormSubmitKey(chr)) {
            this.processFormSubmitKey(de);
            return;
        }
    }

    private void onFocus(DOMUIEvent de) {
        DocPane dp = this.pilot.getDocPane();
        Rectangle box = new Rectangle();
        this.pilot.getView().findBoundingBox((DNode)de.getTarget(), box);
        Point p = new Point();
        this.pilot.getView().findPosition((DNode)de.getTarget(), p);
        int sx = dp.getScrollX();
        int sy = dp.getScrollY();
        int pw = dp.getPaneWidth();
        int ph = dp.getPaneHeight();
        int newX = sx;
        int newY = sy;
        if (p.x < sx || p.x > sx + pw) {
            newX = p.x < sx ? p.x : 5 + p.x - pw;
        }
        if (p.y < sy || p.y > sy + ph) {
            newY = p.y < sy ? p.y : box.height + p.y - ph;
        }
        if (newX != sx || newY != sy) {
            this.scrollHandler.scrollRequest(newX, newY);
            this.pilot.getCSSLayout().setScrollToFocus(true);
        }
    }

    private void onBlur(DOMUIEvent de) {
    }

    protected void doAction(DNode node) {
        DDocument doc = (DDocument)this.pilot.getDocument();
        if (doc == null) {
            return;
        }
        DOMEvent clickevent = doc.createDOMEvent(1);
        node.dispatchEvent(clickevent);
    }

    private boolean scrollAction(int keycode) {
        if (keycode == 34 || keycode == 33 || keycode == 35 || keycode == 36) {
            return this.scrollHandler.scrollRequest(keycode);
        }
        return false;
    }

    private void handleDefaultActionOnLinks(DOMUIEvent domEvent, DElement elem) {
        String loc = elem.getAttribute(46);
        if (loc != null) {
            boolean hash = loc.equals("#");
            boolean mouseMoveUpdate = false;
            if (elem.tagId == 1 && domEvent.target instanceof DImageElement && !hash && ((DImageElement)domEvent.target).getIsMap()) {
                loc = loc + "?" + domEvent.posX + "," + domEvent.posY;
                mouseMoveUpdate = true;
            }
            DDocument doc = this.pilot.getDDocument();
            loc = doc.resolveUrl(loc);
            switch (domEvent.typeId) {
                case 6: {
                    if (!mouseMoveUpdate) break;
                    this.pilot.firePropertyChange("statusLine", null, loc);
                    break;
                }
                case 5: {
                    this.pilot.firePropertyChange("statusLine", null, loc);
                    break;
                }
                case 7: {
                    this.pilot.firePropertyChange("statusLine", null, "");
                    break;
                }
                case 1: {
                    short button;
                    if (hash || domEvent.isMousePressPopupTrigger || (button = domEvent.getButton()) != 0) break;
                    String target = elem.getAttribute(108);
                    if (target == null || target.length() == 0) {
                        target = doc.getBaseTarget();
                    }
                    this.pilot.renderContent(loc, null, target);
                    break;
                }
            }
        }
    }

    public FocusExitHandler getFocusExitHandler() {
        return this.focusExitHandler;
    }

    public void setFocusExitHandler(FocusExitHandler feh) {
        this.focusExitHandler = feh;
    }
}

