/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSLexCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

class CSSLex {
    private Reader reader;
    private InputStream inputStream;
    private char[] buf;
    private int pos;
    private int numRead;
    private char c;
    private int openedBlocks;
    private CSSLexCallback callback;
    private static final char[] important = new char[]{'!', 'i', 'm', 'p', 'o', 'r', 't', 'a', 'n', 't'};
    private boolean[] quotes;

    private void $init$() {
        this.reader = null;
        this.inputStream = null;
        this.buf = null;
        this.pos = 0;
        this.numRead = 0;
        this.c = '\u0000';
        this.openedBlocks = 0;
        this.callback = null;
        this.quotes = new boolean[32];
    }

    public CSSLex() {
        this.$init$();
    }

    public void setLexCallback(CSSLexCallback cback) {
        this.callback = cback;
    }

    void setReader(Reader reader) {
        this.reader = reader;
    }

    public void parseInlineDeclaration(String s) {
        this.buf = s.toCharArray();
        this.openedBlocks = 0;
        this.pos = 0;
        this.numRead = this.buf.length;
        while (this.parseDeclaration()) {
        }
        this.buf = null;
    }

    public void parse() throws IOException {
        this.loadData();
        if (this.buf == null) {
            return;
        }
        this.callback.startStylesheet();
        this.openedBlocks = 0;
        this.pos = 0;
        this.numRead = this.buf.length;
        int oldPos = 0;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == ' ' || this.c == '\t' || this.c == '\r' || this.c == '\n' || this.c == '\f') {
                this.skipWhitespaceChars();
            } else if (this.c == '/' && this.buf[this.pos + 1] == '*') {
                this.skipComment();
            } else if (this.c == '/' && this.buf[this.pos + 1] == '/') {
                this.skipLine();
            } else if (this.c == '@') {
                this.parseAtRule();
            } else if (this.c == '}') {
                if (this.openedBlocks > 0) {
                    --this.openedBlocks;
                    this.callback.endBlock();
                }
                ++this.pos;
            } else if (this.c == '<' && this.buf[this.pos + 1] == '!') {
                this.pos += 4;
            } else if (this.c == '-' && this.buf[this.pos + 1] == '-') {
                this.pos += 3;
                this.callback.resetSelector();
            } else {
                this.parseSelector();
                if (this.c == '{') {
                    this.callback.startDeclBlock();
                    ++this.pos;
                    while (this.parseDeclaration()) {
                    }
                    this.callback.endDeclBlock();
                    ++this.pos;
                }
            }
            if (oldPos == this.pos) {
                // empty if block
            }
            oldPos = ++this.pos;
        }
        this.callback.endStylesheet();
    }

    private final void skipComment() {
        this.pos += 2;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == '*' && this.pos + 1 < this.numRead && this.buf[this.pos + 1] == '/') {
                this.pos += 2;
                if (this.pos >= this.numRead) break;
                this.c = this.buf[this.pos];
                break;
            }
            ++this.pos;
        }
    }

    private final void skipLine() {
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == '\n' || this.c == '\r' || this.c == '\f') {
                this.pos += 2;
                if (this.pos >= this.numRead) break;
                this.c = this.buf[this.pos];
                break;
            }
            ++this.pos;
        }
    }

    private final void skipWhitespaceChars() {
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c != ' ' && this.c != '\t' && this.c != '\n' && this.c != '\r' && this.c != '\f') break;
            ++this.pos;
        }
    }

    private final void parseAtRule() {
        int startPos = this.pos;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == ';' || this.c == '{') break;
            if (this.c == '\'' || this.c == '\"') {
                this.skipString();
                continue;
            }
            ++this.pos;
        }
        this.callback.atRule(this.buf, startPos + 1, this.pos - startPos - 1);
        if (this.c == '{') {
            ++this.openedBlocks;
            this.callback.startBlock();
        }
        ++this.pos;
    }

    private final void parseSelector() {
        this.callback.startSelector();
        while (this.pos < this.buf.length - 1) {
            this.parseSimpleSelector();
            this.skipWhitespaceChars();
            if (this.c == '/' && this.buf[this.pos + 1] == '*') {
                this.skipComment();
            }
            if (this.c == '/' && this.buf[this.pos + 1] == '/') {
                this.skipLine();
            }
            if (this.c == '-' && this.buf[this.pos + 1] == '-') {
                return;
            }
            if (this.c == '{') break;
            if (this.c == '+' || this.c == '>') {
                this.callback.selectorCombinator(this.c);
                ++this.pos;
                this.skipWhitespaceChars();
                if (this.c == '/' && this.buf[this.pos + 1] == '*') {
                    this.skipComment();
                }
                if (this.c != '/' || this.buf[this.pos + 1] != '/') continue;
                this.skipLine();
                continue;
            }
            if (this.c == ',') {
                this.callback.endSelector();
                ++this.pos;
                this.callback.startSelector();
                this.skipWhitespaceChars();
                if (this.c == '/' && this.buf[this.pos + 1] == '*') {
                    this.skipComment();
                }
                if (this.c != '/' || this.buf[this.pos + 1] != '/') continue;
                this.skipLine();
                continue;
            }
            this.callback.selectorCombinator(' ');
        }
        this.callback.endSelector();
    }

    /*
     * Unable to fully structure code
     */
    private final void parseSimpleSelector() {
        startPos = this.pos;
        prefixLength = 0;
        simpleSelectorDone = false;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == ' ' || this.c == '\t' || this.c == '\r' || this.c == '\n' || this.c == '\f') {
                simpleSelectorDone = true;
                break;
            }
            if (this.c == '+' || this.c == '>') {
                simpleSelectorDone = true;
                break;
            }
            if (this.c == ',') {
                simpleSelectorDone = true;
                break;
            }
            if (this.c == '{') {
                simpleSelectorDone = true;
                break;
            }
            if (this.c == '.' || this.c == '#' || this.c == '[' || this.c == ':') break;
            if (this.c == '|') {
                prefixLength = this.pos - startPos + 1;
            } else if (this.c == '-' && this.pos + 1 < this.numRead && this.buf[this.pos + 1] == '-') {
                return;
            }
            ++this.pos;
        }
        if (startPos < this.pos) {
            this.callback.typeSelector(this.buf, startPos, this.pos - startPos, prefixLength);
        }
        if (!simpleSelectorDone) ** GOTO lbl78
        return;
lbl-1000:
        // 1 sources

        {
            if (this.c == '/' && this.buf[this.pos + 1] == '*') {
                this.skipComment();
            }
            if (this.c == '/' && this.buf[this.pos + 1] == '/') {
                this.skipLine();
            }
            if (this.c == '{' || this.c == ',') break;
            if (this.c == '.') {
                startPos = ++this.pos;
                while (this.pos < this.numRead) {
                    this.c = this.buf[this.pos];
                    if (this.c == ' ' || this.c == '\t' || this.c == '\r' || this.c == '\n' || this.c == '\f' || this.c == '+' || this.c == '>' || this.c == '.' || this.c == '#' || this.c == '[' || this.c == '/' || this.c == '{' || this.c == ',' || this.c == ':') break;
                    ++this.pos;
                }
                if (this.pos <= startPos) continue;
                this.callback.classSelector(this.buf, startPos, this.pos - startPos);
                continue;
            }
            if (this.c == '#') {
                startPos = ++this.pos;
                while (this.pos < this.numRead) {
                    this.c = this.buf[this.pos];
                    if (this.c == ' ' || this.c == '\t' || this.c == '\r' || this.c == '\n' || this.c == '\f' || this.c == '+' || this.c == '>' || this.c == '.' || this.c == '#' || this.c == '[' || this.c == '/' || this.c == '{' || this.c == ',' || this.c == ':') break;
                    ++this.pos;
                }
                if (this.pos <= startPos) continue;
                this.callback.idSelector(this.buf, startPos, this.pos - startPos);
                continue;
            }
            if (this.c == ':') {
                startPos = ++this.pos;
                while (this.pos < this.numRead) {
                    this.c = this.buf[this.pos];
                    if (this.c == ' ' || this.c == '\t' || this.c == '\r' || this.c == '\n' || this.c == '\f' || this.c == '+' || this.c == '>' || this.c == '.' || this.c == '#' || this.c == '[' || this.c == '/' || this.c == '{' || this.c == ',' || this.c == ':') break;
                    ++this.pos;
                }
                if (this.pos <= startPos) continue;
                this.callback.pseudoSelector(this.buf, startPos, this.pos - startPos);
                continue;
            }
            if (this.c != '[') break;
            startPos = ++this.pos;
            while (this.pos < this.numRead) {
                this.c = this.buf[this.pos];
                if (this.c == ']') break;
                if (this.c == '\'' || this.c == '\"') {
                    this.skipString();
                    continue;
                }
                ++this.pos;
            }
            if (this.pos > startPos) {
                this.callback.attributeSelector(this.buf, startPos, this.pos - startPos);
            }
            ++this.pos;
lbl78:
            // 8 sources

            ** while (this.pos < this.numRead)
        }
lbl79:
        // 3 sources

    }

    private final boolean parseDeclaration() {
        int pp;
        this.skipWhitespaceChars();
        while (this.c == '/' && this.buf[this.pos + 1] == '*') {
            this.skipComment();
            this.skipWhitespaceChars();
        }
        while (this.c == '/' && this.buf[this.pos + 1] == '/') {
            this.skipLine();
        }
        if (this.pos >= this.numRead) {
            return false;
        }
        if (this.c == '}') {
            return false;
        }
        if (this.c == ';') {
            ++this.pos;
            return true;
        }
        int nameOffset = this.pos;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == ' ' || this.c == '\t' || this.c == '\r' || this.c == '\n' || this.c == '\r' || this.c == '\f' || this.c == '/' || this.c == ':' || this.c == '=') break;
            ++this.pos;
        }
        if (this.pos >= this.numRead) {
            return false;
        }
        int nameLength = this.pos - nameOffset;
        boolean colonFound = false;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == ':' || this.c == '=') {
                colonFound = true;
                ++this.pos;
                continue;
            }
            if (this.c == '/' && this.buf[this.pos + 1] == '*') {
                this.skipComment();
                continue;
            }
            if (this.c == '/' && this.buf[this.pos + 1] == '/') {
                this.skipLine();
                continue;
            }
            if (this.c != ' ' && this.c != '\t' && this.c != '\n' && this.c != '\r' && this.c != '\f') break;
            ++this.pos;
        }
        if (this.pos >= this.numRead || !colonFound) {
            return false;
        }
        int valueOffset = this.pos;
        while (this.pos < this.numRead) {
            this.c = this.buf[this.pos];
            if (this.c == '}' || this.c == ';') break;
            if (this.c == '\'' || this.c == '\"') {
                this.skipString();
                continue;
            }
            ++this.pos;
        }
        if (this.pos > this.numRead) {
            return false;
        }
        int restore = pp = this.pos;
        while (pp > valueOffset) {
            if (restore - --pp >= important.length) break;
            if (this.buf[pp] == important[important.length - (restore - pp)]) continue;
            pp = restore;
            break;
        }
        while (pp > valueOffset) {
            char t;
            if ((t = this.buf[--pp]) == ' ' || t == '\t' || t == '\r' || t == '\n' || t == '\f') continue;
            ++pp;
            break;
        }
        if (pp == valueOffset) {
            return false;
        }
        int valueLength = pp - valueOffset;
        char firstValueChar = this.buf[valueOffset];
        char lastValueChar = this.buf[valueOffset + valueLength - 1];
        if (firstValueChar == '\'' && lastValueChar == '\'' || firstValueChar == '\"' && lastValueChar == '\"') {
            this.callback.declaration(this.buf, nameOffset, nameLength, valueOffset + 1, valueLength - 2);
        } else {
            this.callback.declaration(this.buf, nameOffset, nameLength, valueOffset, valueLength);
        }
        if (this.c == ';') {
            ++this.pos;
            return true;
        }
        return false;
    }

    private final void skipString() {
        int numQuotes = 1;
        char c = this.buf[this.pos];
        if (c == '\'') {
            this.quotes[0] = false;
        } else if (c == '\"') {
            this.quotes[0] = true;
        } else {
            return;
        }
        ++this.pos;
        while (numQuotes > 0 && this.pos < this.numRead) {
            if ((c = this.buf[this.pos++]) == '\'') {
                if (!this.quotes[numQuotes - 1]) {
                    --numQuotes;
                    continue;
                }
                this.quotes[numQuotes++] = false;
                continue;
            }
            if (c != '\"') continue;
            if (this.quotes[numQuotes - 1]) {
                --numQuotes;
                continue;
            }
            this.quotes[numQuotes++] = true;
        }
    }

    private final void loadData() throws IOException {
        boolean num = false;
        this.pos = 0;
        if (this.reader != null) {
            char[] tmp = new char[2048];
            int r = this.reader.read(tmp, this.pos, tmp.length - this.pos);
            while (r > 0) {
                this.pos += r;
                if (this.pos == tmp.length) {
                    char[] tt = new char[tmp.length * 2];
                    System.arraycopy(tmp, 0, tt, 0, tmp.length);
                    tmp = tt;
                }
                r = this.reader.read(tmp, this.pos, tmp.length - this.pos);
            }
            this.buf = new char[this.pos];
            System.arraycopy(tmp, 0, this.buf, 0, this.pos);
            this.reader.close();
            this.reader = null;
        } else {
            byte[] tmp = new byte[2048];
            int r = this.inputStream.read(tmp, this.pos, tmp.length - this.pos);
            while (r > 0) {
                this.pos += r;
                if (this.pos == tmp.length) {
                    byte[] tt = new byte[tmp.length * 2];
                    System.arraycopy(tmp, 0, tt, 0, tmp.length);
                    tmp = tt;
                }
                r = this.inputStream.read(tmp, this.pos, tmp.length - this.pos);
            }
            this.inputStream.close();
            this.buf = new char[this.pos];
            int i = 0;
            while (i < this.pos) {
                this.buf[i] = (char)tmp[i];
                ++i;
            }
            this.inputStream = null;
        }
    }
}

