/*
 * Decompiled with CFR 0.152.
 */
package ice.dom.html;

import ice.dom.html.DefaultHTMLElement;
import ice.dom.html.TableCellElement;
import ice.dom.html.VectorCollection;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.storm.DynEnv;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class TableRowElement
extends DefaultHTMLElement
implements HTMLTableRowElement {
    private static final int Field_cells = 1;
    private static final int Field_rowIndex = 2;
    private static final int Field_sectionRowIndex = 3;
    private static final int Method_deleteCell = -1;
    private static final int Method_insertCell = -2;

    public TableRowElement(DDocument doc, int id) {
        super(doc, id);
    }

    public int getRowIndex() {
        DNode table = this;
        while (table.getNameId() != 79 && table != null) {
            table = (DNode)table.getParentNode();
        }
        if (table != null) {
            HTMLCollection rows = ((HTMLTableElement)((Object)table)).getRows();
            int i = 0;
            while (i < rows.getLength()) {
                if (rows.item(i) == this) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int getSectionRowIndex() {
        Node table = this.getParentNode();
        if (table instanceof HTMLTableSectionElement) {
            HTMLCollection rows = ((HTMLTableSectionElement)table).getRows();
            int i = 0;
            while (i < rows.getLength()) {
                if (rows.item(i) == this) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public HTMLCollection getCells() {
        Vector<Node> vec = new Vector<Node>();
        NodeList cells = this.getChildNodes();
        int i = 0;
        while (i < cells.getLength()) {
            Node cell = cells.item(i);
            if (cell instanceof HTMLTableCellElement) {
                vec.addElement(cell);
            }
            ++i;
        }
        return new VectorCollection(vec);
    }

    public HTMLElement insertCell(int index) {
        HTMLCollection cells = this.getCells();
        if (index < 0 || index > cells.getLength()) {
            return null;
        }
        TableCellElement newCell = new TableCellElement(this.doc, 81);
        this.insertBefore(newCell, cells.item(index));
        return newCell;
    }

    public void deleteCell(int index) {
        HTMLCollection cells = this.getCells();
        if (index < 0 || index >= cells.getLength()) {
            return;
        }
        Node old = cells.item(index);
        old.getParentNode().removeChild(old);
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = TableRowElement.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = TableRowElement.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = TableRowElement.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return this.getCells();
            }
            case 2: {
                return env.wrapInt(this.getRowIndex());
            }
            case 3: {
                return env.wrapInt(this.getSectionRowIndex());
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        if (key_id == 1) {
            return 2;
        }
        if (key_id == 2) {
            return 2;
        }
        if (key_id == 3) {
            return 2;
        }
        return 2;
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                this.deleteCell(env.toInt(args, 0));
                break;
            }
            case -2: {
                return this.insertCell(env.toInt(args, 0));
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        switch (s.length()) {
            case 5: {
                guess = "cells";
                id = 1;
                break;
            }
            case 8: {
                guess = "rowIndex";
                id = 2;
                break;
            }
            case 10: {
                char c = s.charAt(0);
                if (c == 'd') {
                    guess = "deleteCell";
                    id = -1;
                    break;
                }
                if (c != 'i') break;
                guess = "insertCell";
                id = -2;
                break;
            }
            case 15: {
                guess = "sectionRowIndex";
                id = 3;
                break;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

