/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.xml.binxml.BinXMLDecoder;
import oracle.xml.binxml.BinXMLEncoder;
import oracle.xml.binxml.BinXMLMetadataProvider;
import oracle.xml.binxml.BinXMLMetadataProviderFactory;
import oracle.xml.binxml.BinXMLProcessorFactory;
import oracle.xml.binxml.BinXMLProcessorImpl;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.binxml.BinXMLUtil;
import oracle.xml.binxml.BinXMLVocabId;
import oracle.xml.binxml.DBBinXMLMetadataProvider;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLSAXSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.ext.LexicalHandler;

public class BinXMLTestEncDec {
    public static BLOB encode(CLOB inclob, String schemaURL) {
        System.out.println("start encode J \n");
        BLOB outblob = null;
        if (inclob == null) {
            System.out.println("clob is null\n");
            return outblob;
        }
        char[] buffer = new char[100];
        try {
            inclob.getChars(1L, 100, buffer);
            System.out.println(buffer);
        }
        catch (Exception ec) {
            System.out.println("failed clob read\n");
            ec.printStackTrace(System.out);
        }
        try {
            Connection conn = null;
            DriverManager.registerDriver((Driver)new OracleDriver());
            conn = new OracleDriver().defaultConnection();
            DBBinXMLMetadataProvider dbmconn = BinXMLMetadataProviderFactory.createDBMetadataProvider();
            if (conn == null || !(conn instanceof OracleConnection)) {
                return null;
            }
            dbmconn.setConnection((Connection)((OracleConnection)conn));
            BinXMLProcessorFactory binf = new BinXMLProcessorFactory();
            BinXMLProcessorImpl binp = (BinXMLProcessorImpl)BinXMLProcessorFactory.createProcessor((BinXMLMetadataProvider)dbmconn);
            binp.setDebugMode(false);
            ByteArrayOutputStream bytestrm = new ByteArrayOutputStream();
            BinXMLStream binstrm = binp.createBinXMLStream((OutputStream)bytestrm);
            BinXMLEncoder binenc = binstrm.getEncoder();
            System.out.println(" encoder\n");
            System.out.println(schemaURL);
            if (schemaURL != null) {
                binenc.setProperty(1, true);
                binenc.setSchema(schemaURL);
            } else {
                System.out.println("non schema-based\n");
                binenc.setProperty(1, false);
            }
            binenc.setProperty(4, true);
            binenc.setProperty(6, true);
            SAXParser dp = new SAXParser();
            dp.setContentHandler(binenc.getContentHandler());
            dp.setLexHandler(binenc.getLexicalHandler());
            dp.setErrorHandler(binenc.getErrorHandler());
            Reader istream = inclob.getCharacterStream();
            dp.parse(istream);
            System.out.println("parsed\n");
            outblob = BLOB.createTemporary((Connection)conn, (boolean)true, (int)10);
            outblob.putBytes(1L, bytestrm.toByteArray());
            System.out.println(bytestrm.toByteArray());
        }
        catch (Exception e) {
            System.out.println("failed java\n");
            e.printStackTrace(System.out);
        }
        System.out.println("end encode J \n");
        return outblob;
    }

    public static BLOB encode_from_xsd(CLOB inclob, String xsdfile) {
        System.out.println("start encode xsd \n");
        BLOB outblob = null;
        try {
            Connection conn = null;
            DriverManager.registerDriver((Driver)new OracleDriver());
            conn = new OracleDriver().defaultConnection();
            DBBinXMLMetadataProvider dbmconn = BinXMLMetadataProviderFactory.createDBMetadataProvider();
            if (conn == null || !(conn instanceof OracleConnection)) {
                System.out.println("not able to connect to DB\n");
                return null;
            }
            dbmconn.setConnection((Connection)((OracleConnection)conn));
            System.out.println("connected to DB\n");
            BinXMLProcessorFactory binf = new BinXMLProcessorFactory();
            BinXMLProcessorImpl binp = (BinXMLProcessorImpl)BinXMLProcessorFactory.createProcessor((BinXMLMetadataProvider)dbmconn);
            binp.setDebugMode(false);
            System.out.println(xsdfile);
            URL schLocURL = BinXMLUtil.createURL((String)xsdfile);
            String schLoc = schLocURL.toExternalForm();
            BinXMLVocabId schid = dbmconn.saveSchema(schLoc);
            System.out.println("saved\n");
            Reader r = dbmconn.getCompiledSchema(schid);
            System.out.println("got compiled schema\n");
            new BinXMLUtil();
            binp.registerSchema(BinXMLUtil.createURL((String)schLoc), r);
            System.out.println("register schema to JVM locally\n");
            ByteArrayOutputStream bytestrm = new ByteArrayOutputStream();
            BinXMLStream binstrm = binp.createBinXMLStream((OutputStream)bytestrm);
            BinXMLEncoder binenc = binstrm.getEncoder();
            binenc.setProperty(1, true);
            binenc.setSchema(schLoc);
            SAXParser dp = new SAXParser();
            dp.setContentHandler(binenc.getContentHandler());
            dp.setErrorHandler(binenc.getErrorHandler());
            outblob = BLOB.createTemporary((Connection)conn, (boolean)true, (int)10);
            outblob.putBytes(1L, bytestrm.toByteArray());
        }
        catch (Exception e) {
            System.out.println("failed Java\n");
            e.printStackTrace(System.out);
        }
        System.out.println("end encode xsd \n");
        return outblob;
    }

    public static CLOB decode(BLOB inblob) {
        System.out.println("start decode J\n");
        CLOB outclob = null;
        if (inblob == null) {
            System.out.println("blob null\n");
            return outclob;
        }
        try {
            Connection conn = null;
            DriverManager.registerDriver((Driver)new OracleDriver());
            conn = new OracleDriver().defaultConnection();
            DBBinXMLMetadataProvider dbmconn = BinXMLMetadataProviderFactory.createDBMetadataProvider();
            if (conn == null || !(conn instanceof OracleConnection)) {
                return null;
            }
            dbmconn.setConnection((Connection)((OracleConnection)conn));
            BinXMLProcessorFactory binf = new BinXMLProcessorFactory();
            BinXMLProcessorImpl binp = (BinXMLProcessorImpl)BinXMLProcessorFactory.createProcessor((BinXMLMetadataProvider)dbmconn);
            binp.setDebugMode(false);
            BinXMLStream binstrm = binp.createBinXMLStream((Blob)inblob);
            System.out.println("bin stream created");
            BinXMLDecoder bindec = binstrm.getDecoder();
            outclob = CLOB.createTemporary((Connection)conn, (boolean)true, (int)10);
            ByteArrayOutputStream outstrm = new ByteArrayOutputStream();
            XMLSAXSerializer saxser = new XMLSAXSerializer((OutputStream)outstrm);
            bindec.setLexicalHandler((LexicalHandler)saxser);
            bindec.decode((ContentHandler)saxser, (ErrorHandler)saxser);
            System.out.println("decode over");
            outclob.putString(1L, outstrm.toString());
        }
        catch (Exception e) {
            System.out.println("failed java\n");
            e.printStackTrace(System.out);
        }
        System.out.println("end decode J\n");
        return outclob;
    }

    public static void decode_to_file(BLOB inblob, String filename) {
        System.out.println("start decode_to_file");
        try {
            Connection conn = null;
            DriverManager.registerDriver((Driver)new OracleDriver());
            conn = new OracleDriver().defaultConnection();
            DBBinXMLMetadataProvider dbmconn = BinXMLMetadataProviderFactory.createDBMetadataProvider();
            if (conn != null && conn instanceof OracleConnection) {
                dbmconn.setConnection((Connection)((OracleConnection)conn));
            }
            BinXMLProcessorFactory binf = new BinXMLProcessorFactory();
            BinXMLProcessorImpl binp = (BinXMLProcessorImpl)BinXMLProcessorFactory.createProcessor((BinXMLMetadataProvider)dbmconn);
            binp.setDebugMode(false);
            BinXMLStream binstrm = binp.createBinXMLStream((Blob)inblob);
            System.out.println("bin stream created");
            BinXMLDecoder bindec = binstrm.getDecoder();
            File xmlfile = new File(filename);
            FileOutputStream xmlfilestrm = new FileOutputStream(xmlfile);
            XMLSAXSerializer saxser = new XMLSAXSerializer((OutputStream)xmlfilestrm);
            bindec.decode((ContentHandler)saxser, (ErrorHandler)saxser);
        }
        catch (Exception e) {
            System.out.println("failed java\n");
            e.printStackTrace(System.out);
        }
        System.out.println("end decode_to_file");
    }
}

