/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.thread;

import oracle.ldap.util.QClosedException;
import oracle.ldap.util.WorkQueue;
import oracle.ldap.util.thread.ThreadPoolJob;
import oracle.ldap.util.thread.ThreadPoolManager;

public class WorkerThread
extends Thread {
    private ThreadPoolManager m_tpm = null;
    private WorkQueue m_jobQ = null;
    private int m_defThrPriority = this.m_defThrPriority;
    private boolean m_isAlive = true;

    public WorkerThread(ThreadGroup thrGroup, String thrName, ThreadPoolManager poolMgr, int defThrPriority) {
        super(thrGroup, thrName);
        this.m_jobQ = poolMgr.getJobQ();
        this.m_tpm = poolMgr;
        this.setPriority(this.m_defThrPriority);
    }

    public void run() {
        while (this.m_isAlive) {
            ThreadPoolJob tpJob = null;
            try {
                tpJob = (ThreadPoolJob)this.m_jobQ.dequeue();
            }
            catch (QClosedException qce) {
                this.m_tpm.threadTerminated(this);
                this.m_isAlive = false;
                break;
            }
            super.setPriority(tpJob.getJobPriority());
            this.m_tpm.threadBusy(this);
            tpJob.runJob();
            this.m_tpm.threadFreed(this);
            super.setPriority(this.m_defThrPriority);
        }
    }
}

