/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.thread;

import java.util.ArrayList;
import oracle.ldap.util.WorkQueue;
import oracle.ldap.util.thread.WorkerThread;

class ThreadPoolManager {
    private WorkQueue m_jobQ = null;
    private int m_nMinThr = 1;
    private int m_nMaxThr = 10;
    private int m_defThrPriority = 5;
    private ThreadGroup m_thrGroup = null;
    private int m_thrCnt = 0;
    private int m_busyThrCnt = 0;
    private ArrayList m_workerList = null;

    ThreadPoolManager(WorkQueue jobQ, int minThr, int maxThr, int defThrPriority) {
        this.m_nMinThr = minThr;
        this.m_nMaxThr = maxThr;
        this.m_defThrPriority = defThrPriority;
        this.m_jobQ = jobQ;
        this.m_thrGroup = new ThreadGroup("ThreadPool Group - ");
        this.m_workerList = new ArrayList();
        this.initPool();
    }

    protected void initPool() {
        for (int iCnt = 0; iCnt < this.m_nMinThr; ++iCnt) {
            this.beginThread();
        }
    }

    protected void beginThread() {
        WorkerThread wt = new WorkerThread(this.m_thrGroup, "ThreadName", this, this.m_defThrPriority);
        ++this.m_thrCnt;
        this.m_workerList.add(wt);
        wt.start();
    }

    protected boolean allowThreadCreation() {
        return this.m_thrCnt < this.m_nMaxThr;
    }

    synchronized void jobArrived() {
        if (this.m_busyThrCnt < this.m_thrCnt) {
            return;
        }
        if (this.allowThreadCreation()) {
            this.beginThread();
        }
    }

    synchronized void threadBusy(WorkerThread thread) {
        ++this.m_busyThrCnt;
    }

    synchronized void threadFreed(WorkerThread thread) {
        --this.m_busyThrCnt;
    }

    synchronized void threadTerminated(WorkerThread thread) {
        --this.m_thrCnt;
        --this.m_busyThrCnt;
    }

    WorkQueue getJobQ() {
        return this.m_jobQ;
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer("Group Name ");
        buffer.append("\n Number of threads      : " + this.m_thrCnt);
        buffer.append("\n Number of free threads : " + (this.m_thrCnt - this.m_busyThrCnt));
        return buffer.toString();
    }
}

