/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.thread;

import java.util.ArrayList;
import oracle.ldap.util.thread.JobEvent;
import oracle.ldap.util.thread.JobEventListener;

public class ThreadPoolJob {
    private Runnable m_job;
    private int m_jobPriority;
    private ArrayList m_jobEventListeners = null;

    public ThreadPoolJob(Runnable job, int priority) {
        this.m_job = job;
        this.m_jobPriority = priority;
        this.m_jobEventListeners = new ArrayList();
    }

    public void addListener(JobEventListener listener) {
        this.m_jobEventListeners.add(listener);
    }

    public boolean removeListener(JobEventListener listener) {
        return this.m_jobEventListeners.remove(listener);
    }

    void runJob() {
        this.dispatchBeginEvent();
        try {
            this.m_job.run();
        }
        catch (Exception e) {
            this.dispatchErrorEvent(e);
        }
        this.dispatchEndEvent();
    }

    int getJobPriority() {
        return this.m_jobPriority;
    }

    private void dispatchBeginEvent() {
        Object[] listener = this.m_jobEventListeners.toArray();
        for (int iCnt = 0; iCnt < listener.length; ++iCnt) {
            ((JobEventListener)listener[iCnt]).beginJob(new JobEvent(this, null));
        }
    }

    private void dispatchEndEvent() {
        Object[] listener = this.m_jobEventListeners.toArray();
        for (int iCnt = 0; iCnt < listener.length; ++iCnt) {
            ((JobEventListener)listener[iCnt]).endJob(new JobEvent(this, null));
        }
    }

    private void dispatchErrorEvent(Exception e) {
        Object[] listener = this.m_jobEventListeners.toArray();
        for (int iCnt = 0; iCnt < listener.length; ++iCnt) {
            ((JobEventListener)listener[iCnt]).onError(new JobEvent(this, e));
        }
    }
}

