/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.schema;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import oracle.idm.provisioning.plugin.PluginException;
import oracle.ldap.util.JARClassLoader;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.jndi.ConnectionUtil;
import oracle.ldap.util.schema.DIPSchema;
import oracle.ldap.util.schema.ODISchemaException;
import oracle.ldap.util.schema.Plugin;

public class PluginContext
implements Serializable {
    private DIPSchema m_dipSchema = null;
    private JARClassLoader m_pluginClassLoader = null;

    public PluginContext(DIPSchema dipSchema) {
        this.m_dipSchema = dipSchema;
    }

    public DIPSchema getDIPSchema() {
        return this.m_dipSchema;
    }

    public PluginContext(DIPSchema dipSchema, String appType, String appName) throws ODISchemaException, PluginException {
        this(dipSchema);
        LdapContext lCtx = (LdapContext)dipSchema.getDirContext();
        this.init(lCtx, appType, appName);
    }

    private synchronized void init(LdapContext lCtx, String appType, String appName) throws ODISchemaException, PluginException {
        Class<?> cl = this.getClass();
        this.debug("The class Name   : " + cl.getName());
        this.debug("The class Loader : " + cl.getClassLoader());
        if (null == this.m_pluginClassLoader) {
            this.debug("Initialiing the plugin class loader for " + appType + "," + appName);
            byte[][] pluginExecData = this.getExecDataAsArray(lCtx, appType, appName);
            try {
                if (pluginExecData != null) {
                    this.m_pluginClassLoader = new JARClassLoader(pluginExecData, this.getClass().getClassLoader());
                }
            }
            catch (IOException ioe) {
                throw new PluginException(ioe.getMessage());
            }
        }
    }

    public String[] getAllPluginTypes(LdapContext lCtx, String appType, String appName, boolean enabled) throws ODISchemaException, PluginException {
        String[] retPluginNames = null;
        String pluginDn = null;
        ArrayList<String> pluginNames = new ArrayList<String>();
        pluginDn = this.m_dipSchema.getAppPluginContainerDN(lCtx, appType);
        if (null == pluginDn) {
            throw new PluginException("Application container does not exist for [" + appType + "] . Please verify.");
        }
        try {
            String[] reqAttrs = new String[]{"orclStatus"};
            String filter = "objectClass=*";
            SearchControls sctl = new SearchControls();
            NamingEnumeration<SearchResult> result = null;
            sctl.setSearchScope(1);
            sctl.setReturningAttributes(reqAttrs);
            result = lCtx.search(pluginDn, filter, sctl);
            while (result.hasMore()) {
                SearchResult curRes = result.next();
                String name = curRes.getName();
                Attribute attr = curRes.getAttributes().get("orclStatus");
                String status = (String)attr.get();
                if (enabled && !status.equalsIgnoreCase("ENABLE")) continue;
                pluginNames.add(Util.getAttrValueOfRDN(name));
            }
        }
        catch (NameNotFoundException nnfe) {
        }
        catch (NamingException ne) {
            throw new PluginException(ne.getMessage());
        }
        if (pluginNames.size() > 0) {
            retPluginNames = pluginNames.toArray(new String[0]);
        }
        return retPluginNames;
    }

    public Plugin[] getAllPlugins(LdapContext lCtx, String appType, String appName, boolean enabled) throws ODISchemaException, PluginException {
        Plugin[] retPlugins = null;
        String pluginDn = null;
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        pluginDn = this.m_dipSchema.getAppPluginContainerDN(lCtx, appType);
        if (null == pluginDn) {
            throw new PluginException("Application container does not exist for [" + appType + "] . Please verify.");
        }
        try {
            String filter = "objectClass=*";
            SearchControls sctl = new SearchControls();
            NamingEnumeration<SearchResult> result = null;
            sctl.setSearchScope(1);
            result = lCtx.search(pluginDn, filter, sctl);
            while (result.hasMore()) {
                SearchResult curRes = result.next();
                String name = curRes.getName();
                Attributes attrs = curRes.getAttributes();
                Attribute attr = attrs.get("orclStatus");
                String status = (String)attr.get();
                if (enabled && !status.equalsIgnoreCase("ENABLE")) continue;
                String desc = null;
                String addInfo = null;
                String execName = null;
                String[] evts = null;
                Plugin plugin = null;
                name = Util.getAttrValueOfRDN(name);
                attr = attrs.get("description");
                if (attr != null) {
                    desc = (String)attr.get();
                }
                if ((attr = attrs.get("orclODIPPluginAddInfo")) != null) {
                    addInfo = (String)attr.get();
                }
                if ((attr = attrs.get("orclODIPPluginExecName")) != null) {
                    execName = (String)attr.get();
                }
                if ((attr = attrs.get("orclODIPPluginEvents")) != null) {
                    int sz = attr.size();
                    evts = new String[sz];
                    for (int i = 0; i < sz; ++i) {
                        evts[i] = (String)attr.get(i);
                    }
                }
                plugin = new Plugin(name, status, desc, execName, addInfo, evts);
                plugins.add(plugin);
            }
        }
        catch (NameNotFoundException nnfe) {
        }
        catch (NamingException ne) {
            throw new PluginException(ne.getMessage());
        }
        if (plugins.size() > 0) {
            retPlugins = plugins.toArray(new Plugin[0]);
        }
        return retPlugins;
    }

    public Plugin getPlugin(LdapContext lCtx, String appType, String appName, String pluginName, boolean enabled) throws ODISchemaException, PluginException {
        Plugin retPlugin = null;
        String pluginDn = null;
        this.debug("Request for getPlugin " + pluginName + " in " + appType + "," + appName);
        pluginDn = this.m_dipSchema.getAppPluginContainerDN(lCtx, appType);
        if (null == pluginDn) {
            return retPlugin;
        }
        pluginDn = "cn=" + pluginName + "," + pluginDn;
        try {
            Attributes attrs = lCtx.getAttributes(pluginDn);
            Attribute attr = attrs.get("orclStatus");
            String status = (String)attr.get();
            if (!enabled || status.equalsIgnoreCase("ENABLE")) {
                String desc = null;
                String addInfo = null;
                String execName = null;
                String[] evts = null;
                attr = attrs.get("description");
                if (attr != null) {
                    desc = (String)attr.get();
                }
                if ((attr = attrs.get("orclODIPPluginAddInfo")) != null) {
                    addInfo = (String)attr.get();
                }
                if ((attr = attrs.get("orclODIPPluginExecName")) != null) {
                    execName = (String)attr.get();
                }
                if ((attr = attrs.get("orclODIPPluginEvents")) != null) {
                    int sz = attr.size();
                    evts = new String[sz];
                    for (int i = 0; i < sz; ++i) {
                        evts[i] = (String)attr.get(i);
                    }
                }
                retPlugin = new Plugin(pluginName, status, desc, execName, addInfo, evts);
            }
        }
        catch (NameNotFoundException nnfe) {
        }
        catch (NamingException ne) {
            throw new PluginException(ne.getMessage());
        }
        this.debug("Returning plugin " + retPlugin);
        return retPlugin;
    }

    public void createPlugin(LdapContext lCtx, String appType, String appName, Plugin plugin) throws ODISchemaException, PluginException {
        if (null == plugin) {
            throw new IllegalArgumentException("CANNOT_PASS_NULL_ARGUMENT");
        }
        Attributes attrs = this.getAsJNDIAttributes(appType, appName, plugin, false);
        String pluginDn = this.m_dipSchema.getAppPluginContainerDN(lCtx, appType);
        if (null == pluginDn) {
            throw new PluginException("Application container does not exist for [" + appType + "] . Please verify.");
        }
        pluginDn = "cn=" + plugin.getType() + ", " + pluginDn;
        try {
            lCtx.createSubcontext(pluginDn, attrs);
        }
        catch (NameAlreadyBoundException nabe) {
            throw new PluginException("The specified plugin type already exists. Please verify");
        }
        catch (NamingException ne) {
            throw new PluginException(ne.getMessage());
        }
    }

    public void modifyPlugin(LdapContext lCtx, String appType, String appName, Plugin plugin) throws ODISchemaException, PluginException {
        if (null == plugin) {
            throw new IllegalArgumentException("CANNOT_PASS_NULL_ARGUMENT");
        }
        Attributes attrs = this.getAsJNDIAttributes(appType, appName, plugin, true);
        String pluginDn = this.m_dipSchema.getAppPluginContainerDN(lCtx, appType);
        if (null == pluginDn) {
            throw new PluginException("Application container does not exist for [" + appType + "] . Please verify.");
        }
        pluginDn = "cn=" + plugin.getType() + ", " + pluginDn;
        try {
            lCtx.modifyAttributes(pluginDn, 2, attrs);
        }
        catch (NameNotFoundException nabe) {
            throw new PluginException("The specified plugin type does not exist. Please verify");
        }
        catch (NamingException ne) {
            throw new PluginException(ne.getMessage());
        }
    }

    public void deletePlugin(LdapContext lCtx, String appType, String appName, String pluginName) throws ODISchemaException, PluginException {
        if (null == pluginName) {
            throw new IllegalArgumentException("CANNOT_PASS_NULL_ARGUMENT");
        }
        String pluginDn = this.m_dipSchema.getAppPluginContainerDN(lCtx, appType);
        if (null == pluginDn) {
            throw new PluginException("Application container does not exist for [" + appType + "] . Please verify.");
        }
        pluginDn = "cn=" + pluginName + ", " + pluginDn;
        try {
            lCtx.getAttributes(pluginDn, new String[0]);
            lCtx.destroySubcontext(pluginDn);
        }
        catch (NameNotFoundException nnfe) {
            throw new PluginException("The specified plugin does not exist. Please verify.");
        }
        catch (NamingException ne) {
            throw new PluginException(ne.getMessage());
        }
    }

    public byte[] getExecData(LdapContext lCtx, String appType, String appName) throws ODISchemaException, PluginException {
        this.debug("Request to download the JAR content for " + appType + "," + appName);
        byte[] retExecData = null;
        Attribute attr = null;
        Attributes attrs = null;
        String binPropKey = "java.naming.ldap.attributes.binary";
        Object prevPropVal = null;
        String pluginContainerDn = this.m_dipSchema.getAppPluginContainerDN(lCtx, appType);
        if (null == pluginContainerDn) {
            throw new PluginException("Application container does not exist for [" + appType + "] . Please verify.");
        }
        try {
            prevPropVal = lCtx.addToEnvironment(binPropKey, "orclODIPPluginExecData");
            attrs = lCtx.getAttributes(pluginContainerDn, new String[]{"orclODIPPluginExecData"});
            attr = attrs.get("orclODIPPluginExecData");
            if (null != attr) {
                retExecData = (byte[])attr.get();
                this.debug("Jar file downloaded succesfully for the " + appType + " ," + appName);
            } else {
                this.debug("Jar file not present for the " + appType + " ," + appName);
            }
        }
        catch (NamingException ne) {
            throw new PluginException(ne.getMessage());
        }
        finally {
            try {
                if (null != prevPropVal) {
                    lCtx.addToEnvironment(binPropKey, prevPropVal);
                } else {
                    lCtx.removeFromEnvironment(binPropKey);
                }
            }
            catch (NamingException ne) {}
        }
        return retExecData;
    }

    private byte[][] getExecDataAsArray(LdapContext lCtx, String appType, String appName) throws ODISchemaException, PluginException {
        this.debug("Request to download the JAR content for " + appType + "," + appName);
        Object retExecData = null;
        Attribute attr = null;
        Attributes attrs = null;
        String binPropKey = "java.naming.ldap.attributes.binary";
        Object prevPropVal = null;
        String pluginContainerDn = this.m_dipSchema.getAppPluginContainerDN(lCtx, appType);
        if (null == pluginContainerDn) {
            this.debug("Application container does not exist for [" + appType + "] . Please verify.");
            return null;
        }
        try {
            prevPropVal = lCtx.addToEnvironment(binPropKey, "orclODIPPluginExecData");
            attrs = lCtx.getAttributes(pluginContainerDn, new String[]{"orclODIPPluginExecData"});
            attr = attrs.get("orclODIPPluginExecData");
            if (null != attr) {
                int sz = attr.size();
                retExecData = new byte[sz][];
                for (int i = 0; i < sz; ++i) {
                    retExecData[i] = (byte[])attr.get(i);
                }
                this.debug("Jar file downloaded succesfully for the " + appType + " ," + appName);
            } else {
                this.debug("No JARs present for " + appType + " ," + appName);
            }
        }
        catch (NameNotFoundException nnfe) {
            this.debug("No JAR file uploaded for " + appType + " ," + appName);
        }
        catch (NamingException ne) {
            throw new PluginException(ne.getMessage());
        }
        finally {
            try {
                if (null != prevPropVal) {
                    lCtx.addToEnvironment(binPropKey, prevPropVal);
                } else {
                    lCtx.removeFromEnvironment(binPropKey);
                }
            }
            catch (NamingException ne) {}
        }
        return retExecData;
    }

    public void setExecData(LdapContext lCtx, String appType, String appName, byte[] execData) throws ODISchemaException, PluginException {
        Object attr = null;
        BasicAttributes attrs = null;
        String binPropKey = "java.naming.ldap.attributes.binary";
        Object prevPropVal = null;
        String pluginContainerDn = this.m_dipSchema.getAppPluginContainerDN(lCtx, appType);
        if (null == pluginContainerDn) {
            throw new PluginException("Application container does not exist for [" + appType + "] . Please verify.");
        }
        try {
            prevPropVal = lCtx.addToEnvironment(binPropKey, "orclODIPPluginExecData");
            attrs = new BasicAttributes("orclODIPPluginExecData", execData);
            lCtx.modifyAttributes(pluginContainerDn, 2, (Attributes)attrs);
        }
        catch (NamingException ne) {
            throw new PluginException(ne.getMessage());
        }
        finally {
            try {
                if (null != prevPropVal) {
                    lCtx.addToEnvironment(binPropKey, prevPropVal);
                } else {
                    lCtx.removeFromEnvironment(binPropKey);
                }
            }
            catch (NamingException ne) {}
        }
    }

    private Attributes getAsJNDIAttributes(String appType, String appName, Plugin plugin, boolean isModify) throws ODISchemaException, PluginException {
        BasicAttributes attrs = null;
        String status = null;
        String desc = null;
        String execName = null;
        String addInfo = null;
        String[] evts = null;
        attrs = new BasicAttributes();
        desc = plugin.getDescription();
        execName = plugin.getExecName();
        addInfo = plugin.getAdditionalInfo();
        evts = plugin.getEventList();
        status = plugin.getStatus();
        if (!isModify) {
            attrs.put("objectClass", "orclODIPPlugin");
            if (null == status) {
                status = "ENABLE";
            }
        }
        if (status != null) {
            attrs.put("orclStatus", status);
        }
        if (desc != null) {
            attrs.put("description", desc);
        }
        if (execName != null) {
            attrs.put("orclODIPPluginExecName", execName);
        }
        if (addInfo != null) {
            attrs.put("orclODIPPluginAddInfo", addInfo);
        }
        for (int i = 0; evts != null && i < evts.length; ++i) {
            attrs.put("orclODIPPluginEvents", evts[i]);
        }
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPluginInstance(LdapContext lCtx, String appType, String appName, String pluginName) throws ODISchemaException, PluginException {
        Object pluginInstance = null;
        Plugin plugin = null;
        plugin = this.getPlugin(lCtx, appType, appName, pluginName, true);
        if (null != plugin) {
            Class<?> cls = null;
            String pluginExecClass = null;
            PluginContext pluginContext = this;
            synchronized (pluginContext) {
                if (null == this.m_pluginClassLoader) {
                    this.init(lCtx, appType, appName);
                }
            }
            pluginExecClass = plugin.getExecName();
            try {
                cls = this.m_pluginClassLoader.loadClass(pluginExecClass);
                pluginInstance = cls.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new PluginException(cnfe.getMessage());
            }
            catch (InstantiationException ie) {
                throw new PluginException(ie.getMessage());
            }
            catch (IllegalAccessException ile) {
                throw new PluginException(ile.getMessage());
            }
        }
        return pluginInstance;
    }

    public static void emailTest(LdapContext lCtx, PluginContext plgCtx) throws Exception {
        int i;
        String[] s = plgCtx.getAllPluginTypes(lCtx, "VOICEMAIL", "VOICEMAIL-1", true);
        for (int i2 = 0; s != null && i2 < s.length; ++i2) {
            System.out.println(s[i2]);
        }
        Plugin[] plugins = plgCtx.getAllPlugins(lCtx, "VOICEMAIL", "VOICEMAIL-1", true);
        for (int i3 = 0; plugins != null && i3 < plugins.length; ++i3) {
            System.out.println(plugins[i3]);
        }
        Plugin dipPlugin = new Plugin("EventDeliveryPlugin", "ENABLE", "Plugin to deliver events", "oracle.email.ldap.plugin.EventDeliveryPlugin", null, new String[]{"USER_ADD", "USER_MODIFY", "USER_DELETE"});
        plgCtx.createPlugin(lCtx, "VOICEMAIL", "VOICEMAIL-1", dipPlugin);
        System.out.println("Plugin created...");
        plugins = plgCtx.getAllPlugins(lCtx, "VOICEMAIL", "VOICEMAIL-1", true);
        for (i = 0; plugins != null && i < plugins.length; ++i) {
            System.out.println(plugins[i]);
        }
        dipPlugin = new Plugin("EventDeliveryPlugin");
        dipPlugin.setAdditionalInfo("Additional Info");
        dipPlugin.setEventList(new String[]{"NEW_USER_ADD", "NEW_USER_MODIFY", "NEW_USER_DELETE"});
        dipPlugin.setDescription("New Description");
        dipPlugin.setExecName("oracle.ldap.plugin.NewExecName");
        dipPlugin.setStatus("DISABLE");
        plgCtx.modifyPlugin(lCtx, "VOICEMAIL", "VOICEMAIL-1", dipPlugin);
        System.out.println("Plugin modified..");
        plugins = plgCtx.getAllPlugins(lCtx, "VOICEMAIL", "VOICEMAIL-1", false);
        for (i = 0; plugins != null && i < plugins.length; ++i) {
            System.out.println(plugins[i]);
        }
        plgCtx.deletePlugin(lCtx, "VOICEMAIL", "VOICEMAIL-1", "EventDeliveryPlugin");
        System.out.println("Plugin deleted...");
        plugins = plgCtx.getAllPlugins(lCtx, "VOICEMAIL", "VOICEMAIL-1", true);
        for (i = 0; plugins != null && i < plugins.length; ++i) {
            System.out.println(plugins[i]);
        }
        System.out.println("Plugin Exec Data :");
        byte[] exec = plgCtx.getExecData(lCtx, "VOICEMAIL", "VOICEMAIL-1");
        for (int i4 = 0; exec != null && i4 < exec.length; ++i4) {
            System.out.print(exec[i4] + " ");
        }
        System.out.println();
        exec = new byte[]{1, 0, 1, 1, 1};
        plgCtx.setExecData(lCtx, "VOICEMAIL", "VOICEMAIL-1", exec);
    }

    public static void main(String[] args) throws Exception {
        InitialLdapContext dirCtx = ConnectionUtil.getDefaultDirCtx("localhost", "3060", "cn=orcladmin", "welcome");
        DIPSchema dipSchema = new DIPSchema(dirCtx);
        PluginContext plgCtx = new PluginContext(dipSchema);
    }

    private void debug(String msg) {
        UtilDebug.log(32, "PluginContext :", "[" + msg + "]");
    }
}

