/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.schema;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import oracle.ldap.util.jndi.ConnectionUtil;
import oracle.ldap.util.schema.ODISchemaException;

public class DIPSchema
implements Serializable {
    private transient DirContext m_dirCtx = null;
    private String m_schemaVersion = null;
    private String m_dipRootLocation = null;
    private String m_instanceContainerDN = null;
    private String m_provProfileContainerDN = null;
    private String m_syncProfileContainerDN = null;
    private String m_profileDataContainerDN = null;
    private String m_provApplicationContainer = null;
    private String m_ServerConfigContainer = null;
    private String m_syncProfileGroupContainerDN = null;

    public DIPSchema() {
    }

    public DIPSchema(DirContext dirCtx) throws ODISchemaException {
        this();
        this.setDirContext(dirCtx);
    }

    public DIPSchema(String hostName, String portNo, String dn, String passwd) throws ODISchemaException {
        this();
        InitialLdapContext dirCtx = null;
        try {
            if (null == dn || dn.equals("")) {
                String dipAdminDN = null;
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                env.put("java.naming.provider.url", "ldap://" + hostName + ":" + portNo + "/");
                env.put("java.naming.security.authentication", "none");
                dirCtx = new InitialLdapContext(env, null);
                if (passwd != null) {
                    dipAdminDN = "cn=dipadmin,cn=DIPAdmins," + this.getRootContextRootSchemaLocation(dirCtx);
                    dirCtx.addToEnvironment("java.naming.security.authentication", "simple");
                    dirCtx.addToEnvironment("java.naming.security.principal", dipAdminDN);
                    dirCtx.addToEnvironment("java.naming.security.credentials", passwd);
                    dirCtx.reconnect(null);
                }
            } else {
                dirCtx = ConnectionUtil.getDefaultDirCtx(hostName, portNo, dn, passwd);
            }
        }
        catch (CommunicationException ce) {
            throw new ODISchemaException("Unable to connect to the directory server - " + ce.getMessage());
        }
        catch (NamingException ne) {
            throw new ODISchemaException(ne.getMessage());
        }
        this.setDirContext(dirCtx);
    }

    public DIPSchema(String hostName, String portNo, String dn, String passwd, int sslMode) throws ODISchemaException {
        this();
        Properties prop = System.getProperties();
        InitialLdapContext dirCtx = null;
        try {
            if (null == dn || dn.equals("")) {
                String dipAdminDN = null;
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                env.put("java.naming.provider.url", "ldap://" + hostName + ":" + portNo + "/");
                env.put("java.naming.security.authentication", "none");
                if (sslMode >= 1) {
                    prop.put("SSLSocketFactoryImplClass", "oracle.ldap.util.jndi.LDAPJSSESocketFactoryImpl");
                    env.put("java.naming.ldap.factory.socket", "oracle.ldap.util.jndi.LDAPJSSESocketFactoryImpl");
                    env.put("java.naming.security.protocol", "ssl");
                }
                dirCtx = new InitialLdapContext(env, null);
                if (passwd != null) {
                    dipAdminDN = "cn=dipadmin,cn=DIPAdmins," + this.getRootContextRootSchemaLocation(dirCtx);
                    dirCtx.addToEnvironment("java.naming.security.authentication", "simple");
                    dirCtx.addToEnvironment("java.naming.security.principal", dipAdminDN);
                    dirCtx.addToEnvironment("java.naming.security.credentials", passwd);
                    dirCtx.reconnect(null);
                }
            } else {
                if (sslMode == 0) {
                    dirCtx = ConnectionUtil.getDefaultDirCtx(hostName, portNo, dn, passwd);
                }
                if (sslMode == 1) {
                    dirCtx = ConnectionUtil.getSSLDirCtx(hostName, portNo, dn, passwd);
                }
            }
        }
        catch (CommunicationException ce) {
            throw new ODISchemaException("Unable to connect to the directory server - " + ce.getMessage());
        }
        catch (NamingException ne) {
            throw new ODISchemaException(ne.getMessage());
        }
        this.setDirContext(dirCtx);
    }

    public DirContext getDirContext() {
        return this.m_dirCtx;
    }

    public void setDirContext(DirContext dirCtx) throws ODISchemaException {
        this.m_dirCtx = dirCtx;
        this.resolve();
    }

    public String getDIPRootLocation() {
        return this.m_dipRootLocation;
    }

    public String getDIPSchemaVersion() {
        return this.m_schemaVersion;
    }

    public String getDIPInstanceContainerDN() {
        return this.m_instanceContainerDN;
    }

    public String getProvProfileContainerDN() {
        return this.m_provProfileContainerDN;
    }

    public String getSyncProfileContainerDN() {
        return this.m_syncProfileContainerDN;
    }

    public String getSyncProfileGroupContainerDN() {
        return this.m_syncProfileGroupContainerDN;
    }

    public String getProfileDataContainerDN() {
        return this.m_profileDataContainerDN;
    }

    public String getProvApplicationsContainer() {
        return this.m_provApplicationContainer;
    }

    public String getImportProfileGroupDN() {
        return "cn=odipigroup, cn=DIPAdmins," + this.m_dipRootLocation;
    }

    public String getExportProfileGroupDN() {
        return "cn=odipegroup, cn=DIPAdmins," + this.m_dipRootLocation;
    }

    public String getDIPAdminGroupDN() {
        return "cn=dipadmingrp, cn=DIPAdmins," + this.m_dipRootLocation;
    }

    public String getDIPServerGroupDN() {
        return "cn=odisgroup, cn=DIPAdmins," + this.m_dipRootLocation;
    }

    public String getProfileDN(String profName, String profType) {
        String profileDN = null;
        if (profType.equals("SYNC")) {
            profileDN = "orclodipagentname=" + profName + "," + this.getSyncProfileContainerDN();
        } else if (profType.equals("PROV")) {
            profileDN = "orclODIPProfileName=" + profName + "," + this.getProvProfileContainerDN();
        }
        return profileDN;
    }

    public String getDIPServerDN(String hostName) {
        return "cn=odisrv+orclhostname=" + hostName + "," + this.getDIPInstanceContainerDN();
    }

    public String getDIPAdminDN() {
        return "cn=dipadmin, cn=DIPAdmins," + this.m_dipRootLocation;
    }

    public String getEventConfigDN() {
        return "cn=Event Definitions," + this.m_dipRootLocation;
    }

    public String getObjectDefnDN() {
        return "cn=Object Definitions," + this.m_dipRootLocation;
    }

    public String getAppContainerDN(LdapContext lCtx, String appType) throws ODISchemaException {
        String appDN = "cn=" + appType + "," + this.getProvApplicationsContainer();
        String[] reqAttrs = new String[]{};
        Attributes attrs = null;
        try {
            attrs = lCtx.getAttributes(appDN, reqAttrs);
        }
        catch (NameNotFoundException nnfe) {
            appDN = null;
        }
        catch (NamingException ne) {
            throw new ODISchemaException(ne.getMessage());
        }
        return appDN;
    }

    public String getAppPluginContainerDN(LdapContext lCtx, String appName) throws ODISchemaException {
        String retDN = this.getAppContainerDN(lCtx, appName);
        if (null != retDN) {
            retDN = "cn=Plugins, " + retDN;
        }
        return retDN;
    }

    public String getServerConfigContainer() {
        return this.m_ServerConfigContainer;
    }

    private void resolve() throws ODISchemaException {
        if (this.m_dirCtx == null) {
            return;
        }
        String[] reqAttrs = new String[]{"orclODIPSchemaVersion", "orclODIPInstancesLocation", "orclODIPProvProfileLocation", "orclODIPSyncProfileLocation", "orclODIPProfileDataLocation", "orclODIPApplicationsLocation", "orclOdipServerConfigLocation", "orclODIPSyncProfileGrpLocation"};
        this.m_dipRootLocation = this.getRootContextRootSchemaLocation(this.m_dirCtx);
        try {
            Attributes attrs = this.m_dirCtx.getAttributes("cn=schema," + this.m_dipRootLocation, reqAttrs);
            this.m_schemaVersion = (String)attrs.get("orclODIPSchemaVersion").get();
            this.m_instanceContainerDN = (String)attrs.get("orclODIPInstancesLocation").get();
            this.m_syncProfileContainerDN = (String)attrs.get("orclODIPSyncProfileLocation").get();
            this.m_provProfileContainerDN = (String)attrs.get("orclODIPProvProfileLocation").get();
            this.m_profileDataContainerDN = (String)attrs.get("orclODIPProfileDataLocation").get();
            this.m_provApplicationContainer = (String)attrs.get("orclODIPApplicationsLocation").get();
            this.m_ServerConfigContainer = (String)attrs.get("orclOdipServerConfigLocation").get();
            this.m_syncProfileGroupContainerDN = (String)attrs.get("orclODIPSyncProfileGrpLocation").get();
        }
        catch (NamingException ne) {
            throw new ODISchemaException(ne.getMessage());
        }
    }

    private String getRootContextRootSchemaLocation(DirContext dirCtx) throws ODISchemaException {
        String dipAdminDN = null;
        try {
            Attributes attrs = null;
            Attribute attr = null;
            String[] reqAttrs = new String[]{"orclODIPRootLocation"};
            String schemaDN = "cn=schema, cn=Directory Integration Platform, cn=Products, cn=OracleContext";
            attrs = dirCtx.getAttributes(schemaDN, reqAttrs);
            attr = attrs.get("orclODIPRootLocation");
            if (null == attr) {
                throw new ODISchemaException("DIP Schema Root Location not set");
            }
            dipAdminDN = (String)attr.get();
        }
        catch (CommunicationException ce) {
            throw new ODISchemaException("Unable to connect to the directory server - " + ce.getMessage());
        }
        catch (NamingException ne) {
            throw new ODISchemaException(ne.getMessage());
        }
        return dipAdminDN;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append("------------------------------------------------").append(nl).append(" Schema Version : ").append(this.getDIPSchemaVersion()).append(nl).append(" DIP Root DN    : ").append(this.getDIPRootLocation()).append(nl).append(" Instance DN    : ").append(this.getDIPInstanceContainerDN()).append(nl).append(" Prov Profile   : ").append(this.getProvProfileContainerDN()).append(nl).append(" Sync Profile   : ").append(this.getSyncProfileContainerDN()).append(nl).append(" Profile Data   : ").append(this.getProfileDataContainerDN()).append(nl).append(" DIP Admin DN   : ").append(this.getDIPAdminDN()).append(nl).append(" Imp Prof Grp   : ").append(this.getImportProfileGroupDN()).append(nl).append(" Exp Prof Grp   : ").append(this.getExportProfileGroupDN()).append(nl).append(" Provisioned Apps : ").append(this.getProvApplicationsContainer()).append(nl).append("------------------------------------------------").append(nl);
        return buf.toString();
    }

    public static void main(String[] s) throws Exception {
        InitialLdapContext dirCtx = ConnectionUtil.getDefaultDirCtx("localhost", "3060", "cn=orcladmin", "welcome");
        DIPSchema dipSchema = new DIPSchema(dirCtx);
        System.out.println(dipSchema);
        System.out.println();
        System.out.println("EMAIL application container : " + dipSchema.getAppContainerDN(dirCtx, "EMAIL"));
        System.out.println();
        System.out.println("EMAIL application plugin container : " + dipSchema.getAppPluginContainerDN(dirCtx, "EMAIL"));
    }
}

