/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.repapi;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import oracle.ldap.util.repapi.RegistrationManager;

public class RegistrationUtils {
    public static InitialLdapContext getDefaultDirCtx(boolean isSSL, String host, String port, String bindDN, String bindPwd) throws NamingException {
        if (!isSSL) {
            return RegistrationUtils.getDefaultDirCtx(host, port, bindDN, bindPwd);
        }
        return RegistrationUtils.getSSLDirCtx(host, port, bindDN, bindPwd);
    }

    public static InitialLdapContext getDefaultDirCtx(String host, String port, String bindDN, String bindPwd) throws NamingException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (hashtable.get("java.naming.factory.initial") == null) {
            try {
                String saClassName = "oracle.j2ee.naming.LdapInitialContextFactory";
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> configclass = loader.loadClass(saClassName);
                hashtable.put("java.naming.factory.initial", saClassName);
            }
            catch (ClassNotFoundException exp) {
                hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            }
        }
        if (port == null || port.equals("")) {
            hashtable.put("java.naming.provider.url", host);
        } else {
            hashtable.put("java.naming.provider.url", "ldap://" + host + ":" + port + "/");
        }
        hashtable.put("java.naming.security.authentication", "simple");
        hashtable.put("java.naming.security.principal", bindDN);
        hashtable.put("java.naming.security.credentials", bindPwd);
        hashtable.put("java.naming.referral", "follow");
        return new InitialLdapContext(hashtable, null);
    }

    public static InitialLdapContext getSSLDirCtx(String host, String port, String bindDN, String bindPwd) throws NamingException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (hashtable.get("java.naming.factory.initial") == null) {
            try {
                String saClassName = "oracle.j2ee.naming.LdapInitialContextFactory";
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> configclass = loader.loadClass(saClassName);
                hashtable.put("java.naming.factory.initial", saClassName);
            }
            catch (ClassNotFoundException exp) {
                hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            }
        }
        if (port == null || port.equals("")) {
            hashtable.put("java.naming.provider.url", host);
        } else {
            hashtable.put("java.naming.provider.url", "ldap://" + host + ":" + port + "/");
        }
        hashtable.put("java.naming.security.authentication", "simple");
        hashtable.put("java.naming.security.principal", bindDN);
        hashtable.put("java.naming.security.credentials", bindPwd);
        hashtable.put("java.naming.ldap.factory.socket", "oracle.ldap.util.jndi.LDAPJSSESocketFactoryImpl");
        hashtable.put("java.naming.security.protocol", "ssl");
        hashtable.put("java.naming.referral", "follow");
        return new InitialLdapContext(hashtable, null);
    }

    public static void main(String[] args) throws Exception {
        try {
            boolean isSSL = false;
            if (args.length > 3 && args[3].equalsIgnoreCase("ssl")) {
                isSSL = true;
            }
            boolean checked = RegistrationManager.isComponentRegistered(isSSL, args[0], null, args[1], args[2], "das", "dasapp");
            System.out.println("isComponentRegistered  - das:dasapp:" + checked);
            checked = RegistrationManager.isComponentRegistered(isSSL, args[0], null, args[1], args[2], "dip", "dasapp");
            System.out.println("isComponentRegistered dip:dasapp:" + checked);
            checked = RegistrationManager.deRegisterComponent(isSSL, args[0], null, args[1], args[2], "orclapplicationcommonname=dasapp,cn=das,cn=products,cn=oraclecontext");
            System.out.println("deRegisterComponent: das:dasapp:" + checked);
            String dn = RegistrationManager.registerComponent(isSSL, args[0], null, args[1], args[2], "orclapplicationcommonname=dasapp,cn=das,cn=products,cn=oraclecontext", null, null);
            System.out.println("registerComponent das:dasapp :" + dn);
            dn = RegistrationManager.registerComponent(isSSL, args[0], null, args[1], args[2], "das", "dasapp2", null, null);
            System.out.println("registerComponent das:dasapp2:" + dn);
            checked = RegistrationManager.deRegisterComponent(isSSL, args[0], null, args[1], args[2], "orclapplicationcommonname=dasapp2,cn=das,cn=products,cn=oraclecontext");
            System.out.println("deRegisterComponent das:dasapp2:" + checked);
            checked = RegistrationManager.isComponentRegistered(isSSL, args[0], new String(""), args[1], args[2], "dip", "dasapp");
            System.out.println("isComponentRegistered:dip:dasapp" + checked);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

