/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.provisioning;

import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.provisioning.ProvisioningCmdArgs;
import oracle.ldap.util.provisioning.ProvisioningInboundProfile;
import oracle.ldap.util.provisioning.ProvisioningOutboundProfile;
import oracle.ldap.util.provisioning.ProvisioningProfile;
import oracle.ldap.util.provisioning.ProvisioningProfileV2;

class ProvisioningProfileV3
extends ProvisioningProfileV2 {
    public static final String PROV_PROFILE_VERSION = "3.0";
    protected ProvisioningOutboundProfile outBoundProfile = null;
    protected ProvisioningInboundProfile inBoundProfile = null;

    protected static String getProfileVersion() {
        return PROV_PROFILE_VERSION;
    }

    public ProvisioningProfileV3(DirContext ctx, String profile_dn) throws Exception {
        this.readV3ProfileFromDir(ctx, profile_dn);
        this.readInboundProfileFromDir(ctx, profile_dn);
        this.readOutboundProfileFromDir(ctx, profile_dn);
        if (!this.getInboundProfile().isValid()) {
            this.setProfileMode(2);
        } else if (!this.getOutboundProfile().isValid()) {
            this.setProfileMode(1);
        } else {
            this.setProfileMode(3);
        }
    }

    public ProvisioningProfileV3(DirContext ctx, String appDN, String orgDN) throws Exception {
        String profile_DN = ProvisioningProfile.composeProfileDN(ctx, appDN, orgDN);
        this.readV3ProfileFromDir(ctx, profile_DN);
        this.readInboundProfileFromDir(ctx, profile_DN);
        this.readOutboundProfileFromDir(ctx, profile_DN);
        if (!this.getInboundProfile().isValid()) {
            this.setProfileMode(2);
        } else if (!this.getOutboundProfile().isValid()) {
            this.setProfileMode(1);
        } else {
            this.setProfileMode(3);
        }
    }

    public static ProvisioningProfileV3 createNewProfileV3(DirContext ctx, ProvisioningCmdArgs cmd) throws Exception {
        ProvisioningProfileV3 ret_prof = null;
        boolean entry_exists = false;
        Object existing_entry = null;
        Object event_vector = null;
        String mode = cmd.get("PROFILE_MODE");
        int pmode = 2;
        if (mode.equalsIgnoreCase("OUTBOUND")) {
            pmode = 2;
        }
        if (mode.equalsIgnoreCase("INBOUND")) {
            pmode = 1;
        }
        if (mode.equalsIgnoreCase("BOTH")) {
            pmode = 3;
        }
        String profile_dn = ProvisioningProfile.composeProfileDN(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
        if (pmode != 2 && (entry_exists = ProvisioningProfileV3.directoryEntryExists(ctx, "cn=ApplicationToOID," + profile_dn))) {
            throw new Exception(resBundle.getString("PROV_PROFILE_EXISTS"));
        }
        if (pmode != 1 && (entry_exists = ProvisioningProfileV3.directoryEntryExists(ctx, "cn=OIDToApplication," + profile_dn))) {
            throw new Exception(resBundle.getString("PROV_PROFILE_EXISTS"));
        }
        entry_exists = ProvisioningProfileV3.directoryEntryExists(ctx, profile_dn);
        if (entry_exists) {
            throw new Exception(resBundle.getString("PROV_PROFILE_EXISTS"));
        }
        BasicAttribute ldapattr = null;
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("orclODIPProvisioningIntegrationProfileV2");
        objclass.add("orclODIPProvisioningIntegrationProfileV3");
        attrs.put(objclass);
        ldapattr = new BasicAttribute("orclODIPProfileName");
        ldapattr.add(ProvisioningProfileV3.getRDNAttrValue(ctx, profile_dn));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclVersion");
        ldapattr.add(ProvisioningProfileV3.getProfileVersion());
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclStatus");
        ldapattr.add(cmd.get("PROFILE_STATUS"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProvisioningAppName");
        if (cmd.get("APPLICATION_NAME") != null) {
            ldapattr.add(cmd.get("APPLICATION_NAME"));
        } else {
            ldapattr.add(ProvisioningProfileV3.getRDNAttrValue(ctx, cmd.get("APPLICATION_DN")));
        }
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProvisioningAppDN", cmd.get("APPLICATION_DN"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProvisioningOrgName");
        ldapattr.add(ProvisioningProfileV3.getRDNAttrValue(ctx, cmd.get("ORGANIZATION_DN")));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProvisioningAppGUID");
        ldapattr.add(ProvisioningProfileV3.getDirectoryEntryGUID(ctx, cmd.get("APPLICATION_DN")));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProvisioningOrgGUID");
        ldapattr.add(ProvisioningProfileV3.getDirectoryEntryGUID(ctx, cmd.get("ORGANIZATION_DN")));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProfileSchedule");
        ldapattr.add(cmd.get("SCHEDULE"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProfileMaxRetries");
        ldapattr.add(cmd.get("MAX_RETRIES"));
        attrs.put(ldapattr);
        if (cmd.get("INTERFACE_NAME") != null) {
            ldapattr = new BasicAttribute("orclODIPProfileInterfaceName");
            ldapattr.add(cmd.get("INTERFACE_NAME"));
            attrs.put(ldapattr);
        }
        ldapattr = new BasicAttribute("orclODIPProfileInterfaceType");
        ldapattr.add(cmd.get("INTERFACE_TYPE"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProfileInterfaceVersion");
        ldapattr.add(cmd.get("INTERFACE_VERSION"));
        attrs.put(ldapattr);
        if (cmd.get("INTERFACE_CONNECT_INFO") != null) {
            ldapattr = new BasicAttribute("orclODIPProfileInterfaceConnectInformation");
            ldapattr.add(cmd.get("INTERFACE_CONNECT_INFO"));
            attrs.put(ldapattr);
        }
        Vector additionalInfoVector = null;
        additionalInfoVector = cmd.getVector("INTERFACE_ADDITIONAL_INFO");
        if (additionalInfoVector != null) {
            ldapattr = new BasicAttribute("orclODIPProfileInterfaceAdditionalInformation");
            for (int i = 0; i < additionalInfoVector.size(); ++i) {
                ldapattr.add((String)additionalInfoVector.elementAt(i));
            }
            attrs.put(ldapattr);
        }
        ldapattr = new BasicAttribute("orclODIPProfileMaxEventsPerInvocation");
        ldapattr.add(cmd.get("MAX_EVENTS_PER_INVOCATION"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProfileMaxEventsPerSchedule");
        ldapattr.add(cmd.get("MAX_EVENTS_PER_SCHEDULE"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProfileExecGroupID");
        ldapattr.add(cmd.get("PROFILE_GROUP"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProfileDebugLevel");
        ldapattr.add(cmd.get("PROFILE_DEBUG"));
        attrs.put(ldapattr);
        if (cmd.get("APPLICATION_TYPE") != null) {
            ldapattr = new BasicAttribute("orclApplicationType");
            ldapattr.add(cmd.get("APPLICATION_TYPE"));
            attrs.put(ldapattr);
        }
        if (cmd.get("APPLICATION_DISPLAY_NAME") != null) {
            ldapattr = new BasicAttribute("orclApplicationDisplayName");
            ldapattr.add(cmd.get("APPLICATION_DISPLAY_NAME"));
            attrs.put(ldapattr);
        }
        if (cmd.get("APPLICATION_ISDASVISIBLE") != null) {
            ldapattr = new BasicAttribute("orclApplicationIsDASViewable");
            ldapattr.add(cmd.get("APPLICATION_ISDASVISIBLE"));
            attrs.put(ldapattr);
        }
        if (cmd.get("MANAGE_APPLICATION_DEFAULTS") != null) {
            ldapattr = new BasicAttribute("orclManageApplicationDefaults");
            ldapattr.add(cmd.get("MANAGE_APPLICATION_DEFAULTS"));
            attrs.put(ldapattr);
        }
        if (cmd.get("USER_DATA_LOCATION") != null) {
            ldapattr = new BasicAttribute("orclApplicationUserDataLoc");
            ldapattr.add(cmd.get("USER_DATA_LOCATION"));
            attrs.put(ldapattr);
        }
        if (cmd.get("DEFAULT_PROVISIONING_POLICY") != null) {
            ldapattr = new BasicAttribute("orclApplicationDefaultPolicy");
            ldapattr.add(cmd.get("DEFAULT_PROVISIONING_POLICY"));
            attrs.put(ldapattr);
        }
        if (cmd.get("MAX_PROV_FAILURE_RETRIES") != null) {
            ldapattr = new BasicAttribute("orclProvisioningFailureMaxLimit");
            ldapattr.add(cmd.get("MAX_PROV_FAILURE_RETRIES"));
            attrs.put(ldapattr);
        }
        ldapattr = new BasicAttribute("orclODIPEncryptedAttrKey");
        ldapattr.add(cmd.get("CRYPT_KEY"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProfileMaxErrors");
        ldapattr.add(cmd.get("PROFILE_MAX_ERRORS"));
        attrs.put(ldapattr);
        ProvisioningProfile.LOG(((Object)attrs).toString());
        DirContext result = ctx.createSubcontext(profile_dn, (Attributes)attrs);
        ProvisioningProfile.LOG("Created Main Profile Entry Successfully");
        ProvisioningInboundProfile in = null;
        if (pmode != 2) {
            in = ProvisioningInboundProfile.createNewInboundProfile(ctx, cmd);
        }
        ProvisioningOutboundProfile out = null;
        if (pmode != 1) {
            out = ProvisioningOutboundProfile.createNewOutboundProfile(ctx, cmd);
        }
        ret_prof = new ProvisioningProfileV3(ctx, profile_dn);
        ret_prof.setProfileMode(pmode);
        ProvisioningProfile.LOG("Created Main Profile Object Successfully");
        if (!apimode) {
            System.out.println(resBundle.getString("APPLICATION") + ret_prof.getProvisioningProfileAppName());
            System.out.println(resBundle.getString("ORGANIZATION") + ret_prof.getProvisioningProfileOrgName());
            System.out.println(resBundle.getString("STATUS") + ret_prof.getProfileStatus());
            System.out.println(resBundle.getString("SCHEDULE") + ret_prof.getProfileSchedule());
            System.out.println(resBundle.getString("MAX_RETRIES") + ret_prof.getProfileMaxRetries());
            System.out.println(resBundle.getString("EXECUTION_GRP") + ret_prof.getProfileGroup());
            System.out.println(resBundle.getString("INTERFACE_NAME") + ret_prof.getProfileInterfaceName());
            System.out.println(resBundle.getString("INTERFACE_TYPE") + ret_prof.getProfileInterfaceType());
            System.out.println(resBundle.getString("INTERFACE_VER") + ret_prof.getProfileInterfaceVersion());
            System.out.println(resBundle.getString("INTERFACE_CONN_INFO") + "---");
            System.out.println(resBundle.getString("INTERFACE_ADDITIONAL_INFO") + ret_prof.getProfileInterfaceAdditionalInfo());
            if (out != null) {
                System.out.println(resBundle.getString("LAST_APPLIED_CHG_NUM") + ret_prof.getOutboundProfile().getProfileChgLogLastAppliedChangeNumber());
                System.out.println(resBundle.getString("EVENT_SUBCP") + ret_prof.getOutboundProfile().getProvisioningProfileEventSubscription());
                System.out.println(resBundle.getString("SUBCP_MODE") + ret_prof.getOutboundProfile().getProfileSubscriptionModes());
            }
        }
        return ret_prof;
    }

    public void readOutboundProfileFromDir(DirContext ctx, String profile_dn) throws Exception {
        this.outBoundProfile = new ProvisioningOutboundProfile(ctx, profile_dn);
    }

    public ProvisioningOutboundProfile getOutboundProfile() {
        return this.outBoundProfile;
    }

    public void setOutboundProfile(ProvisioningOutboundProfile outprof) {
        this.outBoundProfile = outprof;
    }

    public void readInboundProfileFromDir(DirContext ctx, String profile_dn) throws Exception {
        this.inBoundProfile = new ProvisioningInboundProfile(ctx, profile_dn);
    }

    public ProvisioningInboundProfile getInboundProfile() {
        return this.inBoundProfile;
    }

    public void setInboundProfile(ProvisioningInboundProfile inprof) {
        this.inBoundProfile = inprof;
    }

    private void readV3ProfileFromDir(DirContext ctx, String profile_dn) throws Exception {
        String[] attr_list = new String[]{"*", "orclguid"};
        Property ldap_attr = null;
        ProvisioningProfile.LOG("Searching For MAIN Profile v3 : " + profile_dn);
        PropertySetCollection entry = Util.getEntryDetails(ctx, profile_dn, "objectclass=*", 0, attr_list);
        PropertySet entry_details = entry.getPropertySet(0);
        this.profileDN = profile_dn;
        ldap_attr = entry_details.getProperty("orclODIPProfileName");
        if (ldap_attr != null) {
            this.setProfileName((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclStatus")) != null) {
            this.setProfileStatus((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclVersion")) != null) {
            this.setProfileVersion((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileSchedule")) != null) {
            this.setProfileSchedule((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileMaxRetries")) != null) {
            this.setProfileMaxRetries((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileMaxEventsPerInvocation")) != null) {
            this.setProfileMaxEventPerInvc((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileMaxEventsPerSchedule")) != null) {
            this.setProfileMaxEventPerSch((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileExecGroupID")) != null) {
            this.setProfileGroup((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPEncryptedAttrKey")) != null) {
            this.setProfileCryptKey((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileMaxErrors")) != null) {
            this.setProfileMaxErrors((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileInterfaceName")) != null) {
            this.setProfileInterfaceName((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileInterfaceType")) != null) {
            this.setProfileInterfaceType((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileInterfaceVersion")) != null) {
            this.setProfileInterfaceVersion((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileInterfaceConnectInformation")) != null) {
            this.setProfileInterfaceConnectInfo((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileInterfaceAdditionalInformation")) != null && ldap_attr.size() > 0) {
            Vector<Object> interfaceAdditionalInfoVect = new Vector<Object>();
            for (int i = 0; i < ldap_attr.size(); ++i) {
                interfaceAdditionalInfoVect.addElement(ldap_attr.getValue(i));
            }
            this.setProfileInterfaceAdditionalInfo(interfaceAdditionalInfoVect);
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProvisioningAppName")) != null) {
            this.setProvisioningProfileAppName((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProvisioningAppGUID")) != null) {
            this.setProvisioningProfileAppGUID((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProvisioningOrgName")) != null) {
            this.setProvisioningProfileOrgName((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProvisioningOrgGUID")) != null) {
            this.setProvisioningProfileOrgGUID((String)ldap_attr.getValue(0));
        }
    }

    public static void process(DirContext ctx, ProvisioningCmdArgs cmd) throws Exception {
        int status = 0;
        String emsg = "";
        ProvisioningProfileV3 my_profile = null;
        switch (cmd.getOperation()) {
            case 1: {
                try {
                    my_profile = ProvisioningProfileV3.createNewProfileV3(ctx, cmd);
                    if (apimode) break;
                    System.out.println(resBundle.getString("PROV_PROFILE_SUCCESS"));
                    System.out.println(resBundle.getString("PROFILE_NAME") + my_profile.getProfileName());
                    break;
                }
                catch (Exception e) {
                    emsg = ProvisioningProfileV3.getResultStr(e, "PROV_PROFILE_FAILURE");
                    if (!apimode) {
                        System.out.println(emsg);
                        break;
                    }
                    throw new Exception(emsg);
                }
            }
            case 2: {
                try {
                    my_profile = new ProvisioningProfileV3(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
                    ProvisioningProfile.LOG("Updating Profile(s)");
                    int pmode = my_profile.getProfileMode();
                    String cmdProfileMode = cmd.get("PROFILE_MODE");
                    my_profile.checkIntfVersion(cmd);
                    boolean test = false;
                    if (pmode == 1) {
                        if (!cmdProfileMode.equalsIgnoreCase("INBOUND")) {
                            throw new Exception("Profile currently INBOUND.Cannot Disable");
                        }
                        my_profile.getInboundProfile().disable(ctx);
                        ProvisioningProfile.LOG("Disabled InBound Profile");
                        my_profile.disable(ctx);
                        ProvisioningProfile.LOG("Disabled Main Profile");
                    } else if (pmode == 2) {
                        if (!cmdProfileMode.equalsIgnoreCase("OUTBOUND")) {
                            throw new Exception("Profile currently OUTBOUND.Cannot Disable");
                        }
                        my_profile.disable(ctx, my_profile.getOutboundProfile().getDN());
                        ProvisioningProfile.LOG("Disabled OutBound Profile");
                        my_profile.disable(ctx);
                        ProvisioningProfile.LOG("Disabled Main Profile");
                    } else if (cmdProfileMode.equalsIgnoreCase("INBOUND")) {
                        my_profile.getInboundProfile().disable(ctx);
                        ProvisioningProfile.LOG("Disabled InBound Profile");
                        my_profile.disable(ctx);
                        ProvisioningProfile.LOG("Disabled Main Profile");
                    } else if (cmdProfileMode.equalsIgnoreCase("OUTBOUND")) {
                        my_profile.disable(ctx, my_profile.getOutboundProfile().getDN());
                        ProvisioningProfile.LOG("Disabled OutBound Profile");
                        my_profile.disable(ctx);
                        ProvisioningProfile.LOG("Disabled Main Profile");
                    } else {
                        my_profile.getInboundProfile().disable(ctx);
                        ProvisioningProfile.LOG("Disabled InBound Profile");
                        my_profile.disable(ctx, my_profile.getOutboundProfile().getDN());
                        ProvisioningProfile.LOG("Disabled OutBound Profile");
                        my_profile.disable(ctx);
                        ProvisioningProfile.LOG("Disabled Main Profile");
                    }
                    if (apimode) break;
                    System.out.println(resBundle.getString("PROV_PROFILE_DISABLED"));
                    break;
                }
                catch (Exception e) {
                    emsg = ProvisioningProfileV3.getResultStr(e, "PROV_PROFILE_MOD_FAILURE");
                    if (!apimode) {
                        System.out.println(emsg);
                        break;
                    }
                    throw new Exception(emsg);
                }
            }
            case 3: {
                try {
                    my_profile = new ProvisioningProfileV3(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
                    ProvisioningProfile.LOG("Updating Profile(s)");
                    int pmode = my_profile.getProfileMode();
                    String cmdProfileMode = cmd.get("PROFILE_MODE");
                    my_profile.checkIntfVersion(cmd);
                    if (pmode == 1) {
                        if (!cmdProfileMode.equalsIgnoreCase("INBOUND")) {
                            throw new Exception("Profile currently INBOUND.Cannot Enable");
                        }
                        my_profile.getInboundProfile().enable(ctx);
                        ProvisioningProfile.LOG("Enabled InBound Profile");
                        my_profile.enable(ctx);
                        ProvisioningProfile.LOG("Enabled Main Profile");
                    } else if (pmode == 2) {
                        if (!cmdProfileMode.equalsIgnoreCase("OUTBOUND")) {
                            throw new Exception("Profile currently OUTBOUND.Cannot Enable");
                        }
                        my_profile.enable(ctx, my_profile.getOutboundProfile().getDN());
                        ProvisioningProfile.LOG("Enabled OutBound Profile");
                        my_profile.enable(ctx);
                        ProvisioningProfile.LOG("Enabled Main Profile");
                    } else if (cmdProfileMode.equalsIgnoreCase("INBOUND")) {
                        my_profile.getInboundProfile().enable(ctx);
                        ProvisioningProfile.LOG("Enabled InBound Profile");
                        my_profile.enable(ctx);
                        ProvisioningProfile.LOG("Enabled Main Profile");
                    } else if (cmdProfileMode.equalsIgnoreCase("OUTBOUND")) {
                        my_profile.enable(ctx, my_profile.getOutboundProfile().getDN());
                        ProvisioningProfile.LOG("Enabled OutBound Profile");
                        my_profile.enable(ctx);
                        ProvisioningProfile.LOG("Enabled Main Profile");
                    } else {
                        my_profile.getInboundProfile().enable(ctx);
                        ProvisioningProfile.LOG("Enabled InBound Profile");
                        my_profile.enable(ctx, my_profile.getOutboundProfile().getDN());
                        ProvisioningProfile.LOG("Enabled OutBound Profile");
                        my_profile.enable(ctx);
                        ProvisioningProfile.LOG("Enabled Main Profile");
                    }
                    if (apimode) break;
                    System.out.println(resBundle.getString("PROV_PROFILE_ENABLED"));
                    break;
                }
                catch (Exception e) {
                    emsg = ProvisioningProfileV3.getResultStr(e, "PROV_PROFILE_MOD_FAILURE");
                    if (!apimode) {
                        System.out.println(emsg);
                        break;
                    }
                    throw new Exception(emsg);
                }
            }
            case 4: {
                try {
                    my_profile = new ProvisioningProfileV3(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
                    ProvisioningProfile.LOG("Getting Profile(s) Status");
                    int pmode = my_profile.getProfileMode();
                    my_profile.checkIntfVersion(cmd);
                    if (pmode == 1) {
                        my_profile.status(ctx);
                        my_profile.getInboundProfile().status(ctx);
                        ProvisioningProfile.LOG("InBound Profile Status Success");
                        break;
                    }
                    if (pmode == 2) {
                        my_profile.status(ctx);
                        my_profile.getOutboundProfile().status(ctx);
                        ProvisioningProfile.LOG("OutBound Profile Status Success");
                        break;
                    }
                    my_profile.status(ctx);
                    my_profile.getInboundProfile().status(ctx);
                    my_profile.getOutboundProfile().status(ctx);
                    ProvisioningProfile.LOG("Main Profile(s) Status");
                    break;
                }
                catch (Exception e) {
                    emsg = ProvisioningProfileV3.getResultStr(e, "PROV_PROFILE_NO_STATUS");
                    if (!apimode) {
                        System.out.println(emsg);
                        break;
                    }
                    throw new Exception(emsg);
                }
            }
            case 5: {
                try {
                    my_profile = new ProvisioningProfileV3(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
                    ProvisioningProfile.LOG("Deleting Profile(s)");
                    int pmode = my_profile.getProfileMode();
                    ProvisioningProfile.LOG("Profile Mode : " + pmode);
                    my_profile.checkIntfVersion(cmd);
                    String cmdProfileMode = cmd.get("PROFILE_MODE");
                    if (pmode == 1) {
                        if (!cmdProfileMode.equalsIgnoreCase("INBOUND")) {
                            throw new Exception("Profile currently INBOUND. Cannot Delete");
                        }
                        my_profile.getInboundProfile().delete(ctx);
                        ProvisioningProfile.LOG("Deleted InBound Profile");
                        my_profile.delete(ctx);
                        ProvisioningProfile.LOG("Deleted Main Profile");
                    } else if (pmode == 2) {
                        if (!cmdProfileMode.equalsIgnoreCase("OUTBOUND")) {
                            throw new Exception("Profile currently OUTBOUND.Cannot Delete");
                        }
                        my_profile.delete(ctx, my_profile.getOutboundProfile().getDN());
                        ProvisioningProfile.LOG("Deleted OutBound Profile");
                        my_profile.delete(ctx);
                        ProvisioningProfile.LOG("Deleted Main Profile");
                    } else {
                        if (!cmdProfileMode.equalsIgnoreCase("BOTH")) {
                            throw new Exception("Profile currently BOTH. Please use PROFILE_MODE=BOTH to Delete");
                        }
                        my_profile.getInboundProfile().delete(ctx);
                        ProvisioningProfile.LOG("Deleted InBound Profile");
                        my_profile.delete(ctx, my_profile.getOutboundProfile().getDN());
                        ProvisioningProfile.LOG("Deleted OutBound Profile");
                        my_profile.delete(ctx);
                        ProvisioningProfile.LOG("Deleted Main Profile");
                    }
                    if (apimode) break;
                    System.out.println(resBundle.getString("PROV_PROFILE_DELETED"));
                    break;
                }
                catch (Exception e) {
                    emsg = ProvisioningProfileV3.getResultStr(e, "PROV_PROFILE_DELETE_FAILURE");
                    if (!apimode) {
                        System.out.println(emsg);
                        break;
                    }
                    throw new Exception(emsg);
                }
            }
            case 6: {
                try {
                    my_profile = new ProvisioningProfileV3(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
                    ProvisioningProfile.LOG("Resetting Profile(s)");
                    int pmode = my_profile.getProfileMode();
                    String cmdProfileMode = cmd.get("PROFILE_MODE");
                    my_profile.checkIntfVersion(cmd);
                    if (pmode == 1) {
                        if (!cmdProfileMode.equalsIgnoreCase("INBOUND")) {
                            throw new Exception("Profile currently INBOUND.Cannot Reset");
                        }
                        my_profile.getInboundProfile().reset(ctx);
                        ProvisioningProfile.LOG("Reset InBound Profile");
                    } else if (pmode == 2) {
                        if (!cmdProfileMode.equalsIgnoreCase("OUTBOUND")) {
                            throw new Exception("Profile currently OUTBOUND.Cannot Reset");
                        }
                        my_profile.reset(ctx, my_profile.getOutboundProfile().getDN());
                        ProvisioningProfile.LOG("Reset OutBound Profile");
                    } else {
                        if (cmdProfileMode.equalsIgnoreCase("INBOUND")) {
                            my_profile.getInboundProfile().reset(ctx);
                            ProvisioningProfile.LOG("Reset InBound Profile");
                        }
                        if (cmdProfileMode.equalsIgnoreCase("OUTBOUND")) {
                            my_profile.reset(ctx, my_profile.getOutboundProfile().getDN());
                            ProvisioningProfile.LOG("Reset OutBound Profile");
                        }
                    }
                    if (apimode) break;
                    System.out.println(resBundle.getString("PROV_PROFILE_RESET_SUCCESS"));
                    break;
                }
                catch (Exception e) {
                    emsg = ProvisioningProfileV3.getResultStr(e, "PROV_PROFILE_RESET_FAILURE");
                    if (!apimode) {
                        System.out.println(emsg);
                        break;
                    }
                    throw new Exception(emsg);
                }
            }
            case 7: {
                try {
                    my_profile = new ProvisioningProfileV3(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
                    ProvisioningProfile.LOG("Modifying Profile(s)");
                    int pmode = my_profile.getProfileMode();
                    String cmdProfileMode = cmd.get("PROFILE_MODE");
                    my_profile.checkIntfVersion(cmd);
                    if (pmode == 1) {
                        if (!cmdProfileMode.equalsIgnoreCase("INBOUND")) {
                            throw new Exception("Profile currently INBOUND.Cannot Modify");
                        }
                        my_profile.getInboundProfile().modify(ctx, cmd);
                        ProvisioningProfile.LOG("Modified InBound Profile");
                        my_profile.modify(ctx, cmd);
                        ProvisioningProfile.LOG("Modified Main Profile");
                    } else if (pmode == 2) {
                        if (!cmdProfileMode.equalsIgnoreCase("OUTBOUND")) {
                            throw new Exception("Profile currently OUTBOUND.Cannot Modify");
                        }
                        my_profile.getOutboundProfile().modify(ctx, cmd);
                        ProvisioningProfile.LOG("Modified OutBound Profile");
                        my_profile.modify(ctx, cmd);
                        ProvisioningProfile.LOG("Modified Main Profile");
                    } else {
                        if (!cmdProfileMode.equalsIgnoreCase("OUTBOUND")) {
                            my_profile.getInboundProfile().modify(ctx, cmd);
                            ProvisioningProfile.LOG("Modified InBound Profile");
                        }
                        if (!cmdProfileMode.equalsIgnoreCase("INBOUND")) {
                            my_profile.getOutboundProfile().modify(ctx, cmd);
                            ProvisioningProfile.LOG("Modified OutBound Profile");
                        }
                        my_profile.modify(ctx, cmd);
                        ProvisioningProfile.LOG("Modified Main Profile");
                    }
                    if (apimode) break;
                    System.out.println(resBundle.getString("PROV_PROFILE_MOD_SUCCESS"));
                    break;
                }
                catch (Exception e) {
                    emsg = ProvisioningProfileV3.getResultStr(e, "PROV_PROFILE_MOD_FAILURE");
                    if (!apimode) {
                        System.out.println(emsg);
                        break;
                    }
                    throw new Exception(emsg);
                }
            }
            case 8: {
                try {
                    my_profile = new ProvisioningProfileV3(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
                    my_profile.checkIntfVersion(cmd);
                    my_profile.exists(ctx);
                    if (apimode) break;
                    System.out.println(resBundle.getString("PROV_PROFILE_FOUND"));
                    System.out.println(resBundle.getString("PROFILE_NAME") + my_profile.getProfileName());
                    break;
                }
                catch (Exception e) {
                    emsg = ProvisioningProfileV3.getResultStr(e, "PROV_PROFILE_NOT_FOUND");
                    if (!apimode) {
                        System.out.println(emsg);
                        break;
                    }
                    throw new Exception(emsg);
                }
            }
            default: {
                if (!apimode) {
                    System.out.println(resBundle.getString("PROV_PROFILE_INVALID_OPERATION"));
                    status = -1;
                    break;
                }
                throw new Exception(resBundle.getString("PROV_PROFILE_INVALID_OPERATION"));
            }
        }
    }

    public void modify(DirContext ctx, ProvisioningCmdArgs cmd) throws Exception {
        Vector additionalInfoVect;
        int attrCount = 0;
        ModificationItem[] tmpMods = new ModificationItem[64];
        BasicAttribute ldapattr = null;
        if (cmd.get("SCHEDULE") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileSchedule", cmd.get("SCHEDULE")));
        }
        if (cmd.get("MAX_RETRIES") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileMaxRetries", cmd.get("MAX_RETRIES")));
        }
        if (cmd.get("INTERFACE_NAME") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileInterfaceName", cmd.get("INTERFACE_NAME")));
        }
        if (cmd.get("INTERFACE_TYPE") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileInterfaceType", cmd.get("INTERFACE_TYPE")));
        }
        if (cmd.get("INTERFACE_CONNECT_INFO") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileInterfaceConnectInformation", cmd.get("INTERFACE_CONNECT_INFO")));
        }
        if ((additionalInfoVect = cmd.getVector("INTERFACE_ADDITIONAL_INFO")) != null) {
            ProvisioningProfile.LOG("Updating Attribute :orclODIPProfileInterfaceAdditionalInformation");
            ldapattr = new BasicAttribute("orclODIPProfileInterfaceAdditionalInformation");
            for (int i = 0; i < additionalInfoVect.size(); ++i) {
                ldapattr.add(additionalInfoVect.elementAt(i));
            }
            tmpMods[attrCount++] = new ModificationItem(2, ldapattr);
        }
        if (cmd.get("MAX_EVENTS_PER_INVOCATION") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileMaxEventsPerInvocation", cmd.get("MAX_EVENTS_PER_INVOCATION")));
        }
        if (cmd.get("MAX_EVENTS_PER_SCHEDULE") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileMaxEventsPerSchedule", cmd.get("MAX_EVENTS_PER_SCHEDULE")));
        }
        if (cmd.get("PROFILE_GROUP") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileExecGroupID", cmd.get("PROFILE_GROUP")));
        }
        if (cmd.get("PROFILE_DEBUG") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileDebugLevel", cmd.get("PROFILE_DEBUG")));
        }
        if (cmd.get("CRYPT_KEY") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPEncryptedAttrKey", cmd.get("CRYPT_KEY")));
        }
        if (cmd.get("PROFILE_MAX_ERRORS") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclODIPProfileMaxErrors", cmd.get("PROFILE_MAX_ERRORS")));
        }
        if (cmd.get("APPLICATION_TYPE") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclApplicationType", cmd.get("APPLICATION_TYPE")));
        }
        if (cmd.get("APPLICATION_DISPLAY_NAME") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclApplicationDisplayName", cmd.get("APPLICATION_DISPLAY_NAME")));
        }
        if (cmd.get("USER_DATA_LOCATION") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclApplicationUserDataLoc", cmd.get("USER_DATA_LOCATION")));
        }
        if (cmd.get("DEFAULT_PROVISIONING_POLICY") != null) {
            tmpMods[attrCount++] = new ModificationItem(2, new BasicAttribute("orclApplicationDefaultPolicy", cmd.get("DEFAULT_PROVISIONING_POLICY")));
        }
        ModificationItem[] mods = new ModificationItem[attrCount];
        System.arraycopy(tmpMods, 0, mods, 0, attrCount);
        ProvisioningProfile.LOG("Modifying entry : (" + this.profileDN + ")");
        ctx.modifyAttributes(this.profileDN, mods);
    }

    public static byte[] getBytesFromFile(String fileName) throws Exception {
        File fileObj = new File(fileName);
        FileInputStream fread = new FileInputStream(fileObj);
        long flen = fileObj.length();
        byte[] fbytes = new byte[(int)flen];
        int bytesRead = fread.read(fbytes);
        if ((long)bytesRead != flen) {
            String emsg = "Error in Reading Binary File : " + fileName;
            throw new Exception(emsg);
        }
        return fbytes;
    }
}

