/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.provisioning;

import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.provisioning.ProvisioningCmdArgs;
import oracle.ldap.util.provisioning.ProvisioningProfile;

class ProvisioningOutboundProfileV2 {
    public static final String OUTBOUND_RDN = "cn=OIDToApplication";
    public static final String OUTBOUND_RDN_VAL = "OIDToApplication";
    protected Vector provisioningProfileEventSubscription;
    protected String profileChgLogLastAppliedChangeNumber;
    protected String profileChgLogSubscriberDisable;
    protected String profileProcessingStatus;
    protected Vector profileProcessingErrors;
    protected String profileLastProcessingTime;
    protected String profileLastSuccessfulProcTime;
    protected boolean valid = true;
    protected String m_outboundProfileDN;
    protected String profileStatus;
    static ResourceBundle resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");

    public ProvisioningOutboundProfileV2() {
    }

    public ProvisioningOutboundProfileV2(DirContext ctx, String profile_dn) throws Exception {
        try {
            this.readProfileFromDirectory(ctx, "cn=OIDToApplication," + profile_dn);
        }
        catch (Exception e) {
            this.valid = false;
        }
    }

    public ProvisioningOutboundProfileV2(DirContext ctx, String appDN, String orgDN) throws Exception {
        try {
            String profile_DN = ProvisioningProfile.composeProfileDN(ctx, appDN, orgDN);
            this.readProfileFromDirectory(ctx, "cn=OIDToApplication," + profile_DN);
        }
        catch (Exception e) {
            this.valid = false;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void modify(DirContext ctx, ProvisioningCmdArgs cmd) throws Exception {
        String lastChgNum;
        int attrCount = 0;
        ModificationItem[] tmpMods = new ModificationItem[32];
        BasicAttribute ldapattr = null;
        Vector event_vector = cmd.getVector("EVENT_SUBSCRIPTION");
        if (event_vector != null) {
            ProvisioningProfile.LOG("Updating Attribute :orclODIPProvisioningEventSubscription");
            ldapattr = new BasicAttribute("orclODIPProvisioningEventSubscription");
            for (int i = 0; i < event_vector.size(); ++i) {
                ldapattr.add(event_vector.elementAt(i));
            }
            tmpMods[attrCount++] = new ModificationItem(2, ldapattr);
        }
        if ((lastChgNum = cmd.get("LASTCHANGENUMBER")) != null) {
            ProvisioningProfile.LOG("Updating Attribute :orclLastAppliedChangeNumber");
            ldapattr = new BasicAttribute("orclLastAppliedChangeNumber");
            ldapattr.add(lastChgNum);
            tmpMods[attrCount++] = new ModificationItem(2, ldapattr);
        }
        if (attrCount == 0) {
            ProvisioningProfile.LOG("Nothing TO modify in OUTBOUND Profile");
            return;
        }
        ModificationItem[] mods = new ModificationItem[attrCount];
        System.arraycopy(tmpMods, 0, mods, 0, attrCount);
        ProvisioningProfile.LOG("Modifying entry : (" + this.m_outboundProfileDN + ")");
        ctx.modifyAttributes(this.m_outboundProfileDN, mods);
    }

    public void status(DirContext ctx) throws Exception {
        String[] attr_list = new String[]{"*", "orclguid"};
        Property ldap_attr = null;
        PropertySetCollection entry = Util.getEntryDetails(ctx, this.m_outboundProfileDN, "objectclass=*", 0, attr_list);
        PropertySet entry_details = entry.getPropertySet(0);
        System.out.println(resBundle.getString("OUTBOUND_PROFILE_STATUS_DETAILS"));
        System.out.println("---------------------------------");
        ldap_attr = entry_details.getProperty("orclLastAppliedChangeNumber");
        if (ldap_attr != null) {
            this.setProfileChgLogLastAppliedChangeNumber((String)ldap_attr.getValue(0));
            System.out.println("orclLastAppliedChangeNumber: " + (String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclSubscriberDisable")) != null) {
            this.setProfileChgLogSubscriberDisable((String)ldap_attr.getValue(0));
            System.out.println("orclSubscriberDisable: " + (String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileProcessingStatus")) != null) {
            this.setProfileProcessingStatus((String)ldap_attr.getValue(0));
            System.out.println("orclODIPProfileProcessingStatus: " + (String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileProcessingErrors")) != null && ldap_attr.size() > 0) {
            Vector<Object> errorVector = new Vector<Object>();
            for (int i = 0; i < ldap_attr.size(); ++i) {
                errorVector.addElement(ldap_attr.getValue(i));
                System.out.println("orclODIPProfileProcessingErrors: " + (String)ldap_attr.getValue(0));
            }
            this.setProfileProcessingErrors(errorVector);
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileLastProcessingTime")) != null) {
            this.setProfileLastProcessingTime((String)ldap_attr.getValue(0));
            System.out.println("orclODIPProfileLastProcessingTime: " + (String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileLastSuccessfulProcessingTime")) != null) {
            this.setProfileLastSuccessfulProcTime((String)ldap_attr.getValue(0));
            System.out.println("orclODIPProfileLastSuccessfulProcessingTime: " + (String)ldap_attr.getValue(0));
        }
    }

    public static ProvisioningOutboundProfileV2 createNewOutboundProfileV2(DirContext ctx, ProvisioningCmdArgs cmd) throws Exception {
        ProvisioningOutboundProfileV2 ret_prof = null;
        boolean entry_exists = false;
        Vector event_vector = null;
        String profile_dn = ProvisioningProfile.composeProfileDN(ctx, cmd.get("APPLICATION_DN"), cmd.get("ORGANIZATION_DN"));
        entry_exists = ProvisioningProfile.directoryEntryExists(ctx, "cn=OIDToApplication," + profile_dn);
        if (entry_exists) {
            throw new Exception(resBundle.getString("PROV_PROFILE_EXISTS"));
        }
        BasicAttribute ldapattr = null;
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("orclODIPProvisioningIntegrationOutBoundProfileV2");
        objclass.add("orclChangeSubscriber");
        attrs.put(objclass);
        ldapattr = new BasicAttribute("cn");
        ldapattr.add(OUTBOUND_RDN_VAL);
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclStatus");
        ldapattr.add(cmd.get("PROFILE_STATUS"));
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclODIPProvisioningAppGUID");
        ldapattr.add(ProvisioningProfile.getDirectoryEntryGUID(ctx, cmd.get("APPLICATION_DN")));
        attrs.put(ldapattr);
        event_vector = cmd.getVector("EVENT_SUBSCRIPTION");
        if (event_vector != null) {
            ldapattr = new BasicAttribute("orclODIPProvisioningEventSubscription");
            for (int i = 0; i < event_vector.size(); ++i) {
                ldapattr.add((String)event_vector.elementAt(i));
            }
            attrs.put(ldapattr);
        }
        ldapattr = new BasicAttribute("orclLastAppliedChangeNumber");
        String lastChgNum = cmd.get("LASTCHANGENUMBER");
        if (lastChgNum != null) {
            ldapattr.add(lastChgNum);
        } else {
            ldapattr.add(ProvisioningProfile.getCurrentChangeNumber(ctx));
        }
        attrs.put(ldapattr);
        ldapattr = new BasicAttribute("orclSubscriberDisable");
        ldapattr.add("0");
        attrs.put(ldapattr);
        ProvisioningProfile.LOG(((Object)attrs).toString());
        DirContext result = ctx.createSubcontext("cn=OIDToApplication," + profile_dn, (Attributes)attrs);
        ProvisioningProfile.LOG("Created OutBound SubProfile Entry Successfully");
        ret_prof = new ProvisioningOutboundProfileV2(ctx, profile_dn);
        ProvisioningProfile.LOG("Created OutBound SubProfile Object Successfully");
        return ret_prof;
    }

    private void readProfileFromDirectory(DirContext ctx, String profile_dn) throws Exception {
        int i;
        String[] attr_list = new String[]{"*", "orclguid"};
        Property ldap_attr = null;
        ProvisioningProfile.LOG("Searching For OUTBOUND Profile : " + profile_dn);
        PropertySetCollection entry = Util.getEntryDetails(ctx, profile_dn, "objectclass=*", 0, attr_list);
        PropertySet entry_details = entry.getPropertySet(0);
        this.m_outboundProfileDN = profile_dn;
        ldap_attr = entry_details.getProperty("orclStatus");
        if (ldap_attr != null) {
            this.setProfileStatus((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclLastAppliedChangeNumber")) != null) {
            this.setProfileChgLogLastAppliedChangeNumber((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclSubscriberDisable")) != null) {
            this.setProfileChgLogSubscriberDisable((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProvisioningEventSubscription")) != null && ldap_attr.size() > 0) {
            Vector<Object> eventVector = new Vector<Object>();
            for (i = 0; i < ldap_attr.size(); ++i) {
                eventVector.addElement(ldap_attr.getValue(i));
            }
            this.setProvisioningProfileEventSubscription(eventVector);
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileProcessingStatus")) != null) {
            this.setProfileProcessingStatus((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileProcessingErrors")) != null && ldap_attr.size() > 0) {
            Vector<Object> errorVector = new Vector<Object>();
            for (i = 0; i < ldap_attr.size(); ++i) {
                errorVector.addElement(ldap_attr.getValue(i));
            }
            this.setProfileProcessingErrors(errorVector);
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileLastProcessingTime")) != null) {
            this.setProfileLastProcessingTime((String)ldap_attr.getValue(0));
        }
        if ((ldap_attr = entry_details.getProperty("orclODIPProfileLastSuccessfulProcessingTime")) != null) {
            this.setProfileLastSuccessfulProcTime((String)ldap_attr.getValue(0));
        }
    }

    public String getProfileStatus() {
        return this.profileStatus;
    }

    public void setProfileStatus(String newProfileStatus) {
        this.profileStatus = newProfileStatus;
    }

    public String getProfileChgLogLastAppliedChangeNumber() {
        return this.profileChgLogLastAppliedChangeNumber;
    }

    public void setProfileChgLogLastAppliedChangeNumber(String newProfileChgLogLastAppliedChangeNumber) {
        this.profileChgLogLastAppliedChangeNumber = newProfileChgLogLastAppliedChangeNumber;
    }

    public String getProfileChgLogSubscriberDisable() {
        return this.profileChgLogSubscriberDisable;
    }

    public void setProfileChgLogSubscriberDisable(String newProfileChgLogSubscriberDisable) {
        this.profileChgLogSubscriberDisable = newProfileChgLogSubscriberDisable;
    }

    public Vector getProvisioningProfileEventSubscription() {
        return this.provisioningProfileEventSubscription;
    }

    public void setProvisioningProfileEventSubscription(Vector newProvisioningProfileEventSubscription) {
        this.provisioningProfileEventSubscription = newProvisioningProfileEventSubscription;
    }

    public String getProfileProcessingStatus() {
        return this.profileProcessingStatus;
    }

    public void setProfileProcessingStatus(String newProfileProcessingStatus) {
        this.profileProcessingStatus = newProfileProcessingStatus;
    }

    public Vector getProfileProcessingErrors() {
        return this.profileProcessingErrors;
    }

    public void setProfileProcessingErrors(Vector newProfileProcessingErrors) {
        this.profileProcessingErrors = newProfileProcessingErrors;
    }

    public String getProfileLastProcessingTime() {
        return this.profileLastProcessingTime;
    }

    public void setProfileLastProcessingTime(String newProfileLastProcessingTime) {
        this.profileLastProcessingTime = newProfileLastProcessingTime;
    }

    public String getProfileLastSuccessfulProcTime() {
        return this.profileLastSuccessfulProcTime;
    }

    public void setProfileLastSuccessfulProcTime(String newProfileLastSuccessfulProcTime) {
        this.profileLastSuccessfulProcTime = newProfileLastSuccessfulProcTime;
    }

    public String getDN() {
        return this.m_outboundProfileDN;
    }
}

