/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.param;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ldap.util.ParameterException;
import oracle.ldap.util.nls.NlsMsg;
import oracle.ldap.util.param.FlagParameterDescriptor;
import oracle.ldap.util.param.Parameter;
import oracle.ldap.util.param.ParameterDescriptor;

public abstract class ParameterParser {
    protected String mParamNameValueDelim = "=";
    protected ParameterDescriptor[] mParamDes = null;
    protected Hashtable mParsedParamHT = null;
    protected Vector mUnParsedParamVector = null;
    protected boolean mAllowUndescribedParam = true;

    protected ParameterParser(ParameterDescriptor[] paramDes) {
        this.mParamDes = paramDes;
    }

    protected ParameterParser(ParameterDescriptor[] paramDes, boolean allowUndescribedParams) {
        this(paramDes);
        this.mAllowUndescribedParam = allowUndescribedParams;
    }

    protected ParameterParser(ParameterDescriptor[] paramDes, String delim) {
        this(paramDes);
        if (null == delim) {
            throw new IllegalArgumentException("The delimiter cannot be NULL");
        }
        this.mParamNameValueDelim = delim;
    }

    protected boolean containsParameterDescriptor(String paramName) {
        return this.getParameterDescriptorIndex(paramName, false) != -1;
    }

    protected Hashtable getParsedParams() {
        return this.mParsedParamHT;
    }

    protected Enumeration getParams() {
        return this.mParsedParamHT.elements();
    }

    protected int getParameterDescriptorIndex(String paramName, boolean onlyFlagType) {
        int retVal = -1;
        if (this.mParamDes != null && paramName != null) {
            for (int iCnt = 0; iCnt < this.mParamDes.length; ++iCnt) {
                if (this.mParamDes[iCnt] == null || onlyFlagType && !(this.mParamDes[iCnt] instanceof FlagParameterDescriptor) || !this.mParamDes[iCnt].equals(paramName)) continue;
                retVal = iCnt;
                break;
            }
        }
        return retVal;
    }

    protected void validateAndAddDefaultParams() throws ParameterException {
        if (this.mParamDes != null) {
            for (int iCnt = 0; iCnt < this.mParamDes.length; ++iCnt) {
                String name = this.mParamDes[iCnt].getName();
                if (this.mParamDes[iCnt].isManadatory()) {
                    if (this.mParsedParamHT != null && this.mParsedParamHT.get(name) != null) continue;
                    throw new ParameterException(NlsMsg.getMessage("PARAMETER_MANDATORY_MISSING", name));
                }
                String defVal = this.mParamDes[iCnt].getDefaultValue();
                if (null == defVal) continue;
                if (this.mParsedParamHT == null) {
                    this.mParsedParamHT = new Hashtable();
                    this.mParsedParamHT.put(name, new Parameter(name, defVal, false));
                    continue;
                }
                if (this.mParsedParamHT.get(name) != null) continue;
                this.mParsedParamHT.put(name, new Parameter(name, defVal, false));
            }
        }
    }

    public abstract void parse() throws ParameterException;

    public Parameter get(String paramName) {
        if (null == this.mParsedParamHT) {
            return null;
        }
        return (Parameter)this.mParsedParamHT.get(paramName);
    }

    public Vector getUnParsedParams() {
        return this.mUnParsedParamVector;
    }

    public int size() {
        return this.mParsedParamHT.size();
    }
}

