/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.nls;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class OraDisplayLocaleInfo {
    private static final Hashtable m_cache = new Hashtable();
    private static String M_C_LANGUAGE_RESB = "oracle.ldap.util.nls.LanguageTranslations";
    private static String M_C_TERRITORY_RESB = "oracle.ldap.util.nls.TerritoryTranslations";
    private static String M_C_LANG_TERRIT_RESB = "oracle.ldap.util.nls.LanguageTerritoryTranslations";
    private static String M_C_TIMEZONE_RESB = "oracle.ldap.util.nls.TimeZoneTranslations";
    private final ResourceBundle m_language_resb;
    private final ResourceBundle m_territory_resb;
    private final ResourceBundle m_lang_territ_resb;
    private final Locale m_locale;

    private OraDisplayLocaleInfo(Locale translocale) {
        this.m_locale = translocale;
        this.m_language_resb = ResourceBundle.getBundle(M_C_LANGUAGE_RESB, translocale);
        this.m_territory_resb = ResourceBundle.getBundle(M_C_TERRITORY_RESB, translocale);
        this.m_lang_territ_resb = ResourceBundle.getBundle(M_C_LANG_TERRIT_RESB, translocale);
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OraDisplayLocaleInfo getInstance(Locale translocale) {
        OraDisplayLocaleInfo idli = null;
        Hashtable hashtable = m_cache;
        synchronized (hashtable) {
            idli = (OraDisplayLocaleInfo)m_cache.get(translocale);
            if (idli == null) {
                idli = new OraDisplayLocaleInfo(translocale);
            }
            m_cache.put(translocale, idli);
        }
        return idli;
    }

    public String getDisplayTimeZone(TimeZone tz) {
        if (tz == null) {
            throw new NullPointerException("TimeZone object is null");
        }
        ResourceBundle timezone_resb = ResourceBundle.getBundle(M_C_TIMEZONE_RESB, this.m_locale);
        try {
            return timezone_resb.getString(tz.getID());
        }
        catch (MissingResourceException e) {
            return tz.getDisplayName(this.m_locale);
        }
    }

    public String getDisplayLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("Locale object is null");
        }
        return this.getDisplayLocale(locale.getLanguage(), locale.getCountry());
    }

    public String getDisplayLocale(String oraLanguage, String oraTerritory) {
        if (oraTerritory != null && !oraTerritory.equals("")) {
            try {
                String dtlang = this.m_lang_territ_resb.getString(oraLanguage.toLowerCase());
                String dterr = this.m_territory_resb.getString(oraTerritory.toUpperCase());
                Object[] args = new Object[]{dterr};
                return MessageFormat.format(dtlang, args);
            }
            catch (MissingResourceException e) {
                return oraLanguage + " (" + oraTerritory + ")";
            }
        }
        try {
            return this.m_language_resb.getString(oraLanguage.toLowerCase());
        }
        catch (MissingResourceException e) {
            return oraLanguage;
        }
        catch (NullPointerException e) {
            return "";
        }
    }
}

